/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.rhq.core.domain.criteria.BaseCriteria;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

public class CriteriaQuery<T, C extends BaseCriteria>
implements Iterable<T> {
    private C criteria;
    private CriteriaQueryExecutor<T, C> queryExecutor;

    public CriteriaQuery(C criteria, CriteriaQueryExecutor<T, C> queryExecutor) {
        this.criteria = criteria;
        this.queryExecutor = queryExecutor;
    }

    @Override
    public Iterator<T> iterator() {
        return new QueryResultsIterator(this.executeQuery());
    }

    private PageList<T> executeQuery() {
        return this.queryExecutor.execute(this.criteria);
    }

    protected class QueryResultsIterator
    implements Iterator<T> {
        private PageList<T> currentPage;
        private Iterator<T> iterator;
        private boolean reachedEnd;

        public QueryResultsIterator(PageList<T> firstPage) {
            this.currentPage = firstPage;
            this.iterator = this.currentPage.iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.iterator.hasNext() && !this.reachedEnd) {
                PageControl pcCurrent = this.currentPage.getPageControl();
                PageControl pcOverrides = CriteriaQuery.this.criteria.getPageControlOverrides();
                if (pcCurrent == null && pcOverrides == null) {
                    this.reachedEnd = true;
                } else {
                    if (pcOverrides != null) {
                        pcOverrides.setPageNumber(pcOverrides.getPageNumber() + 1);
                    } else {
                        CriteriaQuery.this.criteria.setPaging(pcCurrent.getPageNumber() + 1, pcCurrent.getPageSize());
                    }
                    this.currentPage.clear();
                    this.currentPage = CriteriaQuery.this.queryExecutor.execute(CriteriaQuery.this.criteria);
                    this.iterator = this.currentPage.iterator();
                    this.reachedEnd = !this.iterator.hasNext();
                }
            }
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

