/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.rhq.core.domain.criteria.Criteria;

public class CriteriaUtil {
    private CriteriaUtil() {
    }

    public static List<Field> getFields(Criteria criteria, Criteria.Type type) {
        String prefix = type.name().toLowerCase();
        ArrayList<Field> results = new ArrayList<Field>();
        Class<?> currentLevelClass = criteria.getClass();
        List globalFields = type.getGlobalFields();
        boolean isCriteriaClass = false;
        do {
            isCriteriaClass = currentLevelClass.equals(Criteria.class);
            for (Field field : currentLevelClass.getDeclaredFields()) {
                if (isCriteriaClass) {
                    if (!globalFields.contains(field.getName())) continue;
                    results.add(field);
                    continue;
                }
                if (!field.getName().startsWith(prefix)) continue;
                results.add(field);
            }
            currentLevelClass = currentLevelClass.getSuperclass();
        } while (!isCriteriaClass);
        return results;
    }

    public static String toString(Criteria criteria) {
        StringBuilder bld = new StringBuilder();
        bld.append(criteria.getClass().getSimpleName()).append("[");
        for (Criteria.Type type : Criteria.Type.values()) {
            switch (type) {
                case FETCH: {
                    bld.append("fetche");
                    break;
                }
                default: {
                    bld.append(type.name().toLowerCase());
                }
            }
            bld.append("s: [");
            List<Field> fields = CriteriaUtil.getFields(criteria, type);
            Collections.sort(fields, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            boolean hasValues = false;
            for (Field f : fields) {
                boolean hasValue = false;
                try {
                    f.setAccessible(true);
                    Object value = f.get(criteria);
                    if (type == Criteria.Type.FETCH && value instanceof Boolean && !((Boolean)value).booleanValue()) {
                        value = null;
                    }
                    if (value != null) {
                        bld.append(f.getName()).append("=");
                        CriteriaUtil.appendToString(value, bld);
                        hasValue = true;
                        hasValues = true;
                    }
                }
                catch (IllegalAccessException e) {
                    bld.append("<value-inaccessible>");
                    hasValue = true;
                    hasValues = true;
                }
                if (!hasValue) continue;
                bld.append(", ");
            }
            if (hasValues) {
                bld.replace(bld.length() - 2, bld.length(), "");
            }
            bld.append("], ");
        }
        bld.replace(bld.length() - 2, bld.length(), "").append("]");
        return bld.toString();
    }

    private static void appendToString(Object object, StringBuilder bld) {
        if (object == null) {
            bld.append("null");
        } else if (object.getClass().isArray()) {
            Class<?> componentType = object.getClass().getComponentType();
            String str = componentType == Boolean.TYPE ? Arrays.toString((boolean[])object) : (componentType == Byte.TYPE ? Arrays.toString((byte[])object) : (componentType == Character.TYPE ? Arrays.toString((char[])object) : (componentType == Double.TYPE ? Arrays.toString((double[])object) : (componentType == Float.TYPE ? Arrays.toString((float[])object) : (componentType == Integer.TYPE ? Arrays.toString((int[])object) : (componentType == Long.TYPE ? Arrays.toString((long[])object) : (componentType == Short.TYPE ? Arrays.toString((short[])object) : Arrays.deepToString((Object[])object))))))));
            bld.append(str);
        } else if (object instanceof CharSequence) {
            bld.append("\"").append(object).append("\"");
        } else {
            bld.append(object.toString());
        }
    }
}

