/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import org.rhq.core.domain.util.PageList;

public class PhantomReadMaxAttemptsExceededException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int numberOfAttempts;
    private final PageList<?> list;
    private final long millisecondsSpentTrying;

    public PhantomReadMaxAttemptsExceededException(int numberOfAttempts, PageList<?> list, long millisecondsSpentTrying) {
        super(PhantomReadMaxAttemptsExceededException.initMessage(numberOfAttempts, list.size(), list.getTotalSize(), millisecondsSpentTrying));
        this.numberOfAttempts = numberOfAttempts;
        this.list = list;
        this.millisecondsSpentTrying = millisecondsSpentTrying;
    }

    public PhantomReadMaxAttemptsExceededException(int numberOfAttempts, PageList<?> list, long millisecondsSpentTrying, Throwable cause) {
        super(PhantomReadMaxAttemptsExceededException.initMessage(numberOfAttempts, list.size(), list.getTotalSize(), millisecondsSpentTrying), cause);
        this.numberOfAttempts = numberOfAttempts;
        this.list = list;
        this.millisecondsSpentTrying = millisecondsSpentTrying;
    }

    public PageList<?> getList() {
        return this.list;
    }

    public long getMillisecondsSpentTrying() {
        return this.millisecondsSpentTrying;
    }

    public int getNumberOfAttempts() {
        return this.numberOfAttempts;
    }

    private static String initMessage(int numberOfAttempts, int collectionSize, int totalCountSize, long millisecondsSpentTrying) {
        return "Could not get consistent results of the paged data and a total count after " + numberOfAttempts + " attempts, the collection size is " + collectionSize + ", while the count query reports " + totalCountSize + ". The discrepancy has not cleared up in " + millisecondsSpentTrying + "ms so we're " + "giving up, returning inconsistent results. Note that is most possibly NOT an error. It is likely " + "caused by concurrent database activity that changes the contents of the database that the criteria " + "query is querying.";
    }
}

