/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.util.LookupUtil;

public final class SystemDatabaseInformation {
    private final Log log = LogFactory.getLog(SystemDatabaseInformation.class);
    private Map<Property, String> properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemDatabaseInformation() {
        DataSource ds = null;
        Connection conn = null;
        try {
            ds = LookupUtil.getDataSource();
            conn = ds.getConnection();
            DatabaseMetaData metadata = conn.getMetaData();
            String url = metadata.getURL();
            String productName = metadata.getDatabaseProductName();
            String productVersion = metadata.getDatabaseProductVersion();
            String driverName = metadata.getDriverName();
            String driverVersion = metadata.getDriverVersion();
            HashMap<Property, String> values = new HashMap<Property, String>();
            values.put(Property.DATABASE_CONNECTION_URL, url);
            values.put(Property.DATABASE_PRODUCT_NAME, productName);
            values.put(Property.DATABASE_PRODUCT_VERSION, productVersion);
            values.put(Property.DATABASE_DRIVER_NAME, driverName);
            values.put(Property.DATABASE_DRIVER_VERSION, driverVersion);
            this.properties = Collections.unmodifiableMap(values);
        }
        catch (Exception e) {
            this.log.error((Object)("Could not load properties for " + SystemDatabaseInformation.class.getSimpleName()));
        }
        finally {
            if (this.properties == null) {
                HashMap<Property, String> values = new HashMap<Property, String>();
                for (Property prop : Property.values()) {
                    values.put(prop, "unknown");
                }
                this.properties = Collections.unmodifiableMap(values);
            }
            JDBCUtil.safeClose((Connection)conn);
        }
    }

    public static SystemDatabaseInformation getInstance() {
        return new SystemDatabaseInformation();
    }

    public Map<Property, String> getProperties(Property property) {
        return this.properties;
    }

    public String getDatabaseConnectionURL() {
        return this.properties.get((Object)Property.DATABASE_CONNECTION_URL);
    }

    public String getDatabaseProductName() {
        return this.properties.get((Object)Property.DATABASE_PRODUCT_NAME);
    }

    public String getDatabaseProductVersion() {
        return this.properties.get((Object)Property.DATABASE_PRODUCT_VERSION);
    }

    public String getDatabaseDriverName() {
        return this.properties.get((Object)Property.DATABASE_DRIVER_NAME);
    }

    public String getDatabaseDriverVersion() {
        return this.properties.get((Object)Property.DATABASE_DRIVER_VERSION);
    }

    public static enum Property {
        DATABASE_CONNECTION_URL,
        DATABASE_PRODUCT_NAME,
        DATABASE_PRODUCT_VERSION,
        DATABASE_DRIVER_NAME,
        DATABASE_DRIVER_VERSION;

    }
}

