/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.composite.IntegerOptionItem;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerRemote;
import org.rhq.enterprise.server.alert.AlertDefinitionUpdateException;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.alert.AlertTemplateManagerLocal;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.alert.engine.AlertDefinitionEvent;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.cloud.StatusManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSender;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderPluginManager;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class AlertDefinitionManagerBean
implements AlertDefinitionManagerLocal,
AlertDefinitionManagerRemote {
    private static final Log LOG = LogFactory.getLog(AlertDefinitionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private AlertTemplateManagerLocal alertTemplateManager;
    @EJB
    private GroupAlertDefinitionManagerLocal groupAlertDefintionManager;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private StatusManagerLocal agentStatusManager;
    @EJB
    private AlertNotificationManagerLocal alertNotificationManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    private boolean checkViewPermission(Subject subject, AlertDefinition alertDefinition) {
        if (alertDefinition.getResourceType() != null) {
            return true;
        }
        if (alertDefinition.getGroup() != null) {
            return this.authorizationManager.canViewGroup(subject, alertDefinition.getGroup().getId());
        }
        return this.authorizationManager.canViewResource(subject, alertDefinition.getResource().getId());
    }

    private boolean checkPermission(Subject subject, AlertDefinition alertDefinition) {
        if (this.authorizationManager.isOverlord(subject)) {
            return true;
        }
        if (alertDefinition.getResourceType() != null) {
            return this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS);
        }
        if (alertDefinition.getGroup() != null) {
            return this.authorizationManager.hasGroupPermission(subject, Permission.MANAGE_ALERTS, alertDefinition.getGroup().getId());
        }
        return this.authorizationManager.hasResourcePermission(subject, Permission.MANAGE_ALERTS, alertDefinition.getResource().getId());
    }

    @Override
    public PageList<AlertDefinition> findAlertDefinitions(Subject subject, int resourceId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AlertDefinition.findByResource");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findByResource", (PageControl)pageControl);
        queryCount.setParameter("id", (Object)resourceId);
        query.setParameter("id", (Object)resourceId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        return new PageList((Collection)list, (int)totalCount, pageControl);
    }

    @Override
    public AlertDefinition getAlertDefinitionById(Subject subject, int alertDefinitionId) {
        AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinitionId);
        if (alertDefinition == null) {
            return null;
        }
        if (!this.checkViewPermission(subject, alertDefinition)) {
            throw new PermissionException("User[" + subject.getName() + "] does not have permission to view alertDefinition[id=" + alertDefinitionId + "] for resource[id=" + alertDefinition.getResource().getId() + "]");
        }
        alertDefinition.getConditions().size();
        for (AlertCondition cond : alertDefinition.getConditions()) {
            if (cond.getMeasurementDefinition() == null) continue;
            cond.getMeasurementDefinition().getId();
        }
        for (AlertNotification notification : alertDefinition.getAlertNotifications()) {
            notification.getConfiguration().getProperties().size();
            if (notification.getExtraConfiguration() == null) continue;
            notification.getExtraConfiguration().getProperties().size();
        }
        return alertDefinition;
    }

    @Override
    public List<IntegerOptionItem> findAlertDefinitionOptionItemsForResource(Subject subject, int resourceId) {
        PageControl pageControl = PageControl.getUnlimitedInstance();
        pageControl.initDefaultOrderingField("ad.name", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findOptionItemsByResource", (PageControl)pageControl);
        query.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<IntegerOptionItem> findAlertDefinitionOptionItemsForGroup(Subject subject, int groupId) {
        PageControl pageControl = PageControl.getUnlimitedInstance();
        pageControl.initDefaultOrderingField("ad.name", PageOrdering.ASC);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findOptionItemsByGroup", (PageControl)pageControl);
        query.setParameter("groupId", (Object)groupId);
        List results = query.getResultList();
        return results;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public int createDependentAlertDefinition(Subject subject, AlertDefinition alertDefinition, int resourceId) throws InvalidAlertDefinitionException {
        AlertDefinition newAlertDefinition = this.createAlertDefinitionInternal(subject, alertDefinition, resourceId, false, false);
        return newAlertDefinition.getId();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public AlertDefinition createAlertDefinitionInNewTransaction(Subject subject, AlertDefinition alertDefinition, Integer resourceId, boolean validateNotificationConfiguration) throws InvalidAlertDefinitionException {
        AlertDefinition newAlertDefinition = this.createAlertDefinitionInternal(subject, alertDefinition, resourceId, true, validateNotificationConfiguration);
        return newAlertDefinition;
    }

    private AlertDefinition createAlertDefinitionInternal(Subject subject, AlertDefinition alertDefinition, Integer resourceId, boolean checkPerms, boolean validateNotificationConfiguration) throws InvalidAlertDefinitionException {
        this.checkAlertDefinition(subject, null, alertDefinition, resourceId, validateNotificationConfiguration);
        if (resourceId != null) {
            alertDefinition.setResource(new Resource(resourceId.intValue()));
        }
        if (checkPerms && !this.checkPermission(subject, alertDefinition)) {
            if (alertDefinition.getResourceType() != null) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to create alert templates for type [" + alertDefinition.getResourceType() + "]");
            }
            if (alertDefinition.getGroup() != null) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to create alert definitions for group [" + alertDefinition.getGroup() + "]");
            }
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to create alert definitions for resource [" + alertDefinition.getResource() + "]");
        }
        if (alertDefinition.getConditions().size() == 1) {
            alertDefinition.setConditionExpression(BooleanExpression.ANY);
        }
        this.fixRecoveryId(alertDefinition);
        this.entityManager.persist((Object)alertDefinition);
        boolean addToCache = false;
        if (resourceId != null && alertDefinition.getEnabled()) {
            if (alertDefinition.getRecoveryId() != 0) {
                AlertDefinition toBeRecoveredDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinition.getRecoveryId());
                if (!toBeRecoveredDefinition.getEnabled()) {
                    addToCache = true;
                }
            } else {
                addToCache = true;
            }
        }
        if (addToCache) {
            this.notifyAlertConditionCacheManager(subject, "createAlertDefinition", alertDefinition, AlertDefinitionEvent.CREATED);
        }
        return alertDefinition;
    }

    private void fixRecoveryId(AlertDefinition definition) {
        try {
            if (definition.getParentId() != 0 && definition.getRecoveryId() != 0) {
                String findCorrectRecoveryId = " SELECT toBeRecovered.id    FROM AlertDefinition toBeRecovered   WHERE toBeRecovered.resource.id = :resourceId     AND toBeRecovered.parentId = :parentId ";
                Query fixRecoveryIdQuery = this.entityManager.createQuery(findCorrectRecoveryId);
                fixRecoveryIdQuery.setParameter("resourceId", (Object)definition.getResource().getId());
                fixRecoveryIdQuery.setParameter("parentId", (Object)definition.getRecoveryId());
                Integer correctRecoveryId = (Integer)fixRecoveryIdQuery.getSingleResult();
                definition.setRecoveryId(correctRecoveryId);
            } else if (definition.getGroupAlertDefinition() != null && definition.getRecoveryId() != 0) {
                String findCorrectRecoveryId = " SELECT toBeRecovered.id    FROM AlertDefinition toBeRecovered   WHERE toBeRecovered.resource.id = :resourceId     AND toBeRecovered.groupAlertDefinition.id = :groupAlertDefinitionId ";
                Query fixRecoveryIdQuery = this.entityManager.createQuery(findCorrectRecoveryId);
                fixRecoveryIdQuery.setParameter("resourceId", (Object)definition.getResource().getId());
                fixRecoveryIdQuery.setParameter("groupAlertDefinitionId", (Object)definition.getRecoveryId());
                Integer correctRecoveryId = (Integer)fixRecoveryIdQuery.getSingleResult();
                definition.setRecoveryId(correctRecoveryId);
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    @Override
    public int removeAlertDefinitions(Subject subject, int[] alertDefinitionIds) {
        if (null == alertDefinitionIds || alertDefinitionIds.length == 0) {
            return 0;
        }
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterIds(ArrayUtils.wrapInArray((int[])alertDefinitionIds));
        criteria.addFilterDeleted(Boolean.valueOf(false));
        criteria.clearPaging();
        PageList<AlertDefinition> defs = this.alertDefinitionManager.findAlertDefinitionsByCriteria(subject, criteria);
        if (defs.isEmpty()) {
            return 0;
        }
        int modifiedCount = 0;
        ArrayList<Integer> resourceDefIds = new ArrayList<Integer>(defs.size());
        Boolean hasManageSettings = this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS);
        for (AlertDefinition ad : defs) {
            if (null != ad.getResourceType()) {
                if (!hasManageSettings.booleanValue()) continue;
                this.alertTemplateManager.removeAlertTemplates(subject, new Integer[]{ad.getId()});
                ++modifiedCount;
                continue;
            }
            if (null != ad.getGroup()) {
                this.groupAlertDefintionManager.removeGroupAlertDefinitions(subject, new Integer[]{ad.getId()});
                ++modifiedCount;
                continue;
            }
            resourceDefIds.add(ad.getId());
        }
        if (!resourceDefIds.isEmpty()) {
            this.alertDefinitionManager.removeResourceAlertDefinitions(subject, ArrayUtils.unwrapCollection(resourceDefIds));
            modifiedCount += resourceDefIds.size();
        }
        return modifiedCount;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int enableAlertDefinitions(Subject subject, int[] alertDefinitionIds) {
        if (null == alertDefinitionIds || alertDefinitionIds.length == 0) {
            return 0;
        }
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterIds(ArrayUtils.wrapInArray((int[])alertDefinitionIds));
        criteria.addFilterEnabled(Boolean.valueOf(false));
        criteria.addFilterDeleted(Boolean.valueOf(false));
        criteria.clearPaging();
        PageList<AlertDefinition> defs = this.alertDefinitionManager.findAlertDefinitionsByCriteria(subject, criteria);
        if (defs.isEmpty()) {
            return 0;
        }
        int modifiedCount = 0;
        ArrayList<Integer> resourceDefIds = new ArrayList<Integer>(defs.size());
        Boolean hasManageSettings = this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS);
        for (AlertDefinition ad : defs) {
            if (null != ad.getResourceType()) {
                if (!hasManageSettings.booleanValue()) continue;
                this.alertTemplateManager.enableAlertTemplates(subject, new Integer[]{ad.getId()});
                ++modifiedCount;
                continue;
            }
            if (null != ad.getGroup()) {
                this.groupAlertDefintionManager.enableGroupAlertDefinitions(subject, new Integer[]{ad.getId()});
                ++modifiedCount;
                continue;
            }
            resourceDefIds.add(ad.getId());
        }
        if (!resourceDefIds.isEmpty()) {
            this.alertDefinitionManager.enableResourceAlertDefinitions(subject, ArrayUtils.unwrapCollection(resourceDefIds));
            modifiedCount += resourceDefIds.size();
        }
        return modifiedCount;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int disableAlertDefinitions(Subject subject, int[] alertDefinitionIds) {
        if (null == alertDefinitionIds || alertDefinitionIds.length == 0) {
            return 0;
        }
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterIds(ArrayUtils.wrapInArray((int[])alertDefinitionIds));
        criteria.addFilterEnabled(Boolean.valueOf(true));
        criteria.addFilterDeleted(Boolean.valueOf(false));
        criteria.clearPaging();
        PageList<AlertDefinition> defs = this.alertDefinitionManager.findAlertDefinitionsByCriteria(subject, criteria);
        if (defs.isEmpty()) {
            return 0;
        }
        int modifiedCount = 0;
        ArrayList<Integer> resourceDefIds = new ArrayList<Integer>(defs.size());
        Boolean hasManageSettings = this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SETTINGS);
        for (AlertDefinition ad : defs) {
            if (null != ad.getResourceType()) {
                if (!hasManageSettings.booleanValue()) continue;
                this.alertTemplateManager.disableAlertTemplates(subject, new Integer[]{ad.getId()});
                ++modifiedCount;
                continue;
            }
            if (null != ad.getGroup()) {
                this.groupAlertDefintionManager.disableGroupAlertDefinitions(subject, new Integer[]{ad.getId()});
                ++modifiedCount;
                continue;
            }
            resourceDefIds.add(ad.getId());
        }
        if (!resourceDefIds.isEmpty()) {
            this.alertDefinitionManager.disableResourceAlertDefinitions(subject, ArrayUtils.unwrapCollection(resourceDefIds));
            modifiedCount += resourceDefIds.size();
        }
        return modifiedCount;
    }

    @Override
    public int enableResourceAlertDefinitions(Subject subject, int[] resourceAlertDefinitionIds) {
        int modifiedCount = 0;
        for (int alertDefId : resourceAlertDefinitionIds) {
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefId);
            if (null == alertDefinition || alertDefinition.getEnabled()) continue;
            alertDefinition.setEnabled(true);
            ++modifiedCount;
            this.notifyAlertConditionCacheManager(subject, "enableResourceAlertDefinitions", alertDefinition, AlertDefinitionEvent.ENABLED);
        }
        return modifiedCount;
    }

    @Override
    public int disableResourceAlertDefinitions(Subject subject, int[] resourceAlertDefinitionIds) {
        int modifiedCount = 0;
        for (int alertDefId : resourceAlertDefinitionIds) {
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefId);
            if (null == alertDefinition || !alertDefinition.getEnabled()) continue;
            alertDefinition.setEnabled(false);
            ++modifiedCount;
            this.notifyAlertConditionCacheManager(subject, "disableResourceAlertDefinitions", alertDefinition, AlertDefinitionEvent.DISABLED);
        }
        return modifiedCount;
    }

    @Override
    public int removeResourceAlertDefinitions(Subject subject, int[] resourceAlertDefinitionIds) {
        int modifiedCount = 0;
        for (int alertDefId : resourceAlertDefinitionIds) {
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefId);
            if (null == alertDefinition || alertDefinition.getDeleted()) continue;
            alertDefinition.setDeleted(true);
            ++modifiedCount;
            this.notifyAlertConditionCacheManager(subject, "removeResourceAlertDefinitions", alertDefinition, AlertDefinitionEvent.DELETED);
        }
        return modifiedCount;
    }

    @Override
    public boolean isEnabled(Integer definitionId) {
        Query enabledQuery = this.entityManager.createNamedQuery("AlertDefinition.isEnabled");
        enabledQuery.setParameter("alertDefinitionId", (Object)definitionId);
        List resultIds = enabledQuery.getResultList();
        return resultIds.size() == 1;
    }

    @Override
    public boolean isTemplate(Integer definitionId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.isTemplate");
        query.setParameter("alertDefinitionId", (Object)definitionId);
        List resultIds = query.getResultList();
        return resultIds.size() == 1;
    }

    @Override
    public boolean isGroupAlertDefinition(Integer definitionId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.isGroupAlertDefinition");
        query.setParameter("alertDefinitionId", (Object)definitionId);
        List resultIds = query.getResultList();
        return resultIds.size() == 1;
    }

    @Override
    public boolean isResourceAlertDefinition(Integer definitionId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.isResourceAlertDefinition");
        query.setParameter("alertDefinitionId", (Object)definitionId);
        List resultIds = query.getResultList();
        return resultIds.size() == 1;
    }

    @Override
    public void copyAlertDefinitions(Subject subject, Integer[] alertDefinitionIds) {
        Integer[] arr$ = alertDefinitionIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int alertDefId = arr$[i$];
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefId);
            if (!this.checkPermission(subject, alertDefinition)) continue;
            AlertDefinition newAlertDefinition = new AlertDefinition(alertDefinition);
            newAlertDefinition.setEnabled(false);
            newAlertDefinition.setParentId(alertDefinition.getParentId());
            newAlertDefinition.setResource(alertDefinition.getResource());
            newAlertDefinition.setResourceType(alertDefinition.getResourceType());
            newAlertDefinition.setGroup(alertDefinition.getGroup());
            newAlertDefinition.setGroupAlertDefinition(alertDefinition.getGroupAlertDefinition());
            this.entityManager.persist((Object)newAlertDefinition);
            this.notifyAlertConditionCacheManager(subject, "copyAlertDefinitions", alertDefinition, AlertDefinitionEvent.CREATED);
        }
    }

    @Override
    public List<AlertDefinition> findAllRecoveryDefinitionsById(Subject subject, Integer alertDefinitionId) {
        if (!this.authorizationManager.isOverlord(subject)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to call " + "getAllRecoveryDefinitionsById; only the overlord has that right");
        }
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findAllByRecoveryDefinitionId");
        query.setParameter("recoveryDefinitionId", (Object)alertDefinitionId);
        List list = query.getResultList();
        return list;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public AlertDefinition updateAlertDefinition(Subject subject, int alertDefinitionId, AlertDefinition alertDefinition, boolean resetMatching) throws InvalidAlertDefinitionException, AlertDefinitionUpdateException {
        return this.updateAlertDefinitionInternal(subject, alertDefinitionId, alertDefinition, resetMatching, true, true);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public AlertDefinition updateDependentAlertDefinition(Subject subject, int alertDefinitionId, AlertDefinition alertDefinition, boolean resetMatching) throws InvalidAlertDefinitionException, AlertDefinitionUpdateException {
        return this.updateAlertDefinitionInternal(subject, alertDefinitionId, alertDefinition, resetMatching, false, false);
    }

    @Override
    public AlertDefinition updateAlertDefinitionInternal(Subject subject, int alertDefinitionId, AlertDefinition alertDefinition, boolean resetMatching, boolean checkPerms, boolean finalizeNotifications) throws InvalidAlertDefinitionException, AlertDefinitionUpdateException {
        if (resetMatching) {
            this.alertDefinitionManager.purgeInternals(alertDefinitionId);
        }
        AlertDefinition oldAlertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinitionId);
        if (checkPerms && !this.checkPermission(subject, oldAlertDefinition)) {
            if (oldAlertDefinition.getResourceType() != null) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to modify alert templates for type [" + oldAlertDefinition.getResourceType() + "]");
            }
            if (oldAlertDefinition.getGroup() != null) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to modify alert definitions for group [" + oldAlertDefinition.getGroup() + "]");
            }
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to modify alert definitions for resource [" + oldAlertDefinition.getResource() + "]");
        }
        boolean isResourceLevel = oldAlertDefinition.getResource() != null;
        this.checkAlertDefinition(subject, oldAlertDefinition, alertDefinition, isResourceLevel ? Integer.valueOf(oldAlertDefinition.getResource().getId()) : null, finalizeNotifications);
        if (oldAlertDefinition.getDeleted()) {
            throw new AlertDefinitionUpdateException("Can not update deleted " + oldAlertDefinition.toSimpleString());
        }
        AlertDefinitionUpdateType updateType = AlertDefinitionUpdateType.get(oldAlertDefinition, alertDefinition);
        if (isResourceLevel && (updateType == AlertDefinitionUpdateType.JUST_DISABLED || updateType == AlertDefinitionUpdateType.STILL_ENABLED)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updating AlertConditionCacheManager with AlertDefinition[ id=" + oldAlertDefinition.getId() + " ]...DELETING"));
                for (AlertCondition nextCondition : oldAlertDefinition.getConditions()) {
                    LOG.debug((Object)("OldAlertCondition[ id=" + nextCondition.getId() + " ]"));
                }
            }
            this.notifyAlertConditionCacheManager(subject, "updateAlertDefinition", oldAlertDefinition, AlertDefinitionEvent.DELETED);
        }
        if (alertDefinition.getConditions().size() == 1) {
            alertDefinition.setConditionExpression(BooleanExpression.ANY);
        }
        oldAlertDefinition.update(alertDefinition, resetMatching);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating: " + oldAlertDefinition));
            for (AlertCondition nextCondition : oldAlertDefinition.getConditions()) {
                LOG.debug((Object)("Condition: " + nextCondition));
            }
            for (AlertNotification nextNotification : oldAlertDefinition.getAlertNotifications()) {
                LOG.debug((Object)("Notification: " + nextNotification));
                LOG.debug((Object)("Notification-Configuration: " + nextNotification.getConfiguration().toString(true)));
                if (nextNotification.getExtraConfiguration() == null) continue;
                LOG.debug((Object)("Notification-Extra-Configuration: " + nextNotification.getExtraConfiguration().toString(true)));
            }
        }
        this.fixRecoveryId(oldAlertDefinition);
        oldAlertDefinition.setMtime(System.currentTimeMillis());
        AlertDefinition newAlertDefinition = (AlertDefinition)this.entityManager.merge((Object)oldAlertDefinition);
        if (isResourceLevel && (updateType == AlertDefinitionUpdateType.JUST_ENABLED || updateType == AlertDefinitionUpdateType.STILL_ENABLED)) {
            boolean addToCache = false;
            if (newAlertDefinition.getRecoveryId() != 0) {
                AlertDefinition toBeRecoveredDefinition = this.getAlertDefinitionById(subject, newAlertDefinition.getRecoveryId());
                if (!toBeRecoveredDefinition.getEnabled()) {
                    addToCache = true;
                }
            } else {
                addToCache = true;
            }
            if (addToCache) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating AlertConditionCacheManager with AlertDefinition[ id=" + newAlertDefinition.getId() + " ]...CREATING"));
                    for (AlertCondition nextCondition : newAlertDefinition.getConditions()) {
                        LOG.debug((Object)("NewAlertCondition[ id=" + nextCondition.getId() + " ]"));
                    }
                }
                this.notifyAlertConditionCacheManager(subject, "updateAlertDefinition", newAlertDefinition, AlertDefinitionEvent.CREATED);
            }
        }
        new ArrayList(newAlertDefinition.getConditions());
        new ArrayList(newAlertDefinition.getAlertNotifications());
        return newAlertDefinition;
    }

    private void checkAlertDefinition(Subject subject, AlertDefinition persistedAlertDefinition, AlertDefinition alertDefinition, Integer resourceId, boolean finalizeNotifications) throws InvalidAlertDefinitionException {
        if (alertDefinition.getDescription() != null && alertDefinition.getDescription().length() > 250) {
            alertDefinition.setDescription(alertDefinition.getDescription().substring(0, 250));
        }
        for (AlertCondition alertCondition : alertDefinition.getConditions()) {
            AlertConditionCategory alertConditionCategory = alertCondition.getCategory();
            if (alertConditionCategory == AlertConditionCategory.ALERT) {
                throw new InvalidAlertDefinitionException("AlertDefinitionManager does not yet support condition category: " + alertConditionCategory);
            }
            if (alertConditionCategory != AlertConditionCategory.BASELINE) continue;
            MeasurementDefinition def = alertCondition.getMeasurementDefinition();
            NumericType numType = (def = (MeasurementDefinition)this.entityManager.getReference(MeasurementDefinition.class, (Object)def.getId())).getNumericType();
            if (numType == null) {
                def = (MeasurementDefinition)this.entityManager.getReference(MeasurementDefinition.class, (Object)def.getId());
                numType = def.getNumericType();
            }
            if (numType == NumericType.DYNAMIC) continue;
            throw new InvalidAlertDefinitionException("Invalid Condition: '" + def.getDisplayName() + "' is a trending metric, and thus will never have baselines calculated for it.");
        }
        if (finalizeNotifications) {
            ArrayList<AlertNotification> notifications = new ArrayList<AlertNotification>(alertDefinition.getAlertNotifications());
            if (persistedAlertDefinition != null) {
                List persistedNotifications;
                List list = persistedNotifications = persistedAlertDefinition.getAlertNotifications() == null ? Collections.emptyList() : persistedAlertDefinition.getAlertNotifications();
                if (persistedNotifications.size() > 0) {
                    Iterator it = notifications.iterator();
                    block1: while (it.hasNext()) {
                        AlertNotification newNotification = (AlertNotification)it.next();
                        if (newNotification.getId() == 0) continue;
                        for (AlertNotification persistedNotification : persistedNotifications) {
                            if (!newNotification.getSenderName().equals(persistedNotification.getSenderName()) || !newNotification.equalsData(persistedNotification)) continue;
                            it.remove();
                            continue block1;
                        }
                    }
                }
            }
            if (!this.alertNotificationManager.finalizeNotifications(subject, notifications)) {
                throw new InvalidAlertDefinitionException("Some of the notifications failed to validate.");
            }
        }
    }

    private void notifyAlertConditionCacheManager(Subject subject, String methodName, AlertDefinition alertDefinition, AlertDefinitionEvent alertDefinitionEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Invoking... " + methodName + " with AlertDefinitionEvent[" + (Object)((Object)alertDefinitionEvent) + "]"));
        }
        if (alertDefinitionEvent == AlertDefinitionEvent.CREATED) {
            if (alertDefinition.getResource() != null) {
                int resourceId = alertDefinition.getResource().getId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Invoking... agentStatusManager.updateByResource(" + resourceId + ")"));
                }
                this.agentStatusManager.updateByResource(subject, resourceId);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"notifyAlertConditionCacheManager skipping alert template or group alert definition");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Invoking... agentStatusManager.updateByAlertDefinition(" + alertDefinition.getId() + ")"));
            }
            this.agentStatusManager.updateByAlertDefinition(subject, alertDefinition.getId());
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void purgeInternals(int alertDefinitionId) {
        try {
            Query alertDampeningEventPurgeQuery = this.entityManager.createNamedQuery("AlertDampeningEvent.deleteByAlertDefinitionId");
            Query unmatchedAlertConditionLogPurgeQuery = this.entityManager.createNamedQuery("AlertConditionLog.deleteUnmatchedByAlertDefinitionId");
            alertDampeningEventPurgeQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
            unmatchedAlertConditionLogPurgeQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
            int alertDampeningEventPurgeCount = alertDampeningEventPurgeQuery.executeUpdate();
            int unmatchedAlertConditionLogPurgeCount = unmatchedAlertConditionLogPurgeQuery.executeUpdate();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Update to AlertDefinition[id=" + alertDefinitionId + " caused a purge of internal, dampening constructs."));
                if (alertDampeningEventPurgeCount > 0) {
                    LOG.debug((Object)("Removed " + alertDampeningEventPurgeCount + " AlertDampeningEvent" + (alertDampeningEventPurgeCount == 1 ? "" : "s")));
                }
                if (unmatchedAlertConditionLogPurgeCount > 0) {
                    LOG.debug((Object)("Removed " + unmatchedAlertConditionLogPurgeCount + " unmatched AlertConditionLog" + (unmatchedAlertConditionLogPurgeCount == 1 ? "" : "s")));
                }
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)("Could not purge internal alerting constructs for: " + alertDefinitionId), t);
        }
    }

    @Override
    public int purgeUnusedAlertDefinitions() {
        Query purgeQuery = this.entityManager.createNamedQuery("AlertDefinition.findUnusedDefinitionIds");
        List resultIds = purgeQuery.getResultList();
        int removed = 0;
        Iterator i$ = resultIds.iterator();
        while (i$.hasNext()) {
            int unusedDefinitionId = (Integer)i$.next();
            AlertDefinition unusedDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)unusedDefinitionId);
            if (unusedDefinition != null) {
                this.entityManager.remove((Object)unusedDefinition);
                ++removed;
                continue;
            }
            LOG.warn((Object)("Could not find alertDefinition[id=" + unusedDefinitionId + "] for purge"));
        }
        return removed;
    }

    @Override
    public AlertDefinition getAlertDefinition(Subject subject, int alertDefinitionId) {
        return this.getAlertDefinitionById(subject, alertDefinitionId);
    }

    @Override
    public PageList<AlertDefinition> findAlertDefinitionsByCriteria(Subject subject, AlertDefinitionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject) && !criteria.isTemplateCriteria()) {
            CriteriaQueryGenerator.AuthorizationTokenType tokenType = criteria.isGroupCriteria() ? CriteriaQueryGenerator.AuthorizationTokenType.GROUP : CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE;
            generator.setAuthorizationResourceFragment(tokenType, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public String[] getAlertNotificationConfigurationPreview(Subject sessionSubject, AlertNotification[] notifications) {
        if (notifications == null || notifications.length == 0) {
            return new String[0];
        }
        AlertSenderPluginManager alertPluginManager = this.alertManager.getAlertPluginManager();
        String[] previews = new String[notifications.length];
        int i = 0;
        for (AlertNotification notif : notifications) {
            AlertSender sender = alertPluginManager.getAlertSenderForNotification(notif);
            previews[i++] = sender != null ? sender.previewConfiguration() : "n/a (unknown sender)";
        }
        return previews;
    }

    static enum AlertDefinitionUpdateType {
        JUST_ENABLED,
        JUST_DISABLED,
        STILL_ENABLED,
        STILL_DISABLED;


        public static AlertDefinitionUpdateType get(AlertDefinition oldDefinition, AlertDefinition newDefinition) {
            if (!oldDefinition.getEnabled() && newDefinition.getEnabled()) {
                return JUST_ENABLED;
            }
            if (oldDefinition.getEnabled() && !newDefinition.getEnabled()) {
                return JUST_DISABLED;
            }
            if (oldDefinition.getEnabled() && newDefinition.getEnabled()) {
                return STILL_ENABLED;
            }
            return STILL_DISABLED;
        }
    }
}

