/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertDefinitionCreationException;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionUpdateException;
import org.rhq.enterprise.server.alert.GroupAlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.InvalidAlertDefinitionException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.safeinvoker.HibernateDetachUtility;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class GroupAlertDefinitionManagerBean
implements GroupAlertDefinitionManagerLocal {
    private static final Log LOG = LogFactory.getLog(GroupAlertDefinitionManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private SubjectManagerLocal subjectManager;

    @Override
    @Deprecated
    public PageList<AlertDefinition> findGroupAlertDefinitions(Subject subject, int resourceGroupId, PageControl pageControl) {
        pageControl.initDefaultOrderingField("ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceGroup");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"AlertDefinition.findByResourceGroup", (PageControl)pageControl);
        queryCount.setParameter("groupId", (Object)resourceGroupId);
        query.setParameter("groupId", (Object)resourceGroupId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        return new PageList((Collection)list, (int)totalCount, pageControl);
    }

    private List<Integer> getChildrenAlertDefinitionIds(int groupAlertDefinitionId) {
        TypedQuery query = this.entityManager.createNamedQuery("AlertDefinition.findByGroupAlertDefinitionId", Integer.class);
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        return query.getResultList();
    }

    @Override
    public int removeGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (null == groupAlertDefinitionIds || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        ArrayList<Integer> allChildDefinitionIds = new ArrayList<Integer>();
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            AlertDefinition groupAlertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)groupAlertDefinitionId);
            if (null == groupAlertDefinition) continue;
            groupAlertDefinition.setDeleted(true);
            groupAlertDefinition.setGroup(null);
            ++modified;
            Subject overlord = this.subjectManager.getOverlord();
            List<Integer> childDefinitionIds = this.getChildrenAlertDefinitionIds(groupAlertDefinitionId);
            if (childDefinitionIds.isEmpty()) continue;
            allChildDefinitionIds.addAll(childDefinitionIds);
            this.alertDefinitionManager.removeResourceAlertDefinitions(overlord, ArrayUtils.unwrapCollection(childDefinitionIds));
            Query query = this.entityManager.createNamedQuery("AlertDefinition.updateDetachProtectedGroupAlertDefs");
            query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
            int numDetached = query.executeUpdate();
        }
        if (!allChildDefinitionIds.isEmpty()) {
            this.breakLinks(allChildDefinitionIds);
        }
        return modified;
    }

    private void breakLinks(List<Integer> ids) {
        Query breakLinksQuery = this.entityManager.createNamedQuery("AlertDefinition.updateSetParentsNull");
        while (!ids.isEmpty()) {
            List<Integer> subList = ids.subList(0, Math.min(500, ids.size()));
            breakLinksQuery.setParameter("childrenDefinitionIds", subList);
            breakLinksQuery.executeUpdate();
            subList.clear();
        }
    }

    private List<Integer> getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(Subject subject, int groupAlertDefinitionId, int resourceGroupId) {
        Query query = this.entityManager.createNamedQuery("AlertDefinition.findResourceIdsNeedingGroupApplication");
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        query.setParameter("resourceGroupId", (Object)resourceGroupId);
        query.setParameter("inventoryStatus", (Object)InventoryStatus.COMMITTED);
        List list = query.getResultList();
        return list;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public int createGroupAlertDefinitions(Subject subject, AlertDefinition groupAlertDefinition, Integer resourceGroupId) throws InvalidAlertDefinitionException, AlertDefinitionCreationException {
        ResourceGroup group = this.resourceGroupManager.getResourceGroupById(subject, resourceGroupId, null);
        groupAlertDefinition.setGroup(group);
        AlertDefinition persistedDefinition = null;
        int groupAlertDefinitionId = 0;
        try {
            persistedDefinition = this.alertDefinitionManager.createAlertDefinitionInNewTransaction(subject, groupAlertDefinition, null, true);
            groupAlertDefinitionId = persistedDefinition.getId();
        }
        catch (Throwable t) {
            throw new AlertDefinitionCreationException("Could not create groupAlertDefinitions for " + group + " with data " + groupAlertDefinition.toSimpleString(), t);
        }
        Throwable firstThrowable = null;
        List<Integer> resourceIdsForGroup = this.getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(subject, groupAlertDefinitionId, resourceGroupId);
        ArrayList<Integer> resourceIdsInError = new ArrayList<Integer>();
        for (Integer resourceId : resourceIdsForGroup) {
            try {
                AlertDefinition childAlertDefinition = new AlertDefinition(persistedDefinition);
                childAlertDefinition.setGroupAlertDefinition(groupAlertDefinition);
                this.alertDefinitionManager.createDependentAlertDefinition(subject, childAlertDefinition, resourceId);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                resourceIdsInError.add(resourceId);
            }
        }
        if (firstThrowable != null) {
            throw new AlertDefinitionCreationException("Could not create alert definition child for Resources " + resourceIdsInError + " with group " + groupAlertDefinition.toSimpleString(), firstThrowable);
        }
        return groupAlertDefinitionId;
    }

    @Override
    public int disableGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (null == groupAlertDefinitionIds || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            AlertDefinition groupAlertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)groupAlertDefinitionId);
            if (null == groupAlertDefinition || !groupAlertDefinition.getEnabled() || groupAlertDefinition.getDeleted()) continue;
            groupAlertDefinition.setEnabled(false);
            ++modified;
            List<Integer> childDefinitionIds = this.getChildrenAlertDefinitionIds(groupAlertDefinitionId);
            if (childDefinitionIds.isEmpty()) continue;
            Subject overlord = this.subjectManager.getOverlord();
            this.alertDefinitionManager.disableResourceAlertDefinitions(overlord, ArrayUtils.unwrapCollection(childDefinitionIds));
        }
        return modified;
    }

    @Override
    public int enableGroupAlertDefinitions(Subject subject, Integer[] groupAlertDefinitionIds) {
        if (null == groupAlertDefinitionIds || groupAlertDefinitionIds.length == 0) {
            return 0;
        }
        int modified = 0;
        for (Integer groupAlertDefinitionId : groupAlertDefinitionIds) {
            AlertDefinition groupAlertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)groupAlertDefinitionId);
            if (null == groupAlertDefinition || groupAlertDefinition.getEnabled() || groupAlertDefinition.getDeleted()) continue;
            groupAlertDefinition.setEnabled(true);
            ++modified;
            List<Integer> childDefinitionIds = this.getChildrenAlertDefinitionIds(groupAlertDefinitionId);
            if (childDefinitionIds.isEmpty()) continue;
            Subject overlord = this.subjectManager.getOverlord();
            this.alertDefinitionManager.enableResourceAlertDefinitions(overlord, ArrayUtils.unwrapCollection(childDefinitionIds));
        }
        return modified;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public AlertDefinition updateGroupAlertDefinitions(Subject subject, AlertDefinition groupAlertDefinition, boolean resetMatching) throws InvalidAlertDefinitionException, AlertDefinitionUpdateException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("updateGroupAlertDefinition: " + groupAlertDefinition));
        }
        AlertDefinition updated = null;
        try {
            updated = this.alertDefinitionManager.updateAlertDefinition(subject, groupAlertDefinition.getId(), groupAlertDefinition, resetMatching);
        }
        catch (Throwable t) {
            throw new AlertDefinitionUpdateException("Failed to update a GroupAlertDefinition: " + groupAlertDefinition.toSimpleString(), t);
        }
        Subject overlord = this.subjectManager.getOverlord();
        Throwable firstThrowable = null;
        List<Integer> alertDefinitions = this.getChildrenAlertDefinitionIds(groupAlertDefinition.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Need to update the following children alert definition ids: " + alertDefinitions));
        }
        ArrayList<Integer> alertDefinitionIdsInError = new ArrayList<Integer>();
        for (Integer alertDefinitionId : alertDefinitions) {
            try {
                this.alertDefinitionManager.updateDependentAlertDefinition(subject, alertDefinitionId, updated, resetMatching);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                alertDefinitionIdsInError.add(alertDefinitionId);
            }
        }
        List<Integer> resourceIds = this.getCommittedResourceIdsNeedingGroupAlertDefinitionApplication(overlord, groupAlertDefinition.getId(), this.getResourceGroupIdForAlertDefinitionId(groupAlertDefinition.getId()));
        ArrayList<Integer> resourceIdsInError = new ArrayList<Integer>();
        for (Integer resourceId : resourceIds) {
            try {
                AlertDefinition childAlertDefinition = new AlertDefinition(updated);
                childAlertDefinition.setGroupAlertDefinition(groupAlertDefinition);
                this.alertDefinitionManager.createAlertDefinitionInNewTransaction(subject, childAlertDefinition, resourceId, false);
            }
            catch (Throwable t) {
                if (firstThrowable == null) {
                    firstThrowable = t;
                }
                resourceIdsInError.add(resourceId);
            }
        }
        if (firstThrowable != null) {
            StringBuilder error = new StringBuilder();
            if (alertDefinitionIdsInError.size() != 0) {
                error.append("Failed to update child AlertDefinitions " + alertDefinitionIdsInError + " ; ");
            }
            if (resourceIdsInError.size() != 0) {
                error.append("Failed to re-create child AlertDefinition for Resources " + resourceIdsInError + "; ");
            }
            throw new AlertDefinitionUpdateException(error.toString(), firstThrowable);
        }
        return updated;
    }

    @Override
    public void addGroupMemberAlertDefinitions(Subject subject, int resourceGroupId, int[] addedResourceIds) throws AlertDefinitionCreationException {
        if (addedResourceIds == null || addedResourceIds.length == 0) {
            return;
        }
        ArrayList<Integer> resourceIdsInError = new ArrayList<Integer>();
        Throwable firstThrowable = null;
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterResourceGroupIds(new Integer[]{resourceGroupId});
        criteria.fetchGroupAlertDefinition(false);
        criteria.fetchConditions(true);
        criteria.fetchAlertNotifications(true);
        criteria.setPaging(0, Integer.MAX_VALUE);
        PageList<AlertDefinition> groupAlertDefinitions = this.alertDefinitionManager.findAlertDefinitionsByCriteria(subject, criteria);
        for (AlertDefinition groupAlertDefinition : groupAlertDefinitions) {
            int[] arr$ = addedResourceIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer resourceId = arr$[i$];
                try {
                    AlertDefinition childAlertDefinition = new AlertDefinition(groupAlertDefinition);
                    AlertDefinition groupAlertDefinitionPojo = new AlertDefinition();
                    groupAlertDefinitionPojo.setId(groupAlertDefinition.getId());
                    childAlertDefinition.setGroupAlertDefinition(groupAlertDefinitionPojo);
                    HibernateDetachUtility.nullOutUninitializedFields((Object)childAlertDefinition, (HibernateDetachUtility.SerializationType)HibernateDetachUtility.SerializationType.SERIALIZATION);
                    this.alertDefinitionManager.createAlertDefinitionInNewTransaction(this.subjectManager.getOverlord(), childAlertDefinition, resourceId, false);
                    continue;
                }
                catch (Throwable t) {
                    if (firstThrowable == null) {
                        firstThrowable = t;
                    }
                    resourceIdsInError.add(resourceId);
                }
            }
        }
        if (firstThrowable != null) {
            throw new AlertDefinitionCreationException("Could not create group alert definition children for Resources " + resourceIdsInError + " under ResourceGroup[id=" + resourceGroupId + "]", firstThrowable);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void purgeAllGroupAlertDefinitions(Subject subject, int resourceGroupId) {
        Integer[] groupAlertDefinitionIdsForResourceGroup = this.findGroupAlertDefinitionIds(resourceGroupId);
        this.removeGroupAlertDefinitions(subject, groupAlertDefinitionIdsForResourceGroup);
    }

    private Integer[] findGroupAlertDefinitionIds(int resourceGroupId) {
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterResourceGroupIds(new Integer[]{resourceGroupId});
        criteria.setPageControl(PageControl.getUnlimitedInstance());
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator((Criteria)criteria);
        generator.alterProjection("alertdefinition.id");
        Query query = generator.getQuery(this.entityManager);
        List groupAlertDefinitionIds = query.getResultList();
        Integer[] results = groupAlertDefinitionIds.toArray(new Integer[groupAlertDefinitionIds.size()]);
        return results;
    }

    @Override
    public void removeGroupMemberAlertDefinitions(Subject subject, int resourceGroupId, Integer[] removedResourceIds) {
        if (removedResourceIds == null || removedResourceIds.length == 0) {
            return;
        }
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addFilterResourceIds(removedResourceIds);
        criteria.addFilterGroupAlertDefinitionGroupId(Integer.valueOf(resourceGroupId));
        criteria.addFilterDeleted(Boolean.valueOf(false));
        criteria.clearPaging();
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList alertDefinitions = queryRunner.execute();
        if (alertDefinitions.isEmpty()) {
            return;
        }
        ArrayList<Integer> allMemberAlertDefinitionIds = new ArrayList<Integer>(alertDefinitions.size());
        ArrayList<Integer> attachedMemberAlertDefinitionIds = new ArrayList<Integer>(alertDefinitions.size());
        for (AlertDefinition ad : alertDefinitions) {
            Integer id = ad.getId();
            allMemberAlertDefinitionIds.add(id);
            if (ad.isReadOnly()) continue;
            attachedMemberAlertDefinitionIds.add(id);
        }
        if (!attachedMemberAlertDefinitionIds.isEmpty()) {
            int[] groupMemberAlertDefinitionIdsArray = ArrayUtils.unwrapCollection(attachedMemberAlertDefinitionIds);
            this.alertDefinitionManager.removeAlertDefinitions(this.subjectManager.getOverlord(), groupMemberAlertDefinitionIdsArray);
        }
        this.breakLinks(allMemberAlertDefinitionIds);
        alertDefinitions.clear();
        allMemberAlertDefinitionIds.clear();
        attachedMemberAlertDefinitionIds.clear();
    }

    private int getResourceGroupIdForAlertDefinitionId(int groupAlertDefinitionId) {
        Query query = this.entityManager.createQuery("SELECT groupAlertDefinition.group.id   FROM AlertDefinition groupAlertDefinition  WHERE groupAlertDefinition.id = :groupAlertDefinitionId");
        query.setParameter("groupAlertDefinitionId", (Object)groupAlertDefinitionId);
        int groupId = ((Number)query.getSingleResult()).intValue();
        return groupId;
    }
}

