/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.auth;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.crypto.CryptoUtil;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.rhq.core.domain.auth.Principal;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.RoleCriteria;
import org.rhq.core.domain.criteria.SavedSearchCriteria;
import org.rhq.core.domain.criteria.SubjectCriteria;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.search.SavedSearch;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SessionNotFoundException;
import org.rhq.enterprise.server.auth.SessionTimeoutException;
import org.rhq.enterprise.server.auth.SubjectException;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.auth.SubjectManagerRemote;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.authz.RoleManagerLocal;
import org.rhq.enterprise.server.content.RepoManagerLocal;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.search.SavedSearchManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class SubjectManagerBean
implements SubjectManagerLocal,
SubjectManagerRemote {
    private final Log log = LogFactory.getLog(SubjectManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private LdapGroupManagerLocal ldapManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private AlertNotificationManagerLocal alertNotificationManager;
    @EJB
    private RoleManagerLocal roleManager;
    @EJB
    private RepoManagerLocal repoManager;
    @EJB
    private SavedSearchManagerLocal savedSearchManager;
    @Resource
    private TimerService timerService;
    private SessionManager sessionManager = SessionManager.getInstance();

    @Override
    public void scheduleSessionPurgeJob() {
        Collection timers = this.timerService.getTimers();
        for (Timer existingTimer : timers) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found timer - attempting to cancel: " + existingTimer.toString()));
            }
            try {
                existingTimer.cancel();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed in attempting to cancel timer: " + existingTimer.toString()));
            }
        }
        this.timerService.createIntervalTimer(60000L, 60000L, new TimerConfig(null, false));
    }

    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void purgeTimedOutSessions() {
        try {
            this.sessionManager.purgeTimedOutSessions();
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to purge timed out sessions - will try again later. Cause: " + t));
        }
    }

    @Override
    public Subject loadUserConfiguration(Integer subjectId) {
        Subject subject = (Subject)this.entityManager.find(Subject.class, (Object)subjectId);
        Configuration config = subject.getUserConfiguration();
        if (config != null && config.getProperties() != null) {
            config.getProperties().size();
        }
        if (subject.getRoles() != null) {
            subject.getRoles().size();
        }
        return subject;
    }

    @Override
    public Subject updateSubject(Subject whoami, Subject subjectToModify) {
        Set<Permission> globalPermissions = this.authorizationManager.getExplicitGlobalPermissions(whoami);
        if (!whoami.equals((Object)subjectToModify) && !globalPermissions.contains(Permission.MANAGE_SECURITY)) {
            throw new PermissionException("You [" + whoami.getName() + "] do not have permission to update user [" + subjectToModify.getName() + "].");
        }
        if (this.authorizationManager.isSystemSuperuser(subjectToModify) && !subjectToModify.getFactive()) {
            throw new PermissionException("You cannot disable system user [" + subjectToModify.getName() + "] - it must always be active.");
        }
        Subject currentSubject = (Subject)this.entityManager.find(Subject.class, (Object)subjectToModify.getId());
        subjectToModify.setRoles(currentSubject.getRoles());
        subjectToModify.setLdapRoles(currentSubject.getLdapRoles());
        subjectToModify.setOwnedGroups(currentSubject.getOwnedGroups());
        return (Subject)this.entityManager.merge((Object)subjectToModify);
    }

    @Override
    public Subject createSubject(Subject whoami, Subject subjectToCreate, String password) throws SubjectException, EntityExistsException {
        if (this.getSubjectByName(subjectToCreate.getName()) != null) {
            throw new EntityExistsException("A user named [" + subjectToCreate.getName() + "] already exists.");
        }
        if (subjectToCreate.getFsystem()) {
            throw new SubjectException("Cannot create new system users: " + subjectToCreate.getName());
        }
        this.entityManager.persist((Object)subjectToCreate);
        this.createPrincipal(whoami, subjectToCreate.getName(), password);
        return subjectToCreate;
    }

    @Override
    public Subject updateSubject(Subject whoami, Subject subjectToModify, String newPassword) {
        Set<Permission> globalPermissions = this.authorizationManager.getExplicitGlobalPermissions(whoami);
        boolean isSecurityManager = globalPermissions.contains(Permission.MANAGE_SECURITY);
        if (!whoami.equals((Object)subjectToModify) && !isSecurityManager) {
            throw new PermissionException("You [" + whoami.getName() + "] do not have permission to update user [" + subjectToModify.getName() + "].");
        }
        boolean subjectToModifyIsSystemSuperuser = this.authorizationManager.isSystemSuperuser(subjectToModify);
        if (!subjectToModify.getFactive() && subjectToModifyIsSystemSuperuser) {
            throw new PermissionException("You cannot disable the system user [" + subjectToModify.getName() + "].");
        }
        Subject attachedSubject = this.getSubjectById(subjectToModify.getId());
        if (attachedSubject == null) {
            throw new IllegalArgumentException("No user exists with id [" + subjectToModify.getId() + "].");
        }
        if (!attachedSubject.getName().equals(subjectToModify.getName())) {
            throw new IllegalArgumentException("You cannot change a user's username.");
        }
        Set newRoles = subjectToModify.getRoles();
        if (newRoles != null) {
            boolean rolesChanged;
            HashSet<Role> currentRoles = new HashSet<Role>((Collection<Role>)this.roleManager.findRolesBySubject(subjectToModify.getId(), PageControl.getUnlimitedInstance()));
            boolean bl = rolesChanged = !newRoles.containsAll(currentRoles) || !currentRoles.containsAll(newRoles);
            if (rolesChanged) {
                int[] newRoleIds = new int[newRoles.size()];
                int i = 0;
                for (Role role : newRoles) {
                    newRoleIds[i++] = role.getId();
                }
                this.roleManager.setAssignedSubjectRoles(whoami, subjectToModify.getId(), newRoleIds);
            }
        }
        boolean ldapRolesModified = false;
        Set newLdapRoles = subjectToModify.getLdapRoles();
        if (newLdapRoles == null) {
            newLdapRoles = Collections.emptySet();
        }
        if (newLdapRoles != null) {
            RoleCriteria subjectLdapRolesCriteria = new RoleCriteria();
            subjectLdapRolesCriteria.addFilterLdapSubjectId(Integer.valueOf(subjectToModify.getId()));
            subjectLdapRolesCriteria.clearPaging();
            PageList<Role> currentLdapRoles = this.roleManager.findRolesByCriteria(whoami, subjectLdapRolesCriteria);
            ldapRolesModified = !currentLdapRoles.containsAll(newLdapRoles) || !newLdapRoles.containsAll((Collection<?>)currentLdapRoles);
        }
        boolean isUserWithPrincipal = this.isUserWithPrincipal(subjectToModify.getName());
        if (ldapRolesModified) {
            if (!isSecurityManager) {
                throw new PermissionException("You cannot change the LDAP roles assigned to [" + subjectToModify.getName() + "] - only a user with the MANAGE_SECURITY permission can do so.");
            }
            if (isUserWithPrincipal) {
                throw new PermissionException("You cannot set LDAP roles on non-LDAP user [" + subjectToModify.getName() + "].");
            }
        }
        if (newPassword != null) {
            if (!this.isUserWithPrincipal(subjectToModify.getName())) {
                throw new IllegalArgumentException("You cannot set a password for an LDAP user.");
            }
            this.changePasswordInternal(subjectToModify.getName(), newPassword);
        }
        return (Subject)this.entityManager.merge((Object)subjectToModify);
    }

    @Override
    public Subject getOverlord() {
        return this.sessionManager.getOverlord();
    }

    @Override
    public Subject getSubjectByName(String username) {
        SubjectCriteria c = new SubjectCriteria();
        c.addFilterName(username);
        c.setStrict(true);
        PageList<Subject> result = this.findSubjectsByCriteria(this.getOverlord(), c);
        return result.isEmpty() ? null : (Subject)result.get(0);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public Subject createSubject(Subject whoami, Subject subject) throws SubjectException {
        if (this.getSubjectByName(subject.getName()) != null) {
            throw new EntityExistsException("A user named [" + subject.getName() + "] already exists.");
        }
        if (subject.getFsystem()) {
            throw new SubjectException("Cannot create new system subjects: " + subject.getName());
        }
        subject.setRoles(null);
        subject.setLdapRoles(null);
        subject.setOwnedGroups(null);
        Configuration configuration = subject.getUserConfiguration();
        if (configuration != null) {
            configuration = (Configuration)this.entityManager.merge((Object)configuration);
            subject.setUserConfiguration(configuration);
        }
        this.entityManager.persist((Object)subject);
        return subject;
    }

    @Override
    public Subject getSubjectById(int id) {
        Subject subject = (Subject)this.entityManager.find(Subject.class, (Object)id);
        return subject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Subject login(String username, String password) throws org.rhq.enterprise.server.exception.LoginException {
        if (password == null) {
            throw new org.rhq.enterprise.server.exception.LoginException("No password was given");
        }
        this._checkAuthentication(username, password);
        Subject subject = this.getSubjectByName(username);
        if (subject != null) {
            if (!subject.getFactive()) {
                throw new org.rhq.enterprise.server.exception.LoginException("User account has been disabled.");
            }
            int rolesNumber = subject.getRoles().size();
            if (rolesNumber != 0) return this.sessionManager.put(subject);
            if (!this.systemManager.isLoginWithoutRolesEnabled()) throw new org.rhq.enterprise.server.exception.LoginException("There are no preconfigured roles for user [" + subject.getName() + "]");
            if (!this.log.isInfoEnabled()) return this.sessionManager.put(subject);
            this.log.info((Object)("Letting in user [" + subject.getName() + "]  without any assigned roles."));
            return this.sessionManager.put(subject);
        } else {
            boolean isLdapAuthenticationEnabled = this.isLdapAuthenticationEnabled();
            if (!isLdapAuthenticationEnabled) throw new IllegalStateException("Somehow you authenticated with a principal that has no associated subject. Your account is invalid.");
            subject = new Subject();
            subject.setId(0);
            subject.setName(username);
            subject.setFactive(true);
            subject.setFsystem(false);
        }
        return this.sessionManager.put(subject);
    }

    @Override
    public Subject checkAuthentication(String username, String password) {
        try {
            this._checkAuthentication(username, password);
            return this.getSubjectByName(username);
        }
        catch (org.rhq.enterprise.server.exception.LoginException e) {
            return null;
        }
    }

    private void _checkAuthentication(String username, String password) throws org.rhq.enterprise.server.exception.LoginException {
        try {
            UsernamePasswordHandler handler = new UsernamePasswordHandler(username, password.toCharArray());
            LoginContext loginContext = new LoginContext("RHQUserSecurityDomain", (CallbackHandler)handler);
            loginContext.login();
            loginContext.getSubject().getPrincipals().iterator().next();
            loginContext.logout();
        }
        catch (LoginException e) {
            throw new org.rhq.enterprise.server.exception.LoginException(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Subject processSubjectForLdap(Subject subject, String subjectPassword) throws org.rhq.enterprise.server.exception.LoginException {
        Subject sessionSubject;
        if (subject == null) return subject;
        boolean userHasPrincipal = this.isUserWithPrincipal(subject.getName());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing subject '" + subject.getName() + "' for LDAP check, userHasPrincipal:" + userHasPrincipal));
        }
        if (userHasPrincipal) {
            return subject;
        }
        boolean isLdapAuthenticationEnabled = this.isLdapAuthenticationEnabled();
        if (!isLdapAuthenticationEnabled) throw new org.rhq.enterprise.server.exception.LoginException("You are authenticated for LDAP, but LDAP is not configured.");
        try {
            sessionSubject = this.sessionManager.getSubject(subject.getSessionId());
        }
        catch (SessionNotFoundException e) {
            throw new org.rhq.enterprise.server.exception.LoginException("User session not valid. Login to proceed.");
        }
        catch (SessionTimeoutException e) {
            throw new org.rhq.enterprise.server.exception.LoginException("User session not valid. Login to proceed.");
        }
        if (!subject.getName().equals(sessionSubject.getName())) {
            throw new org.rhq.enterprise.server.exception.LoginException("User session not valid. Login to proceed.");
        }
        if (subject.getId() == 0) {
            SubjectCriteria subjectCriteria = new SubjectCriteria();
            subjectCriteria.setCaseSensitive(false);
            subjectCriteria.setStrict(true);
            subjectCriteria.fetchRoles(false);
            subjectCriteria.fetchConfiguration(false);
            subjectCriteria.addFilterName(subject.getName());
            PageList<Subject> subjectsLocated = this.findSubjectsByCriteria(this.getOverlord(), subjectCriteria);
            if (!subjectsLocated.isEmpty() && !((Subject)subjectsLocated.get(0)).getName().equals(subject.getName())) {
                Subject ldapSubject = (Subject)subjectsLocated.get(0);
                String msg = "Located existing ldap account with different case for [" + ldapSubject.getName() + "]. " + "Attempting to authenticate with that account instead.";
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)msg);
                }
                this.logout(subject.getSessionId());
                subject = this.login(ldapSubject.getName(), subjectPassword);
                Integer sessionId = subject.getSessionId();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Logged in as [" + ldapSubject.getName() + "] with session id [" + sessionId + "]"));
                }
            } else {
                Subject superuser = this.getOverlord();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("registering new LDAP-authenticated subject [" + subject.getName() + "]"));
                }
                this.createSubject(superuser, subject);
                subject.setFactive(true);
                this.logout(subject.getSessionId());
                subject = this.login(subject.getName(), subjectPassword);
                this.prepopulateLdapFields(subject);
                Configuration newUserConfig = new Configuration();
                PropertySimple simple = new PropertySimple("isNewUser", (Object)true);
                newUserConfig.put((Property)simple);
                subject.setUserConfiguration(newUserConfig);
            }
        }
        if (!this.isLdapAuthorizationEnabled()) return subject;
        ArrayList<String> groupNames = new ArrayList<String>(this.ldapManager.findAvailableGroupsFor(subject.getName()));
        if (groupNames.isEmpty()) {
            if (!this.systemManager.isLoginWithoutRolesEnabled()) throw new org.rhq.enterprise.server.exception.LoginException("You are authenticated for LDAP, but there are no preconfigured roles for you.");
            if (!this.log.isInfoEnabled()) return subject;
            this.log.info((Object)("Letting in user [" + subject.getName() + "]  without any assigned roles."));
            return subject;
        } else {
            if (!this.log.isDebugEnabled()) return subject;
            this.log.debug((Object)("Updating LDAP authorization data for user [" + subject.getName() + "] with LDAP groups " + groupNames + "..."));
            this.ldapManager.assignRolesToLdapSubject(subject.getId(), groupNames);
        }
        return subject;
    }

    @Override
    public void logout(Subject subject) {
        try {
            Subject s = this.getSubjectByNameAndSessionId(subject.getName(), subject.getSessionId());
            this.sessionManager.invalidate(s.getSessionId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void logout(int sessionId) {
        this.sessionManager.invalidate(sessionId);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void createPrincipal(Subject whoami, String username, String password) throws SubjectException {
        Principal principal = new Principal(username, CryptoUtil.createPasswordHash((String)"MD5", (String)"base64", null, null, (String)password));
        this.createPrincipal(whoami, principal);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void createPrincipal(Subject whoami, Principal principal) throws SubjectException {
        try {
            this.entityManager.persist((Object)principal);
        }
        catch (Exception e) {
            throw new SubjectException("Failed to create " + principal + ".", e);
        }
    }

    @Override
    public void changePassword(Subject whoami, String username, String password) {
        if (!whoami.getName().equals(username) && !this.authorizationManager.hasGlobalPermission(whoami, Permission.MANAGE_SECURITY)) {
            throw new PermissionException("You do not have permission to change the password for user [" + username + "]");
        }
        this.changePasswordInternal(username, password);
    }

    private void changePasswordInternal(String username, String password) {
        Query query = this.entityManager.createNamedQuery("Principal.findByUsername");
        query.setParameter("principal", (Object)username);
        Principal principal = (Principal)query.getSingleResult();
        String passwordHash = CryptoUtil.createPasswordHash((String)"MD5", (String)"BASE64", null, null, (String)password);
        principal.setPassword(passwordHash);
    }

    @Override
    public boolean isUserWithPrincipal(String username) {
        try {
            Query q = this.entityManager.createNamedQuery("Principal.findByUsername");
            q.setParameter("principal", (Object)username);
            Principal principal = (Principal)q.getSingleResult();
            return principal != null;
        }
        catch (NoResultException e) {
            return false;
        }
    }

    @Override
    public Collection<String> findAllUsersWithPrincipals() {
        Query q = this.entityManager.createNamedQuery("Principal.findAllUsers");
        List principals = q.getResultList();
        ArrayList<String> users = new ArrayList<String>();
        for (Principal p : principals) {
            users.add(p.getPrincipal());
        }
        return users;
    }

    @Override
    public Subject loginUnauthenticated(String username) throws org.rhq.enterprise.server.exception.LoginException {
        if ("admin".equals(username)) {
            return this.getOverlord();
        }
        Subject subject = this.getSubjectByName(username);
        if (subject == null) {
            throw new org.rhq.enterprise.server.exception.LoginException("User account does not exist. [" + username + "]");
        }
        if (!subject.getFactive()) {
            throw new org.rhq.enterprise.server.exception.LoginException("User account has been disabled. [" + username + "]");
        }
        subject = this.sessionManager.put(subject, 120000L);
        return subject;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void deleteUsers(Subject subject, int[] subjectIds) {
        int[] arr$ = subjectIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            List ownedGroups;
            Integer doomedSubjectId = arr$[i$];
            Subject doomedSubject = this.getSubjectById(doomedSubjectId);
            if (subject.getName().equals(doomedSubject.getName())) {
                throw new PermissionException("You cannot remove yourself: " + doomedSubject.getName());
            }
            if (this.authorizationManager.isSystemSuperuser(doomedSubject)) {
                throw new PermissionException("You cannot delete a system root user - they must always exist");
            }
            Set roles = doomedSubject.getRoles();
            doomedSubject.setRoles(new HashSet());
            for (Role doomedRoleRelationship : roles) {
                doomedRoleRelationship.removeSubject(doomedSubject);
            }
            if (this.isUserWithPrincipal(doomedSubject.getName())) {
                this.deletePrincipal(doomedSubject);
            }
            if (null != (ownedGroups = doomedSubject.getOwnedGroups()) && !ownedGroups.isEmpty()) {
                int size = ownedGroups.size();
                int[] ownedGroupIds = new int[size];
                for (int i = 0; i < size; ++i) {
                    ownedGroupIds[i] = ((ResourceGroup)ownedGroups.get(i)).getId();
                }
                try {
                    this.resourceGroupManager.deleteResourceGroups(subject, ownedGroupIds);
                }
                catch (Throwable t) {
                    if (this.log.isDebugEnabled()) {
                        this.log.error((Object)("Error deleting owned group " + Arrays.toString(ownedGroupIds)), t);
                    }
                    this.log.error((Object)("Error deleting owned group " + Arrays.toString(ownedGroupIds) + ": " + t.getMessage()));
                }
            }
            SavedSearchCriteria savedSearchCriteria = new SavedSearchCriteria();
            savedSearchCriteria.addFilterSubjectId(doomedSubjectId);
            savedSearchCriteria.clearPaging();
            PageList<SavedSearch> savedSearches = this.savedSearchManager.findSavedSearchesByCriteria(subject, savedSearchCriteria);
            for (SavedSearch savedSearch : savedSearches) {
                this.savedSearchManager.deleteSavedSearch(subject, savedSearch.getId());
            }
            this.alertNotificationManager.cleanseAlertNotificationBySubject(doomedSubject.getId());
            this.repoManager.removeOwnershipOfSubject(doomedSubject.getId());
            this.entityManager.remove((Object)doomedSubject);
        }
    }

    @Override
    public void deleteSubjects(Subject sessionSubject, int[] subjectIds) {
        this.deleteUsers(sessionSubject, subjectIds);
    }

    private void deletePrincipal(Subject subject) throws PermissionException {
        if (this.authorizationManager.isSystemSuperuser(subject)) {
            throw new PermissionException("You cannot delete the principal for the root user [" + subject.getName() + "]");
        }
        Query q = this.entityManager.createNamedQuery("Principal.findByUsername");
        q.setParameter("principal", (Object)subject.getName());
        Principal principal = (Principal)q.getSingleResult();
        this.entityManager.remove((Object)principal);
    }

    @Override
    public Subject getSubjectBySessionId(int sessionId) throws Exception {
        Subject subject = this.sessionManager.getSubject(sessionId);
        return subject;
    }

    @Override
    public Subject getSubjectByNameAndSessionId(String username, int sessionId) throws Exception {
        Subject subject = this.getSubjectBySessionId(sessionId);
        if (!username.equals(subject.getName())) {
            throw new SessionNotFoundException();
        }
        return subject;
    }

    @Override
    @ExcludeDefaultInterceptors
    public boolean isValidSessionId(int session, String username, int userid) {
        try {
            Subject sessionSubject = this.sessionManager.getSubject(session);
            return username.equals(sessionSubject.getName()) && userid == sessionSubject.getId();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public PageList<Subject> findAvailableSubjectsForRole(Subject whoami, Integer roleId, Integer[] pendingSubjectIds, PageControl pc) {
        pc.initDefaultOrderingField("s.name");
        String queryName = pendingSubjectIds == null || pendingSubjectIds.length == 0 ? "Subject.findAvailableSubjectsForRole" : "Subject.findAvailableSubjectsForRoleWithExcludes";
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName, (String)"distinct s");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        countQuery.setParameter("roleId", (Object)roleId);
        query.setParameter("roleId", (Object)roleId);
        if (pendingSubjectIds != null && pendingSubjectIds.length > 0) {
            List<Integer> pendingIdsList = Arrays.asList(pendingSubjectIds);
            countQuery.setParameter("excludes", pendingIdsList);
            query.setParameter("excludes", pendingIdsList);
        }
        long count = (Long)countQuery.getSingleResult();
        List subjects = query.getResultList();
        for (Subject subject : subjects) {
            subject.getRoles().size();
        }
        return new PageList((Collection)subjects, (int)count, pc);
    }

    @Override
    public PageList<Subject> findSubjectsByCriteria(Subject subject, SubjectCriteria criteria) {
        boolean canViewUsers;
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList subjects = queryRunner.execute();
        boolean bl = canViewUsers = this.authorizationManager.isSystemSuperuser(subject) || this.authorizationManager.hasGlobalPermission(subject, Permission.MANAGE_SECURITY) || this.authorizationManager.hasGlobalPermission(subject, Permission.VIEW_USERS);
        if (!canViewUsers) {
            if (subjects.contains((Object)subject)) {
                Subject attachedSubject = (Subject)subjects.get(subjects.indexOf((Object)subject));
                subjects.clear();
                subjects.add((Object)attachedSubject);
            } else {
                subjects.clear();
            }
            subjects.setTotalSize(subjects.size());
        }
        return subjects;
    }

    private boolean isLdapAuthenticationEnabled() {
        SystemSettings systemSettings = this.systemManager.getUnmaskedSystemSettings(true);
        String value = (String)systemSettings.get((Object)SystemSetting.LDAP_BASED_JAAS_PROVIDER);
        return value != null ? Boolean.valueOf(value) : false;
    }

    private boolean isLdapAuthorizationEnabled() {
        SystemSettings systemSettings = this.systemManager.getUnmaskedSystemSettings(true);
        String groupFilter = (String)systemSettings.get((Object)SystemSetting.LDAP_GROUP_FILTER);
        String groupMember = (String)systemSettings.get((Object)SystemSetting.LDAP_GROUP_MEMBER);
        return groupFilter != null && groupFilter.trim().length() > 0 || groupMember != null && groupMember.trim().length() > 0;
    }

    private void prepopulateLdapFields(Subject subject) {
        Map<String, String> ldapUserAttributes = this.ldapManager.findLdapUserDetails(subject.getName());
        String givenName = ldapUserAttributes.get("givenName") != null ? ldapUserAttributes.get("givenName") : ldapUserAttributes.get("gn");
        subject.setFirstName(givenName);
        String surname = ldapUserAttributes.get("sn") != null ? ldapUserAttributes.get("sn") : ldapUserAttributes.get("surname");
        subject.setLastName(surname);
        String telephoneNumber = ldapUserAttributes.get("telephoneNumber");
        subject.setPhoneNumber(telephoneNumber);
        String mail = ldapUserAttributes.get("mail") != null ? ldapUserAttributes.get("mail") : ldapUserAttributes.get("rfc822Mailbox");
        subject.setEmailAddress(mail);
        String organizationalUnit = ldapUserAttributes.get("ou") != null ? ldapUserAttributes.get("ou") : ldapUserAttributes.get("organizationalUnitName");
        subject.setDepartment(organizationalUnit);
    }
}

