/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.authz;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;

@ExcludeDefaultInterceptors
@Stateless
public class AuthorizationManagerBean
implements AuthorizationManagerLocal {
    private static final int SUBJECT_ID_OVERLORD = 1;
    private static final int SUBJECT_ID_RHQADMIN = 2;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    public Set<Permission> getExplicitGlobalPermissions(Subject subject) {
        Query query = this.entityManager.createNamedQuery("Subject.getGlobalPermissions");
        query.setParameter("subject", (Object)subject);
        List intermediate = query.getResultList();
        HashSet<Permission> results = new HashSet<Permission>();
        for (Permission permission : intermediate) {
            if (permission.getTarget() != Permission.Target.GLOBAL) continue;
            results.add(permission);
        }
        return results;
    }

    @Override
    public Set<Permission> getExplicitGroupPermissions(Subject subject, int groupId) {
        HashSet<Permission> result;
        block3: {
            Subject owner;
            block2: {
                result = new HashSet<Permission>();
                ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
                owner = group.getSubject();
                if (null != owner) break block2;
                Query query = this.entityManager.createNamedQuery("Subject.getPermissionsByGroup");
                query.setParameter("subject", (Object)subject);
                query.setParameter("groupId", (Object)groupId);
                List resultList = query.getResultList();
                for (Permission permission : resultList) {
                    result.add(permission);
                }
                break block3;
            }
            if (!subject.equals((Object)owner)) break block3;
            Query query = this.entityManager.createNamedQuery("Subject.getPermissionsByPrivateGroup");
            query.setParameter("subjectId", (Object)subject.getId());
            query.setParameter("privateGroupId", (Object)groupId);
            List resultList = query.getResultList();
            for (Object[] row : resultList) {
                result.add((Permission)row[0]);
            }
        }
        return result;
    }

    @Override
    public Set<Permission> getImplicitGroupPermissions(Subject subject, int groupId) {
        Set<Permission> permissions = this.isInventoryManager(subject) ? Permission.RESOURCE_ALL : this.getExplicitGroupPermissions(subject, groupId);
        return permissions;
    }

    @Override
    public Set<Permission> getExplicitResourcePermissions(Subject subject, int resourceId) {
        Query query = this.entityManager.createNamedQuery("Subject.getPermissionsByResource");
        query.setParameter("subject", (Object)subject);
        query.setParameter("resourceId", (Object)resourceId);
        List intermediate = query.getResultList();
        HashSet<Permission> results = new HashSet<Permission>();
        for (Permission permission : intermediate) {
            results.add(permission);
        }
        return results;
    }

    @Override
    public Set<Permission> getImplicitResourcePermissions(Subject subject, int resourceId) {
        Set<Permission> permissions = this.isInventoryManager(subject) ? Permission.RESOURCE_ALL : this.getExplicitResourcePermissions(subject, resourceId);
        return permissions;
    }

    @Override
    public boolean hasGlobalPermission(Subject subject, Permission permission) {
        if (this.isOverlord(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.hasGlobalPermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean hasGroupPermission(Subject subject, Permission permission, int groupId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        ResourceGroup group = (ResourceGroup)this.entityManager.find(ResourceGroup.class, (Object)groupId);
        Subject owner = group.getSubject();
        if (null == owner) {
            Query query = this.entityManager.createNamedQuery("Subject.hasGroupPermission");
            query.setParameter("subject", (Object)subject);
            query.setParameter("permission", (Object)permission);
            query.setParameter("groupId", (Object)groupId);
            long count = (Long)query.getSingleResult();
            return count != 0L;
        }
        if (!subject.equals((Object)owner)) {
            return false;
        }
        Query query = this.entityManager.createNamedQuery("Subject.hasPrivateGroupPermission");
        query.setParameter("subjectId", (Object)subject.getId());
        query.setParameter("permission", (Object)permission);
        query.setParameter("privateGroupId", (Object)groupId);
        List resultList = query.getResultList();
        return !resultList.isEmpty();
    }

    @Override
    public boolean hasResourcePermission(Subject subject, Permission permission, int resourceId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.hasResourcePermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        query.setParameter("resourceId", (Object)resourceId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean hasBundlePermission(Subject subject, Permission permission, int bundleId) {
        Query query = this.entityManager.createNamedQuery("Subject.hasBundlePermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        query.setParameter("bundleId", (Object)bundleId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public Set<Permission> getBundlePermissions(Subject subject, int bundleId) {
        Query query = this.entityManager.createNamedQuery("Subject.getPermissionsByBundle");
        query.setParameter("subject", (Object)subject);
        query.setParameter("bundleId", (Object)bundleId);
        List intermediate = query.getResultList();
        HashSet<Permission> results = new HashSet<Permission>();
        for (Permission permission : intermediate) {
            results.add(permission);
        }
        return results;
    }

    @Override
    public Set<Permission> getBundleGroupPermissions(Subject subject, int bundleGroupId) {
        Query query = this.entityManager.createNamedQuery("Subject.getPermissionsByBundleGroup");
        query.setParameter("subject", (Object)subject);
        query.setParameter("bundleGroupId", (Object)bundleGroupId);
        List intermediate = query.getResultList();
        HashSet<Permission> results = new HashSet<Permission>();
        for (Permission permission : intermediate) {
            results.add(permission);
        }
        return results;
    }

    @Override
    public boolean hasBundlePermission(Subject subject, Permission permission, Collection<Integer> bundleIds) {
        if (this.isSystemSuperuser(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.getBundlesByPermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        List results = query.getResultList();
        return results.containsAll(bundleIds);
    }

    @Override
    public boolean hasBundleGroupPermission(Subject subject, Permission permission, int bundleGroupId) {
        Query query = this.entityManager.createNamedQuery("Subject.hasBundleGroupPermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        query.setParameter("bundleGroupId", (Object)bundleGroupId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean hasAutoGroupPermission(Subject subject, Permission permission, int parentResourceId, int resourceTypeId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.hasAutoGroupPermission");
        query.setParameter("permission", (Object)permission);
        query.setParameter("parentResourceId", (Object)parentResourceId);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        query.setParameter("subjectId", (Object)-1);
        long baseCount = (Long)query.getSingleResult();
        query.setParameter("subjectId", (Object)subject.getId());
        long subjectCount = (Long)query.getSingleResult();
        return baseCount == subjectCount;
    }

    @Override
    public boolean canViewResource(Subject subject, int resourceId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewResource");
        query.setParameter("subject", (Object)subject);
        query.setParameter("resourceId", (Object)resourceId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean canViewResources(Subject subject, List<Integer> resourceIds) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewResources");
        query.setParameter("subject", (Object)subject);
        query.setParameter("resourceIds", resourceIds);
        long count = (Long)query.getSingleResult();
        return count == (long)resourceIds.size();
    }

    @Override
    public boolean canViewGroup(Subject subject, int groupId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewGroup");
        query.setParameter("subject", (Object)subject);
        query.setParameter("groupId", (Object)groupId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean canViewAutoGroup(Subject subject, int parentResourceId, int resourceTypeId) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewAutoGroup");
        query.setParameter("parentResourceId", (Object)parentResourceId);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        query.setParameter("subjectId", (Object)-1);
        long baseCount = (Long)query.getSingleResult();
        query.setParameter("subjectId", (Object)subject.getId());
        long subjectCount = (Long)query.getSingleResult();
        return baseCount == subjectCount;
    }

    @Override
    public boolean canViewBundle(Subject subject, int bundleId) {
        if (this.hasGlobalPermission(subject, Permission.VIEW_BUNDLES)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewBundle");
        query.setParameter("subject", (Object)subject);
        query.setParameter("bundleId", (Object)bundleId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean canViewBundleGroup(Subject subject, int bundleGroupId) {
        if (this.hasGlobalPermission(subject, Permission.VIEW_BUNDLES)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.canViewBundleGroup");
        query.setParameter("subject", (Object)subject);
        query.setParameter("bundleGroupId", (Object)bundleGroupId);
        long count = (Long)query.getSingleResult();
        return count != 0L;
    }

    @Override
    public boolean isInventoryManager(Subject subject) {
        return this.hasGlobalPermission(subject, Permission.MANAGE_INVENTORY);
    }

    @Override
    public boolean hasResourcePermission(Subject subject, Permission permission, Collection<Integer> resourceIds) {
        if (this.isInventoryManager(subject)) {
            return true;
        }
        Query query = this.entityManager.createNamedQuery("Subject.getResourcesByPermission");
        query.setParameter("subject", (Object)subject);
        query.setParameter("permission", (Object)permission);
        List results = query.getResultList();
        return results.containsAll(resourceIds);
    }

    @Override
    public boolean isSystemSuperuser(Subject subject) {
        return subject != null && (subject.getId() == 1 || subject.getId() == 2);
    }

    @Override
    public boolean isOverlord(Subject subject) {
        return subject != null && subject.getId() == 1;
    }

    @Override
    public boolean canUpdateRepo(Subject subject, int repoId) {
        if (this.hasGlobalPermission(subject, Permission.MANAGE_REPOSITORIES)) {
            return true;
        }
        Query q = this.entityManager.createNamedQuery("Repo.isRepoOwnedBySubjectId");
        q.setParameter("repoId", (Object)repoId);
        q.setParameter("subjectId", (Object)subject.getId());
        Long num = (Long)q.getSingleResult();
        return num > 0L;
    }

    @Override
    public boolean canViewRepo(Subject subject, int repoId) {
        if (this.hasGlobalPermission(subject, Permission.MANAGE_REPOSITORIES)) {
            return true;
        }
        Query q = this.entityManager.createNamedQuery("Repo.findVisibleReposBySubjectId");
        q.setParameter("repoId", (Object)repoId);
        q.setParameter("subjectId", (Object)subject.getId());
        Long num = (Long)q.getSingleResult();
        return num > 0L;
    }
}

