/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.remoting.CannotConnectException;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.discovery.DiscoveryAgentService;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeRequest;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeResponse;
import org.rhq.core.clientapi.server.discovery.InvalidInventoryReportException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.clientapi.server.discovery.StaleTypeException;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PluginConfigurationUpdate;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.discovery.MergeInventoryReportResults;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.PlatformSyncInfo;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.CannotConnectToAgentException;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.StringUtil;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.StorageNodeManagerLocal;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.discovery.AgentInventoryStatusUpdateJob;
import org.rhq.enterprise.server.discovery.DeletedResourceTypeFilter;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossRemote;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class DiscoveryBossBean
implements DiscoveryBossLocal,
DiscoveryBossRemote {
    private static final Log LOG = LogFactory.getLog((String)DiscoveryBossBean.class.getName());
    private static final int MERGE_BATCH_SIZE;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private DiscoveryBossLocal discoveryBoss;
    @EJB
    private ResourceGroupManagerLocal groupManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceAvailabilityManagerLocal resourceAvailabilityManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ProductVersionManagerLocal productVersionManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private PluginManagerLocal pluginManager;
    @EJB
    private AvailabilityManagerLocal availabilityManager;
    @EJB
    private StorageNodeManagerLocal storageNodeManager;
    @EJB
    private ConfigurationManagerLocal configurationManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public MergeInventoryReportResults mergeInventoryReport(InventoryReport report) throws InvalidInventoryReportException {
        this.validateInventoryReport(report);
        DeletedResourceTypeFilter filter = new DeletedResourceTypeFilter(this.subjectManager, this.resourceTypeManager, this.pluginManager);
        Set<ResourceType> deletedTypes = filter.apply(report);
        if (!deletedTypes.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The inventory report from " + report.getAgent() + " with added roots " + report.getAddedRoots() + " contains these deleted resource types " + deletedTypes));
            } else {
                LOG.info((Object)("The inventory report from " + report.getAgent() + " contains these deleted resource types " + deletedTypes));
            }
            throw new StaleTypeException("The report contains one or more resource types that have been marked for deletion.");
        }
        Agent agent = report.getAgent();
        long start = System.currentTimeMillis();
        Agent knownAgent = this.agentManager.getAgentByName(agent.getName());
        if (knownAgent == null) {
            throw new InvalidInventoryReportException("Unknown Agent named [" + agent.getName() + "] sent an inventory report - that report will be ignored. " + "This error is harmless and should stop appearing after a short while if the platform of the agent [" + agent.getName() + "] was recently removed from the inventory. In any other case this is a bug.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received inventory report from RHQ Agent [" + knownAgent + "]. Number of added roots: " + report.getAddedRoots().size()));
        }
        Set roots = report.getAddedRoots();
        LOG.debug((Object)report);
        HashMap<String, ResourceType> allTypes = new HashMap<String, ResourceType>();
        for (Resource root : roots) {
            long rootStart = System.currentTimeMillis();
            if (!this.initResourceTypes(root, allTypes)) {
                LOG.error((Object)("Reported resource [" + root + "] has an unknown type [" + root.getResourceType() + "]. The Agent [" + knownAgent + "] most likely has a plugin named '" + root.getResourceType().getPlugin() + "' installed that is not installed on the Server. Resource will be ignored..."));
                continue;
            }
            if (Resource.ROOT != root.getParentResource() && -1 == root.getParentResource().getId()) {
                root.setParentResource(Resource.ROOT);
            }
            this.mergeResource(root, knownAgent);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Root merged: resource/millis=" + root.getName() + '/' + (System.currentTimeMillis() - rootStart)));
        }
        allTypes = null;
        PlatformSyncInfo syncInfo = this.discoveryBoss.getPlatformSyncInfo(knownAgent);
        ResourceTypeCriteria ignoredTypesCriteria = new ResourceTypeCriteria();
        ignoredTypesCriteria.addFilterIgnored(true);
        ignoredTypesCriteria.setPageControl(PageControl.getUnlimitedInstance());
        PageList<ResourceType> ignoredTypes = this.resourceTypeManager.findResourceTypesByCriteria(this.subjectManager.getOverlord(), ignoredTypesCriteria);
        MergeInventoryReportResults results = syncInfo != null ? new MergeInventoryReportResults(syncInfo, ignoredTypes) : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Inventory merge completed in (" + (System.currentTimeMillis() - start) + ")ms"));
        }
        return results;
    }

    @Override
    public PlatformSyncInfo getPlatformSyncInfo(Agent knownAgent) {
        Resource platform = this.resourceManager.getPlatform(knownAgent);
        if (null == platform) {
            return null;
        }
        HashSet<Resource> toplevelServices = new HashSet<Resource>();
        HashSet<Integer> topLevelServerIds = new HashSet<Integer>();
        for (Resource platformChild : platform.getChildResources()) {
            switch (platformChild.getResourceType().getCategory()) {
                case SERVER: {
                    topLevelServerIds.add(platformChild.getId());
                    break;
                }
                case SERVICE: {
                    toplevelServices.add(platformChild);
                    break;
                }
            }
        }
        ResourceSyncInfo platformSyncInfo = ResourceSyncInfo.buildResourceSyncInfo((Resource)platform);
        Set<ResourceSyncInfo> topLevelServiceSyncInfo = this.getToplevelServiceSyncInfo(toplevelServices);
        PlatformSyncInfo result = new PlatformSyncInfo(platformSyncInfo, topLevelServiceSyncInfo, topLevelServerIds);
        return result;
    }

    private Set<ResourceSyncInfo> getToplevelServiceSyncInfo(Set<Resource> topLevelServices) {
        HashSet<ResourceSyncInfo> result = new HashSet<ResourceSyncInfo>(topLevelServices.size());
        HashSet<Integer> topLevelServiceIds = new HashSet<Integer>();
        for (Resource topLevelService : topLevelServices) {
            result.add(ResourceSyncInfo.buildResourceSyncInfo((Resource)topLevelService));
            topLevelServiceIds.add(topLevelService.getId());
        }
        this.getToplevelServiceSyncInfoHierarchy(topLevelServiceIds, result);
        return result;
    }

    private void getToplevelServiceSyncInfoHierarchy(Set<Integer> parentIds, Set<ResourceSyncInfo> result) {
        if (parentIds.isEmpty()) {
            return;
        }
        Query q = this.entityManager.createNamedQuery("ResourceSyncInfo.platformServiceChildren");
        q.setParameter("parentIds", parentIds);
        List childSyncInfos = q.getResultList();
        if (!childSyncInfos.isEmpty()) {
            result.addAll(childSyncInfos);
            HashSet<Integer> childIds = new HashSet<Integer>(childSyncInfos.size());
            for (ResourceSyncInfo childSyncInfo : childSyncInfos) {
                childIds.add(childSyncInfo.getId());
            }
            this.getToplevelServiceSyncInfoHierarchy(childIds, result);
        }
    }

    @Override
    public Collection<ResourceSyncInfo> getResourceSyncInfo(int resourceId) {
        Query query = null;
        ArrayList<ResourceSyncInfo> result = null;
        boolean isNative = true;
        DatabaseType dbType = DatabaseTypeFactory.getDefaultDatabaseType();
        if (DatabaseTypeFactory.isOracle((DatabaseType)dbType)) {
            query = this.entityManager.createNativeQuery("           SELECT r.id, r.uuid, r.mtime, r.inventory_status              FROM rhq_resource r        START WITH r.id = :resourceId  CONNECT BY PRIOR r.id = r.parent_resource_id ");
        } else if (DatabaseTypeFactory.isPostgres((DatabaseType)dbType)) {
            query = this.entityManager.createNativeQuery(" WITH RECURSIVE childResource AS  (   SELECT r.id, r.uuid, r.mtime, r.inventory_status        FROM rhq_resource AS r       WHERE r.id = :resourceId   UNION ALL      SELECT r.id, r.uuid, r.mtime, r.inventory_status        FROM rhq_resource AS r        JOIN childResource AS cr          ON (r.parent_resource_id = cr.id)  )  SELECT id, uuid, mtime, inventory_status    FROM childResource ");
        } else {
            isNative = false;
            query = this.entityManager.createNamedQuery("ResourceSyncInfo.topLevelServer");
        }
        query.setParameter("resourceId", (Object)resourceId);
        if (isNative) {
            List rows = query.getResultList();
            result = new ArrayList<ResourceSyncInfo>(rows.size());
            for (Object[] row : rows) {
                int id = dbType.getInteger(row[0]);
                String uuid = (String)row[1];
                long mtime = dbType.getLong(row[2]);
                InventoryStatus status = InventoryStatus.valueOf((String)((String)row[3]));
                result.add(new ResourceSyncInfo(id, uuid, mtime, status));
            }
        } else {
            result = query.getResultList();
        }
        return result;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Map<Resource, List<Resource>> getQueuedPlatformsAndServers(Subject user, PageControl pc) {
        return this.getQueuedPlatformsAndServers(user, EnumSet.of(InventoryStatus.NEW), pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Map<Resource, List<Resource>> getQueuedPlatformsAndServers(Subject user, EnumSet<InventoryStatus> statuses, PageControl pc) {
        HashMap<Resource, List<Resource>> queuedResources = new HashMap<Resource, List<Resource>>();
        PageList<Resource> queuedPlatforms = this.getQueuedPlatforms(user, statuses, pc);
        for (Resource platform : queuedPlatforms) {
            ArrayList<Resource> queuedServers = new ArrayList<Resource>();
            for (InventoryStatus status : statuses) {
                queuedServers.addAll(this.getQueuedPlatformChildServers(user, status, platform));
            }
            queuedResources.put(platform, queuedServers);
        }
        return queuedResources;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Resource> getQueuedPlatforms(Subject user, EnumSet<InventoryStatus> statuses, PageControl pc) {
        List results;
        pc.initDefaultOrderingField("res.ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findQueuedPlatformsByInventoryStatus");
        queryCount.setParameter("inventoryStatuses", statuses);
        long count = (Long)queryCount.getSingleResult();
        if (count > 0L) {
            Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findQueuedPlatformsByInventoryStatus", (PageControl)pc);
            query.setParameter("inventoryStatuses", statuses);
            results = query.getResultList();
        } else {
            results = Collections.emptyList();
        }
        return new PageList(results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public List<Resource> getQueuedPlatformChildServers(Subject user, InventoryStatus status, Resource platform) {
        PageList<Resource> childServers = this.resourceManager.findChildResourcesByCategoryAndInventoryStatus(user, platform, ResourceCategory.SERVER, status, PageControl.getUnlimitedInstance());
        return childServers;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void updateInventoryStatus(Subject user, List<Resource> platforms, List<Resource> servers, InventoryStatus status) {
        long start = System.currentTimeMillis();
        ArrayList<Resource> attachedPlatforms = new ArrayList<Resource>(platforms.size());
        for (Resource p : platforms) {
            attachedPlatforms.add((Resource)this.entityManager.find(Resource.class, (Object)p.getId()));
        }
        platforms = attachedPlatforms;
        ArrayList<Resource> attachedServers = new ArrayList<Resource>(servers.size());
        for (Resource s : servers) {
            attachedServers.add((Resource)this.entityManager.find(Resource.class, (Object)s.getId()));
        }
        servers = attachedServers;
        this.discoveryBoss.updateInventoryStatusInNewTransaction(user, platforms, servers, status);
        this.scheduleAgentInventoryOperationJob(platforms, servers);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Inventory status set to [" + status + "] for [" + platforms.size() + "] platforms and [" + servers.size() + "] servers in [" + (System.currentTimeMillis() - start) + "]ms"));
        }
    }

    private boolean isJobScheduled(Scheduler scheduler, String name, String group) {
        boolean isScheduled = false;
        try {
            JobDetail jobDetail = scheduler.getJobDetail(name, group);
            if (jobDetail != null) {
                isScheduled = true;
            }
        }
        catch (SchedulerException se) {
            LOG.error((Object)"Error getting job detail", (Throwable)se);
        }
        return isScheduled;
    }

    private void scheduleAgentInventoryOperationJob(List<Resource> platforms, List<Resource> servers) {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        try {
            String DEFAULT_JOB_NAME = "AgentInventoryUpdateJob";
            String DEFAULT_JOB_GROUP = "AgentInventoryUpdateGroup";
            String TRIGGER_PREFIX = "AgentInventoryUpdateTrigger";
            String randomSuffix = UUID.randomUUID().toString();
            String triggerName = "AgentInventoryUpdateTrigger - " + randomSuffix;
            SimpleTrigger trigger = new SimpleTrigger(triggerName, "AgentInventoryUpdateGroup", new Date());
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("TriggerName", triggerName);
            jobDataMap.put("TriggerGroupName", "AgentInventoryUpdateGroup");
            AgentInventoryStatusUpdateJob.externalizeJobValues(jobDataMap, "PlatformsList", platforms);
            AgentInventoryStatusUpdateJob.externalizeJobValues(jobDataMap, "ServersList", servers);
            trigger.setJobName("AgentInventoryUpdateJob");
            trigger.setJobGroup("AgentInventoryUpdateGroup");
            trigger.setJobDataMap(jobDataMap);
            if (this.isJobScheduled(scheduler, "AgentInventoryUpdateJob", "AgentInventoryUpdateGroup")) {
                scheduler.scheduleJob((Trigger)trigger);
            } else {
                JobDetail jobDetail = new JobDetail("AgentInventoryUpdateJob", "AgentInventoryUpdateGroup", AgentInventoryStatusUpdateJob.class);
                scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
        }
        catch (SchedulerException e) {
            LOG.error((Object)"Failed to schedule agent inventory update operation.", (Throwable)e);
            this.updateAgentInventoryStatus(platforms, servers);
        }
    }

    public void updateAgentInventoryStatus(List<Resource> platforms, List<Resource> servers) {
        AgentClient agentClient;
        for (Resource platform : platforms) {
            agentClient = this.agentManager.getAgentClient(platform.getAgent());
            if (agentClient != null) {
                try {
                    PlatformSyncInfo platformSyncInfo = this.getPlatformSyncInfo(platform.getAgent());
                    agentClient.getDiscoveryAgentService().synchronizePlatform(platformSyncInfo);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not perform commit synchronization with agent for platform [" + platform.getName() + "]"), (Throwable)e);
                }
                continue;
            }
            LOG.warn((Object)("Could not perform commit sync with agent for platform [" + platform.getName() + "]; will expect agent to do it later"));
        }
        for (Resource server : servers) {
            if (platforms.contains(server.getParentResource())) continue;
            agentClient = this.agentManager.getAgentClient(server.getAgent());
            if (agentClient != null) {
                try {
                    Collection<ResourceSyncInfo> syncInfos = this.getResourceSyncInfo(server.getId());
                    agentClient.getDiscoveryAgentService().synchronizeServer(server.getId(), syncInfos);
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not perform commit synchronization with agent for server [" + server.getName() + "]"), (Throwable)e);
                }
                continue;
            }
            LOG.warn((Object)("Could not perform commit sync with agent for server [" + server.getName() + "]; will expect agent to do it later"));
        }
    }

    @Override
    public void updateAgentInventoryStatus(String platformsCsvList, String serversCsvList) {
        ArrayList<Resource> platforms = new ArrayList<Resource>();
        AgentInventoryStatusUpdateJob.internalizeJobValues(this.entityManager, platformsCsvList, platforms);
        ArrayList<Resource> servers = new ArrayList<Resource>();
        AgentInventoryStatusUpdateJob.internalizeJobValues(this.entityManager, serversCsvList, servers);
        this.updateAgentInventoryStatus(platforms, servers);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateInventoryStatusInNewTransaction(Subject user, List<Resource> platforms, List<Resource> servers, InventoryStatus status) {
        for (Resource platform : platforms) {
            this.resourceManager.setResourceStatus(user, platform, status, false);
        }
        for (Resource server : servers) {
            this.resourceManager.setResourceStatus(user, server, status, true);
        }
        if (status == InventoryStatus.COMMITTED) {
            ArrayList<Integer> allResourceIds = new ArrayList<Integer>();
            for (Resource platform : platforms) {
                allResourceIds.add(platform.getId());
            }
            for (Resource server : servers) {
                allResourceIds.add(server.getId());
            }
            this.resourceAvailabilityManager.insertNeededAvailabilityForImportedResources(allResourceIds);
        }
    }

    @Override
    public Resource manuallyAddResource(Subject subject, int resourceTypeId, int parentResourceId, Configuration pluginConfiguration) throws Exception {
        Resource result = null;
        ResourceType resourceType = this.resourceTypeManager.getResourceTypeById(subject, resourceTypeId);
        this.entityManager.clear();
        MergeResourceResponse response = this.manuallyAddResource(subject, resourceType, parentResourceId, pluginConfiguration);
        result = this.resourceManager.getResourceById(subject, response.getResourceId());
        return result;
    }

    @Override
    public MergeResourceResponse manuallyAddResource(Subject user, ResourceType resourceType, int parentResourceId, Configuration pluginConfiguration) throws InvalidPluginConfigurationClientException, PluginContainerException {
        MergeResourceResponse mergeResourceResponse;
        if (!this.authorizationManager.hasResourcePermission(user, Permission.CREATE_CHILD_RESOURCES, parentResourceId)) {
            throw new PermissionException("You do not have permission on resource with id " + parentResourceId + " to manually add child resources.");
        }
        Resource parentResource = this.resourceManager.getResourceById(user, parentResourceId);
        if (!resourceType.isSupportsManualAdd()) {
            throw new RuntimeException("Cannot manually add " + resourceType + " child Resource under parent " + parentResource + ", since the " + resourceType + " type does not support manual add.");
        }
        this.abortResourceManualAddIfExistingSingleton(parentResource, resourceType);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(parentResource.getAgent());
            DiscoveryAgentService discoveryAgentService = agentClient.getDiscoveryAgentService();
            mergeResourceResponse = discoveryAgentService.manuallyAddResource(resourceType, parentResourceId, pluginConfiguration, user.getId());
        }
        catch (CannotConnectException e) {
            throw new CannotConnectToAgentException("Error adding [" + resourceType + "] Resource to inventory as " + "a child of " + parentResource + " - cause: " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error adding [" + resourceType + "] Resource to inventory as a child of " + parentResource + " - cause: " + e, e);
        }
        return mergeResourceResponse;
    }

    @Override
    public MergeResourceResponse addResource(Resource resource, int creatorSubjectId) {
        MergeResourceResponse mergeResourceResponse;
        try {
            this.validateResource(resource);
        }
        catch (InvalidInventoryReportException e) {
            throw new IllegalStateException("Plugin Container sent an invalid Resource - " + e.getLocalizedMessage());
        }
        if (!this.initResourceTypes(resource)) {
            throw new IllegalStateException("Plugin Container sent a Resource with an unknown type - " + resource.getResourceType());
        }
        Resource existingResource = this.findExistingResource(resource, null);
        if (existingResource != null) {
            mergeResourceResponse = new MergeResourceResponse(existingResource.getId(), existingResource.getMtime(), true);
        } else {
            Subject creator = this.subjectManager.getSubjectById(creatorSubjectId);
            try {
                creator = this.subjectManager.loginUnauthenticated(creator.getName());
            }
            catch (LoginException e) {
                throw new IllegalStateException("Unable to temporarily login to provided resource creator user for resource creation", e);
            }
            Resource parentResource = this.resourceManager.getResourceById(creator, resource.getParentResource().getId());
            resource.setAgent(parentResource.getAgent());
            resource.setModifiedBy(creator.getName());
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            resource.setItime(System.currentTimeMillis());
            try {
                this.resourceManager.createResource(creator, resource, parentResource.getId());
            }
            catch (ResourceAlreadyExistsException e) {
                throw new IllegalStateException(e);
            }
            mergeResourceResponse = new MergeResourceResponse(resource.getId(), resource.getCtime(), false);
        }
        return mergeResourceResponse;
    }

    @Override
    public boolean updateResourceVersion(int resourceId, String version) {
        Resource existingResource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (existingResource != null) {
            boolean changed = this.updateResourceVersion(existingResource, version);
            if (changed) {
                this.entityManager.merge((Object)existingResource);
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<ResourceUpgradeResponse> upgradeResources(Set<ResourceUpgradeRequest> upgradeRequests) {
        HashSet<ResourceUpgradeResponse> result = new HashSet<ResourceUpgradeResponse>();
        boolean allowGenericPropertiesUpgrade = Boolean.parseBoolean(this.systemManager.getSystemConfiguration(this.subjectManager.getOverlord()).getProperty(RHQConstants.AllowResourceGenericPropertiesUpgrade, "false"));
        for (ResourceUpgradeRequest request : upgradeRequests) {
            Resource existingResource = (Resource)this.entityManager.find(Resource.class, (Object)request.getResourceId());
            if (existingResource == null) continue;
            try {
                ResourceUpgradeResponse upgradedData = this.upgradeResource(existingResource, request, allowGenericPropertiesUpgrade);
                if (upgradedData == null) continue;
                result.add(upgradedData);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to process upgrade request for resource " + existingResource + "."), (Throwable)e);
            }
        }
        return result;
    }

    private boolean updateResourceVersion(Resource resource, String newVersion) {
        boolean versionChanged = false;
        if (resource != null) {
            String oldVersion = resource.getVersion();
            if (oldVersion == null) {
                oldVersion = "";
            }
            if (newVersion == null) {
                newVersion = "";
            }
            boolean bl = versionChanged = !oldVersion.equals(newVersion);
            if (versionChanged) {
                LOG.info((Object)("Resource [" + resource + "] changed its version from [" + oldVersion + "] to [" + newVersion + "]"));
                resource.setVersion(newVersion);
                ProductVersion productVersion = null;
                if (newVersion.length() > 0) {
                    productVersion = this.productVersionManager.addProductVersion(resource.getResourceType(), newVersion);
                }
                resource.setProductVersion(productVersion);
            }
        }
        return versionChanged;
    }

    private ResourceUpgradeResponse upgradeResource(Resource resource, ResourceUpgradeRequest upgradeRequest, boolean allowGenericPropertiesUpgrade) {
        if (upgradeRequest.getUpgradeErrorMessage() != null) {
            ResourceError error = new ResourceError(resource, ResourceErrorType.UPGRADE, upgradeRequest.getUpgradeErrorMessage(), upgradeRequest.getUpgradeErrorStackTrace(), upgradeRequest.getTimestamp());
            this.resourceManager.addResourceError(error);
            return null;
        }
        ResourceUpgradeResponse ret = new ResourceUpgradeResponse();
        ret.setResourceId(resource.getId());
        if (upgradeRequest.hasSomethingToUpgrade()) {
            Configuration pluginConfig;
            String resourceKey = upgradeRequest.getNewResourceKey();
            String name = upgradeRequest.getNewName();
            String description = upgradeRequest.getNewDescription();
            String version = upgradeRequest.getNewVersion();
            boolean isUpgradeAll = allowGenericPropertiesUpgrade || upgradeRequest.isForceGenericPropertyUpgrade();
            StringBuilder logMessage = new StringBuilder("Resource [").append(resource.toString()).append("] upgraded [");
            if (this.needsUpgrade(resource.getResourceKey(), resourceKey)) {
                resource.setResourceKey(resourceKey);
                logMessage.append("resourceKey, ");
                ret.setUpgradedResourceKey(resource.getResourceKey());
            }
            if (isUpgradeAll && this.needsUpgrade(resource.getName(), name)) {
                resource.setName(name);
                logMessage.append("name, ");
                ret.setUpgradedResourceName(resource.getName());
            }
            if (isUpgradeAll && this.needsUpgrade(resource.getDescription(), description)) {
                resource.setDescription(description);
                logMessage.append("description, ");
                ret.setUpgradedResourceDescription(resource.getDescription());
            }
            if (this.needsUpgrade(resource.getVersion(), version)) {
                resource.setVersion(version);
                logMessage.append("version, ");
                ret.setUpgradedResourceVersion(resource.getVersion());
            }
            if (null != (pluginConfig = upgradeRequest.getNewPluginConfiguration())) {
                pluginConfig = pluginConfig.deepCopy(false);
                PluginConfigurationUpdate update = this.configurationManager.upgradePluginConfiguration(this.subjectManager.getOverlord(), resource.getId(), pluginConfig);
                ret.setUpgradedResourcePluginConfiguration(update.getResource().getPluginConfiguration());
            }
            List<ResourceError> upgradeErrors = this.resourceManager.findResourceErrors(this.subjectManager.getOverlord(), resource.getId(), ResourceErrorType.UPGRADE);
            for (ResourceError error : upgradeErrors) {
                this.entityManager.remove((Object)error);
            }
            logMessage.replace(logMessage.length() - 1, logMessage.length(), "] to become [").append(resource.toString()).append("]");
            LOG.info((Object)logMessage.toString());
        }
        return ret;
    }

    private void validateInventoryReport(InventoryReport report) throws InvalidInventoryReportException {
        for (Resource root : report.getAddedRoots()) {
            this.validateResource(root);
        }
    }

    private void validateResource(Resource resource) throws InvalidInventoryReportException {
        if (resource.getResourceType() == null) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has a null type.");
        }
        if (resource.getResourceKey() == null) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has a null key.");
        }
        if (resource.getInventoryStatus() == InventoryStatus.DELETED) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has an illegal inventory status of 'DELETED' - agents are not allowed to delete platforms from inventory.");
        }
        for (Resource childResource : resource.getChildResources()) {
            this.validateResource(childResource);
        }
    }

    private void mergeResource(Resource resource, Agent agent) throws InvalidInventoryReportException {
        long start = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Merging [" + resource + "]..."));
        }
        List<Resource> resourceList = this.treeToBreadthFirstList(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Preparing to merge [" + resourceList.size() + "] Resources with a batch size of [" + MERGE_BATCH_SIZE + "]"));
        }
        HashMap<Resource, Set<PostMergeAction>> postMergeActions = new HashMap<Resource, Set<PostMergeAction>>();
        while (!resourceList.isEmpty()) {
            int size = resourceList.size();
            int end = MERGE_BATCH_SIZE < size ? MERGE_BATCH_SIZE : size;
            List<Resource> resourceBatch = resourceList.subList(0, end);
            this.discoveryBoss.mergeResourceInNewTransaction(resourceBatch, agent, postMergeActions);
            if (!postMergeActions.isEmpty()) {
                this.performPostMergeActions(postMergeActions);
            }
            resourceBatch.clear();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Resource and children merged: resource/millis=" + resource.getName() + '/' + (System.currentTimeMillis() - start)));
        }
    }

    private void performPostMergeActions(Map<Resource, Set<PostMergeAction>> postMergeActions) {
        for (Resource r : postMergeActions.keySet()) {
            for (PostMergeAction a : postMergeActions.get(r)) {
                switch (a) {
                    case LINK_STORAGE_NODE: {
                        this.storageNodeManager.linkResource(r);
                    }
                }
            }
        }
        postMergeActions.clear();
    }

    private List<Resource> treeToBreadthFirstList(Resource resource) {
        if (resource.getResourceType().isIgnored()) {
            return new ArrayList<Resource>(0);
        }
        ArrayList<Resource> result = new ArrayList<Resource>(MERGE_BATCH_SIZE);
        LinkedList<Resource> queue = new LinkedList<Resource>();
        queue.add(resource);
        while (!queue.isEmpty()) {
            Resource node = (Resource)queue.remove();
            if (node.getResourceType().isIgnored()) continue;
            result.add(node);
            for (Resource child : node.getChildResources()) {
                queue.add(child);
            }
        }
        return result;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void mergeResourceInNewTransaction(List<Resource> resourceBatch, Agent agent, Map<Resource, Set<PostMergeAction>> postMergeActions) throws InvalidInventoryReportException {
        long batchStart = System.currentTimeMillis();
        boolean isDebugEnabled = LOG.isDebugEnabled();
        HashMap<Integer, Resource> parentMap = new HashMap<Integer, Resource>();
        for (Resource resource : resourceBatch) {
            Resource existingResource = null;
            long start = System.currentTimeMillis();
            existingResource = this.findExistingResource(resource, parentMap);
            if (null != existingResource) {
                this.updateExistingResource(resource, existingResource);
            } else {
                this.presetAgent(resource, agent);
                this.persistResource(resource, parentMap, postMergeActions);
            }
            if (!isDebugEnabled) continue;
            LOG.debug((Object)("Single Resource merged: resource/millis=" + resource.getName() + '/' + (System.currentTimeMillis() - start)));
        }
        parentMap.clear();
        if (isDebugEnabled) {
            long delta = System.currentTimeMillis() - batchStart;
            LOG.debug((Object)("Resource Batch merged: size/average/millis=" + resourceBatch.size() + "/" + delta / (long)resourceBatch.size() + "/" + delta));
        }
    }

    private void presetAgent(Resource resource, Agent agent) {
        resource.setAgent(agent);
        for (Resource child : resource.getChildResources()) {
            this.presetAgent(child, agent);
        }
    }

    private Resource findExistingResource(Resource resource, Map<Integer, Resource> parentMap) {
        boolean isDebugEnabled = LOG.isDebugEnabled();
        if (isDebugEnabled) {
            LOG.debug((Object)("getExistingResource processing for [" + resource + "]"));
        }
        Resource existingResource = null;
        if (resource.getId() != 0) {
            if (isDebugEnabled) {
                LOG.debug((Object)("Agent claims resource is already in inventory. Id=" + resource.getId()));
            }
            existingResource = (Resource)this.entityManager.find(Resource.class, (Object)resource.getId());
            if (isDebugEnabled) {
                if (null != existingResource) {
                    LOG.debug((Object)("Found resource already in inventory. Id=" + resource.getId()));
                } else {
                    LOG.debug((Object)("However, no resource exists with the specified id. Id=" + resource.getId()));
                }
            }
        } else {
            LOG.debug((Object)"Agent reported resource with id of 0");
        }
        if (existingResource == null) {
            if (isDebugEnabled) {
                LOG.debug((Object)("Checking if a resource exists with the specified business key. Id=" + resource.getId() + ", key=" + resource.getResourceKey()));
            }
            ResourceType resourceType = resource.getResourceType();
            Resource parent = resource;
            while (null != parent && null == existingResource) {
                parent = parent.getParentResource();
                Resource existingParent = null;
                if (null != parent) {
                    int parentId = parent.getId();
                    if (parentId <= 0) {
                        LOG.warn((Object)("Expected potential parent resource to have a valid ID. Parent=" + parent + ", Child=" + resource));
                    }
                    if (null != parentMap) {
                        existingParent = parentMap.get(parentId);
                    }
                    if (null == existingParent) {
                        existingParent = (Resource)this.entityManager.getReference(Resource.class, (Object)parentId);
                        if (null == existingParent) continue;
                        if (null != parentMap) {
                            parentMap.put(parentId, existingParent);
                        }
                    }
                }
                Query query = this.entityManager.createNamedQuery("Resource.findByParentAndKey");
                query.setParameter("parent", existingParent);
                query.setParameter("key", (Object)resource.getResourceKey());
                query.setParameter("plugin", (Object)resourceType.getPlugin());
                query.setParameter("typeName", (Object)resourceType.getName());
                try {
                    existingResource = (Resource)query.getSingleResult();
                }
                catch (NoResultException e) {
                    existingResource = null;
                }
            }
            if (null != existingResource) {
                resource.setId(existingResource.getId());
                if (isDebugEnabled) {
                    LOG.debug((Object)("Found resource already in inventory with specified business key, Id=" + resource.getId()));
                }
            } else {
                LOG.debug((Object)"Unable to find the agent-reported resource by id or business key.");
                if (resource.getId() != 0) {
                    LOG.error((Object)("Resetting the resource's id to zero. Previous Id=" + resource.getId()));
                    resource.setId(0);
                } else {
                    LOG.debug((Object)"Resource's id was already zero, nothing to do for the merge.");
                }
            }
        }
        return existingResource;
    }

    private void updateExistingResource(Resource updatedResource, Resource existingResource) throws InvalidInventoryReportException {
        if (existingResource.getInventoryStatus() == InventoryStatus.UNINVENTORIED) {
            return;
        }
        Resource existingParent = existingResource.getParentResource();
        Resource updatedParent = updatedResource.getParentResource();
        ResourceType existingResourceParentType = existingParent != null ? existingResource.getParentResource().getResourceType() : null;
        ResourceType updatedResourceParentType = updatedParent != null ? updatedResource.getParentResource().getResourceType() : null;
        Set validParentTypes = existingResource.getResourceType().getParentResourceTypes();
        if (validParentTypes != null && !validParentTypes.isEmpty() && !validParentTypes.contains(existingResourceParentType)) {
            if (validParentTypes.contains(updatedResourceParentType)) {
                if (existingResource.getParentResource() != null) {
                    existingResource.getParentResource().removeChildResource(existingResource);
                }
                if (updatedParent != Resource.ROOT) {
                    updatedParent = (Resource)this.entityManager.find(Resource.class, (Object)updatedParent.getId());
                    updatedParent.addChildResource(existingResource);
                } else {
                    existingResource.setParentResource(Resource.ROOT);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Existing Resource " + existingResource + " has invalid parent type (" + existingResourceParentType + ") and so does plugin-reported Resource " + updatedResource + " (" + updatedResourceParentType + ") - valid parent types are [" + validParentTypes + "]."));
            }
        }
        if (existingResource.getDescription() == null && updatedResource.getDescription() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting description of existing resource with id " + existingResource.getId() + " to '" + updatedResource.getDescription() + "' (as reported by agent)..."));
            }
            existingResource.setDescription(updatedResource.getDescription());
        }
        if (existingResource.getResourceKey() != null && !existingResource.getResourceKey().equals(updatedResource.getResourceKey())) {
            LOG.warn((Object)("Agent reported that key for " + existingResource + " has changed from '" + existingResource.getResourceKey() + "' to '" + updatedResource.getResourceKey() + "'."));
        }
        this.updateResourceVersion(existingResource, updatedResource.getVersion());
        if (existingResource.getInventoryStatus() == InventoryStatus.DELETED) {
            existingResource.setInventoryStatus(InventoryStatus.COMMITTED);
            existingResource.setPluginConfiguration(updatedResource.getPluginConfiguration());
            existingResource.setAgentSynchronizationNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initResourceTypes(Resource resource) {
        HashMap<String, ResourceType> types = new HashMap<String, ResourceType>();
        try {
            boolean bl = this.initResourceTypes(resource, types);
            return bl;
        }
        finally {
            types.clear();
        }
    }

    private boolean initResourceTypes(Resource resource, Map<String, ResourceType> loadedTypeMap) {
        String plugin = resource.getResourceType().getPlugin();
        String name = resource.getResourceType().getName();
        StringBuilder key = new StringBuilder(plugin);
        key.append(":::");
        key.append(name);
        ResourceType resourceType = loadedTypeMap.get(key.toString());
        if (null == resourceType) {
            try {
                resourceType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(name, plugin);
            }
            catch (RuntimeException e) {
                resourceType = null;
            }
            if (null == resourceType) {
                return false;
            }
            loadedTypeMap.put(key.toString(), resourceType);
        }
        resource.setResourceType(resourceType);
        if (resourceType.isIgnored()) {
            return true;
        }
        Iterator childIterator = resource.getChildResources().iterator();
        while (childIterator.hasNext()) {
            Resource child = (Resource)childIterator.next();
            if (this.initResourceTypes(child, loadedTypeMap)) continue;
            childIterator.remove();
        }
        return true;
    }

    private void persistResource(Resource resource, Map<Integer, Resource> parentMap, Map<Resource, Set<PostMergeAction>> postMergeActions) {
        String userSuppliedResourceName;
        CreateResourceHistory matchingHistory;
        ResourceType resourceType;
        Integer parentId = null != resource.getParentResource() ? Integer.valueOf(resource.getParentResource().getId()) : null;
        Resource parentResource = null;
        if (null != parentId) {
            if (null != parentMap) {
                parentResource = parentMap.get(parentId);
            }
            if (null == parentResource) {
                parentResource = (Resource)this.entityManager.find(Resource.class, (Object)parentId);
            }
            if (null != parentResource) {
                parentResource.addChildResource(resource);
                parentMap.put(parentId, parentResource);
            }
        }
        if ((resourceType = resource.getResourceType()).isCreatable() && (matchingHistory = this.findMatchingCreateResourceHistory(parentId, resource.getResourceKey())) != null && !StringUtil.isBlank((String)(userSuppliedResourceName = matchingHistory.getCreatedResourceName())) && !userSuppliedResourceName.equals(resource.getName())) {
            resource.setName(userSuppliedResourceName);
        }
        this.entityManager.persist((Object)resource);
        if (resource.getVersion() != null && resource.getVersion().length() > 0) {
            ProductVersion productVersion = this.productVersionManager.addProductVersion(resourceType, resource.getVersion());
            resource.setProductVersion(productVersion);
        }
        Subject overlord = this.subjectManager.getOverlord();
        resource.setItime(System.currentTimeMillis());
        resource.setModifiedBy(overlord.getName());
        this.setInventoryStatus(parentResource, resource, postMergeActions);
        if (null != parentResource) {
            this.groupManager.updateImplicitGroupMembership(overlord, resource);
        }
    }

    private CreateResourceHistory findMatchingCreateResourceHistory(Integer parentId, String resourceKey) {
        CreateResourceHistory next;
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"CreateResourceHistory.findByChildResourceKey", (PageControl)new PageControl(0, 1, new OrderingField[]{new OrderingField("mtime", PageOrdering.DESC)}));
        query.setParameter("parentResourceId", (Object)parentId);
        query.setParameter("newResourceKey", (Object)resourceKey);
        Iterator iterator = query.getResultList().iterator();
        if (iterator.hasNext() && (next = (CreateResourceHistory)iterator.next()).getStatus() == CreateResourceStatus.SUCCESS) {
            return next;
        }
        return null;
    }

    private void setInventoryStatus(Resource parentResource, Resource resource, Map<Resource, Set<PostMergeAction>> postMergeActions) {
        boolean isStorageNode;
        boolean isParentServer;
        if (null == parentResource) {
            resource.setInventoryStatus(InventoryStatus.NEW);
            return;
        }
        ResourceType resourceType = resource.getResourceType();
        boolean isParentCommitted = InventoryStatus.COMMITTED == parentResource.getInventoryStatus();
        boolean isService = ResourceCategory.SERVICE == resourceType.getCategory();
        boolean bl = isParentServer = ResourceCategory.SERVER == parentResource.getResourceType().getCategory();
        if (isParentCommitted && (isService || isParentServer)) {
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            return;
        }
        boolean isStorageNodePlugin = "RHQStorage".equals(resourceType.getPlugin());
        boolean bl2 = isStorageNode = isStorageNodePlugin && "RHQ Storage Node".equals(resourceType.getName());
        if (isStorageNode) {
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            if (!isParentCommitted) {
                parentResource.setInventoryStatus(InventoryStatus.COMMITTED);
            }
            this.addPostMergeAction(postMergeActions, resource, PostMergeAction.LINK_STORAGE_NODE);
            return;
        }
        resource.setInventoryStatus(InventoryStatus.NEW);
    }

    private void addPostMergeAction(Map<Resource, Set<PostMergeAction>> postMergeActions, Resource resource, PostMergeAction action) {
        if (postMergeActions.containsKey(resource)) {
            postMergeActions.get(resource).add(action);
        } else {
            postMergeActions.put(resource, EnumSet.of(PostMergeAction.LINK_STORAGE_NODE));
        }
    }

    @Override
    public void importResources(Subject subject, int[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.COMMITTED, EnumSet.of(InventoryStatus.NEW));
    }

    @Override
    public void ignoreResources(Subject subject, int[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.IGNORED, EnumSet.of(InventoryStatus.NEW, InventoryStatus.COMMITTED));
    }

    @Override
    public void unignoreResources(Subject subject, int[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.NEW, EnumSet.of(InventoryStatus.IGNORED));
    }

    @Override
    public void unignoreAndImportResources(Subject subject, int[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.COMMITTED, EnumSet.of(InventoryStatus.IGNORED));
    }

    private void checkStatus(Subject subject, int[] resourceIds, InventoryStatus target, EnumSet<InventoryStatus> validStatuses) {
        Query query = this.entityManager.createQuery("  SELECT res.inventoryStatus     FROM Resource res    WHERE res.id IN ( :resourceIds ) GROUP BY res.inventoryStatus ");
        List resourceIdList = ArrayUtils.wrapInList((int[])resourceIds);
        EnumSet<InventoryStatus> statuses = EnumSet.noneOf(InventoryStatus.class);
        int fromIndex = 0;
        while (fromIndex < resourceIds.length) {
            int toIndex = resourceIds.length < fromIndex + 1000 ? resourceIds.length : fromIndex + 1000;
            List resourceIdSubList = resourceIdList.subList(fromIndex, toIndex);
            query.setParameter("resourceIds", resourceIdSubList);
            List batchStatuses = query.getResultList();
            statuses.addAll(batchStatuses);
            fromIndex = toIndex;
        }
        if (!validStatuses.containsAll(statuses)) {
            throw new IllegalArgumentException("Can only set inventory status to [" + target + "] for Resources with current inventory status of one of [" + validStatuses + "].");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>(resourceIds.length);
        fromIndex = 0;
        while (fromIndex < resourceIds.length) {
            int toIndex = resourceIds.length < fromIndex + 1000 ? resourceIds.length : fromIndex + 1000;
            int[] resourceIdSubArray = Arrays.copyOfRange(resourceIds, fromIndex, toIndex);
            PageList<Resource> batchResources = this.resourceManager.findResourceByIds(subject, resourceIdSubArray, false, PageControl.getUnlimitedInstance());
            resources.addAll((Collection<Resource>)batchResources);
            fromIndex = toIndex;
        }
        ArrayList<Resource> platforms = new ArrayList<Resource>();
        ArrayList<Resource> servers = new ArrayList<Resource>();
        for (Resource resource : resources) {
            ResourceCategory category = resource.getResourceType().getCategory();
            if (category == ResourceCategory.PLATFORM) {
                if (target == InventoryStatus.IGNORED && resource.getInventoryStatus() == InventoryStatus.COMMITTED) {
                    LOG.warn((Object)("Cannot ignore a committed platform - skipping request to ignore:" + resource));
                    continue;
                }
                platforms.add(resource);
                continue;
            }
            servers.add(resource);
        }
        this.updateInventoryStatus(subject, platforms, servers, target);
    }

    private <T> boolean needsUpgrade(T oldValue, T newValue) {
        return newValue != null && (oldValue == null || !newValue.equals(oldValue));
    }

    private void abortResourceManualAddIfExistingSingleton(Resource parentResource, ResourceType resourceType) {
        if (resourceType.isSingleton()) {
            ResourceCriteria resourceCriteria = new ResourceCriteria();
            resourceCriteria.addFilterParentResourceId(Integer.valueOf(parentResource.getId()));
            resourceCriteria.addFilterResourceTypeId(Integer.valueOf(resourceType.getId()));
            resourceCriteria.clearPaging();
            PageList<Resource> childResourcesOfType = this.resourceManager.findResourcesByCriteria(this.subjectManager.getOverlord(), resourceCriteria);
            if (childResourcesOfType.size() >= 1) {
                throw new RuntimeException("Cannot manually add " + resourceType + " child Resource under parent " + parentResource + ", since " + resourceType + " is a singleton type, and there is already a child Resource of that type. " + "If the existing child Resource corresponds to a managed Resource which no longer exists, " + "uninventory it and then try again.");
            }
        }
    }

    static {
        int mergeBatchSize = 200;
        try {
            mergeBatchSize = Integer.parseInt(System.getProperty("rhq.server.discovery.merge.batch.size", "200"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MERGE_BATCH_SIZE = mergeBatchSize;
    }

    static enum PostMergeAction {
        LINK_STORAGE_NODE;

    }
}

