/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.MeasurementScheduleCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementAggregate;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.measurement.ui.MetricDisplaySummary;
import org.rhq.core.domain.measurement.ui.MetricDisplayValue;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.common.PerformanceMonitorInterceptor;
import org.rhq.enterprise.server.measurement.MeasurementChartsManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementException;
import org.rhq.enterprise.server.measurement.MeasurementNotFoundException;
import org.rhq.enterprise.server.measurement.MeasurementPreferences;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementViewException;
import org.rhq.enterprise.server.measurement.MeasurementViewManagerLocal;
import org.rhq.enterprise.server.measurement.util.MeasurementDataManagerUtility;
import org.rhq.enterprise.server.measurement.util.MeasurementUtils;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
@Interceptors(value={PerformanceMonitorInterceptor.class})
public class MeasurementChartsManagerBean
implements MeasurementChartsManagerLocal {
    private final Log log = LogFactory.getLog(MeasurementChartsManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    @EJB
    private MeasurementDefinitionManagerLocal measurementDefinitionManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private MeasurementDataManagerLocal dataManager;
    @EJB
    private MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private MeasurementViewManagerLocal viewManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;

    @Override
    @Deprecated
    public List<MetricDisplaySummary> getMetricDisplaySummariesForAutoGroup(Subject subject, int autoGroupParentResourceId, int autoGroupChildResourceTypeId, int[] measurementDefinitionIds, long begin, long end, boolean enabledOnly) throws MeasurementException {
        List<MetricDisplaySummary> ret = this.getAggregateMetricDisplaySummaries(subject, EntityContext.forAutoGroup((int)autoGroupParentResourceId, (int)autoGroupChildResourceTypeId), measurementDefinitionIds, begin, end, enabledOnly);
        for (MetricDisplaySummary tmp : ret) {
            tmp.setParentId(autoGroupParentResourceId);
            tmp.setChildTypeId(autoGroupChildResourceTypeId);
        }
        return ret;
    }

    @Override
    public List<MetricDisplaySummary> getMetricDisplaySummariesForCompatibleGroup(Subject subject, EntityContext context, int[] measurementDefinitionIds, long begin, long end, boolean enabledOnly) throws MeasurementException {
        List<MetricDisplaySummary> ret = this.getAggregateMetricDisplaySummaries(subject, context, measurementDefinitionIds, begin, end, enabledOnly);
        int groupId = context.getGroupId();
        for (MetricDisplaySummary tmp : ret) {
            tmp.setGroupId(groupId);
        }
        return ret;
    }

    @Override
    @Deprecated
    public List<MetricDisplaySummary> getMetricDisplaySummariesForAutoGroup(Subject subject, int parent, int type, String viewName) {
        List<MetricDisplaySummary> summaries;
        int[] measurementDefinitionIds;
        MeasurementPreferences preferences = new MeasurementPreferences(subject);
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        long begin = rangePreferences.begin;
        long end = rangePreferences.end;
        try {
            EntityContext context = new EntityContext(Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(parent), Integer.valueOf(type));
            measurementDefinitionIds = this.fillDefinitionIdsFromUserPreferences(context, viewName, subject);
        }
        catch (IllegalArgumentException iae) {
            measurementDefinitionIds = this.resourceGroupManager.findDefinitionsForAutoGroup(subject, parent, type, true);
        }
        try {
            summaries = this.getMetricDisplaySummariesForAutoGroup(subject, parent, type, measurementDefinitionIds, begin, end, false);
        }
        catch (MeasurementException me) {
            this.log.debug((Object)("Can't get ViewMetrics for autogroup: " + me));
            summaries = new ArrayList<MetricDisplaySummary>();
        }
        return summaries;
    }

    @Override
    public List<MetricDisplaySummary> getMetricDisplaySummariesForCompatibleGroup(Subject subject, EntityContext context, String viewName) {
        List<MetricDisplaySummary> summaries;
        int[] measurementDefinitionIds;
        MeasurementPreferences preferences = new MeasurementPreferences(subject);
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        long begin = rangePreferences.begin;
        long end = rangePreferences.end;
        try {
            measurementDefinitionIds = this.fillDefinitionIdsFromUserPreferences(context, viewName, subject);
        }
        catch (IllegalArgumentException iae) {
            measurementDefinitionIds = this.resourceGroupManager.findDefinitionsForCompatibleGroup(subject, context.getGroupId(), true);
        }
        try {
            summaries = this.getMetricDisplaySummariesForCompatibleGroup(subject, context, measurementDefinitionIds, begin, end, false);
        }
        catch (MeasurementException me) {
            this.log.debug((Object)("Can't get ViewMetrics for Compat Group: " + me));
            summaries = new ArrayList<MetricDisplaySummary>();
        }
        return summaries;
    }

    private int[] fillDefinitionIdsFromUserPreferences(EntityContext context, String viewName, Subject subject) {
        List<String> charts;
        try {
            charts = this.viewManager.getCharts(subject, context, viewName);
            if (charts.isEmpty()) {
                throw new IllegalArgumentException("No metrics defined");
            }
        }
        catch (MeasurementViewException mve) {
            throw new IllegalArgumentException("No metrics defined");
        }
        int[] measurementDefinitionIds = new int[charts.size()];
        int i = 0;
        for (String token : charts) {
            MetricDisplaySummary tmp = MeasurementUtils.parseMetricToken(token);
            measurementDefinitionIds[i++] = tmp.getDefinitionId();
        }
        return measurementDefinitionIds;
    }

    @Override
    public List<MetricDisplaySummary> getMetricDisplaySummariesForResource(Subject subject, int resourceId, int[] measurementScheduleIds, long beginTime, long endTime) throws MeasurementException {
        ArrayList<MetricDisplaySummary> allMeasurementData = new ArrayList<MetricDisplaySummary>(measurementScheduleIds.length);
        ArrayList<Integer> scheduleIds = new ArrayList<Integer>(measurementScheduleIds.length);
        for (int measurementScheduleId : measurementScheduleIds) {
            MeasurementSchedule schedule = null;
            try {
                schedule = this.scheduleManager.getScheduleById(subject, measurementScheduleId);
                scheduleIds.add(schedule.getId());
            }
            catch (MeasurementNotFoundException mnfe) {
                throw new MeasurementException(mnfe);
            }
            MetricDisplaySummary summary = this.getMetricDisplaySummary(subject, schedule, beginTime, endTime, false);
            if (summary == null) continue;
            summary.setUnits(schedule.getDefinition().getUnits().name());
            allMeasurementData.add(summary);
        }
        Map<Integer, Integer> alerts = this.alertManager.getAlertCountForSchedules(beginTime, endTime, scheduleIds);
        for (MetricDisplaySummary sum : allMeasurementData) {
            sum.setAlertCount(alerts.get(sum.getScheduleId()).intValue());
        }
        return allMeasurementData;
    }

    @Override
    public List<MetricDisplaySummary> getMetricDisplaySummariesForResource(Subject subject, int resourceId, String viewName) throws MeasurementException {
        List<MeasurementSchedule> scheds;
        try {
            EntityContext context = new EntityContext(Integer.valueOf(resourceId), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1));
            List<String> charts = this.viewManager.getCharts(subject, context, viewName);
            int[] schIds = new int[charts.size()];
            int i = 0;
            for (String metric : charts) {
                metric = metric.split(",")[1];
                int schedId = Integer.parseInt(metric);
                schIds[i++] = schedId;
            }
            scheds = this.scheduleManager.findSchedulesByIds(schIds);
            ArrayList<MeasurementSchedule> tmp = new ArrayList<MeasurementSchedule>(scheds.size());
            block3: for (int id : schIds) {
                for (MeasurementSchedule sch : scheds) {
                    if (sch.getId() != id) continue;
                    tmp.add(sch);
                    continue block3;
                }
            }
            scheds = tmp;
        }
        catch (MeasurementViewException mve) {
            scheds = this.scheduleManager.findSchedulesForResourceAndType(subject, resourceId, DataType.MEASUREMENT, DisplayType.SUMMARY, false);
        }
        int[] scheduleIds = new int[scheds.size()];
        int index = 0;
        for (MeasurementSchedule sched : scheds) {
            scheduleIds[index++] = sched.getId();
        }
        MeasurementPreferences preferences = new MeasurementPreferences(subject);
        MeasurementPreferences.MetricRangePreferences rangePreferences = preferences.getMetricRangePreferences();
        long begin = rangePreferences.begin;
        long end = rangePreferences.end;
        List<MetricDisplaySummary> idss = this.getMetricDisplaySummariesForResource(subject, resourceId, scheduleIds, begin, end);
        return idss;
    }

    @Override
    public List<MetricDisplaySummary> getMetricDisplaySummariesForMetrics(Subject subject, int resourceId, DataType dataType, long begin, long end, boolean narrowed, boolean enabledOnly) throws MeasurementException {
        ArrayList<MetricDisplaySummary> summaries = new ArrayList<MetricDisplaySummary>();
        List<MeasurementSchedule> scheds = this.scheduleManager.findSchedulesForResourceAndType(subject, resourceId, dataType, null, enabledOnly);
        ArrayList<Integer> scheduleIds = new ArrayList<Integer>(scheds.size());
        for (MeasurementSchedule schedule : scheds) {
            MetricDisplaySummary summary = this.getMetricDisplaySummary(subject, schedule, begin, end, narrowed);
            if (summary == null) continue;
            summary.setResourceId(resourceId);
            summaries.add(summary);
            scheduleIds.add(schedule.getId());
        }
        Map<Integer, Integer> alerts = this.alertManager.getAlertCountForSchedules(begin, end, scheduleIds);
        for (MetricDisplaySummary sum : summaries) {
            sum.setAlertCount(alerts.get(sum.getScheduleId()).intValue());
        }
        return summaries;
    }

    private MetricDisplaySummary getMetricDisplaySummary(Subject subject, MeasurementSchedule schedule, long begin, long end, boolean narrowed) throws MeasurementException {
        MetricDisplaySummary summary = new MetricDisplaySummary();
        summary.setScheduleId(Integer.valueOf(schedule.getId()));
        summary.setBeginTimeFrame(Long.valueOf(begin));
        summary.setEndTimeFrame(Long.valueOf(end));
        MeasurementDefinition definition = schedule.getDefinition();
        summary.setDefinitionId(Integer.valueOf(definition.getId()));
        summary.setMetricName(definition.getName());
        summary.setLabel(definition.getDisplayName());
        summary.setDescription(definition.getDescription());
        summary.setMetricSource(schedule.getResource().getName());
        summary.setMetricSourceId(schedule.getResource().getId());
        switch (definition.getDataType()) {
            case MEASUREMENT: {
                int collectionType;
                MeasurementUnits units = definition.getUnits();
                summary.setUnits(units.name());
                NumericType type = definition.getNumericType();
                if (type == null) {
                    throw new IllegalStateException("NumericType is null, but no traits are expected here");
                }
                switch (type) {
                    case DYNAMIC: {
                        collectionType = 0;
                        break;
                    }
                    case TRENDSUP: {
                        collectionType = 2;
                        break;
                    }
                    case TRENDSDOWN: {
                        collectionType = 3;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown measurement type: " + type);
                    }
                }
                summary.setCollectionType(Integer.valueOf(collectionType));
                if (narrowed) break;
                MeasurementAggregate compositeHighLow = this.dataManager.getMeasurementAggregate(subject, schedule.getId(), begin, end);
                if (compositeHighLow.isEmpty()) {
                    summary.setValuesPresent(false);
                }
                HashMap<String, MetricDisplayValue> metricValues = new HashMap<String, MetricDisplayValue>();
                metricValues.put("min", new MetricDisplayValue(compositeHighLow.getMin()));
                metricValues.put("average", new MetricDisplayValue(compositeHighLow.getAvg()));
                metricValues.put("max", new MetricDisplayValue(compositeHighLow.getMax()));
                MeasurementDataNumeric currentNumeric = this.dataManager.getCurrentNumericForSchedule(schedule.getId());
                Double lastValue = currentNumeric != null ? currentNumeric.getValue() : Double.NaN;
                metricValues.put("last", new MetricDisplayValue(lastValue));
                summary.setMetrics(metricValues);
                break;
            }
            case TRAIT: {
                summary.setIsTrait(true);
                MeasurementDataTrait trait = this.dataManager.getCurrentTraitForSchedule(schedule.getId());
                if (trait != null) {
                    summary.setValue(trait.getValue());
                    summary.setTimestamp(trait.getTimestamp());
                    break;
                }
                summary.setValue("- nothing found -");
                summary.setTimestamp(System.currentTimeMillis());
                break;
            }
            case CALLTIME: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported metric data type: " + definition.getDataType());
            }
        }
        return summary;
    }

    private List<MetricDisplaySummary> getAggregateMetricDisplaySummaries(Subject subject, EntityContext context, int[] measurementDefinitionIds, long begin, long end, boolean enabledOnly) throws MeasurementException {
        ArrayList<MetricDisplaySummary> data = new ArrayList<MetricDisplaySummary>(measurementDefinitionIds.length);
        if (measurementDefinitionIds.length == 0) {
            return data;
        }
        if (context.type == EntityContext.Type.Resource) {
            if (!this.authorizationManager.canViewResource(subject, context.resourceId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view metric display summaries for resource[id=" + context.resourceId + "]");
            }
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            if (!this.authorizationManager.canViewGroup(subject, context.groupId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view metric display summaries for resourceGroup[id=" + context.groupId + "]");
            }
        } else if (context.type == EntityContext.Type.AutoGroup && !this.authorizationManager.canViewAutoGroup(subject, context.parentResourceId, context.resourceTypeId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view metric display summaries for autoGroup[parentResourceId=" + context.parentResourceId + ", resourceTypeId=" + context.resourceTypeId + "]");
        }
        MeasurementDataManagerUtility dataUtil = MeasurementDataManagerUtility.getInstance(this.rhqDs);
        for (int definitionId : measurementDefinitionIds) {
            MeasurementAggregate aggregate;
            MeasurementScheduleCriteria criteria = new MeasurementScheduleCriteria();
            if (context.type == EntityContext.Type.Resource) {
                criteria.addFilterResourceId(Integer.valueOf(context.resourceId));
            } else if (context.type == EntityContext.Type.ResourceGroup) {
                criteria.addFilterResourceGroupId(Integer.valueOf(context.groupId));
            } else if (context.type == EntityContext.Type.AutoGroup) {
                criteria.addFilterAutoGroupParentResourceId(Integer.valueOf(context.parentResourceId));
                criteria.addFilterAutoGroupResourceTypeId(Integer.valueOf(context.resourceTypeId));
            }
            criteria.addFilterDefinitionIds(new Integer[]{definitionId});
            criteria.clearPaging();
            PageList<MeasurementSchedule> theSchedules = this.scheduleManager.findSchedulesByCriteria(subject, criteria);
            int totalScheduleCount = theSchedules.getTotalSize();
            criteria.addFilterEnabled(Boolean.valueOf(true));
            criteria.setPageControl(PageControl.getSingleRowInstance());
            theSchedules = this.scheduleManager.findSchedulesByCriteria(subject, criteria);
            int collecting = theSchedules.getTotalSize();
            if (collecting == 0 && enabledOnly) {
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("There were no schedules enabled for definition id " + definitionId));
                continue;
            }
            MetricDisplaySummary summary = new MetricDisplaySummary();
            summary.setNumberCollecting(collecting);
            summary.setShowNumberCollecting(Boolean.valueOf(true));
            summary.setDefinitionId(Integer.valueOf(definitionId));
            summary.setBeginTimeFrame(Long.valueOf(begin));
            summary.setAlertCount(this.getAlertCountForContext(definitionId, context, begin, end));
            summary.setEndTimeFrame(Long.valueOf(end));
            MeasurementDefinition definition = (MeasurementDefinition)this.entityManager.find(MeasurementDefinition.class, (Object)definitionId);
            summary.setDefinitionId(Integer.valueOf(definition.getId()));
            summary.setUnits(definition.getUnits().getName());
            summary.setDescription(definition.getDescription());
            summary.setMetricName(definition.getName());
            summary.setLabel(definition.getDisplayName());
            summary.setDescription(definition.getDescription());
            summary.setMetricSource(definition.getResourceType().getName());
            if (totalScheduleCount == 0) {
                aggregate = new MeasurementAggregate(null, null, null);
                this.log.warn((Object)("No metric schedules found for def=[" + definition + "] and " + context + ", using empty aggregate"));
            } else {
                aggregate = context.type == EntityContext.Type.ResourceGroup && definition.getDataType() == DataType.MEASUREMENT ? this.dataManager.getAggregate(subject, context.getGroupId(), definitionId, begin, end) : dataUtil.getAggregateByDefinitionAndContext(begin, end, definitionId, context);
            }
            if (aggregate.isEmpty()) {
                if (this.log.isTraceEnabled()) {
                    this.log.warn((Object)("No metric data found for def=[" + definition + "] and " + context + " in the timeframe [" + new Date(begin) + ", " + new Date(end) + "]"));
                }
                summary.setValuesPresent(false);
            }
            HashMap<String, MetricDisplayValue> metricValues = new HashMap<String, MetricDisplayValue>();
            metricValues.put("min", new MetricDisplayValue(aggregate.getMin()));
            metricValues.put("average", new MetricDisplayValue(aggregate.getAvg()));
            metricValues.put("max", new MetricDisplayValue(aggregate.getMax()));
            summary.setMetrics(metricValues);
            data.add(summary);
        }
        return data;
    }

    @Override
    public Map<MeasurementDefinition, List<MetricDisplaySummary>> getMetricDisplaySummariesForMetricsCompare(Subject subject, int[] resourceIds, int[] definitionIds, long begin, long end) throws MeasurementException {
        PageList<org.rhq.core.domain.resource.Resource> resources = this.resourceManager.findResourceByIds(subject, resourceIds, true, PageControl.getUnlimitedInstance());
        HashMap<Integer, MeasurementDefinition> measurementDefinitionsMap = new HashMap<Integer, MeasurementDefinition>(definitionIds.length);
        ArrayList<Integer> collectingDefIdList = new ArrayList<Integer>();
        for (int definitionId : definitionIds) {
            if (!this.isMetricCollecting(subject, resourceIds, definitionId)) continue;
            collectingDefIdList.add(definitionId);
        }
        Integer[] collectingDefIds = collectingDefIdList.toArray(new Integer[collectingDefIdList.size()]);
        int[] collectingDefIdArr = new int[collectingDefIds.length];
        for (int i = 0; i < collectingDefIds.length; ++i) {
            collectingDefIdArr[i] = collectingDefIds[i];
        }
        List<MeasurementDefinition> definitions = this.measurementDefinitionManager.findMeasurementDefinitionsByIds(subject, collectingDefIds);
        for (MeasurementDefinition definition : definitions) {
            measurementDefinitionsMap.put(definition.getId(), definition);
        }
        HashMap<MeasurementDefinition, List<MetricDisplaySummary>> compareMetrics = new HashMap<MeasurementDefinition, List<MetricDisplaySummary>>();
        for (org.rhq.core.domain.resource.Resource resource : resources) {
            List<MeasurementSchedule> scheds = this.scheduleManager.findSchedulesByResourceIdAndDefinitionIds(subject, resource.getId(), collectingDefIdArr);
            int[] schedIds = new int[scheds.size()];
            for (int i = 0; i < schedIds.length; ++i) {
                schedIds[i] = scheds.get(i).getId();
            }
            List<MetricDisplaySummary> resourceMDS = this.getMetricDisplaySummariesForResource(subject, resource.getId(), schedIds, begin, end);
            for (MetricDisplaySummary summary : resourceMDS) {
                Integer definitionId = summary.getDefinitionId();
                MeasurementDefinition definition = (MeasurementDefinition)measurementDefinitionsMap.get(definitionId);
                if (definition == null) continue;
                summary.setResource(resource);
                summary.setParent(resource.getParentResource());
                summary.setUnits(definition.getUnits().getName());
                summary.setDescription(definition.getDescription());
                summary.setMetricName(definition.getName());
                summary.setLabel(definition.getDisplayName());
                summary.setMetricSource(definition.getResourceType().getName());
                ArrayList<MetricDisplaySummary> metricsForDefinition = (ArrayList<MetricDisplaySummary>)compareMetrics.get(definition);
                if (metricsForDefinition == null) {
                    metricsForDefinition = new ArrayList<MetricDisplaySummary>();
                    compareMetrics.put(definition, metricsForDefinition);
                }
                metricsForDefinition.add(summary);
            }
        }
        return compareMetrics;
    }

    private boolean isMetricCollecting(Subject subject, int[] resourceIds, int definitionId) {
        boolean isCollecting = false;
        List<MeasurementSchedule> schedules = this.scheduleManager.findSchedulesByResourceIdsAndDefinitionId(subject, resourceIds, definitionId);
        for (MeasurementSchedule schedule : schedules) {
            if (!schedule.isEnabled()) continue;
            isCollecting = true;
            break;
        }
        return isCollecting;
    }

    private int getAlertCountForContext(int measurementDefinitionId, EntityContext context, long begin, long end) {
        if (context.type == EntityContext.Type.AutoGroup) {
            return this.alertManager.getAlertCountByMeasurementDefinitionAndAutoGroup(measurementDefinitionId, context.getParentResourceId(), context.getResourceTypeId(), begin, end);
        }
        if (context.type == EntityContext.Type.Resource) {
            return this.alertManager.getAlertCountByMeasurementDefinitionAndResource(measurementDefinitionId, context.getResourceId(), begin, end);
        }
        if (context.type == EntityContext.Type.ResourceGroup) {
            return this.alertManager.getAlertCountByMeasurementDefinitionAndResourceGroup(measurementDefinitionId, context.getGroupId(), begin, end);
        }
        return 0;
    }
}

