/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.operation;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.clientapi.agent.operation.CancelResults;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.JobTrigger;
import org.rhq.core.domain.common.composite.IntegerOptionItem;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUtility;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.GroupOperationHistoryCriteria;
import org.rhq.core.domain.criteria.OperationDefinitionCriteria;
import org.rhq.core.domain.criteria.ResourceOperationHistoryCriteria;
import org.rhq.core.domain.operation.GroupOperationHistory;
import org.rhq.core.domain.operation.GroupOperationScheduleEntity;
import org.rhq.core.domain.operation.HistoryJobId;
import org.rhq.core.domain.operation.JobId;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.operation.OperationHistory;
import org.rhq.core.domain.operation.OperationRequestStatus;
import org.rhq.core.domain.operation.OperationScheduleEntity;
import org.rhq.core.domain.operation.ResourceOperationHistory;
import org.rhq.core.domain.operation.ResourceOperationScheduleEntity;
import org.rhq.core.domain.operation.ScheduleJobId;
import org.rhq.core.domain.operation.bean.GroupOperationSchedule;
import org.rhq.core.domain.operation.bean.ResourceOperationSchedule;
import org.rhq.core.domain.operation.composite.GroupOperationLastCompletedComposite;
import org.rhq.core.domain.operation.composite.GroupOperationScheduleComposite;
import org.rhq.core.domain.operation.composite.ResourceOperationLastCompletedComposite;
import org.rhq.core.domain.operation.composite.ResourceOperationScheduleComposite;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.common.ApplicationException;
import org.rhq.enterprise.server.configuration.ConfigurationManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.exception.ScheduleException;
import org.rhq.enterprise.server.exception.UnscheduleException;
import org.rhq.enterprise.server.operation.GroupOperationJob;
import org.rhq.enterprise.server.operation.OperationDefinitionNotFoundException;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerRemote;
import org.rhq.enterprise.server.operation.ResourceOperationJob;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceNotFoundException;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupNotFoundException;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.storage.StorageNodeOperationsHandlerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
public class OperationManagerBean
implements OperationManagerLocal,
OperationManagerRemote {
    private static final Log LOG = LogFactory.getLog(OperationManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ConfigurationManagerLocal configurationManager;
    @EJB
    private OperationManagerLocal operationManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private SchedulerLocal scheduler;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private StorageNodeOperationsHandlerLocal storageNodeOperationsHandler;

    @Override
    public List<IntegerOptionItem> getResourceNameOptionItems(int groupId) {
        String queryName = "ResourceGroup.findResourceNamesByGroupId";
        PageControl pc = PageControl.getUnlimitedInstance();
        pc.addDefaultOrderingField("res.name");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        query.setParameter("groupId", (Object)groupId);
        List results = query.getResultList();
        return results;
    }

    @Override
    public ResourceOperationSchedule scheduleResourceOperation(Subject subject, int resourceId, String operationName, long delay, long repeatInterval, int repeatCount, int timeout, Configuration parameters, String notes) throws ScheduleException {
        try {
            SimpleTrigger trigger = new SimpleTrigger();
            if (delay < 0L) {
                delay = 0L;
            }
            trigger.setRepeatCount(repeatCount < 0 ? -1 : repeatCount);
            trigger.setRepeatInterval(repeatInterval < 0L ? 0L : repeatInterval);
            trigger.setStartTime(new Date(System.currentTimeMillis() + delay));
            if ((long)timeout > 0L) {
                if (null == parameters) {
                    parameters = new Configuration();
                }
                parameters.put((Property)new PropertySimple("rhq.timeout", (Object)timeout));
            }
            return this.scheduleResourceOperation(subject, resourceId, operationName, parameters, (Trigger)trigger, notes);
        }
        catch (Exception e) {
            throw new ScheduleException(e);
        }
    }

    @Override
    public ResourceOperationSchedule scheduleResourceOperationUsingCron(Subject subject, int resourceId, String operationName, String cronExpression, int timeout, Configuration parameters, String description) throws ScheduleException {
        if ((long)timeout > 0L) {
            if (parameters == null) {
                parameters = new Configuration();
            }
            parameters.put((Property)new PropertySimple("rhq.timeout", (Object)timeout));
        }
        try {
            CronTrigger cronTrigger = new CronTrigger("resource " + resourceId + "_" + operationName, "group", cronExpression);
            return this.scheduleResourceOperation(subject, resourceId, operationName, parameters, (Trigger)cronTrigger, description);
        }
        catch (Exception e) {
            throw new ScheduleException(e);
        }
    }

    @Override
    public int scheduleResourceOperation(Subject subject, ResourceOperationSchedule schedule) throws ScheduleException {
        JobTrigger jobTrigger = schedule.getJobTrigger();
        Trigger trigger = this.convertToTrigger(jobTrigger);
        try {
            ResourceOperationSchedule resourceOperationSchedule = this.scheduleResourceOperation(subject, schedule.getResource().getId(), schedule.getOperationName(), schedule.getParameters(), trigger, schedule.getDescription());
            return resourceOperationSchedule.getId();
        }
        catch (SchedulerException e) {
            throw new ScheduleException(e);
        }
    }

    @Override
    public int scheduleGroupOperation(Subject subject, GroupOperationSchedule schedule) throws ScheduleException {
        JobTrigger jobTrigger = schedule.getJobTrigger();
        Trigger trigger = this.convertToTrigger(jobTrigger);
        try {
            int[] executionOrderResourceIds;
            List executionOrderResources = schedule.getExecutionOrder();
            if (executionOrderResources == null) {
                executionOrderResourceIds = null;
            } else {
                executionOrderResourceIds = new int[executionOrderResources.size()];
                int executionOrderResourcesSize = executionOrderResources.size();
                for (int i = 0; i < executionOrderResourcesSize; ++i) {
                    Resource executionOrderResource = (Resource)executionOrderResources.get(i);
                    executionOrderResourceIds[i] = executionOrderResource.getId();
                }
            }
            GroupOperationSchedule groupOperationSchedule = this.scheduleGroupOperation(subject, schedule.getGroup().getId(), executionOrderResourceIds, schedule.getHaltOnFailure(), schedule.getOperationName(), schedule.getParameters(), trigger, schedule.getDescription());
            return groupOperationSchedule.getId();
        }
        catch (SchedulerException e) {
            throw new ScheduleException(e);
        }
    }

    @Override
    public ResourceOperationSchedule scheduleResourceOperation(Subject subject, int resourceId, String operationName, Configuration parameters, Trigger trigger, String notes) throws SchedulerException {
        Resource resource = this.getResourceIfAuthorized(subject, resourceId);
        this.ensureControlPermission(subject, resource);
        OperationDefinition opDef = this.validateOperationNameAndParameters(resource.getResourceType(), operationName, parameters);
        String uniqueJobId = this.createUniqueJobName(resource, operationName);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("operationName", operationName);
        this.putDisplayName(jobDataMap, resource.getResourceType().getId(), operationName);
        if (parameters != null) {
            if (parameters.getId() == 0) {
                this.entityManager.persist((Object)parameters);
            }
            jobDataMap.putAsString("parametersId", parameters.getId());
        }
        jobDataMap.putAsString("subjectId", subject.getId());
        jobDataMap.putAsString("resourceId", resource.getId());
        jobDataMap.put("description", notes);
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(uniqueJobId);
        String jobGroupName = this.createJobGroupName(resource);
        jobDetail.setGroup(jobGroupName);
        jobDetail.setDescription(notes);
        jobDetail.setVolatility(false);
        jobDetail.setDurability(false);
        jobDetail.setRequestsRecovery(false);
        jobDetail.setJobClass(ResourceOperationJob.class);
        jobDetail.setJobDataMap(jobDataMap);
        trigger.setName(jobDetail.getName());
        trigger.setGroup(jobDetail.getGroup());
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobDetail.getGroup());
        ResourceOperationScheduleEntity schedule = new ResourceOperationScheduleEntity(jobDetail.getName(), jobDetail.getGroup(), trigger.getStartTime(), resource);
        this.entityManager.persist((Object)schedule);
        jobDataMap.put("entityId", String.valueOf(schedule.getId()));
        ResourceOperationHistory history = new ResourceOperationHistory(uniqueJobId, jobGroupName, subject.getName(), opDef, parameters == null ? null : parameters.deepCopy(false), schedule.getResource(), null);
        this.updateOperationHistory(subject, (OperationHistory)history);
        Date next = this.scheduler.scheduleJob(jobDetail, trigger);
        ResourceOperationSchedule newSchedule = this.getResourceOperationSchedule(subject, jobDetail);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Scheduled Resource operation [" + newSchedule + "] - next fire time is [" + next + "]"));
        }
        return newSchedule;
    }

    private void putDisplayName(JobDataMap jobDataMap, int resourceTypeId, String operationName) {
        try {
            OperationDefinition operationDefintion = this.getOperationDefinitionByResourceTypeAndName(resourceTypeId, operationName, false);
            jobDataMap.put("operationDisplayName", operationDefintion.getDisplayName());
        }
        catch (OperationDefinitionNotFoundException odnfe) {
            jobDataMap.put("operationDisplayName", operationName);
        }
    }

    @Override
    public GroupOperationSchedule scheduleGroupOperation(Subject subject, int compatibleGroupId, int[] executionOrderResourceIds, boolean haltOnFailure, String operationName, Configuration parameters, Trigger trigger, String notes) throws SchedulerException {
        ResourceGroup group = this.getCompatibleGroupIfAuthorized(subject, compatibleGroupId);
        this.ensureControlPermission(subject, group);
        this.validateOperationNameAndParameters(group.getResourceType(), operationName, parameters);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("operationName", operationName);
        this.putDisplayName(jobDataMap, group.getResourceType().getId(), operationName);
        if (parameters != null) {
            if (parameters.getId() == 0) {
                this.entityManager.persist((Object)parameters);
            }
            jobDataMap.putAsString("parametersId", parameters.getId());
        }
        jobDataMap.putAsString("subjectId", subject.getId());
        jobDataMap.putAsString("groupId", group.getId());
        jobDataMap.putAsString("haltOnFailure", haltOnFailure);
        if (executionOrderResourceIds != null && executionOrderResourceIds.length > 0) {
            StringBuilder orderString = new StringBuilder();
            orderString.append(executionOrderResourceIds[0]);
            for (int i = 1; i < executionOrderResourceIds.length; ++i) {
                orderString.append(',');
                orderString.append(executionOrderResourceIds[i]);
            }
            jobDataMap.put("executionOrder", orderString.toString());
        }
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(this.createUniqueJobName(group, operationName));
        jobDetail.setGroup(this.createJobGroupName(group));
        jobDetail.setDescription(notes);
        jobDetail.setVolatility(false);
        jobDetail.setDurability(false);
        jobDetail.setRequestsRecovery(false);
        jobDetail.setJobClass(GroupOperationJob.class);
        jobDetail.setJobDataMap(jobDataMap);
        trigger.setName(jobDetail.getName());
        trigger.setGroup(jobDetail.getGroup());
        trigger.setJobName(jobDetail.getName());
        trigger.setJobGroup(jobDetail.getGroup());
        GroupOperationScheduleEntity schedule = new GroupOperationScheduleEntity(jobDetail.getName(), jobDetail.getGroup(), trigger.getStartTime(), group);
        this.entityManager.persist((Object)schedule);
        jobDataMap.put("entityId", String.valueOf(schedule.getId()));
        Date next = this.scheduler.scheduleJob(jobDetail, trigger);
        GroupOperationSchedule newSchedule = this.getGroupOperationSchedule(subject, jobDetail);
        LOG.debug((Object)("Scheduled group operation [" + newSchedule + "] - next fire time is [" + next + "]"));
        return newSchedule;
    }

    @Override
    public void unscheduleResourceOperation(Subject subject, String jobId, int resourceId) throws UnscheduleException {
        try {
            String jobGroup;
            ScheduleJobId jobIdObject;
            String jobName;
            boolean deleted;
            Integer configId;
            Configuration parameters;
            Resource resource = this.getResourceIfAuthorized(subject, resourceId);
            this.ensureControlPermission(subject, resource);
            ResourceOperationSchedule schedule = null;
            try {
                schedule = this.getResourceOperationSchedule(subject, jobId);
            }
            catch (SchedulerException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Assuming job [" + jobId + "] has completed, ignoring request to unschedule resource operation for resource [" + resourceId + "]"));
                }
                return;
            }
            if (schedule.getParameters() != null && null != (parameters = this.configurationManager.getConfigurationById(configId = Integer.valueOf(schedule.getParameters().getId())))) {
                this.entityManager.remove((Object)parameters);
            }
            if (deleted = this.scheduler.deleteJob(jobName = (jobIdObject = new ScheduleJobId(jobId)).getJobName(), jobGroup = jobIdObject.getJobGroup())) {
                this.deleteOperationScheduleEntity(jobIdObject);
            }
        }
        catch (Exception e) {
            throw new UnscheduleException(e);
        }
    }

    @Override
    public void unscheduleGroupOperation(Subject subject, String jobId, int resourceGroupId) throws UnscheduleException {
        try {
            String jobGroup;
            ScheduleJobId jobIdObject;
            String jobName;
            boolean deleted;
            Integer configId;
            Configuration parameters;
            ResourceGroup group = this.resourceGroupManager.getResourceGroupById(subject, resourceGroupId, GroupCategory.COMPATIBLE);
            this.ensureControlPermission(subject, group);
            this.getCompatibleGroupIfAuthorized(subject, resourceGroupId);
            GroupOperationSchedule schedule = null;
            try {
                schedule = this.getGroupOperationSchedule(subject, jobId);
            }
            catch (SchedulerException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Assuming job [" + jobId + "] has completed, ignoring request to unschedule group operation for group [" + resourceGroupId + "]"));
                }
                return;
            }
            if (schedule.getParameters() != null && null != (parameters = this.configurationManager.getConfigurationById(configId = Integer.valueOf(schedule.getParameters().getId())))) {
                this.entityManager.remove((Object)parameters);
            }
            if (deleted = this.scheduler.deleteJob(jobName = (jobIdObject = new ScheduleJobId(jobId)).getJobName(), jobGroup = jobIdObject.getJobGroup())) {
                this.deleteOperationScheduleEntity(jobIdObject);
            }
        }
        catch (Exception e) {
            throw new UnscheduleException(e);
        }
    }

    @Override
    public void deleteOperationScheduleEntity(ScheduleJobId jobId) {
        try {
            OperationScheduleEntity doomed = this.findOperationScheduleEntity(jobId);
            if (doomed != null) {
                LOG.debug((Object)("Deleting schedule entity: " + jobId));
                this.entityManager.remove((Object)doomed);
            } else {
                LOG.info((Object)("Asked to delete unknown schedule - ignoring: " + jobId));
            }
        }
        catch (NoResultException nre) {
            LOG.info((Object)("Asked to delete unknown schedule - ignoring: " + jobId));
        }
    }

    @Override
    public void updateOperationScheduleEntity(ScheduleJobId jobId, long nextFireTime) {
        OperationScheduleEntity sched = this.findOperationScheduleEntity(jobId);
        sched.setNextFireTime(Long.valueOf(nextFireTime));
        LOG.debug((Object)("Scheduled job has a new next-fire-time: " + sched));
    }

    @Override
    public List<ResourceOperationSchedule> findScheduledResourceOperations(Subject subject, int resourceId) throws Exception {
        String[] jobNames;
        Resource resource = this.getResourceIfAuthorized(subject, resourceId);
        ArrayList<ResourceOperationSchedule> operationSchedules = new ArrayList<ResourceOperationSchedule>();
        String groupName = this.createJobGroupName(resource);
        for (String jobName : jobNames = this.scheduler.getJobNames(groupName)) {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobName, groupName);
            ResourceOperationSchedule sched = this.getResourceOperationSchedule(subject, jobDetail);
            if (sched == null) continue;
            if (resourceId != sched.getResource().getId()) {
                throw new IllegalStateException("Somehow a different resource [" + sched.getResource() + "] was scheduled in the same job group as resource [" + resource + "]");
            }
            operationSchedules.add(sched);
        }
        return operationSchedules;
    }

    @Override
    public List<GroupOperationSchedule> findScheduledGroupOperations(Subject subject, int groupId) throws Exception {
        String[] jobNames;
        ResourceGroup group = this.getCompatibleGroupIfAuthorized(subject, groupId);
        ArrayList<GroupOperationSchedule> operationSchedules = new ArrayList<GroupOperationSchedule>();
        String groupName = this.createJobGroupName(group);
        for (String jobName : jobNames = this.scheduler.getJobNames(groupName)) {
            JobDetail jobDetail = this.scheduler.getJobDetail(jobName, groupName);
            GroupOperationSchedule sched = this.getGroupOperationSchedule(subject, jobDetail);
            if (sched == null) continue;
            if (groupId != sched.getGroup().getId()) {
                throw new IllegalStateException("Somehow a different group [" + sched.getGroup() + "] was scheduled in the same job group as group [" + group + "]");
            }
            operationSchedules.add(sched);
        }
        return operationSchedules;
    }

    @Override
    public ResourceOperationSchedule getResourceOperationSchedule(Subject whoami, int scheduleId) {
        OperationScheduleEntity operationScheduleEntity = (OperationScheduleEntity)this.entityManager.find(OperationScheduleEntity.class, (Object)scheduleId);
        try {
            ResourceOperationSchedule resourceOperationSchedule = this.getResourceOperationSchedule(whoami, operationScheduleEntity.getJobId().toString());
            return resourceOperationSchedule;
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Failed to retrieve ResourceOperationSchedule with id [" + scheduleId + "].", e);
        }
    }

    @Override
    public GroupOperationSchedule getGroupOperationSchedule(Subject whoami, int scheduleId) {
        OperationScheduleEntity operationScheduleEntity = (OperationScheduleEntity)this.entityManager.find(OperationScheduleEntity.class, (Object)scheduleId);
        try {
            GroupOperationSchedule groupOperationSchedule = this.getGroupOperationSchedule(whoami, operationScheduleEntity.getJobId().toString());
            return groupOperationSchedule;
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Failed to retrieve GroupOperationSchedule with id [" + scheduleId + "].", e);
        }
    }

    @Override
    public ResourceOperationSchedule getResourceOperationSchedule(Subject whoami, JobDetail jobDetail) {
        if (null == jobDetail) {
            return null;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        String jobName = jobDetail.getName();
        String jobGroup = jobDetail.getGroup();
        String description = jobDataMap.getString("description");
        String operationName = jobDataMap.getString("operationName");
        String displayName = jobDataMap.getString("operationDisplayName");
        int subjectId = jobDataMap.getIntFromString("subjectId");
        Configuration parameters = null;
        if (jobDataMap.containsKey((Object)"parametersId")) {
            int configId = jobDataMap.getIntFromString("parametersId");
            parameters = (Configuration)this.entityManager.find(Configuration.class, (Object)configId);
        }
        int resourceId = jobDataMap.getIntFromString("resourceId");
        Resource resource = this.getResourceIfAuthorized(whoami, resourceId);
        Integer entityId = this.getOperationScheduleEntityId(jobDetail);
        ResourceOperationSchedule sched = new ResourceOperationSchedule();
        sched.setId(entityId.intValue());
        sched.setJobName(jobName);
        sched.setJobGroup(jobGroup);
        sched.setResource(resource);
        sched.setOperationName(operationName);
        sched.setOperationDisplayName(displayName);
        Subject subject = this.subjectManager.getSubjectById(subjectId);
        sched.setSubject(subject);
        sched.setParameters(parameters);
        sched.setDescription(description);
        Trigger trigger = this.getTriggerOfJob(jobDetail);
        if (trigger == null) {
            return null;
        }
        JobTrigger jobTrigger = this.convertToJobTrigger(trigger);
        sched.setJobTrigger(jobTrigger);
        sched.setNextFireTime(trigger.getNextFireTime());
        return sched;
    }

    private int getOperationScheduleEntityId(JobDetail jobDetail) {
        int entityId;
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        Object entityIdObj = jobDataMap.get((Object)"entityId");
        if (entityIdObj != null) {
            entityId = Integer.valueOf((String)entityIdObj);
        } else {
            String jobName = jobDetail.getName();
            String jobGroup = jobDetail.getGroup();
            ScheduleJobId jobId = new ScheduleJobId(jobName, jobGroup);
            OperationScheduleEntity operationScheduleEntity = this.findOperationScheduleEntity(jobId);
            entityId = operationScheduleEntity.getId();
        }
        return entityId;
    }

    @Override
    public ResourceOperationSchedule getResourceOperationSchedule(Subject subject, String jobId) throws SchedulerException {
        JobId jobIdObject = new JobId(jobId);
        JobDetail jobDetail = this.scheduler.getJobDetail(jobIdObject.getJobName(), jobIdObject.getJobGroup());
        ResourceOperationSchedule resourceOperationSchedule = this.getResourceOperationSchedule(subject, jobDetail);
        if (resourceOperationSchedule == null) {
            throw new SchedulerException("The job with ID [" + jobId + "] is no longer scheduled.");
        }
        return resourceOperationSchedule;
    }

    @Override
    public GroupOperationSchedule getGroupOperationSchedule(Subject subject, JobDetail jobDetail) {
        if (null == jobDetail) {
            return null;
        }
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        String description = jobDetail.getDescription();
        String operationName = jobDataMap.getString("operationName");
        String displayName = jobDataMap.getString("operationDisplayName");
        int subjectId = jobDataMap.getIntFromString("subjectId");
        Configuration parameters = null;
        if (jobDataMap.containsKey((Object)"parametersId")) {
            int configId = jobDataMap.getIntFromString("parametersId");
            parameters = (Configuration)this.entityManager.find(Configuration.class, (Object)configId);
        }
        int groupId = jobDataMap.getIntFromString("groupId");
        ResourceGroup group = this.getCompatibleGroupIfAuthorized(subject, groupId);
        ArrayList<Resource> executionOrder = null;
        if (jobDataMap.containsKey((Object)"executionOrder")) {
            String[] orderArray;
            String orderCommaSeparated = jobDataMap.getString("executionOrder");
            for (String resourceIdString : orderArray = orderCommaSeparated.split(",")) {
                int resourceId = Integer.parseInt(resourceIdString);
                Resource memberResource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
                if (memberResource != null) {
                    if (executionOrder == null) {
                        executionOrder = new ArrayList<Resource>();
                    }
                    if (executionOrder.contains(memberResource)) continue;
                    executionOrder.add(memberResource);
                    continue;
                }
                LOG.debug((Object)("Resource [" + resourceId + "] looks like it was deleted and is no longer a member of group [" + group + "] - ignoring it"));
            }
        }
        boolean haltOnFailure = jobDataMap.getBooleanValueFromString("haltOnFailure");
        Integer entityId = this.getOperationScheduleEntityId(jobDetail);
        GroupOperationSchedule sched = new GroupOperationSchedule();
        sched.setId(entityId.intValue());
        sched.setJobName(jobDetail.getName());
        sched.setJobGroup(jobDetail.getGroup());
        sched.setGroup(group);
        sched.setOperationName(operationName);
        sched.setOperationDisplayName(displayName);
        sched.setSubject(this.subjectManager.getSubjectById(subjectId));
        sched.setParameters(parameters);
        sched.setExecutionOrder(executionOrder);
        sched.setDescription(description);
        sched.setHaltOnFailure(haltOnFailure);
        Trigger trigger = this.getTriggerOfJob(jobDetail);
        if (trigger == null) {
            return null;
        }
        JobTrigger jobTrigger = this.convertToJobTrigger(trigger);
        sched.setJobTrigger(jobTrigger);
        sched.setNextFireTime(trigger.getNextFireTime());
        return sched;
    }

    @Override
    public GroupOperationSchedule getGroupOperationSchedule(Subject subject, String jobId) throws SchedulerException {
        JobId jobIdObject = new JobId(jobId);
        JobDetail jobDetail = this.scheduler.getJobDetail(jobIdObject.getJobName(), jobIdObject.getJobGroup());
        GroupOperationSchedule groupOperationSchedule = this.getGroupOperationSchedule(subject, jobDetail);
        if (groupOperationSchedule == null) {
            throw new SchedulerException("The job with ID [" + jobId + "] is no longer scheduled.");
        }
        return groupOperationSchedule;
    }

    @Override
    public OperationHistory getOperationHistoryByHistoryId(Subject subject, int historyId) {
        ResourceOperationHistory resourceHistory;
        OperationHistory history = (OperationHistory)this.entityManager.find(OperationHistory.class, (Object)historyId);
        if (history == null) {
            throw new IllegalArgumentException("Cannot get history - it does not exist: " + historyId);
        }
        if (history.getParameters() != null) {
            history.getParameters().getId();
        }
        if (history instanceof ResourceOperationHistory && (resourceHistory = (ResourceOperationHistory)history).getResults() != null) {
            resourceHistory.getResults().getId();
        }
        this.ensureViewPermission(subject, history);
        return history;
    }

    @Override
    public PageList<ResourceOperationHistory> findResourceOperationHistoriesByGroupHistoryId(Subject subject, int historyId, PageControl pc) {
        pc.initDefaultOrderingField("h.createdTime", PageOrdering.DESC);
        String queryName = "ResourceOperationHistory.findByGroupOperationHistoryId";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("groupHistoryId", (Object)historyId);
        query.setParameter("groupHistoryId", (Object)historyId);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        PageList pagedResourceHistories = new PageList((Collection)list, (int)totalCount, pc);
        return pagedResourceHistories;
    }

    @Override
    public OperationHistory getOperationHistoryByJobId(Subject subject, String historyJobId) {
        OperationHistory history;
        HistoryJobId jobIdObject = new HistoryJobId(historyJobId);
        Query query = this.entityManager.createNamedQuery("OperationHistory.findByJobId");
        query.setParameter("jobName", (Object)jobIdObject.getJobName());
        query.setParameter("jobGroup", (Object)jobIdObject.getJobGroup());
        query.setParameter("createdTime", (Object)jobIdObject.getCreatedTime());
        try {
            history = (OperationHistory)query.getSingleResult();
        }
        catch (Exception e) {
            history = null;
        }
        if (history == null) {
            throw new RuntimeException("Cannot get history - it does not exist: " + historyJobId);
        }
        this.ensureViewPermission(subject, history);
        return history;
    }

    @Override
    public PageList<ResourceOperationHistory> findCompletedResourceOperationHistories(Subject subject, int resourceId, Long beginDate, Long endDate, PageControl pc) {
        pc.initDefaultOrderingField("h.createdTime", PageOrdering.DESC);
        String queryName = "ResourceOperationHistory.findByResourceIdAndNotStatus";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("resourceId", (Object)resourceId);
        query.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
        query.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
        queryCount.setParameter("beginTime", (Object)beginDate);
        query.setParameter("beginTime", (Object)beginDate);
        queryCount.setParameter("endTime", (Object)endDate);
        query.setParameter("endTime", (Object)endDate);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        if (list != null && list.size() > 0) {
            ResourceOperationHistory resourceHistory = (ResourceOperationHistory)list.get(0);
            this.ensureViewPermission(subject, (OperationHistory)resourceHistory);
        }
        PageList pageList = new PageList((Collection)list, (int)totalCount, pc);
        return pageList;
    }

    @Override
    public PageList<ResourceOperationHistory> findPendingResourceOperationHistories(Subject subject, int resourceId, PageControl pc) {
        pc.initDefaultOrderingField("h.createdTime", PageOrdering.ASC);
        String queryName = "ResourceOperationHistory.findByResourceIdAndStatus";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("resourceId", (Object)resourceId);
        query.setParameter("resourceId", (Object)resourceId);
        queryCount.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
        query.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        if (list != null && list.size() > 0) {
            ResourceOperationHistory resourceHistory = (ResourceOperationHistory)list.get(0);
            this.ensureViewPermission(subject, (OperationHistory)resourceHistory);
        }
        PageList pageList = new PageList((Collection)list, (int)totalCount, pc);
        return pageList;
    }

    @Override
    public PageList<GroupOperationHistory> findCompletedGroupOperationHistories(Subject subject, int groupId, PageControl pc) {
        pc.initDefaultOrderingField("h.createdTime", PageOrdering.DESC);
        String queryName = "GroupOperationHistory.findByGroupIdAndNotStatus";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("groupId", (Object)groupId);
        query.setParameter("groupId", (Object)groupId);
        queryCount.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
        query.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        if (list != null && list.size() > 0) {
            GroupOperationHistory groupHistory = (GroupOperationHistory)list.get(0);
            this.ensureViewPermission(subject, (OperationHistory)groupHistory);
        }
        PageList pageList = new PageList((Collection)list, (int)totalCount, pc);
        return pageList;
    }

    @Override
    public PageList<GroupOperationHistory> findPendingGroupOperationHistories(Subject subject, int groupId, PageControl pc) {
        pc.initDefaultOrderingField("h.createdTime", PageOrdering.ASC);
        String queryName = "GroupOperationHistory.findByGroupIdAndStatus";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        queryCount.setParameter("groupId", (Object)groupId);
        query.setParameter("groupId", (Object)groupId);
        queryCount.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
        query.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
        long totalCount = (Long)queryCount.getSingleResult();
        List list = query.getResultList();
        if (list != null && list.size() > 0) {
            GroupOperationHistory groupHistory = (GroupOperationHistory)list.get(0);
            this.ensureViewPermission(subject, (OperationHistory)groupHistory);
        }
        PageList pageList = new PageList((Collection)list, (int)totalCount, pc);
        return pageList;
    }

    @Override
    public OperationHistory updateOperationHistory(Subject subject, OperationHistory history) {
        GroupOperationHistory groupHistory;
        List roh;
        Configuration parameters;
        if (!this.authorizationManager.isOverlord(subject)) {
            this.ensureControlPermission(subject, history);
        }
        if (history.getId() != 0) {
            OperationHistory existingHistoryItem = (OperationHistory)this.entityManager.find(OperationHistory.class, (Object)history.getId());
            if (null == existingHistoryItem) {
                throw new IllegalArgumentException("Can not update operation history, history record not found. This call creates a new operation history record only if the supplied history argument has id set to 0. [" + history + "]");
            }
            existingHistoryItem.setStatus(history.getStatus());
            existingHistoryItem.setErrorMessage(history.getErrorMessage());
            if (existingHistoryItem.getStartedTime() == 0L) {
                existingHistoryItem.setStartedTime(history.getStartedTime());
            }
            if (history instanceof ResourceOperationHistory) {
                ((ResourceOperationHistory)existingHistoryItem).setResults(((ResourceOperationHistory)history).getResults());
            }
            history = existingHistoryItem;
        }
        if ((parameters = history.getParameters()) != null && parameters.getId() == 0) {
            this.entityManager.persist((Object)parameters);
            history.setParameters(parameters);
        }
        if (history instanceof GroupOperationHistory && (roh = (groupHistory = (GroupOperationHistory)history).getResourceOperationHistories()) != null && roh.size() > 0) {
            ArrayList<Object> attached = new ArrayList<Object>(roh.size());
            for (ResourceOperationHistory unattachedHistory : roh) {
                attached.add(this.entityManager.getReference(ResourceOperationHistory.class, (Object)unattachedHistory.getId()));
            }
            groupHistory.setResourceOperationHistories(attached);
        }
        if ((history = (OperationHistory)this.entityManager.merge((Object)history)).getParameters() != null) {
            history.getParameters().getId();
        }
        this.storageNodeOperationsHandler.handleOperationUpdateIfNecessary(history);
        this.notifyAlertConditionCacheManager("updateOperationHistory", history);
        return history;
    }

    @Override
    public void cancelOperationHistory(Subject subject, int historyId, boolean ignoreAgentErrors) {
        OperationHistory doomedHistory = this.getOperationHistoryByHistoryId(subject, historyId);
        this.ensureControlPermission(subject, doomedHistory);
        if (doomedHistory instanceof GroupOperationHistory) {
            this.cancelGroupOperation(subject, (GroupOperationHistory)doomedHistory, ignoreAgentErrors);
        } else {
            this.cancelResourceOperation(subject, (ResourceOperationHistory)doomedHistory, ignoreAgentErrors);
        }
    }

    private void cancelGroupOperation(Subject subject, GroupOperationHistory doomedHistory, boolean ignoreAgentErrors) {
        if (doomedHistory.getStatus() != OperationRequestStatus.INPROGRESS) {
            throw new IllegalStateException("The group job is no longer in-progress - cannot cancel it: " + doomedHistory);
        }
        boolean hadAgentError = false;
        List doomedResourceHistories = doomedHistory.getResourceOperationHistories();
        for (ResourceOperationHistory doomedResourceHistory : doomedResourceHistories) {
            try {
                CancelResults results = this.cancelResourceOperation(subject, doomedResourceHistory, ignoreAgentErrors);
                if (results != null) continue;
                hadAgentError = true;
            }
            catch (IllegalStateException ignore) {}
        }
        if (!hadAgentError || ignoreAgentErrors) {
            doomedHistory.setStatus(OperationRequestStatus.CANCELED);
            this.notifyAlertConditionCacheManager("cancelGroupOperation", (OperationHistory)doomedHistory);
        }
    }

    private CancelResults cancelResourceOperation(Subject subject, ResourceOperationHistory doomedHistory, boolean ignoreAgentErrors) throws IllegalStateException {
        if (doomedHistory.getStatus() != OperationRequestStatus.INPROGRESS) {
            throw new IllegalStateException("The job is no longer in-progress - cannot cancel it: " + doomedHistory);
        }
        String jobIdString = doomedHistory.getJobId().toString();
        int resourceId = doomedHistory.getResource().getId();
        CancelResults results = null;
        AgentClient agent = null;
        boolean canceled = false;
        try {
            agent = this.agentManager.getAgentClient(this.subjectManager.getOverlord(), resourceId);
            if (agent.pingService(5000L)) {
                results = agent.getOperationAgentService().cancelOperation(jobIdString);
                CancelResults.InterruptedState interruptedState = results.getInterruptedState();
                switch (interruptedState) {
                    case FINISHED: {
                        LOG.debug((Object)("Agent already finished the operation so it cannot be canceled. agent=[" + agent + "], op=[" + doomedHistory + "]"));
                        break;
                    }
                    case QUEUED: {
                        canceled = true;
                        LOG.debug((Object)("Cancel successful. Agent dequeued the operation and will not invoke it. agent=[" + agent + "], op=[" + doomedHistory + "]"));
                        break;
                    }
                    case RUNNING: {
                        canceled = true;
                        LOG.debug((Object)("Agent attempted to cancel the operation - it interrupted the operation while it was running. agent=[" + agent + "], op=[" + doomedHistory + "]"));
                        break;
                    }
                    case UNKNOWN: {
                        canceled = true;
                        LOG.debug((Object)("Agent does not know about the operation. Nothing to cancel. agent=[" + agent + "], op=[" + doomedHistory + "]"));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Please report this bug - bad state: " + interruptedState);
                    }
                }
            } else {
                LOG.warn((Object)("Agent down? Cannot cancel operation. agent=[" + agent + "], op=[" + doomedHistory + "]"));
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Cannot tell the agent to cancel operation. agent=[" + agent + "], op=[" + doomedHistory + "]"), t);
        }
        if (canceled || results == null && ignoreAgentErrors) {
            doomedHistory.setStatus(OperationRequestStatus.CANCELED);
            this.notifyAlertConditionCacheManager("cancelResourceOperation", (OperationHistory)doomedHistory);
        }
        return results;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void deleteOperationHistories(Subject subject, int[] historyIds, boolean deleteEvenIfInProgress) {
        ArrayList<String> errors = null;
        for (int id : historyIds) {
            try {
                this.operationManager.deleteOperationHistory(subject, id, deleteEvenIfInProgress);
            }
            catch (Exception e) {
                if (null == errors) {
                    errors = new ArrayList<String>();
                }
                errors.add("Could not delete operation history [" + id + "]: " + e.getMessage());
            }
        }
        if (null != errors) {
            throw new ApplicationException("Failed to delete [" + errors.size() + "] of [" + historyIds.length + "] operation history records:" + errors);
        }
    }

    @Override
    public void deleteOperationHistory(Subject subject, int historyId, boolean purgeInProgress) {
        OperationHistory doomedHistory = this.getOperationHistoryByHistoryId(subject, historyId);
        this.ensureControlPermission(subject, doomedHistory);
        if (doomedHistory.getStatus() == OperationRequestStatus.INPROGRESS && !purgeInProgress) {
            throw new IllegalStateException("The job is still in the in-progress state. Please wait for it to complete: " + doomedHistory.getId());
        }
        if (doomedHistory instanceof GroupOperationHistory) {
            List resourceHistories = ((GroupOperationHistory)doomedHistory).getResourceOperationHistories();
            for (ResourceOperationHistory child : resourceHistories) {
                this.deleteOperationHistory_helper(child.getId());
            }
        }
        this.deleteOperationHistory_helper(doomedHistory.getId());
    }

    private void deleteOperationHistory_helper(int historyId) {
        Query historyArgumentsQuery = this.entityManager.createNamedQuery("OperationHistory.getParameterConfigurationIds");
        Query historyResultsQuery = this.entityManager.createNamedQuery("ResourceOperationHistory.getResultConfigurationIds");
        historyArgumentsQuery.setParameter("historyId", (Object)historyId);
        historyResultsQuery.setParameter("historyId", (Object)historyId);
        List historyArgumentConfigurationIds = historyArgumentsQuery.getResultList();
        List historyResultConfigurationIds = historyResultsQuery.getResultList();
        Query operationHistoryDeleteQuery = this.entityManager.createNamedQuery("OperationHistory.deleteByHistoryIds");
        operationHistoryDeleteQuery.setParameter("historyId", (Object)historyId);
        operationHistoryDeleteQuery.executeUpdate();
        ArrayList<Integer> allConfigurationIdsToDelete = new ArrayList<Integer>(historyArgumentConfigurationIds.size() + historyResultConfigurationIds.size());
        allConfigurationIdsToDelete.addAll(historyArgumentConfigurationIds);
        allConfigurationIdsToDelete.addAll(historyResultConfigurationIds);
        this.configurationManager.deleteConfigurations(allConfigurationIdsToDelete);
    }

    @Override
    public List<OperationDefinition> findSupportedResourceOperations(Subject subject, int resourceId, boolean eagerLoaded) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view resource [" + resourceId + "]");
        }
        try {
            String queryName = eagerLoaded ? "OperationDefinition.findByResourceAndName" : "OperationDefinition.findLightWeightByResourceAndName";
            Query query = this.entityManager.createNamedQuery(queryName);
            query.setParameter("resourceId", (Object)resourceId);
            query.setParameter("operationName", null);
            List results = query.getResultList();
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get support operations for resource [" + resourceId + "]: " + e, e);
        }
    }

    @Override
    public List<OperationDefinition> findSupportedResourceTypeOperations(Subject subject, int resourceTypeId, boolean eagerLoaded) {
        try {
            String queryName = eagerLoaded ? "OperationDefinition.findByTypeAndName" : "OperationDefinition.findLightWeightByTypeAndName";
            Query query = this.entityManager.createNamedQuery(queryName);
            query.setParameter("resourceTypeId", (Object)resourceTypeId);
            query.setParameter("operationName", null);
            List results = query.getResultList();
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get support operations for resourceType [" + resourceTypeId + "]: " + e, e);
        }
    }

    @Override
    public List<OperationDefinition> findSupportedGroupOperations(Subject subject, int compatibleGroupId, boolean eagerLoaded) {
        if (!this.authorizationManager.canViewGroup(subject, compatibleGroupId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view group [" + compatibleGroupId + "]");
        }
        try {
            String queryName = eagerLoaded ? "OperationDefinition.findByGroupAndName" : "OperationDefinition.findLightWeightByGroupAndName";
            Query query = this.entityManager.createNamedQuery(queryName);
            query.setParameter("groupId", (Object)compatibleGroupId);
            query.setParameter("operationName", null);
            List results = query.getResultList();
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get support operations for group [" + compatibleGroupId + "]: " + e, e);
        }
    }

    @Override
    public OperationDefinition getSupportedResourceOperation(Subject subject, int resourceId, String operationName, boolean eagerLoaded) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view resource [" + resourceId + "]");
        }
        String queryName = eagerLoaded ? "OperationDefinition.findByResourceAndName" : "OperationDefinition.findLightWeightByResourceAndName";
        Query query = this.entityManager.createNamedQuery(queryName);
        query.setParameter("resourceId", (Object)resourceId);
        query.setParameter("operationName", (Object)operationName);
        List results = query.getResultList();
        if (results.size() != 1) {
            throw new RuntimeException("Found " + results.size() + " operations called [" + operationName + "] for resource [" + resourceId + "]: ");
        }
        return (OperationDefinition)results.get(0);
    }

    @Override
    public OperationDefinition getSupportedGroupOperation(Subject subject, int compatibleGroupId, String operationName, boolean eagerLoaded) {
        if (!this.authorizationManager.canViewGroup(subject, compatibleGroupId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view group [" + compatibleGroupId + "]");
        }
        String queryName = eagerLoaded ? "OperationDefinition.findByGroupAndName" : "OperationDefinition.findLightWeightByGroupAndName";
        Query query = this.entityManager.createNamedQuery(queryName);
        query.setParameter("groupId", (Object)compatibleGroupId);
        query.setParameter("operationName", (Object)operationName);
        List results = query.getResultList();
        if (results.size() != 1) {
            throw new RuntimeException("Found " + results.size() + " operations called [" + operationName + "] for group [" + compatibleGroupId + "]: ");
        }
        return (OperationDefinition)results.get(0);
    }

    @Override
    public boolean isResourceOperationSupported(Subject subject, int resourceId) {
        Resource resource;
        try {
            resource = this.getResourceIfAuthorized(subject, resourceId);
        }
        catch (PermissionException e) {
            LOG.debug((Object)("isOperationSupported: User cannot control resource: " + resourceId));
            return false;
        }
        catch (Exception e) {
            LOG.debug((Object)("isOperationSupported: Resource does not exist: " + resourceId));
            return false;
        }
        Set defs = resource.getResourceType().getOperationDefinitions();
        return defs != null && defs.size() > 0;
    }

    @Override
    public boolean isGroupOperationSupported(Subject subject, int resourceGroupId) {
        ResourceGroup group;
        try {
            group = this.resourceGroupManager.getResourceGroupById(subject, resourceGroupId, null);
            if (group.getGroupCategory() == GroupCategory.MIXED) {
                return false;
            }
        }
        catch (ResourceGroupNotFoundException e) {
            LOG.debug((Object)("isGroupOperationSupported: group does not exist: " + resourceGroupId));
            return false;
        }
        catch (PermissionException pe) {
            LOG.debug((Object)("isGroupOperationSupported: User cannot view (and thus) control group: " + resourceGroupId));
            return false;
        }
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.CONTROL, group.getId())) {
            LOG.debug((Object)("isGroupOperationSupported: User cannot control group: " + group));
            return false;
        }
        Set defs = group.getResourceType().getOperationDefinitions();
        return defs != null && defs.size() > 0;
    }

    @Override
    public void checkForTimedOutOperations(Subject subject) {
        List groupHistories;
        long timeout;
        Query query;
        LOG.debug((Object)"Begin scanning for timed out operation histories");
        if (!this.authorizationManager.isOverlord(subject)) {
            LOG.debug((Object)("Unauthorized user " + subject + " tried to execute checkForTimedOutOperations: " + "only the overlord may execute this system operation"));
            return;
        }
        try {
            query = this.entityManager.createNamedQuery("ResourceOperationHistory.findAllInStatus");
            query.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
            List histories = query.getResultList();
            for (ResourceOperationHistory history : histories) {
                boolean neverStarted;
                timeout = this.getOperationTimeout(history.getOperationDefinition(), history.getParameters());
                long duration = history.getDuration();
                long createdTime = history.getCreatedTime();
                boolean timedOut = duration > timeout;
                boolean bl = neverStarted = System.currentTimeMillis() - createdTime > 86400000L;
                if (!timedOut && !neverStarted) continue;
                if (timedOut) {
                    LOG.info((Object)("Operation execution seems to have been orphaned - timing it out: " + history));
                    history.setErrorMessage("Timed out : did not complete after " + duration + " ms" + " (the timeout period was " + timeout + " ms)");
                } else {
                    LOG.info((Object)("Operation execution seems to have never started - timing it out: " + history));
                    history.setErrorMessage("Failed to start : operation never started");
                }
                history.setStatus(OperationRequestStatus.FAILURE);
                this.notifyAlertConditionCacheManager("checkForTimedOutOperations", (OperationHistory)history);
                this.checkForCompletedGroupOperation(history.getId());
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to check for timed out resource operations. Cause: " + t));
        }
        try {
            query = this.entityManager.createNamedQuery("GroupOperationHistory.findActiveInProgress");
            query.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
            groupHistories = query.getResultList();
            for (GroupOperationHistory groupHistory : groupHistories) {
                timeout = this.getOperationTimeout(groupHistory.getOperationDefinition(), groupHistory.getParameters());
                if (groupHistory.getDuration() < timeout) continue;
                for (ResourceOperationHistory resourceHistory : groupHistory.getResourceOperationHistories()) {
                    if (resourceHistory.getStatus() != OperationRequestStatus.INPROGRESS) continue;
                    this.cancelOperationHistory(subject, resourceHistory.getId(), true);
                }
                groupHistory.setErrorMessage("This group operation timed out before all child resource operations could complete normally, those still in progress will attempt to be canceled.");
                groupHistory.setStatus(OperationRequestStatus.FAILURE);
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to check for completed group operations. Cause: " + t));
        }
        try {
            query = this.entityManager.createNamedQuery("GroupOperationHistory.findAbandonedInProgress");
            query.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
            groupHistories = query.getResultList();
            for (GroupOperationHistory groupHistory : groupHistories) {
                OperationRequestStatus groupStatus = OperationRequestStatus.SUCCESS;
                for (ResourceOperationHistory resourceHistory : groupHistory.getResourceOperationHistories()) {
                    if (resourceHistory.getStatus() == OperationRequestStatus.SUCCESS) continue;
                    groupStatus = OperationRequestStatus.FAILURE;
                    break;
                }
                if (groupStatus != OperationRequestStatus.SUCCESS) {
                    groupHistory.setErrorMessage("One or more resource operations timed out and/or did not complete");
                }
                groupHistory.setStatus(groupStatus);
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to check for completed group operations. Cause: " + t));
        }
        try {
            query = this.entityManager.createNamedQuery("GroupOperationHistory.findMemberlessInProgress");
            query.setParameter("status", (Object)OperationRequestStatus.INPROGRESS);
            groupHistories = query.getResultList();
            for (GroupOperationHistory groupHistory : groupHistories) {
                groupHistory.setStatus(OperationRequestStatus.SUCCESS);
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)("Failed to check for memberless group operations. Cause: " + t));
        }
        LOG.debug((Object)"Finished scanning for timed out operation histories");
    }

    @Override
    public PageList<ResourceOperationLastCompletedComposite> findRecentlyCompletedResourceOperations(Subject subject, Integer resourceId, PageControl pageControl) {
        Query count;
        Query query;
        pageControl.initDefaultOrderingField("ro.createdTime", PageOrdering.ASC);
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"OperationHistory.getRecentlyCompletedResource_admin", (PageControl)pageControl);
            count = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"OperationHistory.getRecentlyCompletedResource_admin");
        } else {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"OperationHistory.getRecentlyCompletedResource", (PageControl)pageControl);
            count = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"OperationHistory.getRecentlyCompletedResource");
            query.setParameter("subject", (Object)subject);
            count.setParameter("subject", (Object)subject);
        }
        query.setParameter("resourceId", (Object)resourceId);
        count.setParameter("resourceId", (Object)resourceId);
        int totalCount = ((Number)count.getSingleResult()).intValue();
        List results = query.getResultList();
        return new PageList((Collection)results, totalCount, pageControl);
    }

    @Override
    public PageList<GroupOperationLastCompletedComposite> findRecentlyCompletedGroupOperations(Subject subject, PageControl pageControl) {
        Query count;
        Query query;
        pageControl.initDefaultOrderingField("go.createdTime", PageOrdering.ASC);
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"OperationHistory.getRecentlyCompletedGroup_admin", (PageControl)pageControl);
            count = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"OperationHistory.getRecentlyCompletedGroup_admin");
        } else {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"OperationHistory.getRecentlyCompletedGroup", (PageControl)pageControl);
            count = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"OperationHistory.getRecentlyCompletedGroup");
            query.setParameter("subject", (Object)subject);
            count.setParameter("subject", (Object)subject);
        }
        int totalCount = ((Number)count.getSingleResult()).intValue();
        List results = query.getResultList();
        return new PageList((Collection)results, totalCount, pageControl);
    }

    @Override
    public PageList<ResourceOperationScheduleComposite> findCurrentlyScheduledResourceOperations(Subject subject, PageControl pageControl) {
        Query count;
        Query query;
        pageControl.initDefaultOrderingField("ro.nextFireTime", PageOrdering.DESC);
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"OperationScheduleEntity.getScheduleResource_admin", (PageControl)pageControl);
            count = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"OperationScheduleEntity.getScheduleResource_admin");
        } else {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"OperationScheduleEntity.getScheduleResource", (PageControl)pageControl);
            count = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"OperationScheduleEntity.getScheduleResource");
            query.setParameter("subject", (Object)subject);
            count.setParameter("subject", (Object)subject);
        }
        int totalCount = ((Number)count.getSingleResult()).intValue();
        List results = query.getResultList();
        Subject overlord = this.subjectManager.getOverlord();
        for (ResourceOperationScheduleComposite composite : results) {
            try {
                ResourceOperationSchedule sched = this.getResourceOperationSchedule(subject, composite.getJobId().toString());
                OperationDefinition def = this.getSupportedResourceOperation(overlord, composite.getResourceId(), sched.getOperationName(), false);
                composite.setOperationName(def.getDisplayName() != null ? def.getDisplayName() : sched.getOperationName());
            }
            catch (SchedulerException se) {
                LOG.error((Object)("A schedule entity is out of sync with the scheduler - there is no job scheduled: " + composite), (Throwable)se);
            }
            catch (Exception e) {
                LOG.error((Object)("A scheduled operation has an invalid name - did a plugin change its operation metadata? : " + composite), (Throwable)e);
            }
        }
        return new PageList((Collection)results, totalCount, pageControl);
    }

    @Override
    public PageList<GroupOperationScheduleComposite> findCurrentlyScheduledGroupOperations(Subject subject, PageControl pageControl) {
        Query count;
        Query query;
        pageControl.initDefaultOrderingField("go.nextFireTime", PageOrdering.DESC);
        if (this.authorizationManager.isInventoryManager(subject)) {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"OperationScheduleEntity.getScheduleGroup_admin", (PageControl)pageControl);
            count = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"OperationScheduleEntity.getScheduleGroup_admin");
        } else {
            query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"OperationScheduleEntity.getScheduleGroup", (PageControl)pageControl);
            count = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"OperationScheduleEntity.getScheduleGroup");
            query.setParameter("subject", (Object)subject);
            count.setParameter("subject", (Object)subject);
        }
        int totalCount = ((Number)count.getSingleResult()).intValue();
        List results = query.getResultList();
        Subject overlord = this.subjectManager.getOverlord();
        for (GroupOperationScheduleComposite composite : results) {
            try {
                GroupOperationSchedule sched = this.getGroupOperationSchedule(subject, composite.getJobId().toString());
                OperationDefinition def = this.getSupportedGroupOperation(overlord, composite.getGroupId(), sched.getOperationName(), false);
                composite.setOperationName(def.getDisplayName() != null ? def.getDisplayName() : sched.getOperationName());
            }
            catch (SchedulerException se) {
                LOG.error((Object)("A schedule entity is out of sync with the scheduler - there is no job scheduled: " + composite), (Throwable)se);
            }
            catch (Exception e) {
                LOG.error((Object)("A scheduled operation has an invalid name - did a plugin change its operation metadata? : " + composite), (Throwable)e);
            }
        }
        return new PageList((Collection)results, totalCount, pageControl);
    }

    @Override
    public void checkForCompletedGroupOperation(int historyId) {
        OperationHistory history = (OperationHistory)this.entityManager.find(OperationHistory.class, (Object)historyId);
        if (!(history instanceof ResourceOperationHistory)) {
            return;
        }
        if (history.getStatus() == OperationRequestStatus.INPROGRESS) {
            return;
        }
        GroupOperationHistory groupHistory = ((ResourceOperationHistory)history).getGroupOperationHistory();
        if (groupHistory != null) {
            List allResourceHistories = groupHistory.getResourceOperationHistories();
            boolean stillInProgress = false;
            OperationRequestStatus groupStatus = OperationRequestStatus.SUCCESS;
            StringBuilder groupErrorMessage = null;
            for (ResourceOperationHistory resourceHistory : allResourceHistories) {
                if (resourceHistory.getStatus() == OperationRequestStatus.INPROGRESS) {
                    stillInProgress = true;
                    break;
                }
                if (resourceHistory.getStatus() != OperationRequestStatus.FAILURE && resourceHistory.getStatus() != OperationRequestStatus.CANCELED) continue;
                groupStatus = OperationRequestStatus.FAILURE;
                if (groupErrorMessage == null) {
                    groupErrorMessage = new StringBuilder("The following resources failed to invoke the operation: ");
                } else {
                    groupErrorMessage.append(',');
                }
                groupErrorMessage.append(resourceHistory.getResource().getName());
            }
            if (!stillInProgress) {
                groupHistory.setErrorMessage(groupErrorMessage == null ? null : groupErrorMessage.toString());
                groupHistory.setStatus(groupStatus);
                this.notifyAlertConditionCacheManager("checkForCompletedGroupOperation", (OperationHistory)groupHistory);
            }
        }
    }

    private long getOperationTimeout(OperationDefinition operationDefinition, Configuration parameters) {
        PropertySimple timeoutProperty;
        Integer timeout = null;
        if (parameters != null && (timeoutProperty = parameters.getSimple("rhq.timeout")) != null) {
            timeout = timeoutProperty.getIntegerValue();
        }
        if (timeout == null && (timeout = operationDefinition.getTimeout()) == null) {
            timeout = this.scheduler.getDefaultOperationTimeout();
        }
        if (timeout == null) {
            timeout = 3600;
        }
        return (long)timeout.intValue() * 1000L;
    }

    private Resource getResourceIfAuthorized(Subject subject, int resourceId) {
        Resource resource;
        try {
            resource = this.resourceManager.getResourceById(subject, resourceId);
        }
        catch (ResourceNotFoundException e) {
            throw new RuntimeException("Cannot get support operations for unknown resource [" + resourceId + "]: " + e, e);
        }
        return resource;
    }

    private ResourceGroup getCompatibleGroupIfAuthorized(Subject subject, int compatibleGroupId) {
        ResourceGroup group;
        try {
            group = this.resourceGroupManager.getResourceGroupById(subject, compatibleGroupId, GroupCategory.COMPATIBLE);
        }
        catch (ResourceGroupNotFoundException e) {
            throw new RuntimeException("Cannot get support operations for unknown group [" + compatibleGroupId + "]: " + e, e);
        }
        return group;
    }

    private void ensureControlPermission(Subject subject, OperationHistory history) throws PermissionException {
        if (history instanceof GroupOperationHistory) {
            ResourceGroup group = ((GroupOperationHistory)history).getGroup();
            this.ensureControlPermission(subject, group);
        } else {
            Resource resource = ((ResourceOperationHistory)history).getResource();
            this.ensureControlPermission(subject, resource);
        }
    }

    private void ensureControlPermission(Subject subject, ResourceGroup group) throws PermissionException {
        if (!this.authorizationManager.hasGroupPermission(subject, Permission.CONTROL, group.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to control group [" + group + "]");
        }
    }

    private void ensureControlPermission(Subject subject, Resource resource) throws PermissionException {
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.CONTROL, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to control resource [" + resource + "]");
        }
    }

    private void ensureViewPermission(Subject subject, OperationHistory history) throws PermissionException {
        if (history instanceof GroupOperationHistory) {
            ResourceGroup group = ((GroupOperationHistory)history).getGroup();
            if (!this.authorizationManager.canViewGroup(subject, group.getId())) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view operation history for group [" + group + "]");
            }
        } else {
            Resource resource = ((ResourceOperationHistory)history).getResource();
            if (!this.authorizationManager.canViewResource(subject, resource.getId())) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view operation history for resource [" + resource + "]");
            }
        }
    }

    private String createUniqueJobName(Resource resource, String operationName) {
        return ResourceOperationJob.createUniqueJobName(resource, operationName);
    }

    private String createUniqueJobName(ResourceGroup group, String operationName) {
        return GroupOperationJob.createUniqueJobName(group, operationName);
    }

    private String createJobGroupName(Resource resource) {
        return ResourceOperationJob.createJobGroupName(resource);
    }

    private String createJobGroupName(ResourceGroup group) {
        return GroupOperationJob.createJobGroupName(group);
    }

    @Override
    @Nullable
    public ResourceOperationHistory getLatestCompletedResourceOperation(Subject subject, int resourceId) {
        ResourceOperationHistory result;
        LOG.debug((Object)("Getting latest completed operation for resource [" + resourceId + "]"));
        try {
            Query query = this.entityManager.createNamedQuery("ResourceOperationHistory.findLatestCompletedOperation");
            query.setParameter("resourceId", (Object)resourceId);
            result = (ResourceOperationHistory)query.getSingleResult();
        }
        catch (NoResultException nre) {
            result = null;
        }
        return result;
    }

    @Override
    @Nullable
    public ResourceOperationHistory getOldestInProgressResourceOperation(Subject subject, int resourceId) {
        ResourceOperationHistory result;
        LOG.debug((Object)("Getting oldest in-progress operation for resource [" + resourceId + "]"));
        try {
            Query query = this.entityManager.createNamedQuery("ResourceOperationHistory.findOldestInProgressOperation");
            query.setParameter("resourceId", (Object)resourceId);
            result = (ResourceOperationHistory)query.getSingleResult();
        }
        catch (NoResultException nre) {
            result = null;
        }
        return result;
    }

    @Override
    public OperationDefinition getOperationDefinition(Subject subject, int operationId) {
        OperationDefinition operationDefinition = (OperationDefinition)this.entityManager.find(OperationDefinition.class, (Object)operationId);
        if (operationDefinition == null) {
            throw new OperationDefinitionNotFoundException("Cannot get operation definition - it does not exist: " + operationId);
        }
        return operationDefinition;
    }

    @Override
    public OperationDefinition getOperationDefinitionByResourceTypeAndName(int resourceTypeId, String operationName, boolean eagerLoaded) throws OperationDefinitionNotFoundException {
        String queryName = eagerLoaded ? "OperationDefinition.findByTypeAndName" : "OperationDefinition.findLightWeightByTypeAndName";
        Query query = this.entityManager.createNamedQuery(queryName);
        query.setParameter("resourceTypeId", (Object)resourceTypeId);
        query.setParameter("operationName", (Object)operationName);
        List results = query.getResultList();
        if (results.size() != 1) {
            throw new OperationDefinitionNotFoundException("There were " + results.size() + " operations called " + operationName + " for resourceType[id=" + resourceTypeId + "]");
        }
        return (OperationDefinition)results.get(0);
    }

    private void notifyAlertConditionCacheManager(String callingMethod, OperationHistory operationHistory) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(operationHistory);
        LOG.debug((Object)(callingMethod + ": " + stats.toString()));
    }

    private OperationScheduleEntity findOperationScheduleEntity(ScheduleJobId jobId) {
        Query query = this.entityManager.createNamedQuery("OperationScheduleEntity.findByJobId");
        String jobName = jobId.getJobName();
        query.setParameter("jobName", (Object)jobName);
        String jobGroup = jobId.getJobGroup();
        query.setParameter("jobGroup", (Object)jobGroup);
        OperationScheduleEntity operationScheduleEntity = (OperationScheduleEntity)query.getSingleResult();
        return operationScheduleEntity;
    }

    @Override
    public GroupOperationSchedule scheduleGroupOperation(Subject subject, int groupId, int[] executionOrderResourceIds, boolean haltOnFailure, String operationName, Configuration parameters, long delay, long repeatInterval, int repeatCount, int timeout, String description) throws ScheduleException {
        try {
            SimpleTrigger trigger = new SimpleTrigger();
            if (delay < 0L) {
                delay = 0L;
            }
            trigger.setRepeatCount(repeatCount < 0 ? -1 : repeatCount);
            trigger.setRepeatInterval(repeatInterval < 0L ? 0L : repeatInterval);
            trigger.setStartTime(new Date(System.currentTimeMillis() + delay));
            if ((long)timeout > 0L) {
                if (null == parameters) {
                    parameters = new Configuration();
                }
                parameters.put((Property)new PropertySimple("rhq.timeout", (Object)timeout));
            }
            return this.scheduleGroupOperation(subject, groupId, executionOrderResourceIds, haltOnFailure, operationName, parameters, (Trigger)trigger, description);
        }
        catch (Exception e) {
            throw new ScheduleException(e);
        }
    }

    @Override
    public GroupOperationSchedule scheduleGroupOperationUsingCron(Subject subject, int groupId, int[] executionOrderResourceIds, boolean haltOnFailure, String operationName, Configuration parameters, String cronExpression, int timeout, String description) throws ScheduleException {
        if ((long)timeout > 0L) {
            if (parameters == null) {
                parameters = new Configuration();
            }
            parameters.put((Property)new PropertySimple("rhq.timeout", (Object)timeout));
        }
        CronTrigger cronTrigger = new CronTrigger();
        try {
            cronTrigger.setCronExpression(cronExpression);
            return this.scheduleGroupOperation(subject, groupId, executionOrderResourceIds, haltOnFailure, operationName, parameters, (Trigger)cronTrigger, description);
        }
        catch (Exception e) {
            throw new ScheduleException(e);
        }
    }

    public PageList<OperationDefinition> findOperationDefinitionsByCriteria(Subject subject, OperationDefinitionCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<ResourceOperationHistory> findResourceOperationHistoriesByCriteria(Subject subject, ResourceOperationHistoryCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Override
    public PageList<GroupOperationHistory> findGroupOperationHistoriesByCriteria(Subject subject, GroupOperationHistoryCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.GROUP, subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    @Nullable
    private Trigger getTriggerOfJob(JobDetail jobDetail) {
        Trigger[] triggers;
        try {
            triggers = this.scheduler.getTriggersOfJob(jobDetail.getName(), jobDetail.getGroup());
        }
        catch (SchedulerException e) {
            throw new RuntimeException("Failed to lookup trigger for job [" + jobDetail.getFullName() + "].", e);
        }
        if (triggers.length > 1) {
            throw new IllegalStateException("Job [" + jobDetail.getFullName() + "] has more than one trigger: " + Arrays.asList(triggers));
        }
        if (triggers.length == 0) {
            return null;
        }
        return triggers[0];
    }

    private JobTrigger convertToJobTrigger(Trigger trigger) {
        JobTrigger schedule;
        if (trigger instanceof SimpleTrigger) {
            SimpleTrigger simpleTrigger = (SimpleTrigger)trigger;
            Date startTime = simpleTrigger.getStartTime();
            if (startTime != null) {
                int repeatCount = simpleTrigger.getRepeatCount();
                if (repeatCount == 0) {
                    schedule = JobTrigger.createLaterTrigger((Date)startTime);
                } else {
                    Date endTime;
                    long repeatInterval = simpleTrigger.getRepeatInterval();
                    schedule = repeatCount == -1 ? ((endTime = simpleTrigger.getEndTime()) != null ? JobTrigger.createLaterAndRepeatTrigger((Date)startTime, (long)repeatInterval, (Date)endTime) : JobTrigger.createLaterAndRepeatTrigger((Date)startTime, (long)repeatInterval)) : JobTrigger.createLaterAndRepeatTrigger((Date)startTime, (long)repeatInterval, (int)repeatCount);
                }
            } else {
                int repeatCount = simpleTrigger.getRepeatCount();
                if (repeatCount == 0) {
                    schedule = JobTrigger.createNowTrigger();
                } else {
                    Date endTime;
                    long repeatInterval = simpleTrigger.getRepeatInterval();
                    schedule = repeatCount == -1 ? ((endTime = simpleTrigger.getEndTime()) != null ? JobTrigger.createNowAndRepeatTrigger((long)repeatInterval, (Date)endTime) : JobTrigger.createNowAndRepeatTrigger((long)repeatInterval)) : JobTrigger.createNowAndRepeatTrigger((long)repeatInterval, (int)repeatCount);
                }
            }
        } else if (trigger instanceof CronTrigger) {
            CronTrigger cronTrigger = (CronTrigger)trigger;
            schedule = JobTrigger.createCronTrigger((String)cronTrigger.getCronExpression());
        } else {
            throw new IllegalStateException("Unsupported Quartz trigger type: " + trigger.getClass().getName());
        }
        return schedule;
    }

    private Trigger convertToTrigger(JobTrigger jobTrigger) {
        CronTrigger trigger;
        if (jobTrigger.getRecurrenceType() == JobTrigger.RecurrenceType.CRON_EXPRESSION) {
            CronTrigger cronTrigger = new CronTrigger();
            try {
                cronTrigger.setCronExpression(jobTrigger.getCronExpression());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            trigger = cronTrigger;
        } else {
            SimpleTrigger simpleTrigger = new SimpleTrigger();
            Date startTime = null;
            switch (jobTrigger.getStartType()) {
                case NOW: {
                    startTime = new Date();
                    break;
                }
                case DATETIME: {
                    startTime = jobTrigger.getStartDate();
                }
            }
            simpleTrigger.setStartTime(startTime);
            if (jobTrigger.getRecurrenceType() == JobTrigger.RecurrenceType.REPEAT_INTERVAL) {
                simpleTrigger.setRepeatInterval(jobTrigger.getRepeatInterval().longValue());
                if (jobTrigger.getEndType() == JobTrigger.EndType.REPEAT_COUNT) {
                    simpleTrigger.setRepeatCount(jobTrigger.getRepeatCount().intValue());
                } else {
                    simpleTrigger.setRepeatCount(-1);
                    if (jobTrigger.getEndType() == JobTrigger.EndType.DATETIME) {
                        simpleTrigger.setEndTime(jobTrigger.getEndDate());
                    }
                }
            }
            trigger = simpleTrigger;
        }
        return trigger;
    }

    private OperationDefinition validateOperationNameAndParameters(ResourceType resourceType, String operationName, Configuration parameters) {
        Set operationDefinitions = resourceType.getOperationDefinitions();
        OperationDefinition matchingOperationDefinition = null;
        for (OperationDefinition operationDefinition : operationDefinitions) {
            if (!operationDefinition.getName().equals(operationName)) continue;
            matchingOperationDefinition = operationDefinition;
            break;
        }
        if (matchingOperationDefinition == null) {
            throw new IllegalArgumentException("[" + operationName + "] is not a valid operation name for Resources of type [" + resourceType.getName() + "].");
        }
        ConfigurationDefinition parametersDefinition = matchingOperationDefinition.getParametersConfigurationDefinition();
        List errors = ConfigurationUtility.validateConfiguration((Configuration)parameters, (ConfigurationDefinition)parametersDefinition);
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException("Parameters for [" + operationName + "] on Resource of type [" + resourceType.getName() + "] are not valid: " + errors);
        }
        return matchingOperationDefinition;
    }
}

