/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeNotFoundException;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.ResourceTypeRest;

@Produces(value={"application/json", "application/xml"})
@Path(value="/resource/type")
@Api(value="Resource type related", description="This endpoint deals with resource types")
@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class ResourceTypeHandlerBean
extends AbstractRestBean {
    @EJB
    ResourceTypeManagerLocal typeManager;

    @Cache(maxAge=600)
    @GET
    @Path(value="{id}")
    @ApiOperation(value="Return information about the resource type with the passed id", responseClass="ResourceTypeRest")
    @ApiError(code=404, reason="There is no type with the passed id")
    public Response getTypeById(@PathParam(value="id") int resourceTypeId, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceType type;
        try {
            type = this.typeManager.getResourceTypeById(this.caller, resourceTypeId);
        }
        catch (ResourceTypeNotFoundException e) {
            throw new StuffNotFoundException("Resource type with id " + resourceTypeId);
        }
        ResourceTypeRest rtr = this.resourceTypeToResourceTypeRest(type);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.ok();
        builder.type(mediaType);
        builder.entity((Object)rtr);
        return builder.build();
    }

    @GET
    @GZIP
    @Path(value="/")
    @ApiOperation(value="Search for resource types", responseClass="ResourceTypeRest", multiValueResponse=true)
    public Response getTypes(@ApiParam(value="Limit results to param in the resource type name") @QueryParam(value="q") String name, @ApiParam(value="Limit results to the plugin with the passed name") @QueryParam(value="plugin") String pluginName, @ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page for paging, 0-based") @QueryParam(value="page") Integer page, @Context UriInfo uriInfo, @Context HttpHeaders headers) {
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        if (name != null) {
            criteria.addFilterName(name);
        }
        if (pluginName != null) {
            criteria.addFilterPluginName(pluginName);
        }
        if (page != null) {
            criteria.setPaging(page.intValue(), pageSize);
        }
        PageList<ResourceType> pageList = this.typeManager.findResourceTypesByCriteria(this.caller, criteria);
        ArrayList<ResourceTypeRest> rtrList = new ArrayList<ResourceTypeRest>(pageList.size());
        for (ResourceType type : pageList) {
            ResourceTypeRest rtr = this.resourceTypeToResourceTypeRest(type);
            rtrList.add(rtr);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.ok();
        builder.type(mediaType);
        if (mediaType.equals((Object)this.wrappedCollectionJsonType)) {
            this.wrapForPaging(builder, uriInfo, pageList, rtrList);
        } else {
            GenericEntity<List<ResourceTypeRest>> list = new GenericEntity<List<ResourceTypeRest>>(rtrList){};
            builder.entity((Object)list);
            this.createPagingHeader(builder, uriInfo, pageList);
        }
        return builder.build();
    }

    private ResourceTypeRest resourceTypeToResourceTypeRest(ResourceType type) {
        ResourceTypeRest rtr = new ResourceTypeRest();
        rtr.setId(type.getId());
        rtr.setName(type.getName());
        rtr.setPluginName(type.getPlugin());
        rtr.setCreatePolicy(type.getCreateDeletePolicy());
        rtr.setDataType(type.getCreationDataType());
        return rtr;
    }
}

