/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest.helper;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.rhq.enterprise.server.rest.domain.Link;

public class LinkDeserializer
extends JsonDeserializer<Link> {
    Pattern textPattern = Pattern.compile("\\S+");

    public Link deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String tmp = jp.getText();
        this.validate(jp, tmp, "{");
        jp.nextToken();
        String rel = jp.getText();
        this.validateText(jp, rel);
        jp.nextToken();
        tmp = jp.getText();
        this.validate(jp, tmp, "{");
        jp.nextToken();
        tmp = jp.getText();
        this.validate(jp, tmp, "href");
        jp.nextToken();
        String href = jp.getText();
        this.validateText(jp, href);
        jp.nextToken();
        tmp = jp.getText();
        this.validate(jp, tmp, "}");
        jp.nextToken();
        tmp = jp.getText();
        this.validate(jp, tmp, "}");
        Link link = new Link(rel, href);
        return link;
    }

    private void validateText(JsonParser jsonParser, String input) throws JsonProcessingException {
        Matcher m = this.textPattern.matcher(input);
        if (!m.matches()) {
            throw new JsonParseException("Unexpected token: " + input, jsonParser.getTokenLocation());
        }
    }

    private void validate(JsonParser jsonParser, String input, String expected) throws JsonProcessingException {
        if (!input.equals(expected)) {
            throw new JsonParseException("Unexpected token: " + input, jsonParser.getTokenLocation());
        }
    }
}

