/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public final class SynchronizationConstants {
    public static final String CONFIGURATION_NAMESPACE = "urn:xmlns:rhq-configuration";
    public static final String CONFIGURATION_NAMESPACE_PREFIX = "c";
    public static final String CONFIGURATION_INSTANCE_NAMESPACE = "urn:xmlns:rhq-configuration-instance";
    public static final String CONFIGURATION_INSTANCE_NAMESPACE_PREFIX = "ci";
    public static final String EXPORT_NAMESPACE = "urn:xmlns:rhq-configuration-export";
    public static final String EXPORT_NAMESPACE_PREFIX = "";
    public static final String CONFIGURATION_EXPORT_ELEMENT = "configuration-export";
    public static final String ENTITIES_EXPORT_ELEMENT = "entities";
    public static final String ENTITY_EXPORT_ELEMENT = "entity";
    public static final String ERROR_MESSAGE_ELEMENT = "error-message";
    public static final String NOTES_ELEMENT = "notes";
    public static final String DATA_ELEMENT = "data";
    public static final String VALIDATOR_ELEMENT = "validator";
    public static final String DEFAULT_CONFIGURATION_ELEMENT = "default-configuration";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";

    private SynchronizationConstants() {
    }

    public static NamespaceContext createConfigurationExportNamespaceContext() {
        return new NamespaceContext(){
            private final Map<String, String> PREFIXES = new HashMap<String, String>();
            {
                this.PREFIXES.put(SynchronizationConstants.EXPORT_NAMESPACE_PREFIX, SynchronizationConstants.EXPORT_NAMESPACE);
                this.PREFIXES.put(SynchronizationConstants.CONFIGURATION_INSTANCE_NAMESPACE_PREFIX, SynchronizationConstants.CONFIGURATION_INSTANCE_NAMESPACE);
                this.PREFIXES.put(SynchronizationConstants.CONFIGURATION_NAMESPACE_PREFIX, SynchronizationConstants.CONFIGURATION_NAMESPACE);
            }

            @Override
            public Iterator<String> getPrefixes(String namespaceURI) {
                String prefix = this.getPrefix(namespaceURI);
                if (prefix == null) {
                    return Collections.emptySet().iterator();
                }
                return Collections.singleton(prefix).iterator();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (namespaceURI == null) {
                    throw new IllegalArgumentException();
                }
                if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                    return "xmlns";
                }
                if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                    return "xml";
                }
                String prefix = null;
                for (Map.Entry<String, String> e : this.PREFIXES.entrySet()) {
                    String p = e.getKey();
                    String namespace = e.getValue();
                    if (!namespaceURI.equals(namespace)) continue;
                    prefix = p;
                    break;
                }
                return prefix;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                return this.PREFIXES.get(prefix);
            }
        };
    }
}

