/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.system;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Resource;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.common.ProductInfo;
import org.rhq.core.domain.common.ServerDetails;
import org.rhq.core.domain.common.SystemConfiguration;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.util.StopWatch;
import org.rhq.core.util.obfuscation.PicketBoxObfuscator;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.cloud.instance.ServerManagerLocal;
import org.rhq.enterprise.server.core.CoreServerMBean;
import org.rhq.enterprise.server.core.CustomJaasDeploymentServiceMBean;
import org.rhq.enterprise.server.plugin.pc.MasterServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginManager;
import org.rhq.enterprise.server.system.InvalidSystemConfigurationException;
import org.rhq.enterprise.server.system.SystemInfoManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerRemote;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.SystemDatabaseInformation;

@Singleton
@ConcurrencyManagement(value=ConcurrencyManagementType.BEAN)
public class SystemManagerBean
implements SystemManagerLocal,
SystemManagerRemote {
    private final String SQL_VACUUM = "VACUUM ANALYZE {0}";
    private final String SQL_ANALYZE = "ANALYZE";
    private final String SQL_REINDEX = "REINDEX TABLE {0}";
    private final String SQL_REBUILD = "ALTER INDEX {0} REBUILD";
    private final String[] TABLES_TO_VACUUM = new String[]{"RHQ_RESOURCE", "RHQ_CONFIG", "RHQ_CONFIG_PROPERTY", "RHQ_AGENT"};
    private final String[] TABLES_TO_REINDEX = new String[]{"RHQ_MEASUREMENT_DATA_TRAIT", "RHQ_CALLTIME_DATA_KEY", "RHQ_CALLTIME_DATA_VALUE", "RHQ_AVAILABILITY"};
    private final String[] ORA_INDEXES_TO_REBUILD = new String[]{"RHQ_MEAS_BASELINE_CTIME_IDX", "RHQ_MEAS_DATA_TRAIT_ID_TIME_PK"};
    private static final Log LOG = LogFactory.getLog(SystemManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
    private DataSource dataSource;
    @Resource
    private TimerService timerService;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private ServerManagerLocal serverManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private SystemInfoManagerLocal systemInfoManager;
    private SystemSettings cachedSystemSettings = null;
    private SystemSettings cachedObfuscatedSystemSettings = null;

    @Override
    public void scheduleConfigCacheReloader() {
        Collection timers = this.timerService.getTimers();
        for (Timer existingTimer : timers) {
            LOG.debug((Object)("Found timer - attempting to cancel: " + existingTimer.toString()));
            try {
                existingTimer.cancel();
            }
            catch (Exception e) {
                LOG.warn((Object)("Failed in attempting to cancel timer: " + existingTimer.toString()));
            }
        }
        this.timerService.createIntervalTimer(60000L, 60000L, new TimerConfig(null, false));
    }

    @Timeout
    public void reloadConfigCache(Timer timer) {
        try {
            String oldLastUpdate = (String)this.getCachedSettings().get((Object)SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME);
            this.systemManager.loadSystemConfigurationCacheInNewTx();
            String newLastUpdate = (String)this.getCachedSettings().get((Object)SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME);
            if (!SystemManagerBean.safeEquals(oldLastUpdate, newLastUpdate)) {
                this.systemManager.reconfigureSystem(this.subjectManager.getOverlord());
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Failed to reload the system config cache - will try again later. Cause: " + t));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public DatabaseType getDatabaseType() {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            conn = this.dataSource.getConnection();
            DatabaseType databaseType = dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            return databaseType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Failed to close temporary connection", (Throwable)e);
                }
            }
        }
    }

    @Override
    @Deprecated
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public Properties getSystemConfiguration(Subject subject) {
        Properties copy = new Properties();
        SystemSettings settings = this.getUnmaskedSystemSettings(true);
        for (Map.Entry e : settings.entrySet()) {
            if (!((SystemSetting)e.getKey()).isPublic()) continue;
            String value = (String)e.getValue();
            if (((SystemSetting)e.getKey()).getType() != PropertySimpleType.PASSWORD) {
                value = this.transformSystemConfigurationPropertyToDb((SystemSetting)e.getKey(), (String)e.getValue(), (String)e.getValue());
            }
            copy.put(((SystemSetting)e.getKey()).getInternalName(), value);
        }
        return copy;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public SystemSettings getSystemSettings(Subject subject) {
        SystemSettings ret = new SystemSettings();
        SystemSettings unmasked = this.getUnmaskedSystemSettings(true);
        for (Map.Entry entry : unmasked.entrySet()) {
            if (!((SystemSetting)entry.getKey()).isPublic()) continue;
            if (((SystemSetting)entry.getKey()).getType() == PropertySimpleType.PASSWORD) {
                entry.setValue("_._._[MaSKeD]_._._");
            }
            ret.put((SystemSetting)entry.getKey(), (String)entry.getValue());
        }
        return ret;
    }

    @Override
    public SystemSettings getUnmaskedSystemSettings(boolean includePrivateSettings) {
        SystemSettings ret = this.getCachedSettings();
        return includePrivateSettings ? ret : this.removePrivateSettings(ret);
    }

    @Override
    public void deobfuscate(SystemSettings systemSettings) {
        for (Map.Entry entry : systemSettings.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null || ((SystemSetting)entry.getKey()).getType() != PropertySimpleType.PASSWORD) continue;
            entry.setValue(PicketBoxObfuscator.decode((String)value));
        }
    }

    @Override
    public SystemSettings getObfuscatedSystemSettings(boolean includePrivateSettings) {
        SystemSettings ret = this.getCachedObfuscatedSettings();
        return includePrivateSettings ? ret : this.removePrivateSettings(ret);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void setSystemSettings(Subject subject, SystemSettings settings) {
        this.setAnySystemSettings(this.removePrivateSettings(settings), false, false);
    }

    @Override
    public void setAnySystemSetting(SystemSetting setting, String value) {
        if (SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME == setting) {
            return;
        }
        SystemSettings settings = this.getUnmaskedSystemSettings(true);
        settings.put(setting, value);
        this.setAnySystemSettings(settings, true, true);
    }

    private SystemSettings removePrivateSettings(SystemSettings settings) {
        SystemSettings cleansed = new SystemSettings(settings);
        for (SystemSetting s : SystemSetting.values()) {
            if (s.isPublic()) continue;
            cleansed.remove((Object)s);
        }
        return cleansed;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void setStorageClusterSettings(Subject subject, SystemSettings settings) {
        for (SystemSetting setting : settings.keySet()) {
            if (this.isStorageSetting(setting)) continue;
            throw new IllegalArgumentException(setting + " cannot be updated through this method. This method " + "only allows updating of storage cluster settings.");
        }
        this.setAnySystemSettings(settings, false, true);
    }

    @Override
    public void setAnySystemSettings(SystemSettings settings, boolean skipValidation, boolean ignoreReadOnly) {
        List configs = this.entityManager.createNamedQuery("SystemConfiguration.findAll").getResultList();
        HashMap<String, SystemConfiguration> existingConfigMap = new HashMap<String, SystemConfiguration>();
        for (SystemConfiguration config : configs) {
            existingConfigMap.put(config.getPropertyKey(), config);
        }
        boolean changed = false;
        SystemConfiguration lastUpdateTime = (SystemConfiguration)existingConfigMap.get(SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME.getInternalName());
        for (Map.Entry e : settings.entrySet()) {
            SystemSetting prop = (SystemSetting)e.getKey();
            String value = (String)e.getValue();
            if (!skipValidation) {
                this.verifyNewSystemConfigurationProperty(prop, value, settings);
            }
            SystemConfiguration existingConfig = (SystemConfiguration)existingConfigMap.get(prop.getInternalName());
            if (e.getKey() == SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME) {
                lastUpdateTime = existingConfig;
                continue;
            }
            if (existingConfig == null) {
                value = this.transformSystemConfigurationPropertyToDb(prop, value, null);
                existingConfig = new SystemConfiguration(prop.getInternalName(), value);
                this.entityManager.persist((Object)existingConfig);
                changed = true;
                existingConfigMap.put(existingConfig.getPropertyKey(), existingConfig);
                continue;
            }
            String existingValue = this.transformSystemConfigurationPropertyFromDb(prop, existingConfig.getPropertyValue(), true);
            value = this.unmask(prop, value, existingValue);
            if ((!SystemManagerBean.isEmpty(existingValue) || SystemManagerBean.isEmpty(value)) && (null == existingValue || existingValue.equals(value))) continue;
            if ((prop.isReadOnly() || existingConfig.getFreadOnly() != null && existingConfig.getFreadOnly().booleanValue()) && !this.isStorageSetting(prop) && !ignoreReadOnly) {
                throw new IllegalArgumentException("The setting [" + prop.getInternalName() + "] is read-only - you cannot change its current value! Current value is [" + existingConfig.getPropertyValue() + "] while the new value was [" + value + "].");
            }
            value = this.transformSystemConfigurationPropertyToDb(prop, value, existingValue);
            existingConfig.setPropertyValue(value);
            this.entityManager.merge((Object)existingConfig);
            changed = true;
        }
        if (changed) {
            if (lastUpdateTime == null) {
                lastUpdateTime = new SystemConfiguration(SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME.getInternalName(), Long.toString(System.currentTimeMillis()));
                lastUpdateTime.setFreadOnly(Boolean.valueOf(SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME.isReadOnly()));
                this.entityManager.persist((Object)lastUpdateTime);
            } else {
                lastUpdateTime.setPropertyValue(Long.toString(System.currentTimeMillis()));
                this.entityManager.merge((Object)lastUpdateTime);
            }
            existingConfigMap.put(SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME.getInternalName(), lastUpdateTime);
            this.fillCache(existingConfigMap.values());
        }
    }

    private static boolean isEmpty(String string) {
        return null == string || string.trim().isEmpty();
    }

    private boolean isStorageSetting(SystemSetting setting) {
        switch (setting) {
            case STORAGE_CQL_PORT: 
            case STORAGE_GOSSIP_PORT: 
            case STORAGE_AUTOMATIC_DEPLOYMENT: 
            case STORAGE_PASSWORD: 
            case STORAGE_USERNAME: {
                return true;
            }
        }
        return false;
    }

    private Map<String, String> toMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return map;
    }

    private void transformToSystemSettingsFormat(Map<String, String> map) {
        for (Map.Entry<String, String> e : map.entrySet()) {
            SystemSetting prop = SystemSetting.getByInternalName((String)e.getKey());
            if (prop == null) continue;
            String value = this.transformSystemConfigurationPropertyFromDb(prop, e.getValue(), false);
            e.setValue(value);
        }
    }

    private Map<String, String> getDriftServerPlugins() {
        DriftServerPluginManager pluginMgr = this.getDriftServerPluginManager();
        HashMap<String, String> plugins = new HashMap<String, String>();
        if (pluginMgr != null) {
            for (ServerPluginEnvironment env : pluginMgr.getPluginEnvironments()) {
                plugins.put(env.getPluginKey().getPluginName(), env.getPluginDescriptor().getDisplayName());
            }
        }
        return plugins;
    }

    private DriftServerPluginManager getDriftServerPluginManager() {
        MasterServerPluginContainer masterPC = LookupUtil.getServerPluginService().getMasterPluginContainer();
        if (masterPC == null) {
            LOG.warn((Object)(MasterServerPluginContainer.class.getSimpleName() + " is not started yet"));
            return null;
        }
        DriftServerPluginContainer pc = masterPC.getPluginContainerByClass(DriftServerPluginContainer.class);
        if (pc == null) {
            LOG.warn((Object)(DriftServerPluginContainer.class + " has not been loaded by the " + masterPC.getClass() + " yet"));
            return null;
        }
        return (DriftServerPluginManager)pc.getPluginManager();
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void loadSystemConfigurationCacheInNewTx() {
        this.loadSystemConfigurationCache();
    }

    @Override
    public void loadSystemConfigurationCache() {
        List configs = this.entityManager.createNamedQuery("SystemConfiguration.findAll").getResultList();
        this.fillCache(configs);
    }

    @Override
    @Deprecated
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void setSystemConfiguration(Subject subject, Properties properties, boolean skipValidation) throws Exception {
        Map<String, String> map = this.toMap(properties);
        this.transformToSystemSettingsFormat(map);
        SystemSettings settings = SystemSettings.fromMap(map);
        this.setAnySystemSettings(settings, skipValidation, false);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void validateSystemConfiguration(Subject subject, Properties properties) throws InvalidSystemConfigurationException {
        Map<String, String> map = this.toMap(properties);
        this.transformToSystemSettingsFormat(map);
        SystemSettings settings = SystemSettings.fromMap(map);
        for (Map.Entry e : settings.entrySet()) {
            SystemSetting prop = (SystemSetting)e.getKey();
            String value = (String)e.getValue();
            this.verifyNewSystemConfigurationProperty(prop, value, settings);
        }
    }

    private String transformSystemConfigurationPropertyFromDb(SystemSetting prop, String value, boolean unobfuscate) {
        switch (prop) {
            case LDAP_BASED_JAAS_PROVIDER: {
                if ("JDBC".equals(value)) {
                    return Boolean.toString(false);
                }
                if ("LDAP".equals(value)) {
                    return Boolean.toString(true);
                }
                return value == null ? "" : value;
            }
            case USE_SSL_FOR_LDAP: {
                if ("ssl".equals(value)) {
                    return Boolean.toString(true);
                }
                return Boolean.toString(false);
            }
        }
        switch (prop.getType()) {
            case BOOLEAN: {
                if ("0".equals(value)) {
                    return Boolean.FALSE.toString();
                }
                if ("1".equals(value)) {
                    return Boolean.TRUE.toString();
                }
                return value == null ? Boolean.FALSE.toString() : value;
            }
            case PASSWORD: {
                if (unobfuscate && value != null && value.trim().length() > 0) {
                    return PicketBoxObfuscator.decode((String)value);
                }
                return value == null ? "" : value;
            }
        }
        if (value == null) {
            switch (prop.getType()) {
                case DOUBLE: 
                case FLOAT: 
                case INTEGER: 
                case LONG: {
                    value = "0";
                    break;
                }
                default: {
                    value = "";
                }
            }
        }
        return value;
    }

    private String transformSystemConfigurationPropertyToDb(SystemSetting prop, String newValue, String oldValue) {
        switch (prop) {
            case LDAP_BASED_JAAS_PROVIDER: {
                if (Boolean.parseBoolean(newValue)) {
                    return "LDAP";
                }
                return "JDBC";
            }
            case USE_SSL_FOR_LDAP: {
                if (Boolean.parseBoolean(newValue)) {
                    return "ssl";
                }
                return "";
            }
        }
        if (prop.getType() == PropertySimpleType.PASSWORD && newValue != null) {
            if ("_._._[MaSKeD]_._._".equals(newValue)) {
                return oldValue;
            }
            return PicketBoxObfuscator.encode((String)newValue);
        }
        return newValue;
    }

    private String unmask(SystemSetting prop, String newValue, String currentValue) {
        if (prop.getType() == PropertySimpleType.PASSWORD && "_._._[MaSKeD]_._._".equals(newValue)) {
            newValue = currentValue;
        }
        return newValue;
    }

    private void verifyNewSystemConfigurationProperty(SystemSetting property, String value, SystemSettings settings) {
        long time;
        if (property == SystemSetting.BASE_LINE_DATASET) {
            long baselineDataSet = Long.parseLong(value);
            if (baselineDataSet > 1209600000L) {
                throw new InvalidSystemConfigurationException("Baseline dataset must be less than 14 days");
            }
        } else if (property == SystemSetting.BASE_LINE_FREQUENCY) {
            long baselineDataSet;
            long baselineFrequency = Long.parseLong(value);
            if (baselineFrequency > (baselineDataSet = Long.parseLong((String)settings.get((Object)SystemSetting.BASE_LINE_DATASET)))) {
                throw new InvalidSystemConfigurationException("baseline computation frequency must not be larger than baseline data set");
            }
        } else if (property == SystemSetting.AGENT_MAX_QUIET_TIME_ALLOWED && (time = Long.parseLong(value)) < 180000L) {
            throw new InvalidSystemConfigurationException("Agent Max Quiet Time Allowed must be at least 3 minutes");
        }
    }

    @Override
    public void enableHibernateStatistics() {
        PersistenceUtility.enableHibernateStatistics((EntityManager)this.entityManager, (MBeanServer)ManagementFactory.getPlatformMBeanServer());
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void reconfigureSystem(Subject whoami) {
        try {
            CustomJaasDeploymentServiceMBean mbean = MBeanServerInvocationHandler.newProxyInstance(ManagementFactory.getPlatformMBeanServer(), CustomJaasDeploymentServiceMBean.OBJECT_NAME, CustomJaasDeploymentServiceMBean.class, false);
            mbean.installJaasModules();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long analyze(Subject whoami) {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            long duration;
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (!DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                long l = -1L;
                return l;
            }
            long l = duration = this.doCommand(dbtype, conn, "ANALYZE", null);
            return l;
        }
        catch (Exception e) {
            LOG.error((Object)"Error analyzing database", (Throwable)e);
            throw new RuntimeException("Error analyzing database", e);
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long reindex(Subject whoami) {
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            long duration = 0L;
            if (DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                for (String table : this.TABLES_TO_REINDEX) {
                    duration += this.doCommand(dbtype, conn, "REINDEX TABLE {0}", table);
                }
            } else if (DatabaseTypeFactory.isOracle((DatabaseType)dbtype)) {
                for (String index : this.ORA_INDEXES_TO_REBUILD) {
                    duration += this.doCommand(dbtype, conn, "ALTER INDEX {0} REBUILD", index);
                }
            } else {
                long l = -1L;
                return l;
            }
            long l = duration;
            return l;
        }
        catch (Exception e) {
            LOG.error((Object)"Error reindexing database", (Throwable)e);
            throw new RuntimeException("Error reindexing database", e);
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuum(Subject whoami) {
        return this.vacuum(whoami, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuum(Subject whoami, String[] tableNames) {
        long duration = 0L;
        Connection conn = null;
        DatabaseType dbtype = null;
        try {
            conn = this.dataSource.getConnection();
            dbtype = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (!DatabaseTypeFactory.isPostgres((DatabaseType)dbtype)) {
                long l = -1L;
                return l;
            }
            if (tableNames == null) {
                tableNames = new String[]{null};
            }
            for (String tableName : tableNames) {
                duration += this.doCommand(dbtype, conn, "VACUUM ANALYZE {0}", tableName);
            }
            long arr$ = duration;
            return arr$;
        }
        catch (Exception e) {
            LOG.error((Object)("Error vacuuming database: " + e.getMessage()), (Throwable)e);
            long l = duration;
            return l;
        }
        finally {
            if (dbtype != null) {
                dbtype.closeConnection(conn);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public long vacuumAppdef(Subject whoami) {
        return this.vacuum(whoami, this.TABLES_TO_VACUUM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCommand(DatabaseType dbtype, Connection conn, String command, String table) {
        Statement stmt = null;
        StopWatch watch = new StopWatch();
        if (table == null) {
            table = "";
        }
        command = command.replace("{0}", table);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Execute command: " + command));
        }
        try {
            stmt = conn.createStatement();
            stmt.execute(command);
            long l = watch.getElapsed();
            return l;
        }
        catch (SQLException e) {
            LOG.error((Object)("Error in command: " + command + ": " + e), (Throwable)e);
            long l = watch.getElapsed();
            return l;
        }
        finally {
            dbtype.closeStatement(stmt);
        }
    }

    @Override
    @Deprecated
    public void undeployInstaller() {
    }

    @Override
    public boolean isDebugModeEnabled() {
        try {
            String setting = (String)this.getUnmaskedSystemSettings(true).get((Object)SystemSetting.DEBUG_MODE_ENABLED);
            if (setting == null) {
                setting = "false";
            }
            return Boolean.valueOf(setting);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean isLoginWithoutRolesEnabled() {
        try {
            String setting = (String)this.getUnmaskedSystemSettings(true).get((Object)SystemSetting.LOGIN_WITHOUT_ROLES_ENABLED);
            if (setting == null) {
                setting = "false";
            }
            return Boolean.valueOf(setting);
        }
        catch (Exception t) {
            return false;
        }
    }

    @Override
    public boolean isExperimentalFeaturesEnabled() {
        try {
            String setting = (String)this.getUnmaskedSystemSettings(true).get((Object)SystemSetting.EXPERIMENTAL_FEATURES_ENABLED);
            if (setting == null) {
                setting = "false";
            }
            return Boolean.valueOf(setting);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean isLdapAuthorizationEnabled() {
        SystemSettings settings = this.getUnmaskedSystemSettings(true);
        String ldapAuthValue = (String)settings.get((Object)SystemSetting.LDAP_BASED_JAAS_PROVIDER);
        boolean ldapAuth = ldapAuthValue == null ? false : Boolean.valueOf(ldapAuthValue);
        String groupFilter = (String)settings.get((Object)SystemSetting.LDAP_GROUP_FILTER);
        String groupMember = (String)settings.get((Object)SystemSetting.LDAP_GROUP_MEMBER);
        return ldapAuth && (groupFilter != null && groupFilter.trim().length() > 0 || groupMember != null && groupMember.trim().length() > 0);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public ServerDetails getServerDetails(Subject subject) {
        CoreServerMBean coreServerMBean = LookupUtil.getCoreServer();
        ServerDetails serverDetails = new ServerDetails();
        serverDetails.setProductInfo(this.getProductInfo(subject));
        HashMap details = serverDetails.getDetails();
        DateFormat localTimeFormatter = DateFormat.getDateTimeInstance(1, 0);
        details.put(ServerDetails.Detail.SERVER_LOCAL_TIME, localTimeFormatter.format(new Date()));
        details.put(ServerDetails.Detail.SERVER_TIMEZONE, TimeZone.getDefault().getDisplayName());
        details.put(ServerDetails.Detail.SERVER_HOME_DIR, coreServerMBean.getJBossServerHomeDir().getAbsolutePath());
        details.put(ServerDetails.Detail.SERVER_INSTALL_DIR, coreServerMBean.getInstallDir().getAbsolutePath());
        SystemDatabaseInformation dbInfo = SystemDatabaseInformation.getInstance();
        details.put(ServerDetails.Detail.DATABASE_CONNECTION_URL, dbInfo.getDatabaseConnectionURL());
        details.put(ServerDetails.Detail.DATABASE_DRIVER_NAME, dbInfo.getDatabaseDriverName());
        details.put(ServerDetails.Detail.DATABASE_DRIVER_VERSION, dbInfo.getDatabaseDriverVersion());
        details.put(ServerDetails.Detail.DATABASE_PRODUCT_NAME, dbInfo.getDatabaseProductName());
        details.put(ServerDetails.Detail.DATABASE_PRODUCT_VERSION, dbInfo.getDatabaseProductVersion());
        details.put(ServerDetails.Detail.SERVER_IDENTITY, this.serverManager.getServer().getName());
        return serverDetails;
    }

    @Override
    public ProductInfo getProductInfo(Subject subject) {
        CoreServerMBean coreServer = LookupUtil.getCoreServer();
        ProductInfo productInfo = coreServer.getProductInfo();
        return productInfo;
    }

    @Override
    public void dumpSystemInfo(Subject subject) {
        this.systemInfoManager.dumpToLog(subject);
    }

    private synchronized SystemSettings getCachedSettings() {
        if (this.cachedSystemSettings == null) {
            this.loadSystemConfigurationCache();
        }
        return new SystemSettings(this.cachedSystemSettings);
    }

    private synchronized SystemSettings getCachedObfuscatedSettings() {
        if (this.cachedSystemSettings == null) {
            this.loadSystemConfigurationCache();
        }
        return new SystemSettings(this.cachedObfuscatedSystemSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCache(Collection<SystemConfiguration> configs) {
        String value;
        SystemSettings settings = new SystemSettings();
        for (SystemConfiguration config : configs) {
            SystemSetting prop = SystemSetting.getByInternalName((String)config.getPropertyKey());
            if (prop == null) {
                LOG.warn((Object)("The database contains unknown system configuration setting [" + config.getPropertyKey() + "]."));
                continue;
            }
            if (config.getPropertyValue() == null) {
                String defaultValue = config.getDefaultPropertyValue();
                defaultValue = this.transformSystemConfigurationPropertyFromDb(prop, defaultValue, true);
                settings.put(prop, defaultValue);
                continue;
            }
            value = config.getPropertyValue();
            value = this.transformSystemConfigurationPropertyFromDb(prop, value, true);
            settings.put(prop, value);
        }
        settings.setDriftPlugins(this.getDriftServerPlugins());
        SystemManagerBean systemManagerBean = this;
        synchronized (systemManagerBean) {
            if (this.cachedSystemSettings == null || !SystemManagerBean.safeEquals(this.cachedSystemSettings.get((Object)SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME), settings.get((Object)SystemSetting.LAST_SYSTEM_CONFIG_UPDATE_TIME))) {
                this.cachedSystemSettings = settings;
                this.cachedObfuscatedSystemSettings = new SystemSettings(settings);
                for (Map.Entry entry : this.cachedObfuscatedSystemSettings.entrySet()) {
                    value = (String)entry.getValue();
                    if (value == null || ((SystemSetting)entry.getKey()).getType() != PropertySimpleType.PASSWORD) continue;
                    entry.setValue(PicketBoxObfuscator.encode((String)value));
                }
            }
        }
    }

    private static boolean safeEquals(Object a, Object b) {
        return a == null ? b == null : b != null && a.equals(b);
    }
}

