/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert;

import java.util.EnumSet;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDampeningEvent;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.enterprise.server.alert.AlertDampeningManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;

@Stateless
public class AlertDampeningManagerBean
implements AlertDampeningManagerLocal {
    private final Log log = LogFactory.getLog(AlertDampeningManagerBean.class);
    @EJB
    private AlertManagerLocal alertManager;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @Override
    public AlertDampeningEvent getLatestEventByAlertDefinitionId(int alertDefinitionId) {
        Query latestEventQuery = this.entityManager.createNamedQuery("AlertDampeningEvent.findLatestByAlertDefinitionId");
        latestEventQuery.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        try {
            AlertDampeningEvent latestEvent = (AlertDampeningEvent)latestEventQuery.getSingleResult();
            return latestEvent;
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    private boolean shouldFireDurationCountAlert(int alertDefinitionId, int eventCountThreshold, long lastSeconds) {
        boolean shouldFire;
        long oldestEventTime = System.currentTimeMillis() - lastSeconds * 1000L;
        Query query = this.entityManager.createNamedQuery("AlertDampeningEvent.findByTimeAndTypes");
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        query.setParameter("eventTypes", EnumSet.of(AlertDampeningEvent.Type.POSITIVE, AlertDampeningEvent.Type.POSITIVE_AGAIN));
        query.setParameter("oldestEventTime", (Object)oldestEventTime);
        query.setMaxResults(eventCountThreshold);
        List oldestEvents = query.getResultList();
        this.deleteAlertEventsOlderThan(alertDefinitionId, oldestEventTime);
        boolean bl = shouldFire = oldestEvents.size() == eventCountThreshold;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Need " + eventCountThreshold + " events " + "for the last " + lastSeconds + " seconds" + ", " + "found " + oldestEvents.size()));
        }
        if (shouldFire) {
            for (AlertDampeningEvent event : oldestEvents) {
                event.setAlertDefinition(null);
                this.entityManager.remove((Object)event);
            }
        }
        return shouldFire;
    }

    @Override
    public Alert processEventType(int alertDefinitionId, AlertDampeningEvent.Type eventType) {
        Alert firedAlert = null;
        try {
            boolean fire = false;
            AlertDefinition alertDefinition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)alertDefinitionId);
            AlertDampening alertDampening = alertDefinition.getAlertDampening();
            AlertDampening.Category category = alertDampening.getCategory();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Alert condition processing for " + alertDefinition));
                this.log.debug((Object)("Dampening rules are: " + alertDampening));
            }
            if (category == AlertDampening.Category.NONE) {
                if (eventType == AlertDampeningEvent.Type.POSITIVE || eventType == AlertDampeningEvent.Type.POSITIVE_AGAIN) {
                    fire = this.shouldFireConsecutiveCountAlert(alertDefinitionId, 1L);
                }
            } else if (category == AlertDampening.Category.CONSECUTIVE_COUNT) {
                if (eventType == AlertDampeningEvent.Type.POSITIVE || eventType == AlertDampeningEvent.Type.POSITIVE_AGAIN) {
                    int count = alertDampening.getValue();
                    fire = this.shouldFireConsecutiveCountAlert(alertDefinitionId, count);
                }
            } else if (category == AlertDampening.Category.PARTIAL_COUNT) {
                if (eventType == AlertDampeningEvent.Type.POSITIVE || eventType == AlertDampeningEvent.Type.POSITIVE_AGAIN) {
                    int count = alertDampening.getValue();
                    int period = alertDampening.getPeriod();
                    fire = this.shouldFirePartialCountAlert(alertDefinitionId, count, period);
                }
            } else if (category == AlertDampening.Category.DURATION_COUNT) {
                if (eventType == AlertDampeningEvent.Type.POSITIVE || eventType == AlertDampeningEvent.Type.POSITIVE_AGAIN) {
                    int count = alertDampening.getValue();
                    long period = (long)alertDampening.getPeriod() * alertDampening.getPeriodUnits().getNumberOfSeconds();
                    fire = this.shouldFireDurationCountAlert(alertDefinitionId, count, period);
                }
            } else {
                this.log.info((Object)("Category " + alertDampening.getCategory() + " is not supported for alert dampening processing"));
            }
            if (fire) {
                this.log.debug((Object)"Dampening rules were satisfied");
                firedAlert = this.alertManager.fireAlert(alertDefinitionId);
            } else {
                this.log.debug((Object)"Dampening rules were not satisfied");
            }
        }
        catch (Exception e) {
            firedAlert = null;
            this.log.error((Object)("Error operating on the passed dampening eventType of " + eventType + " " + "for the alert definition with id of " + alertDefinitionId), (Throwable)e);
        }
        return firedAlert;
    }

    private boolean shouldFireConsecutiveCountAlert(int alertDefinitionId, long count) {
        return this.shouldFirePartialCountAlert(alertDefinitionId, count, count);
    }

    private boolean shouldFirePartialCountAlert(int alertDefinitionId, long countNeeded, long period) {
        List<AlertDampeningEvent> events = this.getRecentAlertDampeningEvents(alertDefinitionId, period);
        this.deleteAlertEventsOlderThan(alertDefinitionId, events.get(events.size() - 1).getEventTime());
        long positiveFires = 0L;
        for (AlertDampeningEvent event : events) {
            if (event.getEventType() != AlertDampeningEvent.Type.POSITIVE && event.getEventType() != AlertDampeningEvent.Type.POSITIVE_AGAIN) continue;
            ++positiveFires;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Need " + countNeeded + " events " + "for the last " + period + " events" + ", " + "found " + positiveFires));
        }
        if (positiveFires >= countNeeded) {
            for (AlertDampeningEvent event : events) {
                event.setAlertDefinition(null);
                this.entityManager.remove((Object)event);
            }
            return true;
        }
        return false;
    }

    private List<AlertDampeningEvent> getRecentAlertDampeningEvents(int alertDefinitionId, long maxResults) {
        Query query = this.entityManager.createNamedQuery("AlertDampeningEvent.findByAlertDefinitionId");
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        query.setMaxResults((int)maxResults);
        List results = query.getResultList();
        return results;
    }

    private void deleteAlertEventsOlderThan(Integer alertDefinitionId, long olderThan) {
        Query query = this.entityManager.createNamedQuery("AlertDampeningEvent.deleteByTimestamp");
        query.setParameter("alertDefinitionId", (Object)alertDefinitionId);
        query.setParameter("oldest", (Object)olderThan);
        int deletedCount = query.executeUpdate();
        if (deletedCount > 0 && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleted " + deletedCount + " stale AlertDampeningEvent" + (deletedCount == 1 ? "" : "s") + " for AlertDefinition[id=" + alertDefinitionId + "]"));
        }
    }
}

