/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.model;

import java.util.regex.Pattern;
import org.rhq.core.domain.alert.AlertConditionOperator;
import org.rhq.core.domain.event.EventSeverity;
import org.rhq.enterprise.server.alert.engine.model.AbstractEnumCacheElement;

public class EventCacheElement
extends AbstractEnumCacheElement<EventSeverity> {
    private final Pattern eventDetailsPattern;
    private final Pattern eventSourceLocationPattern;

    private String fixPattern(String regex) {
        boolean sw = regex.startsWith(".*");
        boolean ew = regex.endsWith(".*");
        return (!sw ? ".*" : "") + regex + (!ew ? ".*" : "");
    }

    public EventCacheElement(AlertConditionOperator operator, EventSeverity value, int conditionTriggerId) {
        super(operator, value, conditionTriggerId);
        this.eventDetailsPattern = null;
        this.eventSourceLocationPattern = null;
    }

    public EventCacheElement(AlertConditionOperator operator, String eventDetails, String regexEventDetails, String regexSourceLocation, EventSeverity value, int conditionTriggerId) {
        super(operator, (Object)eventDetails, value, conditionTriggerId);
        if (regexEventDetails != null && !regexEventDetails.trim().isEmpty()) {
            regexEventDetails = this.fixPattern(regexEventDetails);
            this.eventDetailsPattern = Pattern.compile(regexEventDetails, 42);
        } else {
            this.eventDetailsPattern = null;
        }
        if (regexSourceLocation != null && !regexSourceLocation.trim().isEmpty()) {
            regexSourceLocation = this.fixPattern(regexSourceLocation);
            this.eventSourceLocationPattern = Pattern.compile(regexSourceLocation, 2);
        } else {
            this.eventSourceLocationPattern = null;
        }
    }

    @Override
    public boolean matches(EventSeverity providedValue, Object ... extraParams) {
        boolean matches = super.matches(providedValue, extraParams);
        if (matches && this.eventSourceLocationPattern != null) {
            Object sourceLocation = extraParams[0];
            if (!(sourceLocation instanceof String)) {
                this.log.error((Object)(this.getClass().getSimpleName() + " expected a String, but received a " + extraParams.getClass().getSimpleName()));
            } else {
                boolean bl = matches = matches && this.eventSourceLocationPattern.matcher((String)sourceLocation).matches();
            }
        }
        if (matches && this.eventDetailsPattern != null) {
            Object details = extraParams[1];
            if (!(details instanceof String)) {
                this.log.error((Object)(this.getClass().getSimpleName() + " expected a String, but received a " + extraParams.getClass().getSimpleName()));
            } else {
                matches = matches && this.eventDetailsPattern.matcher((String)details).matches();
            }
        }
        return matches;
    }

    @Override
    public AlertConditionOperator.Type getOperatorSupportsType(AlertConditionOperator operator) {
        if (operator == AlertConditionOperator.CHANGES_TO || operator == AlertConditionOperator.CHANGES_FROM) {
            return AlertConditionOperator.Type.NONE;
        }
        return super.getOperatorSupportsType(operator);
    }
}

