/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.install.remote;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SSHFileSend {
    public static boolean sendFile(Session session, String sourceFilename, String destFilename) throws IOException, JSchException {
        int len;
        String command = "scp -p -t '" + destFilename + "'";
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(command);
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();
        channel.connect();
        if (SSHFileSend.checkAck(in) != 0) {
            return false;
        }
        long filesize = new File(sourceFilename).length();
        command = "C0644 " + filesize + " ";
        command = sourceFilename.lastIndexOf(47) > 0 ? command + sourceFilename.substring(sourceFilename.lastIndexOf(47) + 1) : (sourceFilename.lastIndexOf(92) > 0 ? command + sourceFilename.substring(sourceFilename.lastIndexOf(92) + 1) : command + sourceFilename);
        command = command + "\n";
        out.write(command.getBytes());
        out.flush();
        if (SSHFileSend.checkAck(in) != 0) {
            throw new IOException("Error while trying to write " + destFilename + " , " + SSHFileSend.getReason(in));
        }
        FileInputStream fis = new FileInputStream(sourceFilename);
        byte[] buf = new byte[1024];
        while ((len = fis.read(buf, 0, buf.length)) > 0) {
            out.write(buf, 0, len);
        }
        fis.close();
        buf[0] = 0;
        out.write(buf, 0, 1);
        out.flush();
        if (SSHFileSend.checkAck(in) != 0) {
            throw new IOException("Error while trying to write " + destFilename + " , " + SSHFileSend.getReason(in));
        }
        out.close();
        channel.disconnect();
        return true;
    }

    public static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        return b;
    }

    public static String getReason(InputStream in) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        do {
            c = in.read();
            sb.append((char)c);
        } while (c != 10);
        return sb.toString();
    }
}

