/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.AvailabilityCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.ResourceAvailability;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.composite.ResourceIdWithAvailabilityComposite;
import org.rhq.core.domain.resource.group.composite.ResourceGroupAvailability;
import org.rhq.core.domain.resource.group.composite.ResourceGroupComposite;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.StopWatch;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.alert.engine.model.AvailabilityDurationCacheElement;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerRemote;
import org.rhq.enterprise.server.measurement.AvailabilityPoint;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.scheduler.jobs.AlertAvailabilityDurationJob;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.concurrent.AvailabilityReportSerializer;

@Stateless
public class AvailabilityManagerBean
implements AvailabilityManagerLocal,
AvailabilityManagerRemote {
    private final Log log = LogFactory.getLog(AvailabilityManagerBean.class);
    private static final int MERGE_BATCH_SIZE;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AvailabilityManagerLocal availabilityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupManager;
    @EJB
    private ResourceAvailabilityManagerLocal resourceAvailabilityManager;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;
    @Resource
    private TimerService timerService;

    @Override
    public AvailabilityType getCurrentAvailabilityTypeForResource(Subject subject, int resourceId) {
        return this.resourceAvailabilityManager.getLatestAvailabilityType(subject, resourceId);
    }

    @Override
    public Availability getCurrentAvailabilityForResource(Subject subject, int resourceId) {
        Availability retAvailability;
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view current availability for resource[id=" + resourceId + "]");
        }
        try {
            Query q = this.entityManager.createNamedQuery("Availability.findCurrentByResource");
            q.setParameter("resourceId", (Object)resourceId);
            retAvailability = (Availability)q.getSingleResult();
        }
        catch (NoResultException nre) {
            org.rhq.core.domain.resource.Resource resource = this.resourceManager.getResourceById(subject, resourceId);
            List availList = resource.getAvailability();
            if (availList != null && availList.size() > 0) {
                this.log.warn((Object)"Could not query for latest avail but found one - missing null end time (this should never happen)");
                retAvailability = (Availability)availList.get(availList.size() - 1);
            }
            retAvailability = new Availability(resource, AvailabilityType.UNKNOWN);
        }
        return retAvailability;
    }

    @Override
    public List<Availability> getAvailabilitiesForResource(Subject subject, int resourceId, long startTime, long endTime) {
        Availability surrogateAvailability;
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view [" + resourceId + "]");
        }
        Date startDate = new Date(startTime);
        Date endDate = new Date(endTime);
        AvailabilityCriteria c = new AvailabilityCriteria();
        c.addFilterResourceId(Integer.valueOf(resourceId));
        c.addFilterInterval(Long.valueOf(startTime), Long.valueOf(endTime));
        c.addSortStartTime(PageOrdering.ASC);
        PageList<Availability> result = this.findAvailabilityByCriteria(subject, c);
        Iterator i = result.iterator();
        while (i.hasNext()) {
            Availability av = (Availability)i.next();
            if ((null == av.getEndTime() || !av.getEndTime().equals(startTime)) && !av.getStartTime().equals(endTime)) continue;
            i.remove();
        }
        if (result.size() > 0) {
            Availability firstAvailability = (Availability)result.get(0);
            if (firstAvailability.getStartTime() > startDate.getTime()) {
                surrogateAvailability = new Availability(firstAvailability.getResource(), Long.valueOf(startDate.getTime()), AvailabilityType.UNKNOWN);
                surrogateAvailability.setEndTime(firstAvailability.getStartTime());
                result.add(0, surrogateAvailability);
            }
        } else {
            org.rhq.core.domain.resource.Resource surrogateResource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)resourceId);
            surrogateAvailability = new Availability(surrogateResource, Long.valueOf(startDate.getTime()), AvailabilityType.UNKNOWN);
            surrogateAvailability.setEndTime(Long.valueOf(endDate.getTime()));
            result.add(surrogateAvailability);
        }
        this.entityManager.detach(result.get(0));
        if (result.size() > 1) {
            this.entityManager.detach(result.get(result.size() - 1));
        }
        ((Availability)result.get(0)).setStartTime(Long.valueOf(startDate.getTime()));
        ((Availability)result.get(result.size() - 1)).setEndTime(Long.valueOf(endDate.getTime()));
        return result;
    }

    @Override
    public List<ResourceGroupAvailability> getAvailabilitiesForResourceGroup(Subject subject, int groupId, long startTime, long endTime) {
        if (!this.authorizationManager.canViewGroup(subject, groupId)) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to view [" + groupId + "]");
        }
        ArrayList<ResourceGroupAvailability> result = new ArrayList<ResourceGroupAvailability>();
        Date startDate = new Date(startTime);
        Date endDate = new Date(endTime);
        List<Availability> allAvailabilities = this.findResourceGroupAvailabilityWithinInterval(groupId, startDate, endDate);
        if (allAvailabilities.isEmpty()) {
            ResourceGroupAvailability groupAvail = new ResourceGroupAvailability(groupId);
            groupAvail.setStartTime(Long.valueOf(startTime));
            groupAvail.setEndTime(Long.valueOf(endTime));
            int explicitMemberCount = this.resourceGroupManager.getExplicitGroupMemberCount(groupId);
            groupAvail.setGroupAvailabilityType(0 == explicitMemberCount ? ResourceGroupComposite.GroupAvailabilityType.EMPTY : ResourceGroupComposite.GroupAvailabilityType.WARN);
            result.add(groupAvail);
            return result;
        }
        Long atTime = startTime;
        int atTimeIndex = 0;
        ResourceGroupAvailability currentGroupAvail = null;
        int size = allAvailabilities.size();
        do {
            ResourceGroupComposite.GroupAvailabilityType groupAvailTypeAtTime = this.getGroupAvailabilityType(atTime, allAvailabilities);
            if (null == currentGroupAvail || currentGroupAvail.getGroupAvailabilityType() != groupAvailTypeAtTime) {
                if (null != currentGroupAvail) {
                    currentGroupAvail.setEndTime(atTime);
                }
                currentGroupAvail = new ResourceGroupAvailability(groupId);
                currentGroupAvail.setStartTime(atTime);
                currentGroupAvail.setGroupAvailabilityType(groupAvailTypeAtTime);
                result.add(currentGroupAvail);
            }
            while (atTimeIndex < size && allAvailabilities.get(atTimeIndex).getStartTime() <= atTime) {
                ++atTimeIndex;
            }
            if (atTimeIndex >= size) continue;
            atTime = allAvailabilities.get(atTimeIndex).getStartTime();
        } while (atTimeIndex < size);
        currentGroupAvail.setEndTime(Long.valueOf(endTime));
        return result;
    }

    private ResourceGroupComposite.GroupAvailabilityType getGroupAvailabilityType(long atTime, List<Availability> allAvailabilities) {
        long count = 0L;
        long disabled = 0L;
        long down = 0L;
        long unknown = 0L;
        long up = 0L;
        for (Availability av : allAvailabilities) {
            Long startTime = av.getStartTime();
            Long endTime = av.getEndTime();
            if (startTime > atTime || null != endTime && endTime <= atTime) continue;
            ++count;
            switch (av.getAvailabilityType()) {
                case UP: {
                    ++up;
                    break;
                }
                case DOWN: {
                    ++down;
                    break;
                }
                case UNKNOWN: {
                    ++unknown;
                    break;
                }
                case DISABLED: {
                    ++disabled;
                    break;
                }
            }
        }
        if (0L == count) {
            return ResourceGroupComposite.GroupAvailabilityType.EMPTY;
        }
        if (down == count) {
            return ResourceGroupComposite.GroupAvailabilityType.DOWN;
        }
        if (down > 0L || unknown > 0L) {
            return ResourceGroupComposite.GroupAvailabilityType.WARN;
        }
        if (disabled > 0L) {
            return ResourceGroupComposite.GroupAvailabilityType.DISABLED;
        }
        return ResourceGroupComposite.GroupAvailabilityType.UP;
    }

    @Override
    public List<AvailabilityPoint> findAvailabilitiesForResource(Subject subject, int resourceId, long fullRangeBeginTime, long fullRangeEndTime, int numberOfPoints, boolean withCurrentAvailability) {
        EntityContext context = new EntityContext(Integer.valueOf(resourceId), Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(-1));
        return this.getAvailabilitiesForContext(subject, context, fullRangeBeginTime, fullRangeEndTime, numberOfPoints, withCurrentAvailability);
    }

    @Override
    public List<AvailabilityPoint> findAvailabilitiesForResourceGroup(Subject subject, int groupId, long fullRangeBeginTime, long fullRangeEndTime, int numberOfPoints, boolean withCurrentAvailability) {
        EntityContext context = new EntityContext(Integer.valueOf(-1), Integer.valueOf(groupId), Integer.valueOf(-1), Integer.valueOf(-1));
        return this.getAvailabilitiesForContext(subject, context, fullRangeBeginTime, fullRangeEndTime, numberOfPoints, withCurrentAvailability);
    }

    @Override
    public List<AvailabilityPoint> findAvailabilitiesForAutoGroup(Subject subject, int parentResourceId, int resourceTypeId, long fullRangeBeginTime, long fullRangeEndTime, int numberOfPoints, boolean withCurrentAvailability) {
        EntityContext context = new EntityContext(Integer.valueOf(-1), Integer.valueOf(-1), Integer.valueOf(parentResourceId), Integer.valueOf(resourceTypeId));
        return this.getAvailabilitiesForContext(subject, context, fullRangeBeginTime, fullRangeEndTime, numberOfPoints, withCurrentAvailability);
    }

    private List<AvailabilityPoint> getAvailabilitiesForContext(Subject subject, EntityContext context, long fullRangeBeginTime, long fullRangeEndTime, int numberOfPoints, boolean withCurrentAvailability) {
        SurrogateAvailability surrogateAvailability;
        List<Availability> availabilities;
        Date fullRangeEndDate;
        Date fullRangeBeginDate;
        block51: {
            if (context.type == EntityContext.Type.Resource ? !this.authorizationManager.canViewResource(subject, context.resourceId) : context.type == EntityContext.Type.ResourceGroup && !this.authorizationManager.canViewGroup(subject, context.groupId)) {
                throw new PermissionException("User [" + subject.getName() + "] does not have permission to view " + context.toShortString());
            }
            if (numberOfPoints <= 0 || fullRangeBeginTime >= fullRangeEndTime) {
                return new ArrayList<AvailabilityPoint>();
            }
            fullRangeBeginDate = new Date(fullRangeBeginTime);
            fullRangeEndDate = new Date(fullRangeEndTime);
            try {
                if (context.type == EntityContext.Type.Resource) {
                    AvailabilityCriteria c = new AvailabilityCriteria();
                    c.addFilterResourceId(Integer.valueOf(context.resourceId));
                    c.addFilterInterval(Long.valueOf(fullRangeBeginTime), Long.valueOf(fullRangeEndTime));
                    c.addSortStartTime(PageOrdering.ASC);
                    availabilities = this.findAvailabilityByCriteria(subject, c);
                    break block51;
                }
                if (context.type == EntityContext.Type.ResourceGroup) {
                    availabilities = this.findResourceGroupAvailabilityWithinInterval(context.groupId, fullRangeBeginDate, fullRangeEndDate);
                    break block51;
                }
                if (context.type == EntityContext.Type.AutoGroup) {
                    availabilities = this.findAutoGroupAvailabilityWithinInterval(context.parentResourceId, context.resourceTypeId, fullRangeBeginDate, fullRangeEndDate);
                    break block51;
                }
                throw new IllegalArgumentException("Do not yet support retrieving availability history for Context[" + context.toShortString() + "]");
            }
            catch (Exception e) {
                this.log.warn((Object)("Can't obtain Availability for " + context.toShortString()), (Throwable)e);
                ArrayList<AvailabilityPoint> availabilityPoints = new ArrayList<AvailabilityPoint>(numberOfPoints);
                long totalMillis = fullRangeEndTime - fullRangeBeginTime;
                long perPointMillis = totalMillis / (long)numberOfPoints;
                for (int i = numberOfPoints; i >= 0; --i) {
                    availabilityPoints.add(new AvailabilityPoint(AvailabilityType.UNKNOWN, (long)i * perPointMillis));
                }
                Collections.reverse(availabilityPoints);
                return availabilityPoints;
            }
        }
        if (availabilities.size() > 0) {
            Availability earliestAvailability = availabilities.get(0);
            if (earliestAvailability.getStartTime() > fullRangeBeginDate.getTime()) {
                surrogateAvailability = new SurrogateAvailability(earliestAvailability.getResource(), fullRangeBeginDate.getTime());
                surrogateAvailability.setEndTime(earliestAvailability.getStartTime());
                availabilities.add(0, surrogateAvailability);
            }
        } else {
            org.rhq.core.domain.resource.Resource surrogateResource = context.type == EntityContext.Type.Resource ? (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)context.resourceId) : new org.rhq.core.domain.resource.Resource(-1);
            surrogateAvailability = new SurrogateAvailability(surrogateResource, fullRangeBeginDate.getTime());
            surrogateAvailability.setEndTime(fullRangeEndDate.getTime());
            availabilities.add(surrogateAvailability);
        }
        long now = System.currentTimeMillis();
        if (fullRangeEndDate.getTime() > now) {
            Availability latestAvailability = availabilities.get(availabilities.size() - 1);
            latestAvailability.setEndTime(Long.valueOf(now));
            SurrogateAvailability unknownFuture = new SurrogateAvailability(latestAvailability.getResource(), now);
            availabilities.add(unknownFuture);
        }
        long totalMillis = fullRangeEndTime - fullRangeBeginTime;
        long perPointMillis = totalMillis / (long)numberOfPoints;
        ArrayList<AvailabilityPoint> availabilityPoints = new ArrayList<AvailabilityPoint>(numberOfPoints);
        long currentTime = fullRangeEndTime;
        int currentAvailabilityIndex = availabilities.size() - 1;
        long timeUpInDataPoint = 0L;
        long timeDisabledInDataPoint = 0L;
        boolean hasDownPeriods = false;
        boolean hasDisabledPeriods = false;
        boolean hasUnknownPeriods = false;
        long dataPointStartBarrier = fullRangeEndTime - perPointMillis;
        while (currentTime > fullRangeBeginTime) {
            if (currentAvailabilityIndex <= -1) {
                availabilityPoints.add(new AvailabilityPoint(AvailabilityType.UNKNOWN, currentTime));
                currentTime -= perPointMillis;
                continue;
            }
            Availability currentAvailability = availabilities.get(currentAvailabilityIndex);
            long availabilityStartBarrier = currentAvailability.getStartTime();
            if (dataPointStartBarrier >= availabilityStartBarrier) {
                if (currentAvailability instanceof SurrogateAvailability) {
                    if (hasDownPeriods) {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.DOWN, currentTime));
                    } else if (hasDisabledPeriods) {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.DISABLED, currentTime));
                    } else if (timeUpInDataPoint > 0L) {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.UP, currentTime));
                    } else {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.UNKNOWN, currentTime));
                    }
                } else {
                    switch (currentAvailability.getAvailabilityType()) {
                        case UP: {
                            timeUpInDataPoint += currentTime - dataPointStartBarrier;
                            break;
                        }
                        case DOWN: {
                            hasDownPeriods = true;
                            break;
                        }
                        case DISABLED: {
                            hasDisabledPeriods = true;
                            break;
                        }
                        case UNKNOWN: {
                            hasUnknownPeriods = true;
                            break;
                        }
                    }
                    if (timeUpInDataPoint == perPointMillis) {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.UP, currentTime));
                    } else if (hasDownPeriods) {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.DOWN, currentTime));
                    } else if (hasDisabledPeriods) {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.DISABLED, currentTime));
                    } else {
                        availabilityPoints.add(new AvailabilityPoint(AvailabilityType.UNKNOWN, currentTime));
                    }
                }
                timeUpInDataPoint = 0L;
                hasDownPeriods = false;
                hasDisabledPeriods = false;
                hasUnknownPeriods = false;
                if (dataPointStartBarrier == availabilityStartBarrier) {
                    --currentAvailabilityIndex;
                }
                currentTime = dataPointStartBarrier;
                if ((dataPointStartBarrier -= perPointMillis) >= 0L) continue;
                break;
            }
            switch (currentAvailability.getAvailabilityType()) {
                case UP: {
                    timeUpInDataPoint += currentTime - availabilityStartBarrier;
                    break;
                }
                case DOWN: {
                    hasDownPeriods = true;
                    break;
                }
                case DISABLED: {
                    hasDisabledPeriods = true;
                    break;
                }
                default: {
                    hasUnknownPeriods = true;
                }
            }
            --currentAvailabilityIndex;
            currentTime = availabilityStartBarrier;
        }
        Collections.reverse(availabilityPoints);
        if (withCurrentAvailability) {
            AvailabilityPoint oldFirstAvailabilityPoint = (AvailabilityPoint)availabilityPoints.remove(availabilityPoints.size() - 1);
            AvailabilityType newFirstAvailabilityType = oldFirstAvailabilityPoint.getAvailabilityType();
            if (context.type == EntityContext.Type.Resource) {
                newFirstAvailabilityType = this.getCurrentAvailabilityTypeForResource(subject, context.resourceId);
            } else if (context.type == EntityContext.Type.ResourceGroup) {
                ResourceGroupComposite composite = this.resourceGroupManager.getResourceGroupComposite(subject, context.groupId);
                switch (composite.getExplicitAvailabilityType()) {
                    case EMPTY: {
                        newFirstAvailabilityType = null;
                        break;
                    }
                    case DOWN: 
                    case WARN: {
                        newFirstAvailabilityType = AvailabilityType.DOWN;
                        break;
                    }
                    case DISABLED: {
                        newFirstAvailabilityType = AvailabilityType.DISABLED;
                        break;
                    }
                    default: {
                        newFirstAvailabilityType = AvailabilityType.UP;
                    }
                }
            }
            availabilityPoints.add(new AvailabilityPoint(newFirstAvailabilityType, oldFirstAvailabilityPoint.getTimestamp()));
        }
        if (availabilityPoints.size() != numberOfPoints) {
            String errorMsg = "Calculation of availability did not produce the proper number of data points! " + context.toShortString() + "; begin=[" + fullRangeBeginTime + "(" + new Date(fullRangeBeginTime) + ")" + "]; end=[" + fullRangeEndTime + "(" + new Date(fullRangeEndTime) + ")" + "]; numberOfPoints=[" + numberOfPoints + "]; actual-number=[" + availabilityPoints.size() + "]";
            this.log.warn((Object)errorMsg);
        }
        return availabilityPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void setResourceAvailabilities(Map<Agent, int[]> map, AvailabilityType avail) {
        long now = System.currentTimeMillis();
        for (Agent agent : map.keySet()) {
            AvailabilityReport report = new AvailabilityReport(true, null);
            report.setServerSideReport(true);
            for (int resourceId : map.get(agent)) {
                report.addAvailability(new AvailabilityReport.Datum(resourceId, avail, now));
            }
            AvailabilityReportSerializer.getSingleton().lock(agent.getName());
            try {
                this.availabilityManager.mergeAvailabilityReport(report);
            }
            finally {
                AvailabilityReportSerializer.getSingleton().unlock(agent.getName());
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean mergeAvailabilityReport(AvailabilityReport report) {
        int reportSize = report.getResourceAvailability().size();
        String agentName = report.getAgentName();
        StopWatch watch = new StopWatch();
        if (reportSize == 0) {
            this.log.error((Object)("Agent [" + agentName + "] sent an empty availability report.  This is a bug, please report it"));
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Agent [" + agentName + "]: processing availability report of size: " + reportSize));
        }
        ArrayList<Availability> availabilities = new ArrayList<Availability>(report.getResourceAvailability().size());
        for (AvailabilityReport.Datum datum : report.getResourceAvailability()) {
            availabilities.add(new Availability(new org.rhq.core.domain.resource.Resource(datum.getResourceId()), Long.valueOf(datum.getStartTime()), datum.getAvailabilityType()));
        }
        Integer agentToUpdate = this.agentManager.getAgentIdByName(agentName);
        MergeInfo mergeInfo = new MergeInfo(report);
        if (!report.isServerSideReport() && agentToUpdate != null) {
            if (report.isChangesOnlyReport() && this.agentManager.isAgentBackfilled(agentToUpdate)) {
                mergeInfo.setAskForFullReport(true);
            }
            this.availabilityManager.updateLastAvailabilityReportInNewTransaction(agentToUpdate);
        }
        while (!availabilities.isEmpty()) {
            int size = availabilities.size();
            int end = MERGE_BATCH_SIZE < size ? MERGE_BATCH_SIZE : size;
            List<Availability> availBatch = availabilities.subList(0, end);
            this.availabilityManager.mergeAvailabilitiesInNewTransaction(availBatch, mergeInfo);
            availBatch.clear();
        }
        MeasurementMonitor.getMBean().incrementAvailabilityReports(report.isChangesOnlyReport());
        MeasurementMonitor.getMBean().incrementAvailabilitiesInserted(mergeInfo.getNumInserted());
        MeasurementMonitor.getMBean().incrementAvailabilityInsertTime(watch.getElapsed());
        watch.reset();
        if (!report.isServerSideReport()) {
            if (agentToUpdate != null) {
                if (mergeInfo.isAskForFullReport() && report.isChangesOnlyReport()) {
                    this.log.debug((Object)("The server is unsure that it has up-to-date availabilities for agent [" + agentName + "]; asking for a full report to be sent"));
                    return false;
                }
            } else {
                this.log.error((Object)("Could not figure out which agent sent availability report. This error is harmless and should stop appearing after a short while if the platform of the agent [" + agentName + "] was recently removed. In any other case this is a bug." + report));
            }
        }
        return true;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void mergeAvailabilitiesInNewTransaction(List<Availability> availabilities, MergeInfo mergeInfo) {
        ArrayList<Availability> disabledAvailabilities = new ArrayList<Availability>();
        Query q = this.entityManager.createNamedQuery("Availability.findLatestByResourceIds");
        ArrayList<Integer> resourceIds = new ArrayList<Integer>(availabilities.size());
        for (Availability reported : availabilities) {
            resourceIds.add(reported.getResource().getId());
        }
        q.setParameter("resourceIds", resourceIds);
        List latestAvailabilitiesList = q.getResultList();
        resourceIds.clear();
        resourceIds = null;
        Object nonUniqueMarker = new Object();
        HashMap<Integer, Object> latestAvailabilities = new HashMap<Integer, Object>(availabilities.size() + 100);
        for (Availability latestAvailability : latestAvailabilitiesList) {
            Integer resourceId = latestAvailability.getResource().getId();
            if (latestAvailabilities.containsKey(resourceId)) {
                latestAvailabilities.put(resourceId, nonUniqueMarker);
                continue;
            }
            latestAvailabilities.put(resourceId, latestAvailability);
        }
        ArrayList<Availability> changedAvailabilities = new ArrayList<Availability>(availabilities.size());
        for (Availability reported : availabilities) {
            Availability latest;
            Integer resourceId;
            block19: {
                reported.setEndTime(null);
                resourceId = reported.getResource().getId();
                Object latestObject = latestAvailabilities.get(resourceId);
                latest = null;
                if (null == latestObject) {
                    org.rhq.core.domain.resource.Resource attachedResource = (org.rhq.core.domain.resource.Resource)this.entityManager.find(org.rhq.core.domain.resource.Resource.class, (Object)reported.getResource().getId());
                    if (null == attachedResource || InventoryStatus.COMMITTED != attachedResource.getInventoryStatus()) {
                        this.log.info((Object)("Skipping mergeAvailabilityReport() for stale resource [" + reported.getResource() + "]. These messages should go away after the next agent synchronization with the server."));
                        continue;
                    }
                    this.log.warn((Object)("Resource [" + reported.getResource() + "] has no latest availability record (i.e. no endtime) - will attempt to repair.\n" + mergeInfo.toString(false)));
                    try {
                        List attachedAvails = attachedResource.getAvailability();
                        Object attachedLastAvail = null;
                        if (attachedAvails.isEmpty()) {
                            latest = new Availability(attachedResource, Long.valueOf(0L), AvailabilityType.UNKNOWN);
                            this.entityManager.persist((Object)latest);
                        } else {
                            latest = (Availability)attachedAvails.get(attachedAvails.size() - 1);
                            latest.setEndTime(null);
                            latest = (Availability)this.entityManager.merge((Object)latest);
                        }
                        latestAvailabilities.put(resourceId, latest);
                        this.updateResourceAvailability(latest);
                        mergeInfo.setAskForFullReport(true);
                        break block19;
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Unable to repair NoResult latest availablity for Resource [" + reported.getResource() + "]"), t);
                        continue;
                    }
                }
                if (latestObject == nonUniqueMarker) {
                    this.log.debug((Object)("Resource [" + reported.getResource() + "] has multiple availabilities without an endtime - will attempt to remove the extra ones\n" + mergeInfo.toString(false)));
                    try {
                        q = this.entityManager.createNamedQuery("Availability.findCurrentByResource");
                        q.setParameter("resourceId", (Object)resourceId);
                        List latestList = q.getResultList();
                        int latestCount = latestList.size();
                        for (int i = 0; i < latestCount - 1; ++i) {
                            this.entityManager.remove(latestList.get(i));
                        }
                        latest = (Availability)latestList.get(latestCount - 1);
                        this.updateResourceAvailability(latest);
                        latestAvailabilities.put(resourceId, latest);
                        mergeInfo.setAskForFullReport(true);
                        break block19;
                    }
                    catch (Throwable t) {
                        this.log.warn((Object)("Unable to repair NonUnique Result latest availablity for Resource [" + reported.getResource() + "]"), t);
                        continue;
                    }
                }
                latest = (Availability)latestObject;
            }
            AvailabilityType latestType = latest.getAvailabilityType();
            AvailabilityType reportedType = reported.getAvailabilityType();
            if (AvailabilityType.MISSING == reportedType) {
                boolean uninventoried = this.resourceManager.handleMissingResourceInNewTransaction(resourceId);
                if (uninventoried) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Type not enabled for automatic uninventory of MISSING resources. Converting MISSING to DOWN AvailabilityType for resource: " + reported.getResource()));
                }
                reported.setAvailabilityType(AvailabilityType.DOWN);
                reportedType = AvailabilityType.DOWN;
            }
            if (!(AvailabilityType.DISABLED != latestType || mergeInfo.isEnablementReport() && AvailabilityType.UNKNOWN == reportedType)) {
                disabledAvailabilities.add(reported);
                continue;
            }
            if (reported.getStartTime() >= latest.getStartTime()) {
                if (latest.getAvailabilityType() != reported.getAvailabilityType()) {
                    this.entityManager.persist((Object)reported);
                    latestAvailabilities.put(resourceId, reported);
                    mergeInfo.incrementNumInserted();
                    latest.setEndTime(reported.getStartTime());
                    latest = (Availability)this.entityManager.merge((Object)latest);
                    changedAvailabilities.add(reported);
                }
                if (latest.getAvailabilityType() != AvailabilityType.UNKNOWN) continue;
                mergeInfo.setAskForFullReport(true);
                continue;
            }
            this.insertAvailability(reported);
            mergeInfo.incrementNumInserted();
            mergeInfo.setAskForFullReport(true);
        }
        this.updateResourceAvailabilities(changedAvailabilities);
        latestAvailabilities.clear();
        latestAvailabilities = null;
        changedAvailabilities.clear();
        changedAvailabilities = null;
        availabilities.removeAll(disabledAvailabilities);
        this.notifyAlertConditionCacheManager("mergeAvailabilityReport", availabilities.toArray(new Availability[availabilities.size()]));
    }

    private void updateResourceAvailability(Availability reported) {
        ResourceAvailability currentAvailability = this.resourceAvailabilityManager.getLatestAvailability(reported.getResource().getId());
        this.updateResourceAvailabilityIfNecessary(reported, currentAvailability);
    }

    private void updateResourceAvailabilityIfNecessary(Availability reported, ResourceAvailability currentAvailability) {
        if (currentAvailability != null && currentAvailability.getAvailabilityType() != reported.getAvailabilityType()) {
            currentAvailability.setAvailabilityType(reported.getAvailabilityType());
            this.entityManager.merge((Object)currentAvailability);
        } else if (currentAvailability == null) {
            this.log.info((Object)("Skipping updateResourceAvailabilityIfNecessary() for stale resource [" + reported.getResource() + "]. These messages should go away after the next agent synchronization with the server."));
        }
    }

    private void updateResourceAvailabilities(List<Availability> reportedChanges) {
        if (null == reportedChanges || reportedChanges.isEmpty()) {
            return;
        }
        Query q = this.entityManager.createNamedQuery("ResourceAvailability.findByResourceIds");
        ArrayList<Integer> resourceIds = new ArrayList<Integer>(reportedChanges.size());
        for (Availability reported : reportedChanges) {
            resourceIds.add(reported.getResource().getId());
        }
        q.setParameter("resourceIds", resourceIds);
        List resourceAvailabilityList = q.getResultList();
        resourceIds.clear();
        resourceIds = null;
        HashMap<Integer, ResourceAvailability> resourceAvailabilities = new HashMap<Integer, ResourceAvailability>(reportedChanges.size());
        for (ResourceAvailability resourceAvailability : resourceAvailabilityList) {
            resourceAvailabilities.put(resourceAvailability.getResourceId(), resourceAvailability);
        }
        for (Availability reported : reportedChanges) {
            ResourceAvailability currentAvailability = (ResourceAvailability)resourceAvailabilities.get(reported.getResource().getId());
            this.updateResourceAvailabilityIfNecessary(reported, currentAvailability);
        }
        resourceAvailabilities.clear();
        resourceAvailabilities = null;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateLastAvailabilityReportInNewTransaction(int agentId) {
        Query query = this.entityManager.createNamedQuery("Agent.updateLastAvailReport");
        query.setParameter("reportTime", (Object)System.currentTimeMillis());
        query.setParameter("agentId", (Object)agentId);
        query.executeUpdate();
    }

    @Override
    public void updateAgentResourceAvailabilities(int agentId, AvailabilityType platformAvailType, AvailabilityType childAvailType) {
        platformAvailType = null == platformAvailType ? AvailabilityType.DOWN : platformAvailType;
        childAvailType = null == childAvailType ? AvailabilityType.UNKNOWN : childAvailType;
        Query query = this.entityManager.createNamedQuery("Availability.findPlatformCompositeByAgentAndNonmatchingType");
        query.setParameter("agentId", (Object)agentId);
        query.setParameter("availabilityType", (Object)platformAvailType);
        List platformResourcesWithStatus = query.getResultList();
        query = this.entityManager.createNamedQuery("Availability.findChildCompositeByAgentAndNonmatchingType");
        query.setParameter("agentId", (Object)agentId);
        query.setParameter("availabilityType", (Object)childAvailType);
        query.setParameter("disabled", (Object)AvailabilityType.DISABLED);
        List resourcesWithStatus = query.getResultList();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Agent #[" + agentId + "] is going to have [" + resourcesWithStatus.size() + "] resources backfilled with [" + childAvailType.getName() + "]"));
        }
        Date now = new Date();
        int newAvailsSize = platformResourcesWithStatus.size() + resourcesWithStatus.size();
        ArrayList<Availability> newAvailabilities = new ArrayList<Availability>(newAvailsSize);
        if (!platformResourcesWithStatus.isEmpty()) {
            Availability newAvailabilityInterval = this.getNewInterval((ResourceIdWithAvailabilityComposite)platformResourcesWithStatus.get(0), now, platformAvailType);
            if (newAvailabilityInterval != null) {
                newAvailabilities.add(newAvailabilityInterval);
            }
            this.resourceAvailabilityManager.updateAgentResourcesLatestAvailability(agentId, platformAvailType, true);
        }
        for (ResourceIdWithAvailabilityComposite record : resourcesWithStatus) {
            Availability newAvailabilityInterval = this.getNewInterval(record, now, childAvailType);
            if (newAvailabilityInterval == null) continue;
            newAvailabilities.add(newAvailabilityInterval);
        }
        this.resourceAvailabilityManager.updateAgentResourcesLatestAvailability(agentId, childAvailType, false);
        this.notifyAlertConditionCacheManager("setAllAgentResourceAvailabilities", newAvailabilities.toArray(new Availability[newAvailabilities.size()]));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Resources for agent #[" + agentId + "] have been fully backfilled."));
        }
    }

    private Availability getNewInterval(ResourceIdWithAvailabilityComposite record, Date startDate, AvailabilityType aType) {
        Availability old = record.getAvailability();
        if (old != null) {
            if (old.getAvailabilityType() == aType) {
                old.setEndTime(null);
                return null;
            }
            old.setEndTime(Long.valueOf(startDate.getTime()));
        }
        org.rhq.core.domain.resource.Resource resource = new org.rhq.core.domain.resource.Resource();
        resource.setId(record.getResourceId());
        Availability newAvail = new Availability(resource, Long.valueOf(startDate.getTime()), aType);
        this.entityManager.persist((Object)newAvail);
        return newAvail;
    }

    private void insertAvailability(Availability toInsert) {
        Availability existing;
        Query query = this.entityManager.createNamedQuery("Availability.findByResourceAndDate");
        query.setParameter("resourceId", (Object)toInsert.getResource().getId());
        query.setParameter("aTime", (Object)toInsert.getStartTime());
        try {
            existing = (Availability)query.getSingleResult();
        }
        catch (NoResultException nre) {
            this.log.warn((Object)("Resource [" + toInsert.getResource() + "] has no Availabilities, this should not happen.  Correcting situation by adding an Availability."));
            query = this.entityManager.createNamedQuery("Availability.findByResource");
            query.setParameter("resourceId", (Object)toInsert.getResource().getId());
            query.setMaxResults(1);
            Availability firstAvail = (Availability)query.getResultList().get(0);
            if (firstAvail.getAvailabilityType() != toInsert.getAvailabilityType()) {
                toInsert.setEndTime(firstAvail.getStartTime());
                this.entityManager.persist((Object)toInsert);
            } else {
                firstAvail.setStartTime(toInsert.getStartTime());
            }
            return;
        }
        catch (NonUniqueResultException nure) {
            this.log.warn((Object)("Resource [" + toInsert.getResource() + "] received a duplicate Availability. It is being ignored: " + toInsert));
            return;
        }
        if (existing.getAvailabilityType() != toInsert.getAvailabilityType()) {
            query = this.entityManager.createNamedQuery("Availability.findByResourceAndDate");
            query.setParameter("resourceId", (Object)toInsert.getResource().getId());
            query.setParameter("aTime", (Object)(existing.getEndTime() + 1L));
            Availability afterExisting = (Availability)query.getSingleResult();
            if (toInsert.getAvailabilityType() == afterExisting.getAvailabilityType()) {
                if (existing.getStartTime() == toInsert.getStartTime()) {
                    this.entityManager.remove((Object)existing);
                } else {
                    existing.setEndTime(toInsert.getStartTime());
                }
                afterExisting.setStartTime(toInsert.getStartTime());
            } else if (existing.getStartTime() == toInsert.getStartTime()) {
                existing.setAvailabilityType(toInsert.getAvailabilityType());
            } else {
                existing.setEndTime(toInsert.getStartTime());
                toInsert.setEndTime(afterExisting.getStartTime());
                this.entityManager.persist((Object)toInsert);
            }
        }
    }

    @Override
    @Deprecated
    public List<Availability> findAvailabilityWithinInterval(int resourceId, Date startDate, Date endDate) {
        Query q = this.entityManager.createNamedQuery("Availability.findForResourceWithinInterval");
        q.setParameter("resourceId", (Object)resourceId);
        q.setParameter("start", (Object)startDate.getTime());
        q.setParameter("end", (Object)endDate.getTime());
        List results = q.getResultList();
        return results;
    }

    @Override
    public PageList<Availability> findAvailabilityByCriteria(Subject subject, AvailabilityCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList result = queryRunner.execute();
        return result;
    }

    private List<Availability> findResourceGroupAvailabilityWithinInterval(int groupId, Date startDate, Date endDate) {
        Query q = this.entityManager.createNamedQuery("Availability.findForResourceGroupWithinInterval");
        q.setParameter("groupId", (Object)groupId);
        q.setParameter("start", (Object)startDate.getTime());
        q.setParameter("end", (Object)endDate.getTime());
        List results = q.getResultList();
        return results;
    }

    private List<Availability> findAutoGroupAvailabilityWithinInterval(int parentResourceId, int resourceTypeId, Date startDate, Date endDate) {
        Query q = this.entityManager.createNamedQuery("Availability.findForAutoGroupWithinInterval");
        q.setParameter("parentId", (Object)parentResourceId);
        q.setParameter("typeId", (Object)resourceTypeId);
        q.setParameter("start", (Object)startDate.getTime());
        q.setParameter("end", (Object)endDate.getTime());
        List results = q.getResultList();
        return results;
    }

    @Override
    @Deprecated
    public PageList<Availability> findAvailabilityForResource(Subject subject, int resourceId, PageControl pageControl) {
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view Availability history for resource[id=" + resourceId + "]");
        }
        pageControl.initDefaultOrderingField("av.startTime", PageOrdering.DESC);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Availability.findByResourceNoSort");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Availability.findByResourceNoSort", (PageControl)pageControl);
        countQuery.setParameter("resourceId", (Object)resourceId);
        query.setParameter("resourceId", (Object)resourceId);
        long count = (Long)countQuery.getSingleResult();
        List availabilities = query.getResultList();
        return new PageList((Collection)availabilities, (int)count, pageControl);
    }

    private void notifyAlertConditionCacheManager(String callingMethod, Availability ... availabilities) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(availabilities);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(callingMethod + ": " + stats.toString()));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void scheduleAvailabilityDurationCheck(AvailabilityDurationCacheElement cacheElement, org.rhq.core.domain.resource.Resource resource, long startTime) {
        String operator = cacheElement.getAlertConditionOperator().name();
        String durationString = (String)cacheElement.getAlertConditionOperatorOption();
        long duration = Long.valueOf(durationString) * 1000L;
        if (this.log.isDebugEnabled()) {
            Date jobTime = new Date(System.currentTimeMillis() + duration);
            this.log.debug((Object)("Scheduling availability duration job for [" + DateFormat.getDateTimeInstance().format(jobTime) + "]"));
        }
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("alertConditionId", String.valueOf(cacheElement.getAlertConditionTriggerId()));
        infoMap.put("resourceId", String.valueOf(resource.getId()));
        infoMap.put("alertConditionOperator", operator);
        infoMap.put("duration", durationString);
        infoMap.put("startTime", String.valueOf(startTime));
        this.timerService.createSingleActionTimer(duration, new TimerConfig(infoMap, false));
    }

    @Timeout
    public void handleAvailabilityDurationCheck(Timer timer) {
        try {
            AlertAvailabilityDurationJob.execute((HashMap)timer.getInfo());
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to handle availability duration timer - will try again later. Cause: " + t));
        }
    }

    static {
        int mergeBatchSize = 200;
        try {
            mergeBatchSize = Integer.parseInt(System.getProperty("rhq.server.availability.merge.batch.size", "200"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MERGE_BATCH_SIZE = mergeBatchSize > 999 ? 999 : mergeBatchSize;
    }

    static class MergeInfo {
        private AvailabilityReport report;
        private int numInserted = 0;
        private boolean askForFullReport = false;

        public MergeInfo(AvailabilityReport report) {
            this.report = report;
        }

        public int getNumInserted() {
            return this.numInserted;
        }

        public void incrementNumInserted() {
            ++this.numInserted;
        }

        public boolean isAskForFullReport() {
            return this.askForFullReport;
        }

        public void setAskForFullReport(boolean askForFullReport) {
            this.askForFullReport = askForFullReport;
        }

        public boolean isEnablementReport() {
            return this.report.isEnablementReport();
        }

        public boolean isServerSideReport() {
            return this.report.isServerSideReport();
        }

        public String toString(boolean includeAll) {
            return this.report.toString(includeAll);
        }
    }

    private static class SurrogateAvailability
    extends Availability {
        private static final long serialVersionUID = 1L;

        public SurrogateAvailability(org.rhq.core.domain.resource.Resource resource, Long startTime) {
            super(resource, startTime, null);
        }
    }
}

