/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.drift;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.drift.DriftServerPluginFacet;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class DriftServerPluginManager
extends ServerPluginManager {
    private final Log log = LogFactory.getLog(this.getClass());

    public DriftServerPluginManager(DriftServerPluginContainer pc) {
        super(pc);
    }

    public DriftServerPluginFacet getDriftServerPluginComponent() {
        Properties sysConfig = this.getSysConfig();
        String pluginName = sysConfig.getProperty(RHQConstants.ACTIVE_DRIFT_PLUGIN);
        if (pluginName == null) {
            throw new RuntimeException(RHQConstants.ACTIVE_DRIFT_PLUGIN + " system configuration property is not set.");
        }
        return (DriftServerPluginFacet)((Object)this.getServerPluginComponent(pluginName));
    }

    private Properties getSysConfig() {
        SubjectManagerLocal subjectMgr = LookupUtil.getSubjectManager();
        SystemManagerLocal systemMgr = LookupUtil.getSystemManager();
        return systemMgr.getSystemConfiguration(subjectMgr.getOverlord());
    }
}

