/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.purge;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.enterprise.server.purge.PurgeTemplate;

class AlertNotificationLogPurge
extends PurgeTemplate<Integer> {
    private static final String ENTITY_NAME = "AlertNotificationLog";
    private static final String QUERY_SELECT_KEYS_FOR_PURGE = "SELECT nl.ID FROM RHQ_ALERT_NOTIF_LOG nl, RHQ_ALERT a WHERE nl.ALERT_ID = a.ID and a.CTIME BETWEEN ? AND ?";
    private static final String QUERY_PURGE_BY_KEY = "DELETE FROM RHQ_ALERT_NOTIF_LOG WHERE ID = ?";
    private final long beginTime;
    private final long endTime;

    AlertNotificationLogPurge(DataSource dataSource, UserTransaction userTransaction, long beginTime, long endTime) {
        super(dataSource, userTransaction);
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    @Override
    protected String getEntityName() {
        return ENTITY_NAME;
    }

    @Override
    protected String getFindRowKeysQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_SELECT_KEYS_FOR_PURGE;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setFindRowKeysQueryParams(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setLong(1, this.beginTime);
        preparedStatement.setLong(2, this.endTime);
    }

    @Override
    protected Integer getKeyFromResultSet(ResultSet resultSet) throws SQLException {
        return resultSet.getInt(1);
    }

    @Override
    protected String getDeleteRowByKeyQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_PURGE_BY_KEY;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setDeleteRowByKeyQueryParams(PreparedStatement preparedStatement, Integer key) throws SQLException {
        preparedStatement.setInt(1, key);
    }
}

