/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.purge;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.enterprise.server.purge.PurgeTemplate;

public class JPADriftFilePurge
extends PurgeTemplate<String> {
    private static final String ENTITY_NAME = "JPADriftFile";
    private static final String QUERY_SELECT_KEYS_FOR_PURGE = " SELECT    f.HASH_ID  FROM RHQ_DRIFT_FILE f  WHERE NOT EXISTS(SELECT                     1                   FROM RHQ_DRIFT o                   WHERE o.OLD_DRIFT_FILE = f.HASH_ID)        AND NOT EXISTS(SELECT                         1                       FROM RHQ_DRIFT n                       WHERE n.NEW_DRIFT_FILE = f.HASH_ID)        AND f.CTIME < ? ";
    private static final String QUERY_PURGE_BY_KEY = "DELETE FROM RHQ_DRIFT_FILE WHERE hash_id = ?";
    private final long deleteUpToTime;

    JPADriftFilePurge(DataSource dataSource, UserTransaction userTransaction, long deleteUpToTime) {
        super(dataSource, userTransaction);
        this.deleteUpToTime = deleteUpToTime;
    }

    @Override
    protected String getEntityName() {
        return ENTITY_NAME;
    }

    @Override
    protected String getFindRowKeysQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_SELECT_KEYS_FOR_PURGE;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setFindRowKeysQueryParams(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setLong(1, this.deleteUpToTime);
    }

    @Override
    protected String getKeyFromResultSet(ResultSet resultSet) throws SQLException {
        return resultSet.getString(1);
    }

    @Override
    protected String getDeleteRowByKeyQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_PURGE_BY_KEY;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setDeleteRowByKeyQueryParams(PreparedStatement preparedStatement, String key) throws SQLException {
        preparedStatement.setString(1, key);
    }
}

