/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.purge;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.enterprise.server.purge.PurgeTemplate;

class MeasurementDataTraitPurge
extends PurgeTemplate<MeasurementDataPK> {
    private static final String ENTITY_NAME = "MeasurementDataTrait";
    private static final String QUERY_SELECT_KEYS_FOR_PURGE = "SELECT schedule_id, time_stamp FROM rhq_measurement_data_trait WHERE EXISTS   (SELECT t2.schedule_id, t2.time_stamp    FROM rhq_measurement_data_trait t2,      (SELECT max(t4.time_stamp) as mx, t4.schedule_id as schedule_id       FROM rhq_measurement_data_trait t4       WHERE t4.time_stamp < ?       GROUP BY t4.schedule_id) t3    WHERE t2.schedule_id = t3.schedule_id    AND t2.time_stamp < t3.mx    AND rhq_measurement_data_trait.time_stamp = t2.time_stamp    AND rhq_measurement_data_trait.schedule_id = t2.schedule_id) ";
    private static final String QUERY_PURGE_BY_KEY = "DELETE FROM rhq_measurement_data_trait WHERE schedule_id = ? AND time_stamp = ?";
    private final long oldest;

    MeasurementDataTraitPurge(DataSource dataSource, UserTransaction userTransaction, long oldest) {
        super(dataSource, userTransaction);
        this.oldest = oldest;
    }

    @Override
    protected String getEntityName() {
        return ENTITY_NAME;
    }

    @Override
    protected String getFindRowKeysQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_SELECT_KEYS_FOR_PURGE;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setFindRowKeysQueryParams(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setLong(1, this.oldest);
    }

    @Override
    protected MeasurementDataPK getKeyFromResultSet(ResultSet resultSet) throws SQLException {
        return new MeasurementDataPK(resultSet.getLong(2), resultSet.getInt(1));
    }

    @Override
    protected String getDeleteRowByKeyQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_PURGE_BY_KEY;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setDeleteRowByKeyQueryParams(PreparedStatement preparedStatement, MeasurementDataPK key) throws SQLException {
        preparedStatement.setInt(1, key.getScheduleId());
        preparedStatement.setLong(2, key.getTimestamp());
    }
}

