/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.purge;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.enterprise.server.purge.PurgeTemplate;

class MeasurementOOBPurge
extends PurgeTemplate<Integer> {
    private static final String ENTITY_NAME = "MeasurementOOB";
    private static final String QUERY_SELECT_KEYS_FOR_PURGE = "SELECT SCHEDULE_ID FROM RHQ_MEASUREMENT_BLINE WHERE BL_COMPUTE_TIME > ?";
    private static final String QUERY_PURGE_BY_KEY = "DELETE FROM RHQ_MEASUREMENT_OOB WHERE SCHEDULE_ID = ?";
    private final long cutoffTime;

    MeasurementOOBPurge(DataSource dataSource, UserTransaction userTransaction, long cutoffTime) {
        super(dataSource, userTransaction);
        this.cutoffTime = cutoffTime;
    }

    @Override
    protected String getEntityName() {
        return ENTITY_NAME;
    }

    @Override
    protected String getFindRowKeysQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_SELECT_KEYS_FOR_PURGE;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setFindRowKeysQueryParams(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setLong(1, this.cutoffTime);
    }

    @Override
    protected Integer getKeyFromResultSet(ResultSet resultSet) throws SQLException {
        return resultSet.getInt(1);
    }

    @Override
    protected String getDeleteRowByKeyQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_PURGE_BY_KEY;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setDeleteRowByKeyQueryParams(PreparedStatement preparedStatement, Integer key) throws SQLException {
        preparedStatement.setInt(1, key);
    }
}

