/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.purge;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.core.util.stream.StreamUtil;

abstract class PurgeTemplate<KEY extends Serializable> {
    private static final Log LOG = LogFactory.getLog(PurgeTemplate.class);
    private static final String BATCH_SIZE_SYSTEM_PROPERTY = "org.rhq.enterprise.server.purge.PurgeTemplate.BATCH_SIZE";
    private static final int BATCH_SIZE = Integer.getInteger("org.rhq.enterprise.server.purge.PurgeTemplate.BATCH_SIZE", 30000);
    private final DataSource dataSource;
    private final UserTransaction userTransaction;
    private final DatabaseType databaseType;

    public PurgeTemplate(DataSource dataSource, UserTransaction userTransaction) {
        this.dataSource = dataSource;
        this.userTransaction = userTransaction;
        this.databaseType = DatabaseTypeFactory.getDefaultDatabaseType();
    }

    protected abstract String getEntityName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        int deleted = 0;
        KeysInfo keysInfo = null;
        ObjectInputStream keysStream = null;
        try {
            keysInfo = this.loadKeys();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loaded " + keysInfo.count + " key(s) of " + this.getEntityName()));
            }
            keysStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(keysInfo.keysFile)));
            ArrayList<Serializable> selectedKeys = new ArrayList<Serializable>(BATCH_SIZE);
            for (int i = 1; i <= keysInfo.count; ++i) {
                Serializable key = (Serializable)keysStream.readObject();
                selectedKeys.add(key);
                if (selectedKeys.size() != BATCH_SIZE && i != keysInfo.count) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Deleting " + selectedKeys.size() + " row(s) of " + this.getEntityName()));
                }
                deleted += this.deleteRows(selectedKeys);
                selectedKeys.clear();
            }
            this.rollbackIfTransactionActive();
        }
        catch (Exception e) {
            try {
                LOG.error((Object)(this.getEntityName() + ": could not fully process the batched purge"), (Throwable)e);
                this.rollbackIfTransactionActive();
            }
            catch (Throwable throwable) {
                this.rollbackIfTransactionActive();
                StreamUtil.safeClose(keysStream);
                if (keysInfo != null && keysInfo.keysFile != null) {
                    keysInfo.keysFile.delete();
                }
                throw throwable;
            }
            StreamUtil.safeClose((Closeable)keysStream);
            if (keysInfo != null && keysInfo.keysFile != null) {
                keysInfo.keysFile.delete();
            }
        }
        StreamUtil.safeClose((Closeable)keysStream);
        if (keysInfo != null && keysInfo.keysFile != null) {
            keysInfo.keysFile.delete();
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeysInfo loadKeys() throws Exception {
        File keysFile = File.createTempFile(this.getClass().getSimpleName(), null);
        int count = 0;
        ObjectOutputStream objectOutputStream = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(keysFile)));
            this.userTransaction.begin();
            String findRowKeysQuery = this.getFindRowKeysQuery(this.databaseType);
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(findRowKeysQuery);
            this.setFindRowKeysQueryParams(preparedStatement);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                objectOutputStream.writeObject(this.getKeyFromResultSet(resultSet));
                ++count;
            }
            this.userTransaction.commit();
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(connection, preparedStatement, resultSet);
            StreamUtil.safeClose(objectOutputStream);
            this.rollbackIfTransactionActive();
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)connection, (Statement)preparedStatement, (ResultSet)resultSet);
        StreamUtil.safeClose((Closeable)objectOutputStream);
        this.rollbackIfTransactionActive();
        return new KeysInfo(keysFile, count);
    }

    protected abstract String getFindRowKeysQuery(DatabaseType var1);

    protected abstract void setFindRowKeysQueryParams(PreparedStatement var1) throws SQLException;

    protected abstract KEY getKeyFromResultSet(ResultSet var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteRows(List<KEY> selectedKeys) throws Exception {
        int n;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            this.userTransaction.begin();
            String deleteRowByKeyQuery = this.getDeleteRowByKeyQuery(this.databaseType);
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement(deleteRowByKeyQuery);
            for (Serializable key : selectedKeys) {
                this.setDeleteRowByKeyQueryParams(preparedStatement, key);
                preparedStatement.addBatch();
            }
            int[] batchResults = preparedStatement.executeBatch();
            this.userTransaction.commit();
            n = this.evalDeletedRows(batchResults);
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose(connection, preparedStatement, null);
            this.rollbackIfTransactionActive();
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)connection, (Statement)preparedStatement, null);
        this.rollbackIfTransactionActive();
        return n;
    }

    protected abstract String getDeleteRowByKeyQuery(DatabaseType var1);

    protected abstract void setDeleteRowByKeyQueryParams(PreparedStatement var1, KEY var2) throws SQLException;

    private void rollbackIfTransactionActive() {
        try {
            if (this.userTransaction.getStatus() == 0) {
                this.userTransaction.rollback();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int evalDeletedRows(int[] results) {
        int total = 0;
        int failed = 0;
        for (int result : results) {
            if (result == -3) {
                ++failed;
                continue;
            }
            if (result == -2) {
                ++total;
                continue;
            }
            total += result;
        }
        if (failed > 0) {
            LOG.warn((Object)(this.getEntityName() + ": " + failed + " row(s) not purged"));
        }
        return total;
    }

    static {
        LOG.info((Object)("org.rhq.enterprise.server.purge.PurgeTemplate.BATCH_SIZE = " + BATCH_SIZE));
    }

    private static class KeysInfo {
        final File keysFile;
        final int count;

        private KeysInfo(File keysFile, int count) {
            this.keysFile = keysFile;
            this.count = count;
        }
    }
}

