/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.purge;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.enterprise.server.purge.PurgeTemplate;

public class ResourceConfigurationUpdateFromGroupPurge
extends PurgeTemplate<Integer> {
    private static final String ENTITY_NAME = "ResourceConfigurationUpdateFromGroup";
    private static final String QUERY_SELECT_KEYS_FOR_PURGE = "   SELECT    u.CONFIGURATION_ID  FROM    RHQ_CONFIG_UPDATE u  WHERE    u.AGG_RES_UPDATE_ID IN(      SELECT        gu.ID      FROM        RHQ_CONFIG_GROUP_UPDATE gu      WHERE        gu.DTYPE = 'resource'        AND gu.MTIME < ?        AND NOT EXISTS(            SELECT              1            FROM              RHQ_CONFIG_UPDATE u, RHQ_RESOURCE r            WHERE              gu.ID = u.AGG_RES_UPDATE_ID              AND u.CONFIG_RES_ID = r.ID              AND u.CONFIGURATION_ID = r.RES_CONFIGURATION_ID        )        AND NOT EXISTS(            SELECT              1            FROM              RHQ_CONFIG_UPDATE uu            WHERE              gu.DTYPE = uu.DTYPE              AND gu.ID = uu.AGG_RES_UPDATE_ID              AND NOT EXISTS(                  SELECT                    1                  FROM                    RHQ_CONFIG_UPDATE uuu                  WHERE                    uu.CONFIG_RES_ID = uuu.CONFIG_RES_ID                    AND uuu.STATUS = 'SUCCESS'                    AND(uuu.AGG_RES_UPDATE_ID IS NULL OR uuu.AGG_RES_UPDATE_ID <> gu.ID)                    AND uuu.MTIME > uu.MTIME              )        )    ) ";
    private static final String QUERY_PURGE_BY_KEY = "DELETE FROM RHQ_CONFIG WHERE ID = ?";
    private final long deleteUpToTime;

    ResourceConfigurationUpdateFromGroupPurge(DataSource dataSource, UserTransaction userTransaction, long deleteUpToTime) {
        super(dataSource, userTransaction);
        this.deleteUpToTime = deleteUpToTime;
    }

    @Override
    protected String getEntityName() {
        return ENTITY_NAME;
    }

    @Override
    protected String getFindRowKeysQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_SELECT_KEYS_FOR_PURGE;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setFindRowKeysQueryParams(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setLong(1, this.deleteUpToTime);
    }

    @Override
    protected Integer getKeyFromResultSet(ResultSet resultSet) throws SQLException {
        return resultSet.getInt(1);
    }

    @Override
    protected String getDeleteRowByKeyQuery(DatabaseType databaseType) {
        if (DatabaseTypeFactory.isPostgres((DatabaseType)databaseType) || DatabaseTypeFactory.isOracle((DatabaseType)databaseType)) {
            return QUERY_PURGE_BY_KEY;
        }
        throw new UnsupportedOperationException(databaseType.getName());
    }

    @Override
    protected void setDeleteRowByKeyQueryParams(PreparedStatement preparedStatement, Integer key) throws SQLException {
        preparedStatement.setInt(1, key);
    }
}

