/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.PlatformMetricsSummary;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.resource.PlatformUtilizationManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.util.CriteriaQuery;
import org.rhq.enterprise.server.util.CriteriaQueryExecutor;

@Stateless
public class PlatformUtilizationManagerBean
implements PlatformUtilizationManagerLocal {
    @EJB
    private ResourceTypeManagerLocal resourceTypeMgr;
    @EJB
    private ResourceManagerLocal resourceMgr;
    @EJB
    private MeasurementDataManagerLocal measurementDataMgr;
    @EJB
    private PlatformUtilizationManagerLocal platformUtilizationMgr;

    @Override
    public PageList<PlatformMetricsSummary> loadPlatformMetrics(final Subject subject) {
        final ResourceTypeCriteria typeCriteria = new ResourceTypeCriteria();
        typeCriteria.addFilterIgnored(false);
        typeCriteria.addFilterCategory(ResourceCategory.PLATFORM);
        typeCriteria.fetchMetricDefinitions(true);
        CriteriaQueryExecutor<ResourceType, ResourceTypeCriteria> queryExecutor = new CriteriaQueryExecutor<ResourceType, ResourceTypeCriteria>(){

            @Override
            public PageList<ResourceType> execute(ResourceTypeCriteria criteria) {
                return PlatformUtilizationManagerBean.this.resourceTypeMgr.findResourceTypesByCriteria(subject, typeCriteria);
            }
        };
        CriteriaQuery<ResourceType, ResourceTypeCriteria> resourceTypes = new CriteriaQuery<ResourceType, ResourceTypeCriteria>(typeCriteria, queryExecutor);
        HashMap<Integer, Set<Integer>> platformMetricDefs = new HashMap<Integer, Set<Integer>>();
        for (ResourceType resourceType : resourceTypes) {
            platformMetricDefs.put(resourceType.getId(), this.getPlatformMetricDefIds(resourceType));
        }
        final ResourceCriteria resourceCriteria = new ResourceCriteria();
        resourceCriteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.PLATFORM});
        resourceCriteria.addFilterInventoryStatus(InventoryStatus.COMMITTED);
        resourceCriteria.fetchCurrentAvailability(true);
        CriteriaQueryExecutor<Resource, ResourceCriteria> resourceQueryExecutor = new CriteriaQueryExecutor<Resource, ResourceCriteria>(){

            @Override
            public PageList<Resource> execute(ResourceCriteria criteria) {
                return PlatformUtilizationManagerBean.this.resourceMgr.findResourcesByCriteria(subject, resourceCriteria);
            }
        };
        CriteriaQuery<Resource, ResourceCriteria> platforms = new CriteriaQuery<Resource, ResourceCriteria>(resourceCriteria, resourceQueryExecutor);
        PageList summaries = new PageList();
        for (Resource platform : platforms) {
            Set metricDefIds = (Set)platformMetricDefs.get(platform.getResourceType().getId());
            try {
                if (AvailabilityType.UP == platform.getCurrentAvailability().getAvailabilityType()) {
                    Set<MeasurementData> measurementDataSet = this.platformUtilizationMgr.loadLiveMetricsForPlatformInNewTransaction(subject, platform, metricDefIds, 10000L);
                    summaries.add((Object)this.createSummary(platform, measurementDataSet));
                    continue;
                }
                summaries.add((Object)this.createSummary(platform, null));
            }
            catch (RuntimeException e) {
                PlatformMetricsSummary summary = new PlatformMetricsSummary();
                summary.setResource(platform);
                summary.setMetricsAvailable(false);
                summaries.add((Object)summary);
            }
        }
        return summaries;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Set<MeasurementData> loadLiveMetricsForPlatformInNewTransaction(Subject subject, Resource platform, Set<Integer> metricDefinitionIds, Long timeout) {
        return this.measurementDataMgr.findLiveData(subject, platform.getId(), ArrayUtils.unwrapArray((Integer[])metricDefinitionIds.toArray(new Integer[metricDefinitionIds.size()])), timeout);
    }

    private Set<Integer> getPlatformMetricDefIds(ResourceType resourceType) {
        TreeSet<Integer> metricDefIds = new TreeSet<Integer>();
        List<String> metricDefNames = Arrays.asList(PlatformMetricsSummary.MemoryMetric.Used.getProperty(), PlatformMetricsSummary.MemoryMetric.ActualUsed.getProperty(), PlatformMetricsSummary.MemoryMetric.Free.getProperty(), PlatformMetricsSummary.MemoryMetric.ActualFree.getProperty(), PlatformMetricsSummary.MemoryMetric.Total.getProperty(), PlatformMetricsSummary.CPUMetric.Idle.getProperty(), PlatformMetricsSummary.CPUMetric.System.getProperty(), PlatformMetricsSummary.CPUMetric.User.getProperty(), PlatformMetricsSummary.SwapMetric.Free.getProperty(), PlatformMetricsSummary.SwapMetric.Used.getProperty(), PlatformMetricsSummary.SwapMetric.Total.getProperty());
        for (String metricDefName : metricDefNames) {
            Integer metricDefId = this.findMetricDefId(resourceType.getMetricDefinitions(), metricDefName);
            if (metricDefId == null) continue;
            metricDefIds.add(metricDefId);
        }
        return metricDefIds;
    }

    private Integer findMetricDefId(Set<MeasurementDefinition> measurementDefs, String name) {
        for (MeasurementDefinition definition : measurementDefs) {
            if (!name.equals(definition.getName())) continue;
            return definition.getId();
        }
        return null;
    }

    private PlatformMetricsSummary createSummary(Resource resource, Set<MeasurementData> measurementDataSet) {
        PlatformMetricsSummary summary = new PlatformMetricsSummary();
        summary.setResource(resource);
        if (null == measurementDataSet || measurementDataSet.isEmpty()) {
            summary.setMetricsAvailable(false);
        } else {
            summary.setIdleCPU(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.CPUMetric.Idle.getProperty()));
            summary.setSystemCPU(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.CPUMetric.System.getProperty()));
            summary.setUserCPU(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.CPUMetric.User.getProperty()));
            summary.setFreeMemory(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.MemoryMetric.Free.getProperty()));
            summary.setActualFreeMemory(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.MemoryMetric.ActualFree.getProperty()));
            summary.setUsedMemory(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.MemoryMetric.Used.getProperty()));
            summary.setActualUsedMemory(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.MemoryMetric.ActualUsed.getProperty()));
            summary.setTotalMemory(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.MemoryMetric.Total.getProperty()));
            summary.setFreeSwap(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.SwapMetric.Free.getProperty()));
            summary.setTotalSwap(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.SwapMetric.Total.getProperty()));
            summary.setUsedSwap(this.findMeasurementData(measurementDataSet, PlatformMetricsSummary.SwapMetric.Used.getProperty()));
        }
        return summary;
    }

    private MeasurementData findMeasurementData(Set<MeasurementData> measurementDataSet, String name) {
        for (MeasurementData measurementData : measurementDataSet) {
            if (!name.equals(measurementData.getName())) continue;
            return measurementData;
        }
        return null;
    }
}

