/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.disambiguation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.rhq.enterprise.server.resource.disambiguation.DisambiguationPolicy;
import org.rhq.enterprise.server.resource.disambiguation.MutableDisambiguationReport;

public class ReportPartitions<T> {
    private static final long serialVersionUID = 1L;
    private DisambiguationPolicy disambiguationPolicy;
    private List<List<MutableDisambiguationReport<T>>> uniquePartitions;
    private List<List<MutableDisambiguationReport<T>>> ambiguousPartitions;

    public ReportPartitions(DisambiguationPolicy disambiguationPolicy) {
        this.disambiguationPolicy = disambiguationPolicy;
        this.uniquePartitions = new ArrayList<List<MutableDisambiguationReport<T>>>();
        this.ambiguousPartitions = new ArrayList<List<MutableDisambiguationReport<T>>>();
    }

    public ReportPartitions(DisambiguationPolicy disambiguationPolicy, ReportPartitions<T> other) {
        this(disambiguationPolicy);
        this.putAll(other);
    }

    public ReportPartitions(DisambiguationPolicy disambiguationPolicy, List<List<MutableDisambiguationReport<T>>> partitions) {
        this(disambiguationPolicy);
        for (List<MutableDisambiguationReport<T>> partition : partitions) {
            this.putAll(partition);
        }
    }

    public DisambiguationPolicy getDisambiguationPolicy() {
        return this.disambiguationPolicy;
    }

    public List<List<MutableDisambiguationReport<T>>> getAmbiguousPartitions() {
        return Collections.unmodifiableList(this.ambiguousPartitions);
    }

    public List<List<MutableDisambiguationReport<T>>> getUniquePartitions() {
        return Collections.unmodifiableList(this.uniquePartitions);
    }

    public List<List<MutableDisambiguationReport<T>>> getAllPartitions() {
        ArrayList<List<MutableDisambiguationReport<T>>> ret = new ArrayList<List<MutableDisambiguationReport<T>>>(this.ambiguousPartitions);
        ret.addAll(this.uniquePartitions);
        return Collections.unmodifiableList(ret);
    }

    public void put(MutableDisambiguationReport<T> value) {
        this.put(value, true);
    }

    public void putAll(List<MutableDisambiguationReport<T>> values) {
        for (MutableDisambiguationReport<T> v : values) {
            this.put(v, false);
        }
        this.updatePolicy();
    }

    public void putAll(ReportPartitions<T> other) {
        for (List<MutableDisambiguationReport<T>> partition : other.getAllPartitions()) {
            for (MutableDisambiguationReport<T> v : partition) {
                this.put(v, false);
            }
        }
        this.updatePolicy();
    }

    public boolean isPartitionsUnique() {
        return this.ambiguousPartitions.size() == 0;
    }

    public String toString() {
        return "ReportPartitions[policy=" + this.disambiguationPolicy + ", uniquePartitions=" + this.uniquePartitions + ", ambiguousPartitions=" + this.ambiguousPartitions + "]";
    }

    private void put(MutableDisambiguationReport<T> value, boolean updatePolicy) {
        if (this.insertIntoExisting(value, this.ambiguousPartitions) >= 0) {
            return;
        }
        int idx = this.insertIntoExisting(value, this.uniquePartitions);
        if (idx >= 0) {
            this.ambiguousPartitions.add(this.uniquePartitions.remove(idx));
        } else {
            ArrayList<MutableDisambiguationReport<T>> newPartition = new ArrayList<MutableDisambiguationReport<T>>();
            newPartition.add(value);
            this.uniquePartitions.add(newPartition);
        }
        if (updatePolicy) {
            this.updatePolicy();
        }
    }

    private void updatePolicy() {
        this.disambiguationPolicy.getCurrentLevel().setDeciding(this.uniquePartitions.size() > 0);
    }

    private int insertIntoExisting(MutableDisambiguationReport<T> value, List<List<MutableDisambiguationReport<T>>> partitions) {
        int idx = -1;
        boolean found = false;
        for (List<MutableDisambiguationReport<T>> partition : partitions) {
            for (MutableDisambiguationReport<T> partitionPrototype : partition) {
                if (!this.disambiguationPolicy.areAmbiguous(partitionPrototype, value)) continue;
                found = true;
                break;
            }
            ++idx;
            if (!found) continue;
            partition.add(value);
            break;
        }
        return found ? idx : -1;
    }
}

