/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.group;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.naming.CompositeName;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.authz.Role;
import org.rhq.core.domain.common.composite.SystemSetting;
import org.rhq.core.domain.common.composite.SystemSettings;
import org.rhq.core.domain.resource.group.LdapGroup;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.exception.LdapCommunicationException;
import org.rhq.enterprise.server.exception.LdapFilterException;
import org.rhq.enterprise.server.resource.group.LDAPStringUtil;
import org.rhq.enterprise.server.resource.group.LdapGroupManagerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.security.UntrustedSSLSocketFactory;

@Stateless
public class LdapGroupManagerBean
implements LdapGroupManagerLocal {
    private Log log = LogFactory.getLog(LdapGroupManagerBean.class);
    private static final String BASEDN_DELIMITER = ";";
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private SystemManagerLocal systemManager;
    private static boolean groupQueryComplete = false;
    private static int groupQueryResultCount = 0;
    private static long groupQueryStartTime = -1L;
    private static long groupQueryCurrentTime = -1L;
    private static int groupQueryPageCount = 0;
    private static final int LDAP_GROUP_QUERY_LIMIT = 20000;

    private void resetGroupQueryDetails() {
        groupQueryComplete = false;
        groupQueryResultCount = 0;
        groupQueryStartTime = -1L;
        groupQueryCurrentTime = -1L;
        groupQueryPageCount = 0;
    }

    @Override
    public Set<Map<String, String>> findAvailableGroups() {
        Properties systemConfig = this.populateProperties(this.systemManager.getUnmaskedSystemSettings(true));
        this.resetGroupQueryDetails();
        String groupFilter = (String)systemConfig.get(SystemSetting.LDAP_GROUP_FILTER.name());
        if (groupFilter != null && !groupFilter.trim().isEmpty()) {
            String filter = groupFilter.startsWith("(") && groupFilter.endsWith(")") ? groupFilter : String.format("(%s)", groupFilter);
            return this.buildGroup(systemConfig, filter);
        }
        HashSet<Map<String, String>> emptyAvailableGroups = new HashSet<Map<String, String>>();
        return emptyAvailableGroups;
    }

    @Override
    public Set<Map<String, String>> findAvailableGroupsStatus() {
        HashSet<Map<String, String>> availableGroupsQueryStatus = new HashSet<Map<String, String>>();
        availableGroupsQueryStatus.add(this.buildStatusEntry("query.complete", String.valueOf(groupQueryComplete)));
        availableGroupsQueryStatus.add(this.buildStatusEntry("query.results.parsed", String.valueOf(groupQueryResultCount)));
        availableGroupsQueryStatus.add(this.buildStatusEntry("query.start.time", String.valueOf(groupQueryStartTime)));
        availableGroupsQueryStatus.add(this.buildStatusEntry("query.current.time", String.valueOf(groupQueryCurrentTime)));
        availableGroupsQueryStatus.add(this.buildStatusEntry("query.page.count", String.valueOf(groupQueryPageCount)));
        return availableGroupsQueryStatus;
    }

    private Map<String, String> buildStatusEntry(String key, String value) {
        HashMap<String, String> status = new HashMap<String, String>();
        status.put(key, value);
        return status;
    }

    @Override
    public Set<String> findAvailableGroupsFor(String userName) {
        Properties options = this.populateProperties(this.systemManager.getUnmaskedSystemSettings(true));
        String groupFilter = options.getProperty(SystemSetting.LDAP_GROUP_FILTER.name(), "");
        String groupMember = options.getProperty(SystemSetting.LDAP_GROUP_MEMBER.name(), "");
        String groupUsePosix = options.getProperty(SystemSetting.LDAP_GROUP_USE_POSIX.name(), "false");
        if (groupUsePosix == null) {
            groupUsePosix = Boolean.toString(false);
        }
        boolean usePosixGroups = Boolean.valueOf(groupUsePosix);
        String userAttribute = this.getUserAttribute(options, userName, usePosixGroups);
        HashSet<String> ldapSet = new HashSet<String>();
        if (groupFilter.trim().isEmpty() || groupMember.trim().isEmpty()) {
            this.log.warn((Object)("The ldap group filter defined is invalid. Group Filter: " + groupFilter + ", Group Member: " + groupMember));
            return ldapSet;
        }
        if (userAttribute != null && userAttribute.trim().length() > 0) {
            String filter = "";
            filter = String.format("(&(%s)(%s=%s))", groupFilter, groupMember, LDAPStringUtil.encodeForFilter(userAttribute));
            Set<Map<String, String>> matched = this.buildGroup(options, filter);
            this.log.trace((Object)("Located '" + matched.size() + "' LDAP groups for user '" + userName + "' using following ldap filter '" + filter + "'."));
            for (Map<String, String> match : matched) {
                ldapSet.add(match.get("id"));
            }
        } else {
            this.log.debug((Object)("Group lookup will not be performed due to no UserDN found for user " + userName));
        }
        return ldapSet;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void setLdapGroupsOnRole(Subject subject, int roleId, Set<LdapGroup> groups) {
        Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
        if (role == null) {
            throw new IllegalArgumentException("Role with id [" + roleId + "] does not exist.");
        }
        Set currentGroups = role.getLdapGroups();
        ArrayList<String> currentGroupNames = new ArrayList<String>(currentGroups.size());
        for (LdapGroup group : currentGroups) {
            currentGroupNames.add(group.getName());
        }
        ArrayList<String> newGroupNames = new ArrayList<String>(groups.size());
        for (LdapGroup group : groups) {
            newGroupNames.add(group.getName());
        }
        ArrayList<String> namesOfGroupsToBeAdded = new ArrayList<String>(newGroupNames);
        namesOfGroupsToBeAdded.removeAll(currentGroupNames);
        this.addLdapGroupsToRole(subject, roleId, namesOfGroupsToBeAdded);
        ArrayList namesOfGroupsToBeRemoved = new ArrayList(currentGroupNames);
        namesOfGroupsToBeRemoved.removeAll(newGroupNames);
        int[] idsOfGroupsToBeRemoved = new int[namesOfGroupsToBeRemoved.size()];
        int i = 0;
        for (LdapGroup group : currentGroups) {
            if (!namesOfGroupsToBeRemoved.contains(group.getName())) continue;
            idsOfGroupsToBeRemoved[i++] = group.getId();
        }
        this.removeLdapGroupsFromRole(subject, roleId, idsOfGroupsToBeRemoved);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void addLdapGroupsToRole(Subject subject, int roleId, List<String> groupNames) {
        if (groupNames != null && groupNames.size() > 0) {
            Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
            if (role == null) {
                throw new IllegalArgumentException("Could not find role[" + roleId + "] to add LDAP groups to.");
            }
            role.getLdapGroups().size();
            for (String groupId : groupNames) {
                LdapGroup group = new LdapGroup();
                group.setName(groupId);
                role.addLdapGroup(group);
            }
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SECURITY)
    public void removeLdapGroupsFromRole(Subject subject, int roleId, int[] groupIds) {
        if (groupIds != null && groupIds.length > 0) {
            Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
            if (role == null) {
                throw new IllegalArgumentException("Could not find role[" + roleId + "] to remove LDAP groups from.");
            }
            role.getLdapGroups().size();
            int[] arr$ = groupIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer groupId = arr$[i$];
                LdapGroup doomedGroup = (LdapGroup)this.entityManager.find(LdapGroup.class, (Object)groupId);
                if (doomedGroup == null) {
                    throw new IllegalArgumentException("Tried to remove doomedGroup[" + groupId + "] from role[" + roleId + "], but doomedGroup was not found.");
                }
                role.removeLdapGroup(doomedGroup);
            }
            Query purgeQuery = this.entityManager.createNamedQuery("LdapGroup.deleteById");
            LinkedList<Integer> ids = new LinkedList<Integer>();
            for (int i : groupIds) {
                ids.add(i);
            }
            purgeQuery.setParameter("ids", ids);
            purgeQuery.executeUpdate();
        }
    }

    private List<Role> findRolesByLdapGroupNames(List<String> ldapGroupNames) {
        if (ldapGroupNames.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Query query = this.entityManager.createNamedQuery("LdapGroup.findRolesByGroupNames");
        query.setParameter("names", ldapGroupNames);
        return query.getResultList();
    }

    @Override
    public void assignRolesToLdapSubject(int subjectId, List<String> ldapGroupNames) {
        Subject sub = (Subject)this.entityManager.find(Subject.class, (Object)subjectId);
        List<Role> roles = this.findRolesByLdapGroupNames(ldapGroupNames);
        sub.getRoles().clear();
        sub.getLdapRoles().clear();
        for (Role role : roles) {
            sub.addRole(role);
            sub.addLdapRole(role);
        }
    }

    @Override
    public PageList<LdapGroup> findLdapGroupsByRole(int roleId, PageControl pageControl) {
        Role role = (Role)this.entityManager.find(Role.class, (Object)roleId);
        if (role == null) {
            throw new IllegalArgumentException("Could not find role[" + roleId + "] to lookup ldap Groups on");
        }
        return new PageList((Collection)role.getLdapGroups(), role.getLdapGroups().size(), pageControl);
    }

    @Override
    public PageList<LdapGroup> findLdapGroups(PageControl pc) {
        pc.initDefaultOrderingField("g.name");
        String queryName = "LdapGroup.findAll";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        long count = (Long)queryCount.getSingleResult();
        List groups = query.getResultList();
        return new PageList((Collection)groups, (int)count, pc);
    }

    private String getUserAttribute(Properties options, String userName, boolean usePosixGroups) {
        Map<String, String> details = this.findLdapUserDetails(userName);
        String userAttribute = null;
        userAttribute = usePosixGroups ? userName : details.get("dn");
        return userAttribute;
    }

    @Override
    public Map<String, String> findLdapUserDetails(String userName) {
        Properties systemConfig = this.populateProperties(this.systemManager.getUnmaskedSystemSettings(true));
        HashMap<String, String> userDetails = new HashMap<String, String>();
        String baseDN = (String)systemConfig.get(SystemSetting.LDAP_BASE_DN.name());
        String loginProperty = (String)systemConfig.get(SystemSetting.LDAP_LOGIN_PROPERTY.name());
        if (loginProperty == null) {
            loginProperty = "cn";
        }
        String bindDN = (String)systemConfig.get(SystemSetting.LDAP_BIND_DN.name());
        String bindPW = (String)systemConfig.get(SystemSetting.LDAP_BIND_PW.name());
        String searchFilter = (String)systemConfig.get(SystemSetting.LDAP_FILTER.name());
        if (bindDN != null) {
            systemConfig.setProperty("java.naming.security.principal", bindDN);
            systemConfig.setProperty("java.naming.security.credentials", bindPW);
            systemConfig.setProperty("java.naming.security.authentication", "simple");
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(systemConfig, null);
            SearchControls searchControls = this.getSearchControls();
            String filter = searchFilter != null && searchFilter.length() != 0 ? "(&(" + loginProperty + "=" + userName + ")" + "(" + searchFilter + "))" : "(" + loginProperty + "=" + userName + ")";
            this.log.debug((Object)("Using LDAP filter [" + filter + "] to locate user details for " + userName));
            String[] baseDNs = baseDN.split(BASEDN_DELIMITER);
            for (int x = 0; x < baseDNs.length; ++x) {
                NamingEnumeration<SearchResult> answer = ctx.search(baseDNs[x], filter, searchControls);
                if (answer.hasMoreElements()) {
                    String userDN;
                    SearchResult si;
                    block9: {
                        si = answer.next();
                        userDN = null;
                        try {
                            userDN = si.getNameInNamespace();
                        }
                        catch (UnsupportedOperationException use) {
                            userDN = new CompositeName(si.getName()).get(0);
                            if (!si.isRelative()) break block9;
                            userDN = userDN + "," + baseDNs[x];
                        }
                    }
                    userDetails.put("dn", userDN);
                    NamingEnumeration<String> keys = si.getAttributes().getIDs();
                    while (keys.hasMore()) {
                        String key = keys.next();
                        Attribute value = si.getAttributes().get(key);
                        if (value == null || value.get() == null) continue;
                        userDetails.put(key, value.get().toString());
                    }
                    return userDetails;
                }
                this.log.debug((Object)("User " + userName + " not found for BaseDN " + baseDNs[x]));
            }
            return userDetails;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Boolean ldapServerRequiresAttention() {
        boolean requiresAttention = false;
        Properties systemConfig = this.populateProperties(this.systemManager.getUnmaskedSystemSettings(true));
        String loginProperty = (String)systemConfig.get(SystemSetting.LDAP_LOGIN_PROPERTY.name());
        if (loginProperty == null) {
            loginProperty = "cn";
        }
        String bindDN = (String)systemConfig.get(SystemSetting.LDAP_BIND_DN.name());
        String bindPW = (String)systemConfig.get(SystemSetting.LDAP_BIND_PW.name());
        if (bindDN != null) {
            systemConfig.setProperty("java.naming.security.principal", bindDN);
            systemConfig.setProperty("java.naming.security.credentials", bindPW);
            systemConfig.setProperty("java.naming.security.authentication", "simple");
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(systemConfig, null);
            ctx.close();
        }
        catch (NamingException e) {
            requiresAttention = true;
            this.log.error((Object)("LDAP communication error: " + e.getMessage()), (Throwable)e);
        }
        return requiresAttention;
    }

    protected Set<Map<String, String>> buildGroup(Properties systemConfig, String filter) {
        HashSet<Map<String, String>> groupDetailsMap = new HashSet<Map<String, String>>();
        String baseDN = (String)systemConfig.get(SystemSetting.LDAP_BASE_DN.name());
        String loginProperty = (String)systemConfig.get(SystemSetting.LDAP_LOGIN_PROPERTY.name());
        if (loginProperty == null) {
            loginProperty = "cn";
        }
        String bindDN = (String)systemConfig.get(SystemSetting.LDAP_BIND_DN.name());
        String bindPW = (String)systemConfig.get(SystemSetting.LDAP_BIND_PW.name());
        if (bindDN != null) {
            systemConfig.setProperty("java.naming.security.principal", bindDN);
            systemConfig.setProperty("java.naming.security.credentials", bindPW);
            systemConfig.setProperty("java.naming.security.authentication", "simple");
        }
        try {
            InitialLdapContext ctx = new InitialLdapContext(systemConfig, null);
            SearchControls searchControls = this.getSearchControls();
            String[] attributes = new String[]{"cn", "description"};
            searchControls.setReturningAttributes(attributes);
            String groupUseQueryPaging = systemConfig.getProperty(SystemSetting.LDAP_GROUP_PAGING.name(), "false");
            if (groupUseQueryPaging == null) {
                groupUseQueryPaging = Boolean.toString(false);
            }
            boolean useQueryPaging = Boolean.valueOf(groupUseQueryPaging);
            int defaultPageSize = 1000;
            if (useQueryPaging) {
                String groupPageSize = systemConfig.getProperty(SystemSetting.LDAP_GROUP_QUERY_PAGE_SIZE.name(), "" + defaultPageSize);
                if (groupPageSize != null && !groupPageSize.trim().isEmpty()) {
                    int passedInPageSize = -1;
                    try {
                        passedInPageSize = Integer.valueOf(groupPageSize.trim());
                        if (passedInPageSize > 0 && passedInPageSize <= 20000) {
                            defaultPageSize = passedInPageSize;
                        } else {
                            this.log.debug((Object)("LDAP Group Page Size passed '" + groupPageSize + "' was ignored. Defaulting to 1000."));
                        }
                    }
                    catch (NumberFormatException nfe) {
                        this.log.debug((Object)("LDAP Group Page Size passed '" + groupPageSize + "' in is invalid. Defaulting to 1000." + nfe.getMessage()));
                    }
                }
                ctx.setRequestControls(new Control[]{new PagedResultsControl(defaultPageSize, true)});
            }
            String[] baseDNs = baseDN.split(BASEDN_DELIMITER);
            for (int x = 0; x < baseDNs.length; ++x) {
                PagedResultsResponseControl pagedResult;
                groupQueryStartTime = System.currentTimeMillis();
                this.executeGroupSearch(filter, groupDetailsMap, ctx, searchControls, baseDNs, x);
                groupQueryResultCount = groupDetailsMap.size();
                groupQueryCurrentTime = System.currentTimeMillis();
                if (!useQueryPaging) continue;
                byte[] cookie = null;
                Control[] controls = ctx.getResponseControls();
                if (controls != null) {
                    for (Control control : controls) {
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        pagedResult = (PagedResultsResponseControl)control;
                        cookie = pagedResult.getCookie();
                    }
                }
                while (groupQueryResultCount <= 20000 && cookie != null) {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(defaultPageSize, cookie, true)});
                    this.executeGroupSearch(filter, groupDetailsMap, ctx, searchControls, baseDNs, x);
                    groupQueryResultCount = groupDetailsMap.size();
                    ++groupQueryPageCount;
                    groupQueryCurrentTime = System.currentTimeMillis();
                    cookie = null;
                    controls = ctx.getResponseControls();
                    if (controls == null) continue;
                    for (Control control : controls) {
                        if (!(control instanceof PagedResultsResponseControl)) continue;
                        pagedResult = (PagedResultsResponseControl)control;
                        cookie = pagedResult.getCookie();
                    }
                }
            }
        }
        catch (NamingException e) {
            if (e instanceof InvalidSearchFilterException) {
                InvalidSearchFilterException fException = (InvalidSearchFilterException)e;
                String message = "The ldap group filter defined is invalid ";
                this.log.error((Object)message, (Throwable)fException);
                throw new LdapFilterException(message + " " + fException.getMessage());
            }
            this.log.error((Object)("LDAP communication error: " + e.getMessage()), (Throwable)e);
            throw new LdapCommunicationException(e);
        }
        catch (IOException iex) {
            this.log.error((Object)("Unexpected LDAP communciation error:" + iex.getMessage()), (Throwable)iex);
            throw new LdapCommunicationException(iex);
        }
        groupQueryCurrentTime = System.currentTimeMillis();
        groupQueryComplete = true;
        return groupDetailsMap;
    }

    private void executeGroupSearch(String filter, Set<Map<String, String>> groupDetailsMap, InitialLdapContext ctx, SearchControls searchControls, String[] baseDNs, int x) throws NamingException {
        NamingEnumeration<SearchResult> answer = ctx.search(baseDNs[x], filter, searchControls);
        boolean ldapApiEnumerationBugEncountered = false;
        int resultCount = 0;
        while (resultCount <= 20000 && groupDetailsMap.size() <= 20000 && !ldapApiEnumerationBugEncountered && answer.hasMoreElements()) {
            SearchResult si = null;
            try {
                si = answer.next();
            }
            catch (NullPointerException npe) {
                ldapApiEnumerationBugEncountered = true;
                break;
            }
            HashMap<String, String> entry = new HashMap<String, String>();
            String name = (String)si.getAttributes().get("cn").get();
            name = name.trim();
            Attribute desc = si.getAttributes().get("description");
            String description = desc != null ? (String)desc.get() : "";
            description = description.trim();
            entry.put("id", name);
            entry.put("name", name);
            entry.put("description", description);
            groupDetailsMap.add(entry);
            groupQueryResultCount = ++resultCount;
            if (groupQueryPageCount == 0) {
                ++groupQueryPageCount;
            }
            groupQueryCurrentTime = System.currentTimeMillis();
        }
    }

    private Properties populateProperties(SystemSettings systemSettings) {
        Properties properties = null;
        if (systemSettings != null) {
            String providerUrl;
            boolean ldapSsl;
            properties = new Properties();
            Set entries = systemSettings.entrySet();
            for (Map.Entry entry : entries) {
                String value;
                SystemSetting key = (SystemSetting)entry.getKey();
                if (key == null || (value = (String)entry.getValue()) == null) continue;
                properties.put(key.name(), value);
            }
            String factoryName = properties.getProperty(SystemSetting.LDAP_NAMING_FACTORY.name());
            properties.setProperty("java.naming.factory.initial", factoryName);
            String value = properties.getProperty(SystemSetting.USE_SSL_FOR_LDAP.name());
            boolean bl = ldapSsl = "ssl".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
            if (ldapSsl) {
                String ldapSocketFactory = properties.getProperty("java.naming.ldap.factory.socket");
                if (ldapSocketFactory == null) {
                    properties.put("java.naming.ldap.factory.socket", UntrustedSSLSocketFactory.class.getName());
                }
                properties.put("java.naming.security.protocol", "ssl");
            }
            if ((providerUrl = properties.getProperty(SystemSetting.LDAP_NAMING_PROVIDER_URL.name())) == null) {
                int port = ldapSsl ? 636 : 389;
                providerUrl = "ldap://localhost:" + port;
            }
            properties.setProperty("java.naming.provider.url", providerUrl);
        }
        return properties;
    }

    @Deprecated
    private Properties getProperties(Properties systemConfig) {
        String providerUrl;
        boolean ldapSsl;
        Properties env = new Properties(systemConfig);
        String factoryName = env.getProperty(SystemSetting.LDAP_NAMING_FACTORY.name());
        env.setProperty("java.naming.factory.initial", factoryName);
        String value = env.getProperty(SystemSetting.USE_SSL_FOR_LDAP.getInternalName());
        boolean bl = ldapSsl = "ssl".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value);
        if (ldapSsl) {
            String ldapSocketFactory = env.getProperty("java.naming.ldap.factory.socket");
            if (ldapSocketFactory == null) {
                env.put("java.naming.ldap.factory.socket", UntrustedSSLSocketFactory.class.getName());
            }
            env.put("java.naming.security.protocol", "ssl");
        }
        if ((providerUrl = env.getProperty(SystemSetting.LDAP_NAMING_PROVIDER_URL.name())) == null) {
            int port = ldapSsl ? 636 : 389;
            providerUrl = "ldap://localhost:" + port;
        }
        env.setProperty("java.naming.provider.url", providerUrl);
        return env;
    }

    private SearchControls getSearchControls() {
        int scope = 2;
        int timeLimit = 0;
        long countLimit = 0L;
        String[] returnedAttributes = null;
        boolean returnObject = false;
        boolean deference = false;
        SearchControls constraints = new SearchControls(scope, countLimit, timeLimit, returnedAttributes, returnObject, deference);
        return constraints;
    }
}

