/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.cloud.Server;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.PluginCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.plugin.CannedGroupAddition;
import org.rhq.core.domain.plugin.CannedGroupExpression;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.core.domain.plugin.PluginStatusType;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.core.util.stream.StreamUtil;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.core.plugin.PluginAdditionsReader;
import org.rhq.enterprise.server.core.plugin.PluginDeploymentScannerMBean;
import org.rhq.enterprise.server.inventory.InventoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.definition.GroupDefinitionManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerRemote;
import org.rhq.enterprise.server.resource.metadata.PluginStats;
import org.rhq.enterprise.server.resource.metadata.ResourceMetadataManagerLocal;
import org.rhq.enterprise.server.resource.metadata.UpdatePluginsOnAgentsJob;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.util.QuartzUtil;

@Stateless
public class PluginManagerBean
implements PluginManagerLocal,
PluginManagerRemote {
    private final Log log = LogFactory.getLog(PluginManagerBean.class);
    @Resource(name="RHQ_DS", mappedName="java:jboss/datasources/RHQDS")
    private DataSource dataSource;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private ResourceMetadataManagerLocal resourceMetadataManager;
    @EJB
    private PluginManagerLocal pluginMgr;
    @EJB
    private InventoryManagerLocal inventoryMgr;
    @EJB
    private ResourceTypeManagerLocal resourceTypeMgr;
    @EJB
    private ResourceManagerLocal resourceMgr;
    @EJB
    private SubjectManagerLocal subjectMgr;
    @EJB
    private ContentManagerLocal contentManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private SchedulerLocal scheduler;

    @Override
    public Plugin getPlugin(String name) {
        Query query = this.entityManager.createNamedQuery("Plugin.findByName");
        query.setParameter("name", (Object)name);
        Plugin result = null;
        try {
            result = (Plugin)query.getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        return result;
    }

    @Override
    public boolean isReadyForPurge(Plugin plugin) {
        int resourceTypeCount = this.getResourceTypeCount(plugin);
        if (resourceTypeCount > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(plugin + " is not ready to be purged. It still has " + resourceTypeCount + " resource types in the database."));
            }
            return false;
        }
        Plugin inDbPlugin = (Plugin)this.entityManager.find(Plugin.class, (Object)plugin.getId());
        List allServers = this.entityManager.createNamedQuery("Server.findAll").getResultList();
        for (Server s : allServers) {
            if (inDbPlugin.getServersAcknowledgedDelete().contains(s)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(plugin + " is not ready to be purged. Server " + s + " has not acknowledged it knows about its deletion."));
            }
            return false;
        }
        return true;
    }

    private int getResourceTypeCount(Plugin plugin) {
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.addFilterPluginName(plugin.getName());
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        criteria.addFilterDeleted(null);
        criteria.addFilterIgnored(null);
        criteria.setStrict(true);
        PageList<ResourceType> types = this.resourceTypeMgr.findResourceTypesByCriteria(this.subjectMgr.getOverlord(), criteria);
        return types.getTotalSize();
    }

    @Override
    public void purgePlugins(List<Plugin> plugins) {
        for (Plugin p : plugins) {
            Plugin inDb = (Plugin)this.entityManager.find(Plugin.class, (Object)p.getId());
            inDb.getServersAcknowledgedDelete().clear();
            this.entityManager.remove((Object)inDb);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("The following plugins were purged from the database: " + plugins));
        }
    }

    @Override
    public List<Plugin> getPlugins() {
        return this.entityManager.createNamedQuery("Plugin.findAll").getResultList();
    }

    @Override
    public List<Plugin> getInstalledPlugins() {
        Query q = this.entityManager.createNamedQuery("Plugin.findAllInstalled");
        return q.getResultList();
    }

    @Override
    public List<Plugin> findAllDeletedPlugins() {
        return this.entityManager.createNamedQuery("Plugin.findAllDeleted").getResultList();
    }

    @Override
    public List<Plugin> getAllPluginsById(List<Integer> pluginIds) {
        if (pluginIds == null || pluginIds.size() == 0) {
            return new ArrayList<Plugin>();
        }
        Query query = this.entityManager.createNamedQuery("Plugin.findAllByIds");
        query.setParameter("ids", pluginIds);
        return query.getResultList();
    }

    @Override
    public List<Plugin> getPluginsByResourceTypeAndCategory(String resourceTypeName, ResourceCategory resourceCategory) {
        Query query = this.entityManager.createNamedQuery("Plugin.findByResourceType");
        query.setParameter("resourceTypeName", (Object)resourceTypeName);
        query.setParameter("resourceCategory", (Object)resourceCategory);
        List results = query.getResultList();
        return results;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void enablePlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return;
        }
        PluginDependencyGraph graph = this.getPluginMetadataManager().buildDependencyGraph();
        List<Plugin> allPlugins = this.getInstalledPlugins();
        HashSet<String> pluginsThatNeedToBeEnabled = new HashSet<String>();
        for (Integer pluginId : pluginIds) {
            Plugin plugin = this.getPluginFromListById(allPlugins, pluginId);
            if (plugin == null) continue;
            Collection dependencyNames = graph.getAllDependencies(plugin.getName());
            for (String dependencyName : dependencyNames) {
                Plugin dependencyPlugin = this.getPluginFromListByName(allPlugins, dependencyName);
                if (dependencyPlugin == null || dependencyPlugin.isEnabled() || pluginIds.contains(dependencyPlugin.getId())) continue;
                pluginsThatNeedToBeEnabled.add(dependencyPlugin.getDisplayName());
            }
        }
        if (!pluginsThatNeedToBeEnabled.isEmpty()) {
            throw new IllegalArgumentException("You must enable the following plugin dependencies also: " + pluginsThatNeedToBeEnabled);
        }
        for (Integer pluginId : pluginIds) {
            this.setPluginEnabledFlag(subject, pluginId, true);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void disablePlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds == null || pluginIds.size() == 0) {
            return;
        }
        PluginDependencyGraph graph = this.getPluginMetadataManager().buildDependencyGraph();
        List<Plugin> allPlugins = this.getInstalledPlugins();
        HashSet<String> pluginsThatNeedToBeDisabled = new HashSet<String>();
        for (Integer pluginId : pluginIds) {
            Plugin plugin = this.getPluginFromListById(allPlugins, pluginId);
            if (plugin == null) continue;
            Collection dependentNames = graph.getAllDependents(plugin.getName());
            for (String dependentName : dependentNames) {
                Plugin dependentPlugin = this.getPluginFromListByName(allPlugins, dependentName);
                if (dependentPlugin == null || !dependentPlugin.isEnabled() || pluginIds.contains(dependentPlugin.getId())) continue;
                pluginsThatNeedToBeDisabled.add(dependentPlugin.getDisplayName());
            }
        }
        if (!pluginsThatNeedToBeDisabled.isEmpty()) {
            throw new IllegalArgumentException("You must disable the following dependent plugins also: " + pluginsThatNeedToBeDisabled);
        }
        for (Integer pluginId : pluginIds) {
            this.setPluginEnabledFlag(subject, pluginId, false);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void deletePlugins(Subject subject, List<Integer> pluginIds) throws Exception {
        if (pluginIds.isEmpty()) {
            return;
        }
        PluginDependencyGraph graph = this.getPluginMetadataManager().buildDependencyGraph();
        List<Plugin> allPlugins = this.getInstalledPlugins();
        HashSet<String> pluginsToDelete = new HashSet<String>();
        for (Integer pluginId : pluginIds) {
            Plugin plugin = this.getPluginFromListById(allPlugins, pluginId);
            if (plugin == null || !plugin.getStatus().equals((Object)PluginStatusType.INSTALLED)) continue;
            Collection dependentNames = graph.getAllDependents(plugin.getName());
            for (String dependentName : dependentNames) {
                Plugin dependentPlugin = this.getPluginFromListByName(allPlugins, dependentName);
                if (dependentPlugin == null || !dependentPlugin.isEnabled() || pluginIds.contains(dependentPlugin.getId())) continue;
                pluginsToDelete.add(dependentPlugin.getDisplayName());
            }
        }
        if (!pluginsToDelete.isEmpty()) {
            throw new IllegalArgumentException("You must delete the following dependent plugins also: " + pluginsToDelete);
        }
        List<Plugin> plugins = this.pluginMgr.getAllPluginsById(pluginIds);
        this.pluginMgr.markPluginsDeleted(subject, plugins);
        try {
            for (Plugin plugin : plugins) {
                this.deleteResourcesForPlugin(subject, plugin);
            }
        }
        catch (Throwable t) {
            this.log.warn((Object)"Failed to uninventory all resources of deleted plugins. This should fix itself automatically when the PurgeResourceTypsJob executes.", t);
        }
        GroupDefinitionManagerLocal groupDefMgr = LookupUtil.getGroupDefinitionManager();
        for (Plugin plugin : plugins) {
            groupDefMgr.updateGroupsByCannedExpressions(plugin.getName(), null);
        }
    }

    private void deleteResourcesForPlugin(Subject subject, Plugin plugin) throws Exception {
        ResourceTypeCriteria criteria = new ResourceTypeCriteria();
        criteria.setStrict(true);
        criteria.addFilterPluginName(plugin.getName());
        criteria.addFilterDeleted(true);
        criteria.addFilterIgnored(null);
        criteria.addFilterParentResourceTypesEmpty(true);
        criteria.clearPaging();
        PageList<ResourceType> deletedServerTypes = this.resourceTypeMgr.findResourceTypesByCriteria(subject, criteria);
        for (ResourceType deletedServerType : deletedServerTypes) {
            this.deleteResourcesForType(subject, deletedServerType);
        }
    }

    private void deleteResourcesForType(Subject subject, ResourceType type) throws Exception {
        ArrayList<Integer> typeIds = new ArrayList<Integer>(1);
        typeIds.add(type.getId());
        List<Integer> resourceIds = this.resourceMgr.findIdsByTypeIds(typeIds);
        for (Integer resourceId : resourceIds) {
            this.resourceMgr.uninventoryResourceInNewTransaction(resourceId);
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public void markPluginsDeleted(Subject subject, List<Plugin> plugins) throws Exception {
        this.log.debug((Object)(subject + " preparing to delete the following plugins: " + plugins));
        for (Plugin plugin : plugins) {
            if (plugin.getStatus().equals((Object)PluginStatusType.INSTALLED)) {
                long startTime = System.currentTimeMillis();
                List<Integer> resourceTypeIds = this.resourceTypeMgr.getResourceTypeIdsByPlugin(plugin.getName());
                this.inventoryMgr.markTypesDeleted(resourceTypeIds, false);
                plugin.setStatus(PluginStatusType.DELETED);
                this.entityManager.merge((Object)plugin);
                long endTime = System.currentTimeMillis();
                this.log.debug((Object)("Deleted " + plugin + " in " + (endTime - startTime) + " ms"));
                continue;
            }
            this.log.debug((Object)("Skipping " + plugin + ". It is already deleted."));
        }
    }

    @Override
    public List<PluginStats> getPluginStats(List<Integer> pluginIds) {
        ArrayList<PluginStats> stats = new ArrayList<PluginStats>();
        List<Plugin> plugins = this.getAllPluginsById(pluginIds);
        for (Plugin plugin : plugins) {
            List<Integer> resourceTypeIds = this.resourceTypeMgr.getResourceTypeIdsByPlugin(plugin.getName());
            Integer resourceCount = this.resourceMgr.getResourceCount(resourceTypeIds);
            stats.add(new PluginStats(plugin, resourceTypeIds.size(), resourceCount));
        }
        return stats;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void setPluginEnabledFlag(Subject subject, int pluginId, boolean enabled) throws Exception {
        Query q = this.entityManager.createNamedQuery("Plugin.updatePluginEnabledById");
        q.setParameter("id", (Object)pluginId);
        q.setParameter("enabled", (Object)enabled);
        q.executeUpdate();
        this.log.info((Object)((enabled ? "Enabling" : "Disabling") + " plugin [" + pluginId + "]"));
    }

    @Override
    public File getPluginDropboxDirectory() {
        File dir = new File(LookupUtil.getPluginDeploymentScanner().getUserPluginDir());
        return dir;
    }

    private Plugin getPluginFromListById(List<Plugin> plugins, int id) {
        for (Plugin plugin : plugins) {
            if (id != plugin.getId()) continue;
            return plugin;
        }
        return null;
    }

    private Plugin getPluginFromListByName(List<Plugin> plugins, String name) {
        for (Plugin plugin : plugins) {
            if (!name.equals(plugin.getName())) continue;
            return plugin;
        }
        return null;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void registerPlugin(Plugin plugin, PluginDescriptor pluginDescriptor, File pluginFile, boolean forceUpdate) throws Exception {
        if (this.isDeleted(plugin)) {
            String msg = "A deleted version of " + plugin + " already exists in the database. The plugin cannot be " + "installed until the deleted version is purged from the database (which should happen a couple of" + " minutes after all servers acknowledged the plugin was deleted). Especially, the plugin won't be" + " purged if ANY of the servers in the HA cloud have been down at the point in time the plugin was" + " deleted and haven't gone back up yet.";
            this.log.warn((Object)msg);
            throw new IllegalStateException(msg);
        }
        this.log.debug((Object)("Registering " + plugin + "..."));
        long startTime = System.currentTimeMillis();
        boolean newOrUpdated = this.pluginMgr.installPluginJar(plugin, pluginDescriptor, pluginFile);
        boolean typesUpdated = this.registerPluginTypes(plugin.getName(), pluginDescriptor, newOrUpdated, forceUpdate);
        if (typesUpdated) {
            PluginMetadataManager metadataManager = this.getPluginMetadataManager();
            Map extensions = metadataManager.getEmbeddedExtensions(plugin.getName());
            if (extensions != null && extensions.size() > 0) {
                for (Map.Entry entry : extensions.entrySet()) {
                    String extPluginName = (String)entry.getKey();
                    PluginDescriptor extPluginDescriptor = (PluginDescriptor)entry.getValue();
                    this.log.debug((Object)("Plugin [" + extPluginName + "] will be re-registered because it embeds types from plugin [" + plugin.getName() + "]"));
                    this.registerPluginTypes(extPluginName, extPluginDescriptor, false, true);
                    this.resourceMetadataManager.removeObsoleteTypes(this.subjectMgr.getOverlord(), extPluginName, metadataManager);
                }
            }
            this.resourceMetadataManager.removeObsoleteTypes(this.subjectMgr.getOverlord(), plugin.getName(), metadataManager);
            this.resourceMetadataManager.removeObsoleteSubCategories(this.subjectMgr.getOverlord(), null, null);
        }
        long endTime = System.currentTimeMillis();
        this.log.debug((Object)("Finished registering " + plugin + " in " + (endTime - startTime) + " ms"));
    }

    private boolean isDeleted(Plugin plugin) {
        for (Plugin deletedPlugins : this.findAllDeletedPlugins()) {
            if (!deletedPlugins.equals((Object)plugin)) continue;
            return true;
        }
        return false;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public boolean installPluginJar(Plugin newPlugin, PluginDescriptor pluginDescriptor, File pluginFile) throws Exception {
        boolean newOrUpdated;
        Plugin existingPlugin = this.getPlugin(newPlugin.getName());
        boolean bl = newOrUpdated = null == existingPlugin;
        if (existingPlugin != null) {
            Plugin obsolete = AgentPluginDescriptorUtil.determineObsoletePlugin((Plugin)newPlugin, (Plugin)existingPlugin);
            if (obsolete == existingPlugin) {
                newOrUpdated = true;
            }
            newPlugin.setId(existingPlugin.getId());
            newPlugin.setEnabled(existingPlugin.isEnabled());
        }
        if (newOrUpdated) {
            if (newPlugin.getDisplayName() == null) {
                newPlugin.setDisplayName(newPlugin.getName());
            }
            newPlugin = this.updatePluginExceptContent(newPlugin);
            if (pluginFile != null) {
                this.entityManager.flush();
                this.streamPluginFileContentToDatabase(newPlugin.getId(), pluginFile);
            }
            this.log.debug((Object)("Updated plugin entity [" + newPlugin + "]"));
        }
        return newOrUpdated;
    }

    private boolean registerPluginTypes(String newPluginName, PluginDescriptor pluginDescriptor, boolean newOrUpdated, boolean forceUpdate) throws Exception {
        boolean typesUpdated = false;
        PluginMetadataManager metadataManager = this.getPluginMetadataManager();
        if (newOrUpdated || forceUpdate || !metadataManager.getPluginNames().contains(newPluginName)) {
            Set rootResourceTypes = metadataManager.loadPlugin(pluginDescriptor);
            if (rootResourceTypes == null) {
                throw new Exception("Failed to load plugin [" + newPluginName + "].");
            }
            if (newOrUpdated || forceUpdate) {
                this.resourceMetadataManager.updateTypes(rootResourceTypes);
                typesUpdated = true;
            }
        }
        return typesUpdated;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void update(Subject subject) throws Exception {
        PluginDeploymentScannerMBean scanner = LookupUtil.getPluginDeploymentScanner();
        scanner.scanAndRegister();
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public String schedulePluginUpdateOnAgents(Subject subject, long delayInMilliseconds) throws Exception {
        JobDetail jobDetail = UpdatePluginsOnAgentsJob.getJobDetail();
        Trigger trigger = QuartzUtil.getFireOnceOffsetTrigger(jobDetail, delayInMilliseconds);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
            return jobDetail.getName();
        }
        catch (ObjectAlreadyExistsException e) {
            this.log.debug((Object)("A request to update plugins on agents seems to already be scheduled. Ignoring the current request with the error message: " + e.getMessage()));
            throw e;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public boolean isPluginUpdateOnAgentsFinished(Subject subject, String handle) {
        try {
            return this.scheduler.getJobDetail(handle, UpdatePluginsOnAgentsJob.class.getName()) == null;
        }
        catch (SchedulerException e) {
            if (this.log.isDebugEnabled()) {
                this.log.warn((Object)("Failed to retrieve job details while checking for active plugin update schedule, code: " + e.getErrorCode()), (Throwable)e);
            } else {
                this.log.warn((Object)("Failed to retrieve job details while checking for active plugin update schedule, code: " + e.getErrorCode() + ", message: " + e.getMessage()));
            }
            return false;
        }
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<Plugin> deployUsingBytes(Subject subject, String pluginJarName, byte[] pluginJarBytes) throws Exception {
        File base = this.getPluginDropboxDirectory();
        File targetFile = new File(base, pluginJarName);
        FileOutputStream out = new FileOutputStream(targetFile);
        ByteArrayInputStream in = new ByteArrayInputStream(pluginJarBytes);
        StreamUtil.copy((InputStream)in, (OutputStream)out, (boolean)true);
        return this.updateAndDetectChanges(subject);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public List<Plugin> deployUsingContentHandle(Subject subject, String pluginJarName, String handle) throws Exception {
        File pluginJar = this.contentManager.getTemporaryContentFile(handle);
        File base = this.getPluginDropboxDirectory();
        FileUtil.copyFile((File)pluginJar, (File)new File(base, pluginJarName));
        return this.updateAndDetectChanges(subject);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_SETTINGS)
    public PageList<Plugin> findPluginsByCriteria(Subject subject, PluginCriteria criteria) {
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        return queryRunner.execute();
    }

    private List<Plugin> updateAndDetectChanges(Subject subject) throws Exception {
        List<Plugin> before = this.getPlugins();
        this.update(subject);
        List<Plugin> after = this.getPlugins();
        for (Plugin p : before) {
            after.remove(p);
        }
        return after;
    }

    @Override
    public void acknowledgeDeletedPluginsBy(int serverId) {
        Query q = this.entityManager.createNamedQuery("Plugin.unackedDeletedPlugins");
        q.setParameter("serverId", (Object)serverId);
        List plugins = q.getResultList();
        Server server = (Server)this.entityManager.find(Server.class, (Object)serverId);
        for (Plugin p : plugins) {
            p.getServersAcknowledgedDelete().add(server);
            this.entityManager.merge((Object)p);
        }
    }

    private Plugin updatePluginExceptContent(Plugin plugin) throws Exception {
        if (plugin.getId() == 0) {
            this.entityManager.persist((Object)plugin);
        } else {
            Plugin pluginEntity = (Plugin)this.entityManager.getReference(Plugin.class, (Object)plugin.getId());
            pluginEntity.setName(plugin.getName());
            pluginEntity.setPath(plugin.getPath());
            pluginEntity.setDisplayName(plugin.getDisplayName());
            pluginEntity.setEnabled(plugin.isEnabled());
            pluginEntity.setStatus(plugin.getStatus());
            pluginEntity.setMd5(plugin.getMD5());
            pluginEntity.setVersion(plugin.getVersion());
            pluginEntity.setAmpsVersion(plugin.getAmpsVersion());
            pluginEntity.setDeployment(plugin.getDeployment());
            pluginEntity.setDescription(plugin.getDescription());
            pluginEntity.setHelp(plugin.getHelp());
            pluginEntity.setMtime(plugin.getMtime());
            try {
                this.entityManager.flush();
            }
            catch (Exception e) {
                throw new Exception("Failed to update a plugin that matches [" + plugin + "]");
            }
        }
        return plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamPluginFileContentToDatabase(int id, File file) throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        FileInputStream fis = new FileInputStream(file);
        try {
            conn = this.dataSource.getConnection();
            ps = conn.prepareStatement("UPDATE RHQ_PLUGIN SET CONTENT = ? WHERE ID = ?");
            ps.setBinaryStream(1, (InputStream)new BufferedInputStream(fis), (int)file.length());
            ps.setInt(2, id);
            int updateResults = ps.executeUpdate();
            if (updateResults != 1) {
                throw new Exception("Failed to update content for plugin [" + id + "] from [" + file + "]");
            }
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Connection)conn, ps, rs);
            StreamUtil.safeClose((Closeable)fis);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)ps, rs);
        StreamUtil.safeClose((Closeable)fis);
    }

    private PluginMetadataManager getPluginMetadataManager() {
        return LookupUtil.getPluginDeploymentScanner().getPluginMetadataManager();
    }

    @Override
    public List<CannedGroupExpression> getCannedGroupExpressions() {
        ArrayList<CannedGroupExpression> list = new ArrayList<CannedGroupExpression>();
        String pluginDir = LookupUtil.getPluginDeploymentScanner().getAgentPluginDir();
        long now = System.currentTimeMillis();
        this.log.debug((Object)"Reading canned expressions from all agent plugin jars");
        for (Plugin plugin : this.getInstalledPlugins()) {
            if (!plugin.getDeployment().equals((Object)PluginDeploymentType.AGENT)) continue;
            File pluginFile = new File(pluginDir, plugin.getPath());
            try {
                URL pluginUrl = pluginFile.toURI().toURL();
                CannedGroupAddition addition = PluginAdditionsReader.getCannedGroupsAddition(pluginUrl, plugin.getName());
                if (addition == null) continue;
                list.addAll(addition.getExpressions());
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to parse plugin addition found in plugin [" + pluginFile.getAbsolutePath() + "]"), (Throwable)e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading " + list.size() + " canned expressions from all plugins took " + (System.currentTimeMillis() - now) + "ms"));
        }
        return list;
    }
}

