/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.Cache;
import org.infinispan.manager.CacheContainer;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.UILinkTemplate;
import org.rhq.enterprise.server.rest.domain.GroupRest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.PagingCollection;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Produces(value={"application/json", "application/xml", "text/html", "application/vnd.rhq.wrapped+json"})
@Resource(name="ISPN", mappedName="java:jboss/infinispan/rhq")
public class AbstractRestBean {
    protected Log log = LogFactory.getLog((String)this.getClass().getName());
    protected final MediaType wrappedCollectionJsonType = new MediaType("application", "vnd.rhq.wrapped+json");
    protected final String wrappedCollectionJson = "application/vnd.rhq.wrapped+json";
    private static final CacheKey META_KEY = new CacheKey("rhq.rest.resourceMeta", 0);
    @Resource(name="ISPN")
    private CacheContainer container;
    protected Cache<CacheKey, Object> cache;
    protected Subject caller;
    @EJB
    protected ResourceManagerLocal resMgr;
    @EJB
    protected ResourceGroupManagerLocal resourceGroupManager;

    @PostConstruct
    public void start() {
        this.cache = this.container.getCache("rhqRestCache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String renderTemplate(String templateName, Object objectToRender) {
        block7: {
            String string;
            Configuration config = new Configuration();
            ClassTemplateLoader ctl = new ClassTemplateLoader(this.getClass(), "/rest_templates/");
            TemplateLoader[] loaders = new TemplateLoader[]{ctl};
            MultiTemplateLoader mtl = new MultiTemplateLoader(loaders);
            config.setTemplateLoader((TemplateLoader)mtl);
            if (!templateName.endsWith(".ftl")) {
                templateName = templateName + ".ftl";
            }
            Template template = config.getTemplate(templateName);
            StringWriter out = new StringWriter();
            try {
                HashMap<String, Object> root = new HashMap<String, Object>();
                root.put("var", objectToRender);
                template.process(root, (Writer)out);
                string = out.toString();
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    this.log.error((Object)ioe);
                    break block7;
                }
                catch (TemplateException te) {
                    this.log.error((Object)te.getMessage());
                }
            }
            out.close();
            return string;
        }
        return null;
    }

    protected <T> T getFromCache(int id, Class<T> clazz) {
        CacheKey key = new CacheKey(clazz, id);
        return this.getFromCache(key, clazz);
    }

    protected <T> T getFromCache(CacheKey key, Class<T> clazz) {
        Object o = null;
        CacheValue value = (CacheValue)this.cache.get((Object)key);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (null != value) {
            if (debugEnabled) {
                this.log.debug((Object)("Cache Hit for " + key));
            }
            if (value.getReaders().contains(this.caller.getId())) {
                o = value.getValue();
            } else if (debugEnabled) {
                this.log.debug((Object)("Cache Hit ignored, caller " + this.caller.toString() + " not found"));
            }
        } else if (debugEnabled) {
            this.log.debug((Object)("Cache Miss for " + key));
        }
        return (T)o;
    }

    protected <T> boolean putToCache(int id, Class<T> clazz, T o) {
        CacheKey key = new CacheKey(clazz, id);
        return this.putToCache(key, o);
    }

    protected <T> boolean putToCache(CacheKey key, T o) {
        boolean result = false;
        CacheValue value = (CacheValue)this.cache.get((Object)key);
        if (null != value) {
            value.getReaders().add(this.caller.getId());
            value.setValue(o);
        } else {
            value = new CacheValue(o, this.caller.getId());
        }
        try {
            this.cache.put((Object)key, (Object)value);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cache Put " + key));
            }
            result = true;
        }
        catch (Exception e) {
            this.log.warn((Object)e.getMessage());
        }
        return result;
    }

    protected <T> boolean removeFromCache(int id, Class<T> clazz) {
        CacheKey key = new CacheKey(clazz, id);
        Object cacheValue = this.cache.remove((Object)key);
        if (null != cacheValue) {
            this.log.debug((Object)("Cache Remove " + key));
        }
        return true;
    }

    public ResourceWithType fillRWT(org.rhq.core.domain.resource.Resource res, UriInfo uriInfo) {
        ResourceType resourceType = res.getResourceType();
        ResourceWithType rwt = new ResourceWithType(res.getName(), res.getId());
        rwt.setTypeName(resourceType.getName());
        rwt.setTypeId(resourceType.getId());
        rwt.setPluginName(resourceType.getPlugin());
        rwt.setStatus(res.getInventoryStatus().name());
        rwt.setLocation(res.getLocation());
        rwt.setDescription(res.getDescription());
        rwt.setAvailability(res.getCurrentAvailability().getAvailabilityType().toString());
        org.rhq.core.domain.resource.Resource parent = res.getParentResource();
        if (parent != null) {
            rwt.setParentId(parent.getId());
        } else {
            rwt.setParentId(0);
        }
        rwt.setAncestry(res.getAncestry());
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/operation/definitions");
        uriBuilder.queryParam("resourceId", new Object[]{res.getId()});
        URI uri = uriBuilder.build(new Object[0]);
        Link link = new Link("operationDefinitions", uri.toString());
        rwt.addLink(link);
        link = this.getLinkToResource(res, uriInfo, "self");
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/schedules");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("schedules", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/availability");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("availability", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/children");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("children", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}/alerts");
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("alerts", uri.toString());
        rwt.addLink(link);
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/definitions");
        uriBuilder.queryParam("resourceId", new Object[]{res.getId()});
        uri = uriBuilder.build(new Object[]{res.getId()});
        link = new Link("alertDefinitions", uri.toString());
        rwt.addLink(link);
        if (parent != null) {
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}/");
            uri = uriBuilder.build(new Object[]{parent.getId()});
            link = new Link("parent", uri.toString());
            rwt.addLink(link);
        }
        rwt.addLink(this.createUILink(uriInfo, UILinkTemplate.RESOURCE, res.getId()));
        return rwt;
    }

    protected Link getLinkToResource(org.rhq.core.domain.resource.Resource res, UriInfo uriInfo, String rel) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/{id}");
        URI uri = uriBuilder.build(new Object[]{res.getId()});
        Link link = new Link(rel, uri.toString());
        return link;
    }

    protected Link getLinkToResourceType(ResourceType type, UriInfo uriInfo, String rel) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/resource/type/{id}");
        URI uri = uriBuilder.build(new Object[]{type.getId()});
        Link link = new Link(rel, uri.toString());
        return link;
    }

    protected Link getLinkToGroup(ResourceGroup group, UriInfo uriInfo, String rel) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}");
        URI uri = uriBuilder.build(new Object[]{group.getId()});
        Link link = new Link(rel, uri.toString());
        return link;
    }

    protected org.rhq.core.domain.resource.Resource fetchResource(int resourceId) {
        org.rhq.core.domain.resource.Resource res = this.resMgr.getResource(this.caller, resourceId);
        if (res == null) {
            throw new StuffNotFoundException("Resource with id " + resourceId);
        }
        return res;
    }

    protected Response.ResponseBuilder withMediaType(Response.ResponseBuilder builder, HttpHeaders headers) {
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder.type(mediaType);
        return builder;
    }

    protected <T> Response.ResponseBuilder paginate(HttpHeaders headers, UriInfo uriInfo, PageList<?> pageList, List<T> results, final Class<T> elementType) {
        Response.ResponseBuilder builder = Response.ok();
        this.withMediaType(builder, headers);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)this.wrappedCollectionJsonType)) {
            this.wrapForPaging(builder, uriInfo, pageList, results);
        } else {
            ParameterizedType myType = new ParameterizedType(){
                final Type[] params;
                {
                    this.params = new Type[]{elementType};
                }

                @Override
                public Type[] getActualTypeArguments() {
                    return this.params;
                }

                @Override
                public Type getRawType() {
                    return List.class;
                }

                @Override
                public Type getOwnerType() {
                    return null;
                }
            };
            GenericEntity list = new GenericEntity(results, (Type)myType);
            builder.entity((Object)list);
            this.createPagingHeader(builder, uriInfo, pageList);
        }
        return builder;
    }

    protected void createPagingHeader(Response.ResponseBuilder builder, UriInfo uriInfo, PageList<?> resultList) {
        UriBuilder uriBuilder;
        PageControl pc = resultList.getPageControl();
        int page = pc.getPageNumber();
        if (resultList.getTotalSize() > (pc.getPageNumber() + 1) * pc.getPageSize()) {
            int nextPage = page + 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{nextPage});
            builder.header("Link", (Object)new Link("next", uriBuilder.build(new Object[0]).toString()).rfc5988String());
        }
        if (page > 0) {
            int prevPage = page - 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{prevPage});
            builder.header("Link", (Object)new Link("prev", uriBuilder.build(new Object[0]).toString()).rfc5988String());
        }
        if (!pc.isUnlimited()) {
            int lastPage = resultList.getTotalSize() / pc.getPageSize() - 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{lastPage});
            builder.header("Link", (Object)new Link("last", uriBuilder.build(new Object[0]).toString()).rfc5988String());
        }
        uriBuilder = uriInfo.getRequestUriBuilder();
        builder.header("Link", (Object)new Link("current", uriBuilder.build(new Object[0]).toString()).rfc5988String());
        builder.header("X-collection-size", (Object)resultList.getTotalSize());
    }

    protected <T> void wrapForPaging(Response.ResponseBuilder builder, UriInfo uriInfo, PageList<?> originalList, Collection<T> resultList) {
        UriBuilder uriBuilder;
        PagingCollection<T> pColl = new PagingCollection<T>(resultList);
        pColl.setTotalSize(originalList.getTotalSize());
        PageControl pageControl = originalList.getPageControl();
        pColl.setPageSize(pageControl.getPageSize());
        int page = pageControl.getPageNumber();
        pColl.setCurrentPage(page);
        int lastPage = originalList.getTotalSize() / pageControl.getPageSize() - 1;
        pColl.setLastPage(lastPage);
        if (originalList.getTotalSize() > (page + 1) * pageControl.getPageSize()) {
            int nextPage = page + 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{nextPage});
            pColl.addLink(new Link("next", uriBuilder.build(new Object[0]).toString()));
        }
        if (page > 0) {
            int prevPage = page - 1;
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{prevPage});
            pColl.addLink(new Link("prev", uriBuilder.build(new Object[0]).toString()));
        }
        if (!pageControl.isUnlimited()) {
            uriBuilder = uriInfo.getRequestUriBuilder();
            uriBuilder.replaceQueryParam("page", new Object[]{lastPage});
            pColl.addLink(new Link("last", uriBuilder.build(new Object[0]).toString()));
        }
        uriBuilder = uriInfo.getRequestUriBuilder();
        pColl.addLink(new Link("current", uriBuilder.build(new Object[0]).toString()));
        builder.entity(pColl);
    }

    protected ResourceGroup fetchGroup(int groupId, boolean requireCompatible) {
        ResourceGroup resourceGroup = this.resourceGroupManager.getResourceGroup(this.caller, groupId);
        if (resourceGroup == null) {
            throw new StuffNotFoundException("Group with id " + groupId);
        }
        if (requireCompatible && resourceGroup.getGroupCategory() != GroupCategory.COMPATIBLE) {
            throw new BadArgumentException("Group with id " + groupId, "it is no compatible group");
        }
        return resourceGroup;
    }

    protected GroupRest fillGroup(ResourceGroup group, UriInfo uriInfo) {
        GroupRest gr = new GroupRest(group.getName());
        gr.setId(group.getId());
        gr.setCategory(group.getGroupCategory());
        gr.setRecursive(group.isRecursive());
        if (group.getGroupDefinition() != null) {
            gr.setDynaGroupDefinitionId(group.getGroupDefinition().getId());
        }
        gr.setExplicitCount(group.getExplicitResources().size());
        gr.setImplicitCount(group.getImplicitResources().size());
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}");
        URI uri = uriBuilder.build(new Object[]{group.getId()});
        Link link = new Link("edit", uri.toASCIIString());
        gr.getLinks().add(link);
        gr.getLinks().add(this.getLinkToGroup(group, uriInfo, "self"));
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/group/{id}/metricDefinitions");
        uri = uriBuilder.build(new Object[]{group.getId()});
        link = new Link("metricDefinitions", uri.toASCIIString());
        gr.getLinks().add(link);
        gr.getLinks().add(this.createUILink(uriInfo, UILinkTemplate.GROUP, group.getId()));
        return gr;
    }

    protected Link createUILink(UriInfo uriInfo, UILinkTemplate template, Integer ... entityId) {
        String urlBase = template.getUrl();
        String replaced = String.format(urlBase, entityId);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.fragment(replaced);
        uriBuilder.replacePath("coregui/");
        URI uri = uriBuilder.build(new Object[0]);
        String href = uri.toString();
        href = href.replaceAll("%2F", "/");
        Link link = new Link("coregui", href);
        return link;
    }

    protected MetricSchedule getMetricScheduleInternal(UriInfo uriInfo, MeasurementSchedule schedule, MeasurementDefinition definition) {
        URI uri;
        UriBuilder uriBuilder;
        MetricSchedule ms = new MetricSchedule(schedule.getId(), definition.getName(), definition.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), definition.getUnits().toString(), definition.getDataType().toString());
        ms.setDefinitionId(definition.getId());
        if (schedule.getMtime() != null) {
            ms.setMtime(schedule.getMtime());
        }
        if (definition.getDataType() == DataType.MEASUREMENT) {
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/metric/data/{id}");
            uri = uriBuilder.build(new Object[]{schedule.getId()});
            Link metricLink = new Link("metric", uri.toString());
            ms.addLink(metricLink);
            uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/metric/data/{id}/raw");
            uri = uriBuilder.build(new Object[]{schedule.getId()});
            metricLink = new Link("metric-raw", uri.toString());
            ms.addLink(metricLink);
        }
        uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("resource/" + schedule.getResource().getId());
        uri = uriBuilder.build(new Object[0]);
        Link link = new Link("resource", uri.toString());
        ms.addLink(link);
        return ms;
    }

    protected void setCachingHeader(Response.ResponseBuilder builder, int maxAgeSecs) {
        CacheControl cc = new CacheControl();
        cc.setPrivate(false);
        cc.setNoCache(false);
        cc.setNoStore(false);
        if (maxAgeSecs > -1) {
            cc.setMaxAge(maxAgeSecs);
        }
        builder.cacheControl(cc);
    }

    private static class CacheValue {
        private Object value;
        private Set<Integer> readers = new HashSet<Integer>();

        public CacheValue(Object value, int readerId) {
            this.readers.add(readerId);
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Set<Integer> getReaders() {
            return this.readers;
        }
    }

    protected static class CacheKey {
        private String namespace;
        private int id;

        public CacheKey(Class<?> clazz, int id) {
            this(clazz.getName(), id);
        }

        public CacheKey(String namespace, int id) {
            this.namespace = namespace;
            this.id = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.namespace == null ? other.namespace != null : !this.namespace.equals(other.namespace)) {
                return false;
            }
            return this.id == other.id;
        }

        public String toString() {
            return "CacheKey [namespace=" + this.namespace + ", id=" + this.id + "]";
        }
    }
}

