/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertDampening;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.AlertPriority;
import org.rhq.core.domain.alert.BooleanExpression;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.operation.OperationDefinition;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.StringUtil;
import org.rhq.enterprise.server.alert.AlertConditionManagerLocal;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.alert.AlertNotificationManagerLocal;
import org.rhq.enterprise.server.operation.OperationManagerLocal;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderInfo;
import org.rhq.enterprise.server.plugin.pc.alert.AlertSenderPluginManager;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.UILinkTemplate;
import org.rhq.enterprise.server.rest.domain.AlertConditionRest;
import org.rhq.enterprise.server.rest.domain.AlertDefinitionRest;
import org.rhq.enterprise.server.rest.domain.AlertNotificationRest;
import org.rhq.enterprise.server.rest.domain.AlertSender;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.helper.ConfigurationHelper;

@Path(value="/alert")
@Api(value="Deal with Alert Definitions", description="This api deals with alert definitions.")
@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class AlertDefinitionHandlerBean
extends AbstractRestBean {
    @EJB
    private AlertDefinitionManagerLocal alertDefinitionManager;
    @EJB
    private AlertNotificationManagerLocal notificationMgr;
    @EJB
    private AlertConditionManagerLocal conditionMgr;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private ResourceGroupManagerLocal resourceGroupMgr;
    @EJB
    private ResourceTypeManagerLocal resourceTypeMgr;
    @EJB
    private OperationManagerLocal operationMgr;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @GET
    @Path(value="/definition")
    @ApiOperation(value="Redirects to /alert/definitions")
    public Response redirectDefinitionToDefinitions(@Context UriInfo uriInfo) {
        UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
        String path = uriInfo.getPath();
        path = path.replace("/definition", "/definitions");
        uriBuilder.replacePath("/rest" + path);
        Response.ResponseBuilder builder = Response.seeOther((URI)uriBuilder.build(new Object[0]));
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/definitions")
    @ApiOperation(value="List all Alert Definition", responseClass="AlertDefinitionRest", multiValueResponse=true)
    public Response listAlertDefinitions(@ApiParam(value="Should conditions and notifications be returned too?") @QueryParam(value="full") @DefaultValue(value="false") boolean full, @ApiParam(value="Page number") @QueryParam(value="page") Integer page, @ApiParam(value="Page size") @DefaultValue(value="20") @QueryParam(value="ps") int pageSize, @ApiParam(value="Resource id to filter by") @QueryParam(value="resourceId") Integer resourceId, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.addSortId(PageOrdering.ASC);
        if (page != null) {
            criteria.setPaging(page.intValue(), pageSize);
        }
        if (resourceId != null) {
            criteria.addFilterResourceIds(new Integer[]{resourceId});
        }
        PageList<AlertDefinition> defs = this.alertDefinitionManager.findAlertDefinitionsByCriteria(this.caller, criteria);
        ArrayList<AlertDefinitionRest> ret = new ArrayList<AlertDefinitionRest>(defs.size());
        for (AlertDefinition def : defs) {
            AlertDefinitionRest adr = this.definitionToDomain(def, full, uriInfo);
            ret.add(adr);
        }
        Response.ResponseBuilder builder = Response.ok();
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder.type(mediaType);
        if (mediaType.equals((Object)this.wrappedCollectionJsonType)) {
            this.wrapForPaging(builder, uriInfo, defs, ret);
        } else {
            this.createPagingHeader(builder, uriInfo, defs);
            if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                GenericEntity<List<AlertDefinitionRest>> list = new GenericEntity<List<AlertDefinitionRest>>(ret){};
                builder.entity((Object)list);
            } else {
                builder.entity(ret);
            }
        }
        return builder.build();
    }

    @GET
    @Path(value="/definition/{id}")
    @ApiOperation(value="Get one AlertDefinition by id", responseClass="AlertDefinitionRest")
    @ApiError(code=404, reason="No definition found with the passed id.")
    public Response getAlertDefinition(@ApiParam(value="Id of the alert definition to retrieve") @PathParam(value="id") int definitionId, @ApiParam(value="Should conditions and notifications be returned too?") @QueryParam(value="full") @DefaultValue(value="true") boolean full, @Context Request request, @Context UriInfo uriInfo) {
        AlertDefinition def = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (def == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        EntityTag eTag = new EntityTag(Integer.toHexString(def.hashCode()));
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            AlertDefinitionRest adr = this.definitionToDomain(def, full, uriInfo);
            builder = Response.ok((Object)adr);
        }
        builder.tag(eTag);
        return builder.build();
    }

    @POST
    @Path(value="/definitions")
    @ApiOperation(value="Create an AlertDefinition for the resource/group/resource type passed as query param. One and only one of the three params must be given at any time. Please also check the POST method for conditions and notifications to see their options")
    @ApiErrors(value={@ApiError(code=406, reason="There was not exactly one of 'resourceId','groupId' or 'resourceTypeId' given"), @ApiError(code=406, reason="The passed condition failed validation"), @ApiError(code=406, reason="The passed group was a mixed group, that can not have alert definitions"), @ApiError(code=404, reason="A non existing alert notification sender was requested."), @ApiError(code=404, reason="A referenced alert to recover does not exist")})
    public Response createAlertDefinition(@ApiParam(value="The id of the resource to attach the definition to") @QueryParam(value="resourceId") Integer resourceId, @ApiParam(value="The id of the group to attach the definition to") @QueryParam(value="groupId") Integer groupId, @ApiParam(value="The id of the resource type to attach the definition to") @QueryParam(value="resourceTypeId") Integer resourceTypeId, @ApiParam(value="The data for the new definition") AlertDefinitionRest adr, @Context UriInfo uriInfo) {
        int i = 0;
        if (resourceId != null) {
            ++i;
        }
        if (groupId != null) {
            ++i;
        }
        if (resourceTypeId != null) {
            ++i;
        }
        if (i != 1) {
            throw new BadArgumentException("query param", "You must give exactly one query param out of 'resourceId', 'groupId' or 'resourceTypeId'");
        }
        AlertDefinition alertDefinition = new AlertDefinition();
        alertDefinition.setName(adr.getName());
        alertDefinition.setEnabled(adr.isEnabled());
        if (adr.getPriority() == null) {
            adr.setPriority("LOW");
        }
        alertDefinition.setPriority(AlertPriority.valueOf((String)adr.getPriority().toUpperCase()));
        alertDefinition.setConditionExpression(BooleanExpression.valueOf((String)adr.getConditionMode().toUpperCase()));
        alertDefinition.setRecoveryId(Integer.valueOf(adr.getRecoveryId()));
        Resource resource = null;
        if (resourceId != null) {
            resource = this.fetchResource(resourceId);
        }
        ResourceType resourceType = null;
        if (groupId != null) {
            ResourceGroup group = this.resourceGroupMgr.getResourceGroup(this.caller, groupId);
            alertDefinition.setGroup(group);
            if (group.getGroupCategory() == GroupCategory.MIXED) {
                throw new BadArgumentException("Group with id " + groupId + " is a mixed group");
            }
            resourceType = group.getResourceType();
        }
        if (resourceTypeId != null) {
            resourceType = this.resourceTypeMgr.getResourceTypeById(this.caller, resourceTypeId);
            alertDefinition.setResourceType(resourceType);
        }
        HashSet<AlertCondition> conditions = new HashSet<AlertCondition>(adr.getConditions().size());
        for (AlertConditionRest acr : adr.getConditions()) {
            AlertCondition condition = this.conditionRestToCondition(acr, resource, resourceType);
            conditions.add(condition);
        }
        alertDefinition.setConditions(conditions);
        ArrayList<AlertNotification> notifications = new ArrayList<AlertNotification>(adr.getNotifications().size());
        AlertSenderPluginManager pluginManager = this.alertManager.getAlertPluginManager();
        for (AlertNotificationRest anr : adr.getNotifications()) {
            AlertNotification notification = this.notificationRestToNotification(alertDefinition, anr);
            notifications.add(notification);
        }
        alertDefinition.setAlertNotifications(notifications);
        this.setDampeningFromRest(alertDefinition, adr);
        if (adr.getRecoveryId() > 0) {
            AlertDefinition recoveryDef = this.alertDefinitionManager.getAlertDefinition(this.caller, adr.getRecoveryId());
            if (recoveryDef != null) {
                alertDefinition.setRecoveryId(Integer.valueOf(adr.getRecoveryId()));
            } else {
                throw new StuffNotFoundException("Recovery alert with id " + adr.getRecoveryId());
            }
        }
        AlertDefinition updatedDefinition = this.alertDefinitionManager.createAlertDefinitionInNewTransaction(this.caller, alertDefinition, resourceId, false);
        int definitionId = updatedDefinition.getId();
        AlertDefinitionRest uadr = this.definitionToDomain(updatedDefinition, true, uriInfo);
        uadr.setId(definitionId);
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/definition/{id}");
        URI uri = uriBuilder.build(new Object[]{definitionId});
        Response.ResponseBuilder builder = Response.created((URI)uri);
        builder.entity((Object)uadr);
        return builder.build();
    }

    @PUT
    @Path(value="/definition/{id}")
    @ApiOperation(value="Update the alert definition (priority, enablement, dampening, recovery)", notes="Priority must be HIGH,LOW,MEDIUM. If not provided, LOW is assumed.")
    @ApiError(code=404, reason="No AlertDefinition with the passed id exists")
    public Response updateDefinition(@ApiParam(value="Id of the alert definition to update") @PathParam(value="id") int definitionId, @ApiParam(value="Data for the update") AlertDefinitionRest definitionRest, @Context UriInfo uriInfo) {
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (definition == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        definition = new AlertDefinition(definition);
        definition.setEnabled(definitionRest.isEnabled());
        if (definitionRest.getPriority() != null) {
            definition.setPriority(AlertPriority.valueOf((String)definitionRest.getPriority()));
        } else {
            definition.setPriority(AlertPriority.LOW);
        }
        this.setDampeningFromRest(definition, definitionRest);
        if (definitionRest.getRecoveryId() > 0) {
            AlertDefinition recoveryDef = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionRest.getRecoveryId());
            if (recoveryDef != null) {
                definition.setRecoveryId(Integer.valueOf(definitionRest.getRecoveryId()));
            } else {
                throw new StuffNotFoundException("Alert to recover with id " + definitionRest.getRecoveryId());
            }
        }
        definition = this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definitionId, definition, true, true, true);
        this.entityManager.flush();
        EntityTag eTag = new EntityTag(Integer.toHexString(definition.hashCode()));
        AlertDefinitionRest adr = this.definitionToDomain(definition, false, uriInfo);
        Response.ResponseBuilder builder = Response.ok((Object)adr);
        builder.tag(eTag);
        return builder.build();
    }

    @DELETE
    @Path(value="definition/{id}")
    @ApiOperation(value="Delete an alert definition", notes="This operation is by default idempotent, returning 204.If you want to check if the definition existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=204, reason="Definition was deleted or did not exist with validation not set"), @ApiError(code=404, reason="Definition did not exist and validate was set")})
    public Response deleteDefinition(@ApiParam(value="Id of the definition to delete") @PathParam(value="id") int definitionId, @ApiParam(value="Validate if the definition exists") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate) {
        int count = this.alertDefinitionManager.removeAlertDefinitions(this.caller, new int[]{definitionId});
        if (count == 0 && validate) {
            throw new StuffNotFoundException("Definition with id " + definitionId);
        }
        return Response.noContent().build();
    }

    private void setDampeningFromRest(AlertDefinition alertDefinition, AlertDefinitionRest adr) {
        AlertDampening.Category dampeningCategory;
        try {
            dampeningCategory = AlertDampening.Category.valueOf((String)adr.getDampeningCategory().toUpperCase());
        }
        catch (Exception e) {
            AlertDampening.Category[] vals = AlertDampening.Category.values();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < vals.length; ++i) {
                builder.append(vals[i].name());
                if (i >= vals.length - 1) continue;
                builder.append(", ");
            }
            throw new BadArgumentException("dampening category", "Allowed values are: " + builder.toString());
        }
        if (dampeningCategory == AlertDampening.Category.ONCE) {
            alertDefinition.setWillRecover(true);
            dampeningCategory = AlertDampening.Category.NONE;
        }
        if (dampeningCategory == AlertDampening.Category.NO_DUPLICATES) {
            dampeningCategory = AlertDampening.Category.NONE;
        }
        AlertDampening dampening = new AlertDampening(dampeningCategory);
        if (adr.getDampeningCount() > -1) {
            dampening.setValue(adr.getDampeningCount());
        }
        if (adr.getDampeningPeriod() > 0) {
            dampening.setPeriod(adr.getDampeningPeriod());
            try {
                if (adr.getDampeningUnit() != null) {
                    dampening.setPeriodUnits(AlertDampening.TimeUnits.valueOf((String)adr.getDampeningUnit().toUpperCase()));
                }
            }
            catch (Exception e) {
                throw new BadArgumentException("dampening unit", "Allowed values are MINUTES,HOURS,DAYS, WEEKS");
            }
        }
        alertDefinition.setAlertDampening(dampening);
    }

    private AlertNotification notificationRestToNotification(AlertDefinition alertDefinition, AlertNotificationRest anr) {
        AlertNotification notification = new AlertNotification(anr.getSenderName());
        if (this.notificationMgr.getAlertInfoForSender(anr.getSenderName()) == null) {
            throw new StuffNotFoundException("AlertSender with name [" + anr.getSenderName() + "]");
        }
        notification.setAlertDefinition(alertDefinition);
        notification.setConfiguration(ConfigurationHelper.mapToConfiguration(anr.getConfig()));
        notification.setExtraConfiguration(ConfigurationHelper.mapToConfiguration(anr.getExtraConfig()));
        return notification;
    }

    @DELETE
    @Path(value="condition/{cid}")
    @ApiOperation(value="Remove an alert condition", notes="This operation is by default idempotent, returning 204.If you want to check if the condition existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=204, reason="Condition was deleted or did not exist with validation not set"), @ApiError(code=404, reason="Condition did not exist and validate was set")})
    public Response deleteCondition(@ApiParam(value="The id of the condition to remove") @PathParam(value="cid") int conditionId, @ApiParam(value="Validate if the condition exists") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate) {
        Integer definitionId;
        try {
            definitionId = this.findDefinitionIdForConditionId(conditionId);
        }
        catch (NoResultException nre) {
            if (validate) {
                throw new StuffNotFoundException("Condition with id " + conditionId);
            }
            return Response.noContent().build();
        }
        AlertDefinition definition2 = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)definitionId);
        AlertCondition condition = null;
        for (AlertCondition c : definition2.getConditions()) {
            if (c.getId() != conditionId) continue;
            condition = c;
        }
        definition2.getConditions().remove(condition);
        this.alertDefinitionManager.updateAlertDefinition(this.caller, definitionId, definition2, true);
        return Response.noContent().build();
    }

    @POST
    @Path(value="definition/{id}/conditions")
    @ApiOperation(value="Add a new alert condition to an existing alert definition", notes="<xml><para>Each condition falls into a category. Allowed categories are AVAILABILITY, AVAIL_DURATION, BASELINE(m), CHANGE(m), CONTROL, DRIFT, EVENT, RANGE(m), RESOURCE_CONFIG, THRESHOLD(m), TRAIT(m).Categories with an appended (m) are for metrics and need a metricDefinition, but no name, as the name is obtained from the metric definition. Parameters vary depending on the category: <itemizedlist><listitem><simpara>AVAILABILITY: name is one of AVAIL_GOES_DOWN, AVAIL_GOES_DISABLED, AVAIL_GOES_UNKNOWN, AVAIL_GOES_NOT_UP and AVAIL_GOES_UP.</simpara></listitem><listitem><simpara>AVAIL_DURATION: name is one of AVAIL_DURATION_DOWN andAVAIL_DURATION_NOT_UP; option gives the duration in seconds.</simpara></listitem><listitem><simpara>BASELINE: option is one of 'min','mean','max', threshold gives the percentage (0.01=1%), comparator is one of '&lt;','=' and '>'.</simpara></listitem><listitem><simpara>CONTROL: option gives the Operation status (FAILURE,SUCCESS,INPROGRESS,CANCELED), name is the name of the operation (not the display-name).</simpara></listitem><listitem><simpara>EVENT: name is the severity (DEBUG,INFO,WARN,ERROR,FATAL), option is an optional RegEx to match against.</simpara></listitem><listitem><simpara>DRIFT: name is optional and matches drift-definitions; option is optional and matches directories.</simpara></listitem><listitem><simpara>RANGE: threshold has the lower bound, option the higher bound, comparator is one of '&lt;','&lt;=','=','>=' or '>'.</simpara></listitem><listitem><simpara>RESOURCE_CONFIG: no additional params needed.</simpara></listitem><listitem><simpara>THRESHOLD: comparator is one of '&lt;','=','>'; threshold is the value to compare against.</simpara></listitem><listitem><simpara>TRAIT: option is an optional RegEx to match against.</simpara></listitem></itemizedlist></para></xml>")
    @ApiErrors(value={@ApiError(code=404, reason="No AlertDefinition with the passed id exists"), @ApiError(code=406, reason="The passed condition failed validation. A more detailed message is provided")})
    public Response addConditionToDefinition(@ApiParam(value="The id of the alert definition") @PathParam(value="id") int definitionId, @ApiParam(value="The condition to add") AlertConditionRest conditionRest, @Context UriInfo uriInfo) {
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (definition == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        Resource resource = definition.getResource();
        ResourceType resourceType = definition.getResourceType();
        AlertCondition condition = this.conditionRestToCondition(conditionRest, resource, resourceType);
        definition.addCondition(condition);
        this.alertDefinitionManager.updateAlertDefinition(this.caller, definitionId, definition, false);
        Response.ResponseBuilder builder = this.getResponseBuilderForCondition(definitionId, uriInfo, condition, true);
        return builder.build();
    }

    private Integer findDefinitionIdForConditionId(int conditionId) {
        Query q = this.entityManager.createQuery("SELECT condition.alertDefinition.id FROM AlertCondition condition WHERE condition.id = :id ");
        q.setParameter("id", (Object)conditionId);
        Object o = q.getSingleResult();
        return (Integer)o;
    }

    @PUT
    @Path(value="condition/{cid}")
    @ApiOperation(value="Update an existing condition of an alert definition.Note that the update will change the id of the condition")
    @ApiErrors(value={@ApiError(code=404, reason="Condition with passed id does not exist"), @ApiError(code=406, reason="The passed category or condition operator was invalid")})
    public Response updateCondition(@ApiParam(value="The id of the condition to update") @PathParam(value="cid") int conditionId, @ApiParam(value="The updated condition") AlertConditionRest conditionRest, @Context UriInfo uriInfo) {
        Integer definitionId;
        try {
            definitionId = this.findDefinitionIdForConditionId(conditionId);
        }
        catch (NoResultException nre) {
            throw new StuffNotFoundException("Condition with id " + conditionId);
        }
        AlertDefinition definition = (AlertDefinition)this.entityManager.find(AlertDefinition.class, (Object)definitionId);
        AlertCondition condition = null;
        Iterator iterator = definition.getConditions().iterator();
        while (iterator.hasNext()) {
            AlertCondition oldCondition = (AlertCondition)iterator.next();
            if (oldCondition.getId() != conditionId) continue;
            condition = new AlertCondition(oldCondition);
            oldCondition.setAlertDefinition(null);
            iterator.remove();
            this.entityManager.remove((Object)oldCondition);
        }
        Resource resource = definition.getResource();
        ResourceType resourceType = definition.getResourceType();
        AlertCondition restCondition = this.conditionRestToCondition(conditionRest, resource, resourceType);
        condition.setOption(conditionRest.getOption());
        condition.setComparator(conditionRest.getComparator());
        condition.setMeasurementDefinition(restCondition.getMeasurementDefinition());
        condition.setThreshold(conditionRest.getThreshold());
        condition.setTriggerId(conditionRest.getTriggerId());
        definition.getConditions().add(condition);
        this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definitionId, definition, true, true, true);
        this.entityManager.flush();
        Response.ResponseBuilder builder = this.getResponseBuilderForCondition(definitionId, uriInfo, condition, false);
        return builder.build();
    }

    @GET
    @Path(value="condition/{cid}")
    @ApiOperation(value="Retrieve a condition of an alert definition by its condition id")
    @ApiError(code=404, reason="No condition with the passed id exists")
    public Response getCondition(@ApiParam(value="The id of the condition to retrieve") @PathParam(value="cid") int conditionId) {
        AlertCondition condition = this.conditionMgr.getAlertConditionById(conditionId);
        if (condition == null) {
            throw new StuffNotFoundException("No condition with id " + conditionId);
        }
        AlertConditionRest acr = this.conditionToConditionRest(condition);
        return Response.ok((Object)acr).build();
    }

    private AlertCondition conditionRestToCondition(AlertConditionRest conditionRest, Resource resource, ResourceType resourceType) {
        MeasurementDefinition md;
        AlertCondition condition = new AlertCondition();
        try {
            condition.setCategory(AlertConditionCategory.valueOf((String)conditionRest.getCategory().toUpperCase()));
        }
        catch (Exception e) {
            String allowedValues = this.stringify(AlertConditionCategory.class);
            throw new BadArgumentException("Field 'category' [" + conditionRest.getCategory() + "] is invalid. Allowed values " + "are : " + allowedValues);
        }
        int measurementDefinition = conditionRest.getMeasurementDefinition();
        if (measurementDefinition != 0) {
            Set definitions;
            ResourceType type;
            Set definitions2;
            md = (MeasurementDefinition)this.entityManager.find(MeasurementDefinition.class, (Object)measurementDefinition);
            if (md == null) {
                throw new StuffNotFoundException("measurementDefinition with id " + measurementDefinition);
            }
            if (resource != null && !(definitions2 = (type = resource.getResourceType()).getMetricDefinitions()).contains(md)) {
                throw new BadArgumentException("MeasurementDefinition does not apply to resource");
            }
            if (resourceType != null && !(definitions = resourceType.getMetricDefinitions()).contains(md)) {
                throw new BadArgumentException("MeasurementDefinition does not apply to resource type");
            }
        }
        String optionValue = conditionRest.getOption();
        String conditionName = conditionRest.getName();
        condition.setName(conditionName);
        AlertConditionCategory category = condition.getCategory();
        switch (category) {
            case ALERT: {
                break;
            }
            case AVAIL_DURATION: {
                if (optionValue == null) {
                    throw new BadArgumentException("Option needs to be provided as duration in seconds");
                }
                try {
                    Integer.parseInt(optionValue);
                }
                catch (NumberFormatException nfe) {
                    throw new BadArgumentException("Option provided [" + optionValue + "] was bad. Must be duration in seconds");
                }
                this.checkForAllowedValues("name", conditionName, "AVAIL_DURATION_DOWN", "AVAIL_DURATION_NOT_UP");
                break;
            }
            case AVAILABILITY: {
                this.checkForAllowedValues("name", conditionName, "AVAIL_GOES_DOWN", "AVAIL_GOES_DISABLED", "AVAIL_GOES_UNKNOWN", "AVAIL_GOES_NOT_UP", "AVAIL_GOES_UP");
                break;
            }
            case BASELINE: {
                if (measurementDefinition == 0) {
                    throw new BadArgumentException("You need to provide a measurementDefinition for category BASELINE");
                }
                md = (MeasurementDefinition)this.entityManager.find(MeasurementDefinition.class, (Object)measurementDefinition);
                if (md == null) {
                    throw new StuffNotFoundException("measurementDefinition with id " + measurementDefinition);
                }
                condition.setMeasurementDefinition(md);
                condition.setName(md.getDisplayName());
                this.checkForAllowedValues("option", optionValue, "min", "max", "mean");
                this.checkForAllowedValues("comparator", conditionRest.getComparator(), "<", "=", ">");
                break;
            }
            case CHANGE: {
                md = this.getMeasurementDefinition(measurementDefinition, category);
                condition.setMeasurementDefinition(md);
                condition.setName(md.getDisplayName());
                if (md.getDataType() != DataType.CALLTIME) break;
                this.checkForAllowedValues("option", optionValue, "MIN", "MAX", "AVG");
                break;
            }
            case CONTROL: {
                this.checkForAllowedValues("option", optionValue, "INPROGRESS", "SUCCESS", "FAILURE", "CANCELED");
                if (conditionName != null) break;
                throw new BadArgumentException("name must be the name (not display name) of a valid operation.");
            }
            case DRIFT: {
                break;
            }
            case EVENT: {
                this.checkForAllowedValues("name", conditionName, "DEBUG", "INFO", "WARN", "ERROR", "FATAL");
                break;
            }
            case RANGE: {
                this.checkForAllowedValues("comparator", conditionRest.getComparator(), "<", "=", ">", "<=", ">=");
                if (optionValue == null) {
                    throw new BadArgumentException("You need to supply an upper threshold in 'option' as numeric value");
                }
                try {
                    Double.parseDouble(optionValue);
                }
                catch (NumberFormatException nfe) {
                    throw new BadArgumentException("You need to supply an upper threshold in 'option' as numeric value");
                }
                md = this.getMeasurementDefinition(measurementDefinition, category);
                condition.setMeasurementDefinition(md);
                condition.setName(md.getDisplayName());
                break;
            }
            case RESOURCE_CONFIG: {
                break;
            }
            case THRESHOLD: {
                this.checkForAllowedValues("comparator", conditionRest.getComparator(), "<", "=", ">");
                md = this.getMeasurementDefinition(measurementDefinition, category);
                condition.setMeasurementDefinition(md);
                condition.setName(md.getDisplayName());
                if (md.getDataType() != DataType.CALLTIME) break;
                this.checkForAllowedValues("option", optionValue, "MIN", "MAX", "AVG");
                break;
            }
            case TRAIT: {
                md = this.getMeasurementDefinition(measurementDefinition, category);
                condition.setMeasurementDefinition(md);
                condition.setName(md.getDisplayName());
            }
        }
        condition.setOption(optionValue);
        condition.setComparator(conditionRest.getComparator());
        condition.setThreshold(conditionRest.getThreshold());
        condition.setTriggerId(conditionRest.getTriggerId());
        return condition;
    }

    private MeasurementDefinition getMeasurementDefinition(int measurementDefinition, AlertConditionCategory category) {
        if (measurementDefinition == 0) {
            throw new BadArgumentException("You need to provide a measurementDefinition for category " + category.name());
        }
        MeasurementDefinition md = (MeasurementDefinition)this.entityManager.find(MeasurementDefinition.class, (Object)measurementDefinition);
        if (md == null) {
            throw new StuffNotFoundException("measurementDefinition with id " + measurementDefinition);
        }
        return md;
    }

    private void checkForAllowedValues(String attributeName, String toCheck, String ... allowedValues) {
        if (toCheck == null) {
            throw new BadArgumentException("Field " + attributeName + " must be set. Allowed values are: " + StringUtil.arrayToString((Object[])allowedValues));
        }
        if (allowedValues == null) {
            throw new IllegalArgumentException("No allowed values are provided - please contact support");
        }
        boolean match = false;
        for (String value : allowedValues) {
            if (!toCheck.equals(value)) continue;
            match = true;
        }
        if (!match) {
            throw new BadArgumentException("Field " + attributeName + " has an invalid value [" + toCheck + "]. Allowed values are: " + StringUtil.arrayToString((Object[])allowedValues));
        }
    }

    private String stringify(Class<? extends Enum> clazz) {
        EnumSet<? extends Enum> enumSet = EnumSet.allOf(clazz);
        StringBuilder b = new StringBuilder();
        Iterator iter = enumSet.iterator();
        while (iter.hasNext()) {
            Enum anEnum = (Enum)iter.next();
            b.append(anEnum.name());
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        return b.toString();
    }

    private Response.ResponseBuilder getResponseBuilderForCondition(int definitionId, UriInfo uriInfo, AlertCondition originalCondition, boolean isCreate) {
        Response.ResponseBuilder builder;
        AlertDefinition updatedDefinition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        Set conditions = updatedDefinition.getConditions();
        int conditionId = -1;
        AlertCondition createdCondition = null;
        for (AlertCondition cond : conditions) {
            if (originalCondition.getId() != cond.getId() && (cond.getName() == null || !cond.getName().equals(originalCondition.getName()))) continue;
            conditionId = cond.getId();
            createdCondition = cond;
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/condition/{cid}");
        URI uri = uriBuilder.build(new Object[]{conditionId});
        AlertConditionRest result = this.conditionToConditionRest(createdCondition);
        if (isCreate) {
            builder = Response.created((URI)uri);
        } else {
            builder = Response.ok();
            builder.location(uri);
        }
        builder.entity((Object)result);
        return builder;
    }

    @GET
    @Path(value="notification/{nid}")
    @ApiOperation(value="Return a notification definition by its id")
    @ApiError(code=404, reason="No notification with the passed id found")
    public Response getNotification(@ApiParam(value="The id of the notification definition to retrieve") @PathParam(value="nid") int notificationId) {
        AlertNotification notification = this.notificationMgr.getAlertNotification(this.caller, notificationId);
        if (notification == null) {
            throw new StuffNotFoundException("No notification with id " + notificationId);
        }
        AlertNotificationRest anr = this.notificationToNotificationRest(notification);
        return Response.ok((Object)anr).build();
    }

    @DELETE
    @Path(value="notification/{nid}")
    @ApiOperation(value="Remove a notification definition", notes="This operation is by default idempotent, returning 204.If you want to check if the notification existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=204, reason="Notification was deleted or did not exist with validation not set"), @ApiError(code=404, reason="Notification did not exist and validate was set")})
    public Response deleteNotification(@ApiParam(value="The id of the notification definition to remove") @PathParam(value="nid") int notificationId, @ApiParam(value="Validate if the notification exists") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate) {
        AlertNotification notification = this.notificationMgr.getAlertNotification(this.caller, notificationId);
        if (notification != null) {
            AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, notification.getAlertDefinition().getId());
            definition.getAlertNotifications().remove(notification);
            this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definition.getId(), definition, true, true, true);
            this.entityManager.flush();
        } else if (validate) {
            throw new StuffNotFoundException("Notification with id " + notificationId);
        }
        return Response.noContent().build();
    }

    @PUT
    @Path(value="notification/{nid}")
    @ApiOperation(value="Update a notification definition")
    @ApiError(code=404, reason="There is no notification with the passed id")
    public Response updateNotification(@ApiParam(value="The id of the notification definition to update") @PathParam(value="nid") int notificationId, @ApiParam(value="The updated notification definition to use") AlertNotificationRest notificationRest) {
        AlertNotification notification = this.notificationMgr.getAlertNotification(this.caller, notificationId);
        if (notification == null) {
            throw new StuffNotFoundException("No notification with id " + notificationId);
        }
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, notification.getAlertDefinition().getId());
        AlertNotification newNotif = this.notificationRestToNotification(definition, notificationRest);
        notification.setConfiguration(newNotif.getConfiguration());
        notification.setExtraConfiguration(newNotif.getExtraConfiguration());
        this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definition.getId(), definition, true, true, true);
        this.entityManager.flush();
        List notifications = definition.getAlertNotifications();
        int newNotifId = 0;
        for (AlertNotification n : notifications) {
            if (!n.getSenderName().equals(notification.getSenderName())) continue;
            newNotifId = n.getId();
        }
        AlertNotification result = this.notificationMgr.getAlertNotification(this.caller, newNotifId);
        AlertNotificationRest resultRest = this.notificationToNotificationRest(result);
        return Response.ok((Object)resultRest).build();
    }

    @POST
    @Path(value="definition/{id}/notifications")
    @ApiOperation(value="Add a new notification definition to an alert definition")
    @ApiErrors(value={@ApiError(code=404, reason="Requested alert notification sender does not exist"), @ApiError(code=404, reason="There is no alert definition with the passed id")})
    public Response addNotificationToDefinition(@ApiParam(value="Id of the alert definition that should get the notification definition") @PathParam(value="id") int definitionId, @ApiParam(value="The notification definition to add") AlertNotificationRest notificationRest, @Context UriInfo uriInfo) {
        AlertDefinition definition = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (definition == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        AlertNotification notification = this.notificationRestToNotification(definition, notificationRest);
        int existingNotificationCount = definition.getAlertNotifications().size();
        definition.addAlertNotification(notification);
        this.alertDefinitionManager.updateAlertDefinitionInternal(this.caller, definitionId, definition, false, true, true);
        this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        this.entityManager.flush();
        AlertDefinition updatedDefinition = this.alertDefinitionManager.getAlertDefinitionById(this.caller, definitionId);
        List notifs = updatedDefinition.getAlertNotifications();
        assert (notifs.size() == existingNotificationCount + 1);
        AlertNotification updatedNotification = (AlertNotification)notifs.get(existingNotificationCount);
        AlertNotificationRest updatedNotificationRest = this.notificationToNotificationRest(updatedNotification);
        int notificationId = updatedNotification.getId();
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/notification/{nid}");
        URI uri = uriBuilder.build(new Object[]{notificationId});
        Response.ResponseBuilder builder = Response.created((URI)uri);
        builder.entity((Object)updatedNotificationRest);
        return builder.build();
    }

    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Return a list of alert notification senders with a short description. The list does not include the configuration definition.")
    @GET
    @GZIP
    @Path(value="senders")
    public Response getAlertSenders(@Context UriInfo uriInfo) {
        List<String> senderNames = this.notificationMgr.listAllAlertSenders();
        ArrayList<AlertSender> senderList = new ArrayList<AlertSender>(senderNames.size());
        for (String senderName : senderNames) {
            AlertSenderInfo info = this.notificationMgr.getAlertInfoForSender(senderName);
            AlertSender sender = new AlertSender(senderName);
            sender.setDescription(info.getDescription());
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/alert/sender/{name}");
            URI uri = uriBuilder.build(new Object[]{sender.getSenderName()});
            Link self = new Link("self", uri.toString());
            sender.setLink(self);
            senderList.add(sender);
        }
        GenericEntity<List<AlertSender>> entity = new GenericEntity<List<AlertSender>>(senderList){};
        Response.ResponseBuilder builder = Response.ok((Object)entity);
        return builder.build();
    }

    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Return an alert notification sender by name. This includes information about the configuration it expects")
    @GET
    @GZIP
    @Path(value="sender/{name}")
    @ApiError(code=404, reason="There is no sender with the passed name")
    public Response getAlertSenderByName(@ApiParam(value="Name of the sender to retrieve") @PathParam(value="name") String senderName, @Context UriInfo uriInfo) {
        AlertSenderInfo info = this.notificationMgr.getAlertInfoForSender(senderName);
        if (info == null) {
            throw new StuffNotFoundException("Alert sender with name [" + senderName + "]");
        }
        AlertSender sender = new AlertSender(senderName);
        sender.setDescription(info.getDescription());
        ConfigurationDefinition definition = this.notificationMgr.getConfigurationDefinitionForSender(senderName);
        for (PropertyDefinition pd : definition.getPropertyDefinitions().values()) {
            if (pd instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple pds = (PropertyDefinitionSimple)pd;
                sender.getConfigDefinition().put(pds.getName(), pds.getType().name());
                continue;
            }
            this.log.warn((Object)("Property " + pd.getName() + " for sender " + senderName + " is not of a supported type"));
        }
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
        uriBuilder.path("/alert/sender/{name}");
        URI uri = uriBuilder.build(new Object[]{sender.getSenderName()});
        Link self = new Link("self", uri.toString());
        sender.setLink(self);
        Response.ResponseBuilder builder = Response.ok((Object)sender);
        return builder.build();
    }

    AlertDefinitionRest definitionToDomain(AlertDefinition def, boolean full, UriInfo uriInfo) {
        AlertDampening.TimeUnits units;
        AlertDefinitionRest adr = new AlertDefinitionRest(def.getId());
        adr.setName(def.getName());
        adr.setEnabled(def.getEnabled());
        adr.setPriority(def.getPriority().getName());
        adr.setConditionMode(def.getConditionExpression().toString());
        adr.setRecoveryId(def.getRecoveryId());
        if (full) {
            List notifications;
            Set conditions = def.getConditions();
            if (conditions.size() > 0) {
                ArrayList<AlertConditionRest> conditionRestList = new ArrayList<AlertConditionRest>(conditions.size());
                for (AlertCondition condition : conditions) {
                    AlertConditionRest acr = this.conditionToConditionRest(condition);
                    conditionRestList.add(acr);
                }
                adr.setConditions(conditionRestList);
            }
            if ((notifications = def.getAlertNotifications()).size() > 0) {
                ArrayList<AlertNotificationRest> notificationRestList = new ArrayList<AlertNotificationRest>(notifications.size());
                for (AlertNotification notification : notifications) {
                    AlertNotificationRest anr = this.notificationToNotificationRest(notification);
                    notificationRestList.add(anr);
                }
                adr.setNotifications(notificationRestList);
            }
        }
        AlertDampening dampening = def.getAlertDampening();
        adr.setDampeningCategory(dampening.getCategory().name());
        if (dampening.getCategory() == AlertDampening.Category.NONE && def.getWillRecover()) {
            adr.setDampeningCategory(AlertDampening.Category.ONCE.name());
        }
        String s = (units = dampening.getValueUnits()) != null ? " " + units.name() : "";
        adr.setDampeningCount(dampening.getValue());
        units = dampening.getPeriodUnits();
        s = units != null ? " " + units.name() : "";
        adr.setDampeningPeriod(dampening.getPeriod());
        if (dampening.getPeriodUnits() != null) {
            adr.setDampeningUnit(dampening.getPeriodUnits().name());
        }
        List<Link> links = adr.getLinks();
        if (def.getResource() != null) {
            links.add(this.createUILink(uriInfo, UILinkTemplate.RESOURCE_ALERT_DEF, def.getResource().getId(), adr.getId()));
            links.add(this.getLinkToResource(def.getResource(), uriInfo, "resource"));
        } else if (def.getGroup() != null) {
            links.add(this.createUILink(uriInfo, UILinkTemplate.GROUP_ALERT_DEF, def.getGroup().getId(), adr.getId()));
            links.add(this.getLinkToGroup(def.getGroup(), uriInfo, "group"));
        } else {
            links.add(this.createUILink(uriInfo, UILinkTemplate.TEMPLATE_ALERT_DEF, def.getResourceType().getId(), adr.getId()));
            links.add(this.getLinkToResourceType(def.getResourceType(), uriInfo, "resourceType"));
        }
        return adr;
    }

    private AlertNotificationRest notificationToNotificationRest(AlertNotification notification) {
        AlertNotificationRest anr = new AlertNotificationRest();
        anr.setId(notification.getId());
        anr.setSenderName(notification.getSenderName());
        ConfigurationDefinition configDef = this.notificationMgr.getConfigurationDefinitionForSender(notification.getSenderName());
        anr.setConfig(ConfigurationHelper.configurationToMap(notification.getConfiguration(), configDef, false));
        ConfigurationDefinition extraConfigDef = null;
        if ("Resource Operations".equals(notification.getSenderName())) {
            OperationDefinition opDef = this.operationMgr.getOperationDefinition(this.caller, Integer.valueOf(notification.getConfiguration().getSimpleValue("operation-definition-id", "0")));
            extraConfigDef = opDef.getParametersConfigurationDefinition();
        }
        anr.setExtraConfig(ConfigurationHelper.configurationToMap(notification.getExtraConfiguration(), extraConfigDef, false));
        return anr;
    }

    private AlertConditionRest conditionToConditionRest(AlertCondition condition) {
        AlertConditionRest acr = new AlertConditionRest();
        acr.setId(condition.getId());
        acr.setName(condition.getName());
        acr.setCategory(condition.getCategory().getName());
        acr.setOption(condition.getOption());
        acr.setComparator(condition.getComparator());
        acr.setMeasurementDefinition(condition.getMeasurementDefinition() == null ? 0 : condition.getMeasurementDefinition().getId());
        acr.setThreshold(condition.getThreshold());
        acr.setTriggerId(condition.getTriggerId());
        return acr;
    }
}

