/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.rhq.core.domain.criteria.PluginCriteria;
import org.rhq.core.domain.plugin.Plugin;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.BooleanValue;
import org.rhq.enterprise.server.rest.domain.PluginRest;
import org.rhq.enterprise.server.rest.domain.StringValue;

@Path(value="/plugins")
@Api(value="Plugin related", description="This endpoint deals with RHQ's plugins")
@Produces(value={"application/json", "application/xml"})
@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class PluginHandlerBean
extends AbstractRestBean {
    @EJB
    private PluginManagerLocal pluginManager;

    @GET
    @Path(value="/")
    @ApiOperation(value="Looks for the plugins currently present in the system, optionally reloading them from the server's filesystem")
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Response findPlugins(@QueryParam(value="name") String name, @ApiParam(value="Look for enabled, disabled or both kinds of plugins?") @QueryParam(value="enabled") Boolean enabled, @ApiParam(value="The version of the plugin to look for") @QueryParam(value="version") String version, @ApiParam(value="Whether to look for deleted, installed or both plugins") @DefaultValue(value="false") @QueryParam(value="deleted") Boolean deleted, @ApiParam(value="Whether to reload the plugins from the filesystem before performing the search. This can be used to take into effect the plugins that have been manually put into server's plugin \"dropbox\" directory.") @QueryParam(value="reload") boolean reload, @ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page for paging, 0-based") @QueryParam(value="page") Integer page, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        PluginCriteria crit = new PluginCriteria();
        if (name != null) {
            crit.addFilterName(name);
        }
        if (enabled != null) {
            crit.addFilterEnabled(enabled.booleanValue());
        }
        if (version != null) {
            crit.addFilterVersion(version);
        }
        if (deleted != null) {
            crit.addFilterDeleted(deleted.booleanValue());
        }
        if (reload) {
            this.pluginManager.update(this.caller);
        }
        if (page != null) {
            crit.setPaging(page.intValue(), pageSize);
        }
        PageList<Plugin> plugins = this.pluginManager.findPluginsByCriteria(this.caller, crit);
        return this.paginate(headers, uriInfo, plugins, PluginRest.list(plugins), PluginRest.class).build();
    }

    @GET
    @Path(value="{id}")
    @ApiOperation(value="Gets info about a single plugin")
    public Response getPluginInfo(@ApiParam(value="The id of the plugin") @PathParam(value="id") int id, @Context HttpHeaders headers) {
        PluginCriteria crit = new PluginCriteria();
        crit.addFilterId(Integer.valueOf(id));
        PageList<Plugin> plugins = this.pluginManager.findPluginsByCriteria(this.caller, crit);
        if (plugins.isEmpty()) {
            throw new StuffNotFoundException("Plugin");
        }
        return this.withMediaType(Response.ok((Object)PluginRest.from((Plugin)plugins.get(0))), headers).build();
    }

    @PUT
    @Path(value="{id}")
    @ApiOperation(value="Updates the enablement of a plugin.")
    public Response updatePluginState(@ApiParam(value="The id of the plugin") @PathParam(value="id") int id, @ApiParam(value="true means plugin is enabled, false means plugin is disabled") @QueryParam(value="enabled") boolean enabled, @Context HttpHeaders headers) throws Exception {
        if (enabled) {
            this.pluginManager.enablePlugins(this.caller, Collections.singletonList(id));
        } else {
            this.pluginManager.disablePlugins(this.caller, Collections.singletonList(id));
        }
        return this.getPluginInfo(id, headers);
    }

    @DELETE
    @Path(value="{id}")
    @ApiOperation(value="Deletes a single plugin, optionally purging it.")
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Response deletePlugin(@ApiParam(value="The id of the plugin") @PathParam(value="id") int id, @Context HttpHeaders headers) throws Exception {
        this.pluginManager.deletePlugins(this.caller, Collections.singletonList(id));
        return this.getPluginInfo(id, headers);
    }

    @POST
    @Path(value="/")
    @ApiOperation(value="Puts the plugin provided using a content handle into a dropbox and scans the dropbox for changes. In another words, this can result in more than just the provided plugin to become registered in the server if there were some unregistered plugins waiting in the dropbox directory. The content identified by the handle is NOT deleted afterwards.")
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public Response register(@ApiParam(value="The handle retrieved from upload") @QueryParam(value="handle") String handle, @ApiParam(value="Name of the plugin file") @QueryParam(value="name") String name, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws Exception {
        List<Plugin> newOnes = this.pluginManager.deployUsingContentHandle(this.caller, name, handle);
        Plugin myPlugin = null;
        for (Plugin p : newOnes) {
            if (!p.getPath().equals(name)) continue;
            myPlugin = p;
            break;
        }
        if (myPlugin == null) {
            return this.withMediaType(Response.ok(PluginRest.list(newOnes)), headers).build();
        }
        URI myPluginUri = uriInfo.getBaseUri().resolve(uriInfo.getPath()).resolve(Integer.toString(myPlugin.getId()));
        return this.withMediaType(Response.created((URI)myPluginUri), headers).entity(PluginRest.list(newOnes)).build();
    }

    @POST
    @Path(value="/deploy")
    @ApiOperation(value="Pushes out all the enabled plugins to all the agents running at that point in time. Defaults to start that process immediately. The returned string is a handle that can be used to check whether all the agents received the updated plugins.")
    public Response deployOnAgents(@ApiParam(value="The delay in milliseconds before triggering the update on the agents") @QueryParam(value="delay") @DefaultValue(value="0") long delay, @Context HttpHeaders headers) throws Exception {
        StringValue handle = new StringValue(this.pluginManager.schedulePluginUpdateOnAgents(this.caller, delay));
        return this.withMediaType(Response.ok((Object)handle), headers).build();
    }

    @GET
    @Path(value="/deploy/{handle}")
    @ApiOperation(value="Checks whether the deployment to the agents identified by the provided handle has finished or not.")
    public Response isUpdateFinished(@ApiParam(value="The deploy handle") @PathParam(value="handle") String handle, @Context HttpHeaders headers) {
        BooleanValue ret = new BooleanValue(this.pluginManager.isPluginUpdateOnAgentsFinished(this.caller, handle));
        return this.withMediaType(Response.ok((Object)ret), headers).build();
    }
}

