/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiError;
import com.wordnik.swagger.annotations.ApiErrors;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJB;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.interceptor.Interceptors;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.GZIP;
import org.jboss.resteasy.annotations.cache.Cache;
import org.jboss.resteasy.links.AddLinks;
import org.jboss.resteasy.links.LinkResource;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.AvailabilityCriteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.criteria.ResourceTypeCriteria;
import org.rhq.core.domain.discovery.AvailabilityReport;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.resource.composite.ResourceAvailabilitySummary;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.BadArgumentException;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.AvailabilityRest;
import org.rhq.enterprise.server.rest.domain.AvailabilitySummary;
import org.rhq.enterprise.server.rest.domain.CreateCBResourceRequest;
import org.rhq.enterprise.server.rest.domain.Link;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.ResourceWithChildren;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;
import org.rhq.enterprise.server.rest.domain.StringValue;
import org.rhq.enterprise.server.rest.helper.ConfigurationHelper;

@Path(value="/resource")
@Api(value="Resource related", description="This endpoint deals with individual resources, not resource groups")
@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class ResourceHandlerBean
extends AbstractRestBean {
    private static final String NO_RESOURCE_FOR_ID = "If no resource with the passed id exists";
    private static final String DEFAULT_PACKAGE = "default.rest.package";
    public static final String DUMMY_AGENT_NAME_PREFIX = "dummy-agent:name";
    public static final String DUMMY_AGENT_TOKEN_PREFIX = "abc-";
    @EJB
    AvailabilityManagerLocal availMgr;
    @EJB
    AlertManagerLocal alertManager;
    @EJB
    ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    AgentManagerLocal agentMgr;
    @EJB
    ResourceFactoryManagerLocal resourceFactory;
    @EJB
    DiscoveryBossLocal discoveryBoss;
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;

    @GET
    @Path(value="/{id:\\d+}")
    @Cache(isPrivate=true, maxAge=120)
    @ApiOperation(value="Retrieve a single resource", responseClass="ResourceWithType")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getResource(@ApiParam(value="Id of the resource to retrieve") @PathParam(value="id") int id, @Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        EntityTag eTag;
        Resource res = this.fetchResource(id);
        long mtime = res.getMtime();
        Response.ResponseBuilder builder = request.evaluatePreconditions(new Date(mtime), eTag = new EntityTag(Long.toOctalString((long)res.hashCode() + mtime)));
        if (builder != null) {
            return builder.build();
        }
        ResourceWithType rwt = this.fillRWT(res, uriInfo);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("resourceWithType", rwt), (MediaType)mediaType) : Response.ok((Object)rwt);
        return builder.build();
    }

    @PUT
    @Path(value="/{id:\\d+}")
    @ApiOperation(value="Update a single resource or import a new resource from the discovery queue.", notes="You can either update a resource that is already in inventory, in which case the fieldsname, description and location can be updated. Or you can import a Platform or Server resource that is in state NEW.To do this you need to PUT the resource retrieved with a COMMITTED state", responseClass="ResourceWithType")
    @ApiErrors(value={@ApiError(code=404, reason="If no resource with the passed id exists"), @ApiError(code=406, reason="Tried to update a resource that is not COMMITTED")})
    public Response updateResource(@ApiParam(value="Id of the resource to import") @PathParam(value="id") int resourceId, @ApiParam(value="Resource to update") ResourceWithType resourceWithType, @Context UriInfo uriInfo) {
        Resource res = this.fetchResource(resourceId);
        if (res.getInventoryStatus() == InventoryStatus.NEW && res.getResourceType().getCategory() != ResourceCategory.SERVICE && resourceWithType.getStatus().equalsIgnoreCase("COMMITTED")) {
            this.discoveryBoss.importResources(this.caller, new int[]{resourceId});
            res = this.fetchResource(resourceId);
            ResourceWithType outWithType = this.fillRWT(res, uriInfo);
            return Response.ok((Object)outWithType).build();
        }
        if (res.getInventoryStatus() != InventoryStatus.COMMITTED) {
            throw new BadArgumentException("Can only update resources in committed state");
        }
        Resource in = new Resource(res.getId());
        in.setName(resourceWithType.getResourceName());
        in.setDescription(resourceWithType.getDescription());
        in.setLocation(resourceWithType.getLocation());
        Resource out = this.resMgr.updateResource(this.caller, in);
        ResourceWithType outWithType = this.fillRWT(out, uriInfo);
        return Response.ok((Object)outWithType).build();
    }

    @GET
    @GZIP
    @Path(value="/")
    @ApiError(code=406, reason="The passed inventory status was invalid")
    @ApiOperation(value="Search for resources by the given search string, possibly limited by category and paged", responseClass="ResourceWithType")
    public Response getResourcesByQuery(@ApiParam(value="Limit results to param in the resource name") @QueryParam(value="q") String q, @ApiParam(value="Limit to category (PLATFORM, SERVER, SERVICE") @QueryParam(value="category") String category, @ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page for paging, 0-based") @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="Limit to Inventory status of the resources", allowableValues="ALL, NEW, IGNORED, COMMITTED, DELETED, UNINVENTORIED") @DefaultValue(value="COMMITTED") @QueryParam(value="status") String status, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addSortName(PageOrdering.ASC);
        if (!status.toLowerCase().equals("all")) {
            try {
                criteria.addFilterInventoryStatus(InventoryStatus.valueOf((String)status.toUpperCase()));
            }
            catch (IllegalArgumentException iae) {
                throw new BadArgumentException("status", "Value " + status + " is not in the list of allowed values: ALL, NEW, IGNORED, COMMITTED, DELETED, UNINVENTORIED");
            }
        } else {
            criteria.addFilterInventoryStatus(null);
        }
        if (q != null) {
            criteria.addFilterName(q);
        }
        if (category != null) {
            criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.valueOf((String)category.toUpperCase())});
        }
        if (page != null) {
            criteria.setPaging(page.intValue(), pageSize);
        }
        PageList<Resource> ret = this.resMgr.findResourcesByCriteria(this.caller, criteria);
        Response.ResponseBuilder builder = this.getResponseBuilderForResourceList(headers, uriInfo, ret);
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/platforms")
    @Cache(isPrivate=true, maxAge=300)
    @ApiOperation(value="List all platforms in the system", multiValueResponse=true, responseClass="ResourceWithType")
    public Response getPlatforms(@ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page for paging, 0-based") @QueryParam(value="page") @DefaultValue(value="0") Integer page, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        PageControl pc = new PageControl(page.intValue(), pageSize);
        pc.setPrimarySort("id", PageOrdering.ASC);
        PageList<Resource> ret = this.resMgr.findResourcesByCategory(this.caller, ResourceCategory.PLATFORM, InventoryStatus.COMMITTED, pc);
        Response.ResponseBuilder builder = this.getResponseBuilderForResourceList(headers, uriInfo, ret);
        return builder.build();
    }

    private Response.ResponseBuilder getResponseBuilderForResourceList(HttpHeaders headers, UriInfo uriInfo, PageList<Resource> resources) {
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(resources.size());
        for (Resource r : resources) {
            this.putToCache(r.getId(), Resource.class, r);
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            rwtList.add(rwt);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = Response.ok();
        builder.type(mediaType);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder.entity((Object)this.renderTemplate("listResourceWithType", rwtList));
        } else if (mediaType.equals((Object)this.wrappedCollectionJsonType)) {
            this.wrapForPaging(builder, uriInfo, resources, rwtList);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder.entity((Object)list);
            this.createPagingHeader(builder, uriInfo, resources);
        }
        return builder;
    }

    @GET
    @GZIP
    @Path(value="/{id}/hierarchy")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Retrieve the hierarchy of resources starting with the passed one", multiValueResponse=true, responseClass="ResourceWithType")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public ResourceWithChildren getHierarchy(@ApiParam(value="Id of the resource to start with") @PathParam(value="id") int baseResourceId) {
        Resource start = this.fetchResource(baseResourceId);
        return this.getHierarchy(start);
    }

    private ResourceWithChildren getHierarchy(Resource baseResource) {
        ResourceWithChildren rwc = new ResourceWithChildren("" + baseResource.getId(), baseResource.getName());
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, baseResource, InventoryStatus.COMMITTED, pc);
        if (!ret.isEmpty()) {
            ArrayList<ResourceWithChildren> resList = new ArrayList<ResourceWithChildren>(ret.size());
            for (Resource res : ret) {
                ResourceWithChildren child = this.getHierarchy(res);
                resList.add(child);
                this.putToCache(res.getId(), Resource.class, res);
            }
            if (!resList.isEmpty()) {
                rwc.setChildren(resList);
            }
        }
        return rwc;
    }

    @GET
    @Path(value="/{id}/availability")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Return the current availability for the passed resource", responseClass="AvailabilityRest")
    public Response getAvailability(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int resourceId, @Context HttpHeaders headers) {
        Availability avail = this.availMgr.getCurrentAvailabilityForResource(this.caller, resourceId);
        AvailabilityRest availabilityRest = avail.getAvailabilityType() != null ? new AvailabilityRest(avail.getAvailabilityType(), avail.getStartTime(), avail.getResource().getId()) : new AvailabilityRest(avail.getStartTime(), resourceId);
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        Response.ResponseBuilder builder = mediaType.equals((Object)MediaType.TEXT_HTML_TYPE) ? Response.ok((Object)this.renderTemplate("availability.ftl", availabilityRest), (MediaType)mediaType) : Response.ok((Object)availabilityRest);
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/{id}/availability/history")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Return the availability history for the passed resource", responseClass="AvailabilityRest", multiValueResponse=true)
    public Response getAvailabilityHistory(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int resourceId, @ApiParam(value="Start time", defaultValue="30 days ago") @QueryParam(value="start") long start, @ApiParam(value="End time", defaultValue="Now") @QueryParam(value="end") long end, @Context HttpHeaders headers) {
        Response.ResponseBuilder builder;
        Object availabilityRest;
        this.fetchResource(resourceId);
        if (end == 0L) {
            end = System.currentTimeMillis();
        }
        if (start == 0L) {
            start = end - 2592000000L;
        }
        AvailabilityCriteria criteria = new AvailabilityCriteria();
        criteria.addFilterInterval(Long.valueOf(start), Long.valueOf(end));
        criteria.addFilterResourceId(Integer.valueOf(resourceId));
        criteria.addSortStartTime(PageOrdering.DESC);
        PageList<Availability> points = this.availMgr.findAvailabilityByCriteria(this.caller, criteria);
        ArrayList<Object> ret = new ArrayList<Object>(points.size());
        for (Availability avail : points) {
            availabilityRest = avail.getAvailabilityType() != null ? new AvailabilityRest(avail.getAvailabilityType(), avail.getStartTime(), avail.getResource().getId()) : new AvailabilityRest(avail.getStartTime(), resourceId);
            if (avail.getEndTime() != null) {
                ((AvailabilityRest)availabilityRest).setUntil(avail.getEndTime());
            }
            ret.add(availabilityRest);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listAvailability.ftl", ret), (MediaType)mediaType);
        } else {
            availabilityRest = new GenericEntity<List<AvailabilityRest>>(ret){};
            builder = Response.ok((Object)availabilityRest);
        }
        return builder.build();
    }

    @GET
    @Path(value="/{id}/availability/summary")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Return the availability history for the passed resource", responseClass="AvailabilitySummary", multiValueResponse=false)
    public Response getAvailabilitySummary(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int resourceId, @Context HttpHeaders headers) {
        this.fetchResource(resourceId);
        ResourceAvailabilitySummary summary = this.resMgr.getAvailabilitySummary(this.caller, resourceId);
        AvailabilitySummary as = new AvailabilitySummary(resourceId, summary);
        Response.ResponseBuilder builder = Response.ok((Object)as);
        MediaType type = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder.type(type);
        return builder.build();
    }

    @PUT
    @Path(value="/{id}/availability")
    @ApiOperation(value="Set the current availability of the passed resource")
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public void reportAvailability(@ApiParam(value="Id of the resource to update") @PathParam(value="id") int resourceId, @ApiParam(value="New Availability setting", required=true) AvailabilityRest avail) {
        if (avail.getResourceId() != resourceId) {
            throw new IllegalArgumentException("Resource Ids do not match");
        }
        Resource resource = this.fetchResource(resourceId);
        AvailabilityType at = AvailabilityType.valueOf((String)avail.getType());
        if (resource.getResourceType().getCategory() == ResourceCategory.PLATFORM && at == AvailabilityType.DISABLED) {
            throw new BadArgumentException("Availability", "Platforms must not be set to DISABLED");
        }
        Agent agent = this.agentMgr.getAgentByResourceId(this.caller, resourceId);
        AvailabilityReport report = new AvailabilityReport(true, agent.getName());
        Availability availability = new Availability(resource, Long.valueOf(avail.getSince()), at);
        report.addAvailability(availability);
        this.availMgr.mergeAvailabilityReport(report);
    }

    @GZIP
    @GET
    @Path(value="/{id}/schedules")
    @LinkResource(rel="schedules", value=MetricSchedule.class)
    @Cache(isPrivate=true, maxAge=60)
    @ApiOperation(value="Get the metric schedules of the passed resource id", multiValueResponse=true, responseClass="MetricSchedule")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getSchedules(@ApiParam(value="Id of the resource to obtain the schedules for") @PathParam(value="id") int resourceId, @ApiParam(value="Limit by type", allowableValues="<empty>, all, metric, trait, measurement") @QueryParam(value="type") @DefaultValue(value="all") String scheduleType, @ApiParam(value="Limit by enabled schedules") @QueryParam(value="enabledOnly") @DefaultValue(value="true") boolean enabledOnly, @ApiParam(value="Limit by name") @QueryParam(value="name") String name, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        if (scheduleType.equals("metric")) {
            scheduleType = DataType.MEASUREMENT.toString().toLowerCase();
        }
        Resource res = this.resMgr.getResource(this.caller, resourceId);
        Set schedules = res.getSchedules();
        ArrayList<MetricSchedule> ret = new ArrayList<MetricSchedule>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            this.putToCache(schedule.getId(), MeasurementSchedule.class, schedule);
            MeasurementDefinition definition = schedule.getDefinition();
            if (!"all".equals(scheduleType) && !scheduleType.toLowerCase().equals(definition.getDataType().toString().toLowerCase()) || enabledOnly && (!enabledOnly || !schedule.isEnabled()) || name != null && (name == null || !name.equals(definition.getName()))) continue;
            MetricSchedule ms = this.getMetricScheduleInternal(uriInfo, schedule, definition);
            ret.add(ms);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listMetricSchedule", ret), (MediaType)mediaType);
        } else {
            GenericEntity<List<MetricSchedule>> list = new GenericEntity<List<MetricSchedule>>(ret){};
            builder = Response.ok((Object)list, (MediaType)mediaType);
        }
        return builder.build();
    }

    @GZIP
    @GET
    @Path(value="/{id}/children")
    @LinkResource(rel="children", value=ResourceWithType.class)
    @ApiOperation(value="Get the direct children of the passed resource")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    public Response getChildren(@ApiParam(value="Id of the resource to get children") @PathParam(value="id") int id, @ApiParam(value="Page size for paging") @QueryParam(value="ps") @DefaultValue(value="20") int pageSize, @ApiParam(value="Page for paging, 0-based") @QueryParam(value="page") @DefaultValue(value="0") Integer page, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        PageControl pc = new PageControl(page.intValue(), pageSize);
        Resource parent = this.fetchResource(id);
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, parent, InventoryStatus.COMMITTED, pc);
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(ret.size());
        for (Resource r : ret) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            rwtList.add(rwt);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("listResourceWithType", rwtList), (MediaType)mediaType);
        } else {
            GenericEntity<List<ResourceWithType>> list = new GenericEntity<List<ResourceWithType>>(rwtList){};
            builder = Response.ok((Object)list);
        }
        return builder.build();
    }

    @GZIP
    @AddLinks
    @GET
    @Path(value="/{id}/alerts")
    @ApiError(code=404, reason="If no resource with the passed id exists")
    @ApiOperation(value="Get a list of links to the alerts for the passed resource")
    public List<Link> getAlertsForResource(@ApiParam(value="Id of the resource to query") @PathParam(value="id") int resourceId) {
        AlertCriteria criteria = new AlertCriteria();
        this.fetchResource(resourceId);
        criteria.addFilterResourceIds(new Integer[]{resourceId});
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        ArrayList<Link> links = new ArrayList<Link>(alerts.size());
        for (Alert al : alerts) {
            Link link = new Link();
            link.setRel("alert");
            link.setHref("/alert/" + al.getId());
            links.add(link);
        }
        return links;
    }

    @ApiOperation(value="Create a new platform in the Server. If the platform already exists, this is a no-op.The platform internally has a special name so that it will not clash with one that was generatedvia a normal RHQ agent. DEPRECATED Use POST /platforms instead")
    @POST
    @Path(value="platform/{name}")
    public Response createPlatformOLD(@ApiParam(value="Name of the platform") @PathParam(value="name") String name, @ApiParam(value="Type of the platform", allowableValues="Linux,Windows,... TODO") StringValue typeValue, @Context UriInfo uriInfo) {
        String typeName = typeValue.getValue();
        return this.createPlatformInternal(name, typeName, uriInfo);
    }

    @POST
    @Path(value="platforms")
    @ApiOperation(value="Create a new platform in the Server. If the platform already exists, this is a no-op.The platform internally has a special name so that it will not clash with one that was generatedvia a normal RHQ agent. Only resourceName and typeName need to be supplied in the passed object")
    public Response createPlatform(@ApiParam(value="The info about the platform. Only type name and resource name need to be supplied") ResourceWithType resource, @Context UriInfo uriInfo) {
        String typeName = resource.getTypeName();
        String resourceName = resource.getResourceName();
        return this.createPlatformInternal(resourceName, typeName, uriInfo);
    }

    private Response createPlatformInternal(String name, String typeName, UriInfo uriInfo) {
        ResourceType type = this.resourceTypeManager.getResourceTypeByNameAndPlugin(typeName, "Platforms");
        if (type == null) {
            throw new StuffNotFoundException("Platform with type [" + typeName + "]");
        }
        String resourceKey = "p:" + name;
        Resource r = this.resMgr.getResourceByParentAndKey(this.caller, null, resourceKey, "Platforms", typeName);
        if (r != null) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{r.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        Agent agent = new Agent(DUMMY_AGENT_NAME_PREFIX + name, "-dummy-p:" + name, 12345, "http://foo.com/p:name/" + name, DUMMY_AGENT_TOKEN_PREFIX + name);
        this.agentMgr.createAgent(agent);
        Resource platform = new Resource(resourceKey, name, type);
        platform.setUuid(UUID.randomUUID().toString());
        platform.setAgent(agent);
        platform.setInventoryStatus(InventoryStatus.COMMITTED);
        platform.setModifiedBy(this.caller.getName());
        platform.setDescription(type.getDescription() + ". Created via REST-api");
        platform.setItime(System.currentTimeMillis());
        try {
            this.resMgr.createResource(this.caller, platform, -1);
            this.createSchedules(platform);
            ResourceWithType rwt = this.fillRWT(platform, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{platform.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        catch (ResourceAlreadyExistsException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @ApiOperation(value="Create a resource with a given type below a certain parent. DEPRECATED Use POST / instead")
    @POST
    @Path(value="{name}")
    public Response createResourceOLD(@ApiParam(value="Name of the new resource") @PathParam(value="name") String name, @ApiParam(value="Name of the Resource type") StringValue typeValue, @ApiParam(value="Name of the plugin providing the type") @QueryParam(value="plugin") String plugin, @ApiParam(value="Id of the future parent to attach this to") @QueryParam(value="parentId") int parentId, @Context UriInfo uriInfo) {
        String typeName = typeValue.getValue();
        return this.createResourceInternalOld(name, plugin, parentId, typeName, uriInfo);
    }

    @POST
    @Path(value="/")
    @ApiErrors(value={@ApiError(code=302, reason="Creation is still happening. Check back with a GET on the Location.")})
    @ApiOperation(value="Create a new resource as a child of an existing resource. ", notes="If a handle is given, a content based resource is created; the content identified by the handle is not removed from the content store.If no handle is given, a resource is created from the data of the passed 'resource' object.")
    public Response createResource(@ApiParam(value="The info about the resource. You need to supply resource name, resource type name, plugin name, id of the parent") CreateCBResourceRequest resource, @ApiParam(value="A handle that identifies content that has been uploaded to the server before.") @QueryParam(value="handle") String handle, @Context HttpHeaders headers, @Context UriInfo uriInfo) throws IOException {
        if (handle != null) {
            return this.createContentBackedResource(resource, handle, headers, uriInfo);
        }
        return this.createResourceInternal(resource, headers, uriInfo);
    }

    private Response createResourceRegularChild(CreateCBResourceRequest request, ResourceType resType, HttpHeaders headers, UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        int parentId = request.getParentId();
        String name = request.getResourceName();
        ResourceTypeCriteria rtc = new ResourceTypeCriteria();
        rtc.addFilterId(Integer.valueOf(resType.getId()));
        rtc.fetchPluginConfigurationDefinition(true);
        rtc.fetchResourceConfigurationDefinition(true);
        resType = (ResourceType)this.resourceTypeManager.findResourceTypesByCriteria(this.caller, rtc).get(0);
        Configuration defaultPc = new Configuration();
        Configuration pluginConfig = ConfigurationHelper.mapToConfiguration(request.getPluginConfig());
        if (resType.getPluginConfigurationDefinition().getDefaultTemplate() != null) {
            defaultPc = resType.getPluginConfigurationDefinition().getDefaultTemplate().getConfiguration().deepCopyWithoutProxies();
        }
        for (Property p : pluginConfig.getProperties()) {
            defaultPc.put(p);
        }
        Configuration defaultRc = new Configuration();
        Configuration resourceConfig = ConfigurationHelper.mapToConfiguration(request.getResourceConfig());
        if (resType.getResourceConfigurationDefinition().getDefaultTemplate() != null) {
            defaultRc = resType.getResourceConfigurationDefinition().getDefaultTemplate().getConfiguration().deepCopyWithoutProxies();
        }
        for (Property p : resourceConfig.getProperties()) {
            defaultRc.put(p);
        }
        CreateResourceHistory history = this.resourceFactory.createResource(this.caller, parentId, resType.getId(), name, defaultPc, defaultRc, null);
        CreateResourceStatus status = history.getStatus();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (status == CreateResourceStatus.SUCCESS) {
            ResourceWithType rwt = this.findCreatedResource(history.getParentResource().getId(), history.getCreatedResourceName(), uriInfo);
            if (rwt != null) {
                builder = Response.ok();
                builder.entity((Object)rwt);
            } else {
                status = CreateResourceStatus.IN_PROGRESS;
            }
        }
        if (status == CreateResourceStatus.IN_PROGRESS) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/creationStatus/{id}");
            URI uri = uriBuilder.build(new Object[]{history.getId()});
            builder = Response.status((int)302);
            builder.entity((Object)"Creation is running - please check back later");
            builder.location(uri);
        } else {
            builder = Response.serverError();
            builder.entity((Object)new StringValue(history.getErrorMessage()));
        }
        builder.type(mediaType);
        return builder.build();
    }

    private Response createResourceSyntetic(CreateCBResourceRequest request, ResourceType resType, HttpHeaders headers, UriInfo uriInfo) {
        String resourceKey;
        int parentId = request.getParentId();
        String typeName = request.getTypeName();
        String plugin = request.getPluginName();
        String name = request.getResourceName();
        Resource parent = this.resMgr.getResourceById(this.caller, parentId);
        Resource r = this.resMgr.getResourceByParentAndKey(this.caller, parent, resourceKey = "res:" + name + ":" + parentId, plugin, typeName);
        if (r != null) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{r.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        Resource res = new Resource(resourceKey, name, resType);
        res.setUuid(UUID.randomUUID().toString());
        res.setAgent(parent.getAgent());
        res.setParentResource(parent);
        res.setInventoryStatus(InventoryStatus.COMMITTED);
        res.setDescription(resType.getDescription() + ". Created via REST-api");
        try {
            this.resMgr.createResource(this.caller, res, parent.getId());
            this.createSchedules(res);
            ResourceWithType rwt = this.fillRWT(res, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{res.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        catch (ResourceAlreadyExistsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Response createResourceManualImport(CreateCBResourceRequest request, ResourceType resType, HttpHeaders headers, UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        ResourceTypeCriteria rtc = new ResourceTypeCriteria();
        rtc.addFilterId(Integer.valueOf(resType.getId()));
        rtc.fetchPluginConfigurationDefinition(true);
        resType = (ResourceType)this.resourceTypeManager.findResourceTypesByCriteria(this.caller, rtc).get(0);
        Configuration defaultPc = new Configuration();
        if (resType.getPluginConfigurationDefinition().getDefaultTemplate() != null) {
            defaultPc = resType.getPluginConfigurationDefinition().getDefaultTemplate().getConfiguration().deepCopyWithoutProxies();
        }
        Configuration pluginConfig = ConfigurationHelper.mapToConfiguration(request.getPluginConfig());
        for (Property p : pluginConfig.getProperties()) {
            defaultPc.put(p);
        }
        try {
            long now = System.currentTimeMillis();
            Resource r = this.discoveryBoss.manuallyAddResource(this.caller, resType.getId(), request.getParentId(), defaultPc);
            if (now > r.getCtime()) {
                builder = Response.serverError();
                builder.entity((Object)new StringValue("Duplicate resource: manuallyAdded resource under same parent having same properties already exists on server. Note that 'resourceName' is ignored."));
                return builder.build();
            }
            if (request.getResourceName() != null) {
                r.setName(request.getResourceName());
                r = this.resMgr.updateResource(this.caller, r);
            }
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{r.getId()});
            builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        catch (InvalidPluginConfigurationClientException e) {
            builder = Response.serverError();
            builder.entity((Object)new StringValue(e.getMessage()));
            e.printStackTrace();
        }
        catch (PluginContainerException e) {
            builder = Response.serverError();
            builder.entity((Object)new StringValue(e.getMessage()));
            e.printStackTrace();
        }
        catch (Exception e) {
            builder = Response.serverError();
            builder.entity((Object)new StringValue(e.getMessage()));
            e.printStackTrace();
        }
        return builder.build();
    }

    private Response createResourceInternal(CreateCBResourceRequest request, HttpHeaders headers, UriInfo uriInfo) throws IOException {
        int parentId = request.getParentId();
        this.fetchResource(parentId);
        ResourceType resType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(request.getTypeName(), request.getPluginName());
        if (resType == null) {
            throw new StuffNotFoundException("ResourceType with name [" + request.getTypeName() + "] and plugin [" + request.getPluginName() + "]");
        }
        if (resType.isSupportsManualAdd()) {
            return this.createResourceManualImport(request, resType, headers, uriInfo);
        }
        if (resType.isCreatable()) {
            return this.createResourceRegularChild(request, resType, headers, uriInfo);
        }
        return this.createResourceSyntetic(request, resType, headers, uriInfo);
    }

    private Response createResourceInternalOld(String name, String plugin, int parentId, String typeName, UriInfo uriInfo) {
        Resource parent = this.resMgr.getResourceById(this.caller, parentId);
        ResourceType resType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(typeName, plugin);
        if (resType == null) {
            throw new StuffNotFoundException("ResourceType with name [" + typeName + "] and plugin [" + plugin + "]");
        }
        String resourceKey = "res:" + name + ":" + parentId;
        Resource r = this.resMgr.getResourceByParentAndKey(this.caller, parent, resourceKey, plugin, typeName);
        if (r != null) {
            ResourceWithType rwt = this.fillRWT(r, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{r.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        Resource res = new Resource(resourceKey, name, resType);
        res.setUuid(UUID.randomUUID().toString());
        res.setAgent(parent.getAgent());
        res.setParentResource(parent);
        res.setInventoryStatus(InventoryStatus.COMMITTED);
        res.setDescription(resType.getDescription() + ". Created via REST-api");
        try {
            this.resMgr.createResource(this.caller, res, parent.getId());
            this.createSchedules(res);
            ResourceWithType rwt = this.fillRWT(res, uriInfo);
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/{id}");
            URI uri = uriBuilder.build(new Object[]{res.getId()});
            Response.ResponseBuilder builder = Response.created((URI)uri);
            builder.entity((Object)rwt);
            return builder.build();
        }
        catch (ResourceAlreadyExistsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Response createContentBackedResource(CreateCBResourceRequest request, String handle, HttpHeaders headers, UriInfo uriInfo) throws IOException {
        Response.ResponseBuilder builder;
        int parentId = request.getParentId();
        String typeName = request.getTypeName();
        String plugin = request.getPluginName();
        String name = request.getResourceName();
        String tmpDirName = System.getProperty("java.io.tmpdir");
        File tmpDir = new File(tmpDirName);
        File content = new File(tmpDir, handle);
        if (!content.exists() || !content.canRead()) {
            throw new StuffNotFoundException("Content for handle " + handle);
        }
        BufferedInputStream resourceBits = new BufferedInputStream(new FileInputStream(content));
        this.fetchResource(parentId);
        ResourceType resType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(typeName, plugin);
        if (resType == null) {
            throw new StuffNotFoundException("ResourceType with name [" + typeName + "] and plugin [" + plugin + "]");
        }
        Configuration pluginConfig = ConfigurationHelper.mapToConfiguration(request.getPluginConfig());
        Configuration deployConfig = ConfigurationHelper.mapToConfiguration(request.getResourceConfig());
        String packageName = DEFAULT_PACKAGE;
        CreateResourceHistory history = this.resourceFactory.createResource(this.caller, parentId, resType.getId(), name, pluginConfig, packageName, null, null, deployConfig, resourceBits);
        CreateResourceStatus status = history.getStatus();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        if (status == CreateResourceStatus.SUCCESS) {
            ResourceWithType rwt = this.findCreatedResource(history.getParentResource().getId(), history.getCreatedResourceName(), uriInfo);
            if (rwt != null) {
                builder = Response.ok();
                builder.entity((Object)rwt);
            } else {
                status = CreateResourceStatus.IN_PROGRESS;
            }
        }
        if (status == CreateResourceStatus.IN_PROGRESS) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.path("/resource/creationStatus/{id}");
            URI uri = uriBuilder.build(new Object[]{history.getId()});
            builder = Response.status((int)302);
            builder.entity((Object)"Creation is running - please check back later");
            builder.location(uri);
        } else {
            builder = Response.serverError();
            builder.entity((Object)new StringValue(history.getErrorMessage()));
        }
        builder.type(mediaType);
        return builder.build();
    }

    @GET
    @Path(value="/creationStatus/{id}")
    @ApiOperation(value="Get the status of a resource creation for content based resources.")
    @ApiError(code=302, reason="Creation is still going on. Check back later with the same URL.")
    public Response getHistoryItem(@PathParam(value="id") int historyId, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        CreateResourceHistory history;
        try {
            history = this.resourceFactory.getCreateHistoryItem(historyId);
        }
        catch (EJBTransactionRolledbackException e) {
            if (e.getCause() instanceof NoResultException) {
                throw new StuffNotFoundException("Resource creation status with id " + historyId);
            }
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        CreateResourceStatus status = history.getStatus();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (status == CreateResourceStatus.SUCCESS) {
            ResourceWithType rwt = this.findCreatedResource(history.getParentResource().getId(), history.getCreatedResourceName(), uriInfo);
            if (rwt != null) {
                builder = Response.ok();
                this.setCachingHeader(builder, 600);
                builder.entity((Object)rwt);
            } else {
                UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
                URI uri = uriBuilder.build(new Object[0]);
                builder = Response.status((int)302);
                builder.entity((Object)"Creation is still running - please check back later");
                builder.location(uri);
            }
        } else if (status == CreateResourceStatus.IN_PROGRESS) {
            UriBuilder uriBuilder = uriInfo.getRequestUriBuilder();
            URI uri = uriBuilder.build(new Object[0]);
            builder = Response.status((int)302);
            builder.entity((Object)"Creation is still running - please check back later");
            builder.location(uri);
        } else {
            builder = Response.serverError();
            StringValue errorMessage = new StringValue(status + ": " + history.getErrorMessage());
            builder.entity((Object)errorMessage);
        }
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        builder.type(mediaType);
        return builder.build();
    }

    private ResourceWithType findCreatedResource(int parentId, String name, UriInfo uriInfo) {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.setStrict(true);
        criteria.addFilterParentResourceId(Integer.valueOf(parentId));
        criteria.addFilterName(name);
        criteria.addFilterInventoryStatus(InventoryStatus.COMMITTED);
        PageList<Resource> resources = this.resMgr.findResourcesByCriteria(this.caller, criteria);
        if (resources.size() == 0) {
            return null;
        }
        Resource res = (Resource)resources.get(0);
        return this.fillRWT(res, uriInfo);
    }

    @DELETE
    @Path(value="/{id}")
    @ApiOperation(value="Remove a resource from inventory", notes="This operation is by default idempotent, returning 204.If you want to check if the resource existed at all, you need to pass the 'validate' query parameter.")
    @ApiErrors(value={@ApiError(code=204, reason="Resource was removed or did not exist with validation not set"), @ApiError(code=404, reason="Resource did not exist and validate was set")})
    public Response uninventoryOrDeleteResource(@PathParam(value="id") int resourceId, @ApiParam @DefaultValue(value="false") @QueryParam(value="physical") boolean delete, @ApiParam(value="Validate that the resource exists") @QueryParam(value="validate") @DefaultValue(value="false") boolean validate) {
        try {
            this.fetchResource(resourceId);
        }
        catch (Exception e) {
            if (validate) {
                throw new StuffNotFoundException("Resource with id " + resourceId);
            }
            return Response.noContent().build();
        }
        if (!delete) {
            this.resMgr.uninventoryResource(this.caller, resourceId);
        } else {
            this.resourceFactory.deleteResource(this.caller, resourceId);
        }
        return Response.noContent().build();
    }

    private void createSchedules(Resource resource) {
        ResourceType rt = resource.getResourceType();
        Set definitions = rt.getMetricDefinitions();
        for (MeasurementDefinition definition : definitions) {
            MeasurementSchedule schedule = new MeasurementSchedule(definition, resource);
            schedule.setEnabled(definition.isDefaultOn());
            schedule.setInterval(definition.getDefaultInterval());
            this.entityManager.persist((Object)schedule);
        }
    }
}

