/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.domain.Link;

@Api(value="Handle the root context to have an anchor for discoverability")
@Path(value="/")
@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class RootHandlerBean
extends AbstractRestBean {
    private String[] roots = new String[]{"platforms", "resource/platforms", "groups", "group", "dynaGroups", "group/definitions", "alerts", "alert", "status", "status", "favoriteResources", "user/favorites/resource", "operationHistory", "operation/history", "reports", "reports", "plugins", "plugins", "self", ""};

    @GET
    @Path(value="index")
    @ApiOperation(value="Return links from the root /index of the REST-resource tree")
    public Response index(@Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        return this.handleIndex(headers, uriInfo);
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Return links from the root / of the REST-resource tree")
    public Response index2(@Context Request request, @Context HttpHeaders headers, @Context UriInfo uriInfo) {
        return this.handleIndex(headers, uriInfo);
    }

    private Response handleIndex(HttpHeaders headers, UriInfo uriInfo) {
        Response.ResponseBuilder builder;
        MediaType mediaType = (MediaType)headers.getAcceptableMediaTypes().get(0);
        ArrayList<Link> links = new ArrayList<Link>(this.roots.length / 2);
        for (int i = 0; i < this.roots.length; i += 2) {
            String rel = this.roots[i];
            String target = this.roots[i + 1];
            if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                target = target + ".json";
            } else if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
                target = target + ".html";
            } else if (mediaType.equals((Object)MediaType.APPLICATION_XML_TYPE)) {
                target = target + ".xml";
            } else {
                this.log.error((Object)("Unknown media type " + mediaType));
                throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
            }
            Link link = new Link(rel, target);
            links.add(link);
        }
        if (mediaType.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            builder = Response.ok((Object)this.renderTemplate("index", links));
        } else {
            GenericEntity<List<Link>> list = new GenericEntity<List<Link>>(links){};
            builder = Response.ok((Object)list);
        }
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge(86400);
        builder.cacheControl(cacheControl);
        return builder.build();
    }
}

