/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import org.rhq.core.domain.auth.Subject;
import org.rhq.enterprise.server.auth.SessionManager;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;

public class SetCallerInterceptor {
    @Resource
    private EJBContext ejbContext;
    @EJB
    private SubjectManagerLocal subjectManager;
    private SessionManager sessionManager = SessionManager.getInstance();

    @AroundInvoke
    public Object setCaller(InvocationContext ctx) throws Exception {
        Subject caller = null;
        Principal p = this.ejbContext.getCallerPrincipal();
        if (p != null) {
            caller = this.subjectManager.getSubjectByName(p.getName());
        }
        if (caller == null) {
            throw new IllegalAccessException("No calling principal provided");
        }
        caller = this.sessionManager.put(caller);
        AbstractRestBean target = (AbstractRestBean)ctx.getTarget();
        target.caller = caller;
        Object result = ctx.proceed();
        if (result instanceof StreamingOutput) {
            return new SecureStreamingOutput((StreamingOutput)result, caller);
        }
        this.sessionManager.invalidate(caller.getSessionId());
        return result;
    }

    private class SecureStreamingOutput
    implements StreamingOutput {
        private StreamingOutput delegate;
        private Subject caller;

        public SecureStreamingOutput(StreamingOutput delegate, Subject caller) {
            this.delegate = delegate;
            this.caller = caller;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            this.delegate.write(output);
            SetCallerInterceptor.this.sessionManager.invalidate(this.caller.getSessionId());
        }
    }
}

