/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.subsystem;

import java.util.Collection;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.alert.AlertConditionCategory;
import org.rhq.core.domain.alert.AlertConditionLog;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.composite.AlertDefinitionComposite;
import org.rhq.core.domain.alert.composite.AlertHistoryComposite;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.server.PersistenceUtility;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.purge.PurgeManagerLocal;
import org.rhq.enterprise.server.subsystem.AlertSubsystemManagerLocal;
import org.rhq.enterprise.server.util.QueryUtility;

@Stateless
public class AlertSubsystemManagerBean
implements AlertSubsystemManagerLocal {
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private AlertManagerLocal alertManager;
    @EJB
    private PurgeManagerLocal purgeManager;

    @Override
    public PageList<AlertHistoryComposite> getAlertHistories(Subject subject, String resourceFilter, String parentFilter, Long startTime, Long endTime, AlertConditionCategory category, PageControl pc) {
        pc.initDefaultOrderingField("a.id", PageOrdering.DESC);
        String queryName = null;
        queryName = this.authorizationManager.isInventoryManager(subject) ? "Alert.findAllComposites_admin" : "Alert.findAllComposites";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            queryCount.setParameter("subjectId", (Object)subject.getId());
            query.setParameter("subjectId", (Object)subject.getId());
        }
        resourceFilter = QueryUtility.formatSearchParameter(resourceFilter);
        parentFilter = QueryUtility.formatSearchParameter(parentFilter);
        queryCount.setParameter("resourceFilter", (Object)resourceFilter);
        query.setParameter("resourceFilter", (Object)resourceFilter);
        queryCount.setParameter("parentFilter", (Object)parentFilter);
        query.setParameter("parentFilter", (Object)parentFilter);
        queryCount.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        queryCount.setParameter("startTime", (Object)startTime);
        query.setParameter("startTime", (Object)startTime);
        queryCount.setParameter("endTime", (Object)endTime);
        query.setParameter("endTime", (Object)endTime);
        queryCount.setParameter("category", (Object)category);
        query.setParameter("category", (Object)category);
        long totalCount = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        for (AlertHistoryComposite composite : results) {
            this.fetchCollectionFields(composite.getAlert());
        }
        return new PageList((Collection)results, (int)totalCount, pc);
    }

    @Override
    public PageList<AlertDefinitionComposite> getAlertDefinitions(Subject subject, String resourceFilter, String parentFilter, Long startTime, Long endTime, AlertConditionCategory category, PageControl pc) {
        pc.initDefaultOrderingField("ad.id", PageOrdering.DESC);
        String queryName = null;
        queryName = this.authorizationManager.isInventoryManager(subject) ? "AlertDefinition.findAllComposites_admin" : "AlertDefinition.findAllComposites";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        if (!this.authorizationManager.isInventoryManager(subject)) {
            queryCount.setParameter("subjectId", (Object)subject.getId());
            query.setParameter("subjectId", (Object)subject.getId());
        }
        resourceFilter = QueryUtility.formatSearchParameter(resourceFilter);
        parentFilter = QueryUtility.formatSearchParameter(parentFilter);
        queryCount.setParameter("resourceFilter", (Object)resourceFilter);
        query.setParameter("resourceFilter", (Object)resourceFilter);
        queryCount.setParameter("parentFilter", (Object)parentFilter);
        query.setParameter("parentFilter", (Object)parentFilter);
        queryCount.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        queryCount.setParameter("startTime", (Object)startTime);
        query.setParameter("startTime", (Object)startTime);
        queryCount.setParameter("endTime", (Object)endTime);
        query.setParameter("endTime", (Object)endTime);
        queryCount.setParameter("category", (Object)category);
        query.setParameter("category", (Object)category);
        long totalCount = (Long)queryCount.getSingleResult();
        List results = query.getResultList();
        for (AlertDefinitionComposite composite : results) {
            this.fetchCollectionFields(composite.getAlertDefinition());
        }
        return new PageList((Collection)results, (int)totalCount, pc);
    }

    private void fetchCollectionFields(Alert alert) {
        for (AlertConditionLog log : alert.getConditionLogs()) {
            this.fetchCollectionFields(log.getCondition());
        }
    }

    private void fetchCollectionFields(AlertDefinition alertDefinition) {
        for (AlertCondition condition : alertDefinition.getConditions()) {
            this.fetchCollectionFields(condition);
        }
    }

    private void fetchCollectionFields(AlertCondition alertCondition) {
        if (alertCondition != null) {
            alertCondition.getName();
            if (alertCondition.getMeasurementDefinition() != null) {
                alertCondition.getMeasurementDefinition().getName();
            }
        }
    }

    @Override
    public void deleteAlertHistories(Subject subject, Integer[] historyIds) {
        this.alertManager.deleteAlerts(subject, ArrayUtils.unwrapArray((Integer[])historyIds));
    }

    @Override
    public int purgeAllAlertHistories(Subject subject) {
        return this.purgeManager.deleteAlerts(0L, System.currentTimeMillis());
    }
}

