/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.sync.util;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class IndentingXMLStreamWriter
implements XMLStreamWriter {
    public static final String DEFAULT_INDENT_STRING = "    ";
    private int depth;
    private XMLStreamWriter wrapped;
    private String indentString;
    private boolean seenData;

    public IndentingXMLStreamWriter(XMLStreamWriter wrapped) {
        this(wrapped, DEFAULT_INDENT_STRING);
    }

    public IndentingXMLStreamWriter(XMLStreamWriter wrapped, String indentString) {
        this.wrapped = wrapped;
        this.indentString = indentString;
    }

    private void onStartElement() throws XMLStreamException {
        this.wrapped.writeCharacters("\n");
        this.writeIndent();
        ++this.depth;
        this.seenData = false;
    }

    private void onEndElement() throws XMLStreamException {
        --this.depth;
        if (!this.seenData) {
            this.wrapped.writeCharacters("\n");
            this.writeIndent();
        }
        this.seenData = false;
    }

    private void onEmptyElement() throws XMLStreamException {
        this.seenData = false;
        this.wrapped.writeCharacters("\n");
        this.writeIndent();
    }

    private void writeIndent() throws XMLStreamException {
        for (int i = 0; i < this.depth; ++i) {
            this.wrapped.writeCharacters(this.indentString);
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.onStartElement();
        this.wrapped.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onStartElement();
        this.wrapped.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onStartElement();
        this.wrapped.writeStartElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.onEmptyElement();
        this.wrapped.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.onEmptyElement();
        this.wrapped.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.onEmptyElement();
        this.wrapped.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.onEndElement();
        this.wrapped.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        while (this.depth > 0) {
            this.writeEndElement();
        }
        this.wrapped.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.wrapped.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.wrapped.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.wrapped.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.wrapped.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.wrapped.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.wrapped.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.wrapped.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.wrapped.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.wrapped.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.wrapped.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.wrapped.writeCData(data);
        this.seenData = true;
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.writeIndent();
        this.wrapped.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.wrapped.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.wrapped.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.wrapped.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.wrapped.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.wrapped.writeCharacters(text);
        this.seenData = true;
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.wrapped.writeCharacters(text, start, len);
        this.seenData = true;
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.wrapped.getPrefix(uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.wrapped.setPrefix(prefix, uri);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.wrapped.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.wrapped.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.wrapped.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.wrapped.getProperty(name);
    }
}

