/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.alert.engine.mbean;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.rhq.enterprise.server.alert.engine.internal.AlertConditionCacheCoordinator;
import org.rhq.enterprise.server.alert.engine.mbean.AlertConditionCacheMonitorMBean;
import org.rhq.enterprise.server.util.LookupUtil;

public class AlertConditionCacheMonitor
implements AlertConditionCacheMonitorMBean,
MBeanRegistration {
    public AtomicInteger availabilityCacheElementMatches = new AtomicInteger();
    public AtomicInteger eventCacheElementMatches = new AtomicInteger();
    public AtomicInteger measurementCacheElementMatches = new AtomicInteger();
    public AtomicInteger resourceConfigurationCacheElementMatches = new AtomicInteger();
    public AtomicInteger operationCacheElementMatches = new AtomicInteger();
    public AtomicInteger driftCacheElementMatches = new AtomicInteger();
    public AtomicInteger totalCacheElementMatches = new AtomicInteger();
    public AtomicLong availabilityProcessingTime = new AtomicLong();
    public AtomicLong eventProcessingTime = new AtomicLong();
    public AtomicLong measurementProcessingTime = new AtomicLong();
    public AtomicLong resourceConfigurationProcessingTime = new AtomicLong();
    public AtomicLong operationProcessingTime = new AtomicLong();
    public AtomicLong driftProcessingTime = new AtomicLong();
    public AtomicLong totalProcessingTime = new AtomicLong();
    private static MBeanServer mbeanServer;
    private static ObjectName objectName;
    private static AlertConditionCacheMonitorMBean proxy;

    public static AlertConditionCacheMonitorMBean getMBean() {
        if (proxy == null) {
            proxy = objectName != null ? MBeanServerInvocationHandler.newProxyInstance(mbeanServer, objectName, AlertConditionCacheMonitorMBean.class, false) : new AlertConditionCacheMonitor();
        }
        return proxy;
    }

    @Override
    public int getAvailabilityCacheElementCount() {
        return AlertConditionCacheCoordinator.getInstance().getCacheSize(AlertConditionCacheCoordinator.Cache.AvailabilityCache);
    }

    @Override
    public int getEventCacheElementCount() {
        return AlertConditionCacheCoordinator.getInstance().getCacheSize(AlertConditionCacheCoordinator.Cache.EventsCache);
    }

    @Override
    public int getMeasurementCacheElementCount() {
        return AlertConditionCacheCoordinator.getInstance().getCacheSize(AlertConditionCacheCoordinator.Cache.MeasurementDataCache) + AlertConditionCacheCoordinator.getInstance().getCacheSize(AlertConditionCacheCoordinator.Cache.MeasurementTraitCache);
    }

    @Override
    public int getResourceConfigurationCacheElementCount() {
        return AlertConditionCacheCoordinator.getInstance().getCacheSize(AlertConditionCacheCoordinator.Cache.ResourceConfigurationCache);
    }

    @Override
    public int getOperationCacheElementCount() {
        return AlertConditionCacheCoordinator.getInstance().getCacheSize(AlertConditionCacheCoordinator.Cache.ResourceOperationCache);
    }

    @Override
    public int getDriftCacheElementCount() {
        return AlertConditionCacheCoordinator.getInstance().getCacheSize(AlertConditionCacheCoordinator.Cache.DriftCache);
    }

    @Override
    public Map<String, Integer> getCacheCounts() {
        return AlertConditionCacheCoordinator.getInstance().getCacheCounts();
    }

    @Override
    public int getAvailabilityCacheElementMatches() {
        return this.availabilityCacheElementMatches.get();
    }

    @Override
    public int getEventCacheElementMatches() {
        return this.eventCacheElementMatches.get();
    }

    @Override
    public int getMeasurementCacheElementMatches() {
        return this.measurementCacheElementMatches.get();
    }

    @Override
    public int getResourceConfigurationCacheElementMatches() {
        return this.resourceConfigurationCacheElementMatches.get();
    }

    @Override
    public int getOperationCacheElementMatches() {
        return this.operationCacheElementMatches.get();
    }

    @Override
    public int getDriftCacheElementMatches() {
        return this.driftCacheElementMatches.get();
    }

    @Override
    public int getTotalCacheElementMatches() {
        return this.totalCacheElementMatches.get();
    }

    @Override
    public void incrementAvailabilityCacheElementMatches(int matches) {
        this.availabilityCacheElementMatches.addAndGet(matches);
        this.totalCacheElementMatches.addAndGet(matches);
    }

    @Override
    public void incrementEventCacheElementMatches(int matches) {
        this.eventCacheElementMatches.addAndGet(matches);
        this.totalCacheElementMatches.addAndGet(matches);
    }

    @Override
    public void incrementResourceConfigurationCacheElementMatches(int matches) {
        this.resourceConfigurationCacheElementMatches.addAndGet(matches);
        this.totalCacheElementMatches.addAndGet(matches);
    }

    @Override
    public void incrementMeasurementCacheElementMatches(int matches) {
        this.measurementCacheElementMatches.addAndGet(matches);
        this.totalCacheElementMatches.addAndGet(matches);
    }

    @Override
    public void incrementOperationCacheElementMatches(int matches) {
        this.operationCacheElementMatches.addAndGet(matches);
        this.totalCacheElementMatches.addAndGet(matches);
    }

    @Override
    public void incrementDriftCacheElementMatches(int matches) {
        this.driftCacheElementMatches.addAndGet(matches);
        this.totalCacheElementMatches.addAndGet(matches);
    }

    @Override
    public long getAvailabilityProcessingTime() {
        return this.availabilityProcessingTime.get();
    }

    @Override
    public long getEventProcessingTime() {
        return this.eventProcessingTime.get();
    }

    @Override
    public long getMeasurementProcessingTime() {
        return this.measurementProcessingTime.get();
    }

    @Override
    public long getOperationProcessingTime() {
        return this.operationProcessingTime.get();
    }

    @Override
    public long getDriftProcessingTime() {
        return this.driftProcessingTime.get();
    }

    @Override
    public long getTotalProcessingTime() {
        return this.totalProcessingTime.get();
    }

    @Override
    public void incrementAvailabilityProcessingTime(long moreMillis) {
        this.availabilityProcessingTime.addAndGet(moreMillis);
        this.totalProcessingTime.addAndGet(moreMillis);
    }

    @Override
    public void incrementEventProcessingTime(long moreMillis) {
        this.eventProcessingTime.addAndGet(moreMillis);
        this.totalProcessingTime.addAndGet(moreMillis);
    }

    @Override
    public void incrementResourceConfigurationProcessingTime(long moreMillis) {
        this.resourceConfigurationProcessingTime.addAndGet(moreMillis);
        this.totalProcessingTime.addAndGet(moreMillis);
    }

    @Override
    public void incrementMeasurementProcessingTime(long moreMillis) {
        this.measurementProcessingTime.addAndGet(moreMillis);
        this.totalProcessingTime.addAndGet(moreMillis);
    }

    @Override
    public void incrementOperationProcessingTime(long moreMillis) {
        this.operationProcessingTime.addAndGet(moreMillis);
        this.totalProcessingTime.addAndGet(moreMillis);
    }

    @Override
    public void incrementDriftProcessingTime(long moreMillis) {
        this.driftProcessingTime.addAndGet(moreMillis);
        this.totalProcessingTime.addAndGet(moreMillis);
    }

    @Override
    public void reloadCaches() {
        LookupUtil.getAlertConditionCacheManager().reloadAllCaches();
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        objectName = name;
        mbeanServer = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        mbeanServer = null;
    }
}

