/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.discovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.discovery.InvalidPluginConfigurationClientException;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeRequest;
import org.rhq.core.clientapi.agent.upgrade.ResourceUpgradeResponse;
import org.rhq.core.clientapi.server.discovery.InvalidInventoryReportException;
import org.rhq.core.clientapi.server.discovery.InventoryReport;
import org.rhq.core.clientapi.server.discovery.StaleTypeException;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.discovery.MergeResourceResponse;
import org.rhq.core.domain.discovery.ResourceSyncInfo;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.ProductVersion;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceError;
import org.rhq.core.domain.resource.ResourceErrorType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.RHQConstants;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.authz.RequiredPermission;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.discovery.AgentInventoryStatusUpdateJob;
import org.rhq.enterprise.server.discovery.DeletedResourceTypeFilter;
import org.rhq.enterprise.server.discovery.DiscoveryBossLocal;
import org.rhq.enterprise.server.resource.ProductVersionManagerLocal;
import org.rhq.enterprise.server.resource.ResourceAlreadyExistsException;
import org.rhq.enterprise.server.resource.ResourceAvailabilityManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.resource.ResourceTypeManagerLocal;
import org.rhq.enterprise.server.resource.group.ResourceGroupManagerLocal;
import org.rhq.enterprise.server.resource.metadata.PluginManagerLocal;
import org.rhq.enterprise.server.scheduler.SchedulerLocal;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

@Stateless
public class DiscoveryBossBean
implements DiscoveryBossLocal {
    private final Log log = LogFactory.getLog((String)DiscoveryBossBean.class.getName());
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private DiscoveryBossLocal discoveryBoss;
    @EJB
    private ResourceGroupManagerLocal groupManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ResourceAvailabilityManagerLocal resourceAvailabilityManager;
    @EJB
    private ResourceTypeManagerLocal resourceTypeManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ProductVersionManagerLocal productVersionManager;
    @EJB
    private SystemManagerLocal systemManager;
    @EJB
    private PluginManagerLocal pluginManager;

    @Override
    public ResourceSyncInfo mergeInventoryReport(InventoryReport report) throws InvalidInventoryReportException {
        ResourceSyncInfo syncInfo;
        this.validateInventoryReport(report);
        DeletedResourceTypeFilter filter = new DeletedResourceTypeFilter(this.subjectManager, this.resourceTypeManager, this.pluginManager);
        if (!filter.accept(report)) {
            throw new StaleTypeException("The report contains one or more resource types that have been marked for deletion.");
        }
        Agent agent = report.getAgent();
        long start = System.currentTimeMillis();
        Agent knownAgent = this.agentManager.getAgentByName(agent.getName());
        if (knownAgent == null) {
            throw new InvalidInventoryReportException("Unknown Agent named [" + agent.getName() + "] sent an inventory report - that report will be ignored. " + "This error is harmless and should stop appearing after a short while if the platform of the agent [" + agent.getName() + "] was recently removed from the inventory. In any other case this is a bug.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received inventory report from RHQ Agent [" + knownAgent + "]. Number of added roots: " + report.getAddedRoots().size()));
        }
        Set roots = report.getAddedRoots();
        this.log.debug((Object)report);
        for (Resource root : roots) {
            long rootStart = System.currentTimeMillis();
            if (!this.initResourceTypes(root)) continue;
            if (root.getParentResource() != Resource.ROOT && root.getParentResource().getId() != -1) {
                Resource parent = this.getExistingResource(root.getParentResource());
                assert (parent != null);
                this.mergeResource(root, parent, knownAgent);
            } else {
                this.mergeResource(root, Resource.ROOT, knownAgent);
            }
            this.entityManager.flush();
            this.entityManager.clear();
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Root merged: resource/millis=" + root.getName() + '/' + (System.currentTimeMillis() - rootStart)));
        }
        Resource platform = this.resourceManager.getPlatform(knownAgent);
        ResourceSyncInfo resourceSyncInfo = syncInfo = platform != null ? (ResourceSyncInfo)this.entityManager.find(ResourceSyncInfo.class, (Object)platform.getId()) : null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Inventory merge completed in (" + (System.currentTimeMillis() - start) + ")ms"));
        }
        return syncInfo;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Map<Resource, List<Resource>> getQueuedPlatformsAndServers(Subject user, PageControl pc) {
        return this.getQueuedPlatformsAndServers(user, EnumSet.of(InventoryStatus.NEW), pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public Map<Resource, List<Resource>> getQueuedPlatformsAndServers(Subject user, EnumSet<InventoryStatus> statuses, PageControl pc) {
        HashMap<Resource, List<Resource>> queuedResources = new HashMap<Resource, List<Resource>>();
        PageList<Resource> queuedPlatforms = this.getQueuedPlatforms(user, statuses, pc);
        for (Resource platform : queuedPlatforms) {
            ArrayList<Resource> queuedServers = new ArrayList<Resource>();
            for (InventoryStatus status : statuses) {
                queuedServers.addAll(this.getQueuedPlatformChildServers(user, status, platform));
            }
            queuedResources.put(platform, queuedServers);
        }
        return queuedResources;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public PageList<Resource> getQueuedPlatforms(Subject user, EnumSet<InventoryStatus> statuses, PageControl pc) {
        List results;
        pc.initDefaultOrderingField("res.ctime", PageOrdering.DESC);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"Resource.findQueuedPlatformsByInventoryStatus");
        queryCount.setParameter("inventoryStatuses", statuses);
        long count = (Long)queryCount.getSingleResult();
        if (count > 0L) {
            Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"Resource.findQueuedPlatformsByInventoryStatus", (PageControl)pc);
            query.setParameter("inventoryStatuses", statuses);
            results = query.getResultList();
        } else {
            results = Collections.emptyList();
        }
        return new PageList(results, (int)count, pc);
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public List<Resource> getQueuedPlatformChildServers(Subject user, InventoryStatus status, Resource platform) {
        PageList<Resource> childServers = this.resourceManager.findChildResourcesByCategoryAndInventoryStatus(user, platform, ResourceCategory.SERVER, status, PageControl.getUnlimitedInstance());
        return childServers;
    }

    @Override
    @RequiredPermission(value=Permission.MANAGE_INVENTORY)
    public void updateInventoryStatus(Subject user, List<Resource> platforms, List<Resource> servers, InventoryStatus status) {
        long start = System.currentTimeMillis();
        ArrayList<Resource> attachedPlatforms = new ArrayList<Resource>(platforms.size());
        for (Resource p : platforms) {
            attachedPlatforms.add((Resource)this.entityManager.find(Resource.class, (Object)p.getId()));
        }
        platforms = attachedPlatforms;
        ArrayList<Resource> attachedServers = new ArrayList<Resource>(servers.size());
        for (Resource s : servers) {
            attachedServers.add((Resource)this.entityManager.find(Resource.class, (Object)s.getId()));
        }
        servers = attachedServers;
        this.discoveryBoss.updateInventoryStatus(user, status, platforms, servers);
        this.scheduleAgentInventoryOperationJob(platforms, servers);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Inventory status set to [" + status + "] for [" + platforms.size() + "] platforms and [" + servers.size() + "] servers in [" + (System.currentTimeMillis() - start) + "]ms"));
        }
    }

    private boolean isJobScheduled(Scheduler scheduler, String name, String group) {
        boolean isScheduled = false;
        try {
            JobDetail jobDetail = scheduler.getJobDetail(name, group);
            if (jobDetail != null) {
                isScheduled = true;
            }
        }
        catch (SchedulerException se) {
            this.log.error((Object)"Error getting job detail", (Throwable)se);
        }
        return isScheduled;
    }

    private void scheduleAgentInventoryOperationJob(List<Resource> platforms, List<Resource> servers) {
        SchedulerLocal scheduler = LookupUtil.getSchedulerBean();
        try {
            String DEFAULT_JOB_NAME = "AgentInventoryUpdateJob";
            String DEFAULT_JOB_GROUP = "AgentInventoryUpdateGroup";
            String TRIGGER_PREFIX = "AgentInventoryUpdateTrigger";
            String randomSuffix = UUID.randomUUID().toString();
            String triggerName = "AgentInventoryUpdateTrigger - " + randomSuffix;
            SimpleTrigger trigger = new SimpleTrigger(triggerName, "AgentInventoryUpdateGroup", new Date());
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("TriggerName", triggerName);
            jobDataMap.put("TriggerGroupName", "AgentInventoryUpdateGroup");
            AgentInventoryStatusUpdateJob.externalizeJobValues(jobDataMap, "PlatformsList", platforms);
            AgentInventoryStatusUpdateJob.externalizeJobValues(jobDataMap, "ServersList", servers);
            trigger.setJobName("AgentInventoryUpdateJob");
            trigger.setJobGroup("AgentInventoryUpdateGroup");
            trigger.setJobDataMap(jobDataMap);
            if (this.isJobScheduled(scheduler, "AgentInventoryUpdateJob", "AgentInventoryUpdateGroup")) {
                scheduler.scheduleJob((Trigger)trigger);
            } else {
                JobDetail jobDetail = new JobDetail("AgentInventoryUpdateJob", "AgentInventoryUpdateGroup", AgentInventoryStatusUpdateJob.class);
                scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            }
        }
        catch (SchedulerException e) {
            this.log.error((Object)"Failed to schedule agent inventory update operation.", (Throwable)e);
            this.updateAgentInventoryStatus(platforms, servers);
        }
    }

    public void updateAgentInventoryStatus(List<Resource> platforms, List<Resource> servers) {
        AgentClient agentClient;
        for (Resource platform : platforms) {
            agentClient = this.agentManager.getAgentClient(platform.getAgent());
            try {
                agentClient.getDiscoveryAgentService().synchronizeInventory((ResourceSyncInfo)this.entityManager.find(ResourceSyncInfo.class, (Object)platform.getId()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Could not perform commit synchronization with agent for platform [" + platform.getName() + "]"), (Throwable)e);
            }
        }
        for (Resource server : servers) {
            if (platforms.contains(server.getParentResource())) continue;
            agentClient = this.agentManager.getAgentClient(server.getAgent());
            try {
                agentClient.getDiscoveryAgentService().synchronizeInventory((ResourceSyncInfo)this.entityManager.find(ResourceSyncInfo.class, (Object)server.getId()));
            }
            catch (Exception e) {
                this.log.warn((Object)("Could not perform commit synchronization with agent for server [" + server.getName() + "]"), (Throwable)e);
            }
        }
    }

    @Override
    public void updateAgentInventoryStatus(String platformsCsvList, String serversCsvList) {
        ArrayList<Resource> platforms = new ArrayList<Resource>();
        AgentInventoryStatusUpdateJob.internalizeJobValues(this.entityManager, platformsCsvList, platforms);
        ArrayList<Resource> servers = new ArrayList<Resource>();
        AgentInventoryStatusUpdateJob.internalizeJobValues(this.entityManager, serversCsvList, servers);
        this.updateAgentInventoryStatus(platforms, servers);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateInventoryStatus(Subject user, InventoryStatus status, List<Resource> platforms, List<Resource> servers) {
        for (Resource platform : platforms) {
            this.resourceManager.setResourceStatus(user, platform, status, false);
        }
        for (Resource server : servers) {
            this.resourceManager.setResourceStatus(user, server, status, true);
        }
        if (status == InventoryStatus.COMMITTED) {
            ArrayList<Integer> allResourceIds = new ArrayList<Integer>();
            for (Resource platform : platforms) {
                allResourceIds.add(platform.getId());
            }
            for (Resource server : servers) {
                allResourceIds.add(server.getId());
            }
            this.resourceAvailabilityManager.insertNeededAvailabilityForImportedResources(allResourceIds);
        }
    }

    @Override
    public Resource manuallyAddResource(Subject subject, int resourceTypeId, int parentResourceId, Configuration pluginConfiguration) throws Exception {
        Resource result = null;
        ResourceType resourceType = this.resourceTypeManager.getResourceTypeById(subject, resourceTypeId);
        this.entityManager.clear();
        MergeResourceResponse response = this.manuallyAddResource(subject, resourceType, parentResourceId, pluginConfiguration);
        result = this.resourceManager.getResourceById(subject, response.getResourceId());
        return result;
    }

    @Override
    @NotNull
    public MergeResourceResponse manuallyAddResource(Subject user, ResourceType resourceType, int parentResourceId, Configuration pluginConfiguration) throws InvalidPluginConfigurationClientException, PluginContainerException {
        MergeResourceResponse mergeResourceResponse;
        if (!this.authorizationManager.hasResourcePermission(user, Permission.CREATE_CHILD_RESOURCES, parentResourceId)) {
            throw new PermissionException("You do not have permission on resource with id " + parentResourceId + " to manually add child resources.");
        }
        try {
            Resource parentResource = this.resourceManager.getResourceById(user, parentResourceId);
            AgentClient agentClient = this.agentManager.getAgentClient(parentResource.getAgent());
            mergeResourceResponse = agentClient.getDiscoveryAgentService().manuallyAddResource(resourceType, parentResourceId, pluginConfiguration, user.getId());
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error adding " + resourceType.getName() + " resource to inventory as a child of the resource with id " + parentResourceId + " - cause: " + e.getLocalizedMessage(), e);
        }
        return mergeResourceResponse;
    }

    @Override
    public MergeResourceResponse addResource(Resource resource, int creatorSubjectId) {
        MergeResourceResponse mergeResourceResponse;
        try {
            this.validateResource(resource);
        }
        catch (InvalidInventoryReportException e) {
            throw new IllegalStateException("Plugin Container sent an invalid Resource - " + e.getLocalizedMessage());
        }
        if (!this.initResourceTypes(resource)) {
            throw new IllegalStateException("Plugin Container sent a Resource with an unknown type - " + resource.getResourceType());
        }
        Resource existingResource = this.getExistingResource(resource);
        if (existingResource != null) {
            mergeResourceResponse = new MergeResourceResponse(existingResource.getId(), true);
        } else {
            Subject creator = this.subjectManager.getSubjectById(creatorSubjectId);
            try {
                creator = this.subjectManager.loginUnauthenticated(creator.getName());
            }
            catch (LoginException e) {
                throw new IllegalStateException("Unable to temporarily login to provided resource creator user for resource creation", e);
            }
            Resource parentResource = this.resourceManager.getResourceById(creator, resource.getParentResource().getId());
            resource.setAgent(parentResource.getAgent());
            resource.setModifiedBy(creator.getName());
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            resource.setItime(System.currentTimeMillis());
            try {
                this.resourceManager.createResource(creator, resource, parentResource.getId());
            }
            catch (ResourceAlreadyExistsException e) {
                throw new IllegalStateException(e);
            }
            mergeResourceResponse = new MergeResourceResponse(resource.getId(), false);
        }
        return mergeResourceResponse;
    }

    @Override
    public boolean updateResourceVersion(int resourceId, String version) {
        Resource existingResource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        if (existingResource != null) {
            boolean changed = this.updateResourceVersion(existingResource, version);
            if (changed) {
                this.entityManager.merge((Object)existingResource);
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<ResourceUpgradeResponse> upgradeResources(Set<ResourceUpgradeRequest> upgradeRequests) {
        HashSet<ResourceUpgradeResponse> result = new HashSet<ResourceUpgradeResponse>();
        boolean allowGenericPropertiesUpgrade = Boolean.parseBoolean(this.systemManager.getSystemConfiguration(this.subjectManager.getOverlord()).getProperty(RHQConstants.AllowResourceGenericPropertiesUpgrade, "false"));
        for (ResourceUpgradeRequest request : upgradeRequests) {
            Resource existingResource = (Resource)this.entityManager.find(Resource.class, (Object)request.getResourceId());
            if (existingResource == null) continue;
            try {
                ResourceUpgradeResponse upgradedData = this.upgradeResource(existingResource, request, allowGenericPropertiesUpgrade);
                if (upgradedData == null) continue;
                result.add(upgradedData);
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to process upgrade request for resource " + existingResource + "."), (Throwable)e);
            }
        }
        return result;
    }

    private boolean updateResourceVersion(Resource resource, String newVersion) {
        boolean versionChanged = false;
        if (resource != null) {
            String oldVersion = resource.getVersion();
            if (oldVersion == null) {
                oldVersion = "";
            }
            if (newVersion == null) {
                newVersion = "";
            }
            boolean bl = versionChanged = !oldVersion.equals(newVersion);
            if (versionChanged) {
                this.log.info((Object)("Resource [" + resource + "] changed its version from [" + oldVersion + "] to [" + newVersion + "]"));
                resource.setVersion(newVersion);
                ProductVersion productVersion = null;
                if (newVersion.length() > 0) {
                    productVersion = this.productVersionManager.addProductVersion(resource.getResourceType(), newVersion);
                }
                resource.setProductVersion(productVersion);
            }
        }
        return versionChanged;
    }

    private ResourceUpgradeResponse upgradeResource(@NotNull Resource resource, ResourceUpgradeRequest upgradeRequest, boolean allowGenericPropertiesUpgrade) {
        if (upgradeRequest.getUpgradeErrorMessage() != null) {
            ResourceError error = new ResourceError(resource, ResourceErrorType.UPGRADE, upgradeRequest.getUpgradeErrorMessage(), upgradeRequest.getUpgradeErrorStackTrace(), upgradeRequest.getTimestamp());
            this.resourceManager.addResourceError(error);
            return null;
        }
        ResourceUpgradeResponse ret = new ResourceUpgradeResponse();
        ret.setResourceId(resource.getId());
        String resourceKey = upgradeRequest.getNewResourceKey();
        String name = upgradeRequest.getNewName();
        String description = upgradeRequest.getNewDescription();
        if (resourceKey != null || name != null || description != null) {
            StringBuilder logMessage = new StringBuilder("Resource [").append(resource.toString()).append("] upgraded its ");
            if (this.needsUpgrade(resource.getResourceKey(), resourceKey)) {
                resource.setResourceKey(resourceKey);
                logMessage.append("resourceKey, ");
            }
            ret.setUpgradedResourceKey(resource.getResourceKey());
            if (allowGenericPropertiesUpgrade && this.needsUpgrade(resource.getName(), name)) {
                resource.setName(name);
                logMessage.append("name, ");
            }
            ret.setUpgradedResourceName(resource.getName());
            if (allowGenericPropertiesUpgrade && this.needsUpgrade(resource.getDescription(), description)) {
                resource.setDescription(description);
                logMessage.append("description, ");
            }
            ret.setUpgradedResourceDescription(resource.getDescription());
            List<ResourceError> upgradeErrors = this.resourceManager.findResourceErrors(this.subjectManager.getOverlord(), resource.getId(), ResourceErrorType.UPGRADE);
            for (ResourceError error : upgradeErrors) {
                this.entityManager.remove((Object)error);
            }
            logMessage.replace(logMessage.length() - 1, logMessage.length(), "to become [").append(resource.toString()).append("]");
            this.log.info((Object)logMessage.toString());
        }
        return ret;
    }

    private void validateInventoryReport(InventoryReport report) throws InvalidInventoryReportException {
        for (Resource root : report.getAddedRoots()) {
            this.validateResource(root);
        }
    }

    private void validateResource(Resource resource) throws InvalidInventoryReportException {
        if (resource.getResourceType() == null) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has a null type.");
        }
        if (resource.getResourceKey() == null) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has a null key.");
        }
        if (resource.getInventoryStatus() == InventoryStatus.DELETED) {
            throw new InvalidInventoryReportException("Reported resource [" + resource + "] has an illegal inventory status of 'DELETED' - agents are not allowed to delete platforms from inventory.");
        }
        for (Resource childResource : resource.getChildResources()) {
            this.validateResource(childResource);
        }
    }

    private void mergeResource(@NotNull Resource resource, @Nullable Resource parentResource, @NotNull Agent agent) throws InvalidInventoryReportException {
        long start = System.currentTimeMillis();
        this.log.debug((Object)("Merging [" + resource + "]..."));
        Resource existingResource = this.getExistingResource(resource);
        if (existingResource != null) {
            this.updatePreviouslyInventoriedResource(resource, existingResource);
        } else {
            this.presetAgent(resource, agent);
            this.addResourceToInventory(resource, parentResource);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Resource merged: resource/millis=" + resource.getName() + '/' + (System.currentTimeMillis() - start)));
        }
    }

    private void presetAgent(Resource resource, Agent agent) {
        resource.setAgent(agent);
        for (Resource child : resource.getChildResources()) {
            this.presetAgent(child, agent);
        }
    }

    private Resource getExistingResource(Resource resource) {
        Resource existingResource = null;
        this.log.debug((Object)("getExistingResource processing for [" + resource + "]"));
        String idLogMsg = "id=" + resource.getId();
        if (resource.getId() != 0) {
            this.log.debug((Object)(idLogMsg + ": Agent claims resource is already in inventory."));
            existingResource = (Resource)this.entityManager.find(Resource.class, (Object)resource.getId());
            if (existingResource == null) {
                this.log.debug((Object)(idLogMsg + ": However, no resource exists with the specified id."));
            } else {
                this.log.debug((Object)(idLogMsg + ": Found resource already in inventory with specified id"));
            }
        } else {
            this.log.debug((Object)(idLogMsg + ": Agent reported resource with id of 0."));
        }
        if (existingResource == null) {
            this.log.debug((Object)(idLogMsg + ": Checking if a resource exists with the specified business key."));
            ResourceType resourceType = resource.getResourceType();
            Subject overlord = this.subjectManager.getOverlord();
            for (Resource parent = resource; parent != null && existingResource == null; parent = parent.getParentResource()) {
                Resource existingParent = null;
                if (parent != null && (existingParent = (Resource)this.entityManager.find(Resource.class, (Object)parent.getId())) == null) continue;
                existingResource = this.resourceManager.getResourceByParentAndKey(overlord, existingParent, resource.getResourceKey(), resourceType.getPlugin(), resourceType.getName());
            }
            if (existingResource != null) {
                resource.setId(existingResource.getId());
                this.log.debug((Object)(idLogMsg + ": Found resource already in inventory with specified business key"));
            } else {
                this.log.debug((Object)(idLogMsg + ": Unable to find the agent-reported resource by id or business key."));
                if (resource.getId() != 0) {
                    this.log.error((Object)(idLogMsg + ": Resetting the resource's id to zero."));
                    resource.setId(0);
                } else {
                    this.log.debug((Object)(idLogMsg + ": Resource's id was already zero, nothing to do for the merge."));
                }
            }
        }
        if (existingResource != null) {
            existingResource.getChildResources().size();
        }
        return existingResource;
    }

    private void updatePreviouslyInventoriedResource(Resource updatedResource, Resource existingResource) throws InvalidInventoryReportException {
        if (existingResource.getInventoryStatus() == InventoryStatus.UNINVENTORIED) {
            return;
        }
        Resource existingParent = existingResource.getParentResource();
        Resource updatedParent = updatedResource.getParentResource();
        ResourceType existingResourceParentType = existingParent != null ? existingResource.getParentResource().getResourceType() : null;
        ResourceType updatedResourceParentType = updatedParent != null ? updatedResource.getParentResource().getResourceType() : null;
        Set validParentTypes = existingResource.getResourceType().getParentResourceTypes();
        if (validParentTypes != null && !validParentTypes.isEmpty() && !validParentTypes.contains(existingResourceParentType)) {
            if (validParentTypes.contains(updatedResourceParentType)) {
                if (existingResource.getParentResource() != null) {
                    existingResource.getParentResource().removeChildResource(existingResource);
                }
                if (updatedParent != Resource.ROOT) {
                    updatedParent = this.getExistingResource(updatedParent);
                    updatedParent.addChildResource(existingResource);
                } else {
                    existingResource.setParentResource(Resource.ROOT);
                }
            } else {
                this.log.debug((Object)("Existing Resource " + existingResource + " has invalid parent type (" + existingResourceParentType + ") and so does plugin-reported Resource " + updatedResource + " (" + updatedResourceParentType + ") - valid parent types are [" + validParentTypes + "]."));
            }
        }
        if (existingResource.getDescription() == null && updatedResource.getDescription() != null) {
            this.log.debug((Object)("Setting description of existing resource with id " + existingResource.getId() + " to '" + updatedResource.getDescription() + "' (as reported by agent)..."));
            existingResource.setDescription(updatedResource.getDescription());
        }
        if (existingResource.getResourceKey() != null && !existingResource.getResourceKey().equals(updatedResource.getResourceKey())) {
            this.log.warn((Object)("Agent reported that key for " + existingResource + " has changed from '" + existingResource.getResourceKey() + "' to '" + updatedResource.getResourceKey() + "'."));
        }
        this.updateResourceVersion(existingResource, updatedResource.getVersion());
        if (existingResource.getInventoryStatus() == InventoryStatus.DELETED) {
            existingResource.setInventoryStatus(InventoryStatus.COMMITTED);
            existingResource.setPluginConfiguration(updatedResource.getPluginConfiguration());
        }
        for (Resource childResource : updatedResource.getChildResources()) {
            this.mergeResource(childResource, existingResource, existingResource.getAgent());
        }
    }

    private boolean initResourceTypes(Resource resource) {
        ResourceType resourceType;
        try {
            resourceType = this.resourceTypeManager.getResourceTypeByNameAndPlugin(this.subjectManager.getOverlord(), resource.getResourceType().getName(), resource.getResourceType().getPlugin());
        }
        catch (RuntimeException e) {
            this.log.error((Object)("Failed to lookup Resource type [" + resource.getResourceType() + "] for reported Resource [" + resource + "] - this should not have happened."));
            return false;
        }
        if (resourceType == null) {
            this.log.error((Object)("Reported resource [" + resource + "] has an unknown type [" + resource.getResourceType() + "]. The Agent most likely has a plugin named '" + resource.getResourceType().getPlugin() + "' installed that is not installed on the Server. Resource will be ignored..."));
            return false;
        }
        resource.setResourceType(resourceType);
        Iterator childIterator = resource.getChildResources().iterator();
        while (childIterator.hasNext()) {
            Resource child = (Resource)childIterator.next();
            if (this.initResourceTypes(child)) continue;
            childIterator.remove();
        }
        return true;
    }

    private void addResourceToInventory(Resource resource, Resource parentResource) {
        this.log.debug((Object)("New resource [" + resource + "] reported - adding to inventory with status 'NEW'..."));
        this.initAutoDiscoveredResource(resource, parentResource);
        this.entityManager.persist((Object)resource);
        if (parentResource != null) {
            parentResource.addChildResource(resource);
        }
        this.addProductVersionsRecursively(resource);
        if (parentResource != null) {
            this.groupManager.updateImplicitGroupMembership(this.subjectManager.getOverlord(), resource);
        }
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void addProductVersionsRecursively(Resource resource) {
        if (resource.getVersion() != null && resource.getVersion().length() > 0) {
            ResourceType type = resource.getResourceType();
            ProductVersion productVersion = this.productVersionManager.addProductVersion(type, resource.getVersion());
            resource.setProductVersion(productVersion);
        }
        for (Resource child : resource.getChildResources()) {
            this.addProductVersionsRecursively(child);
        }
    }

    private void initAutoDiscoveredResource(Resource resource, Resource parent) {
        if (resource.getParentResource() != null && resource.getParentResource().getInventoryStatus() == InventoryStatus.COMMITTED && (resource.getResourceType().getCategory() == ResourceCategory.SERVICE || resource.getParentResource().getResourceType().getCategory() == ResourceCategory.SERVER)) {
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
        } else {
            resource.setInventoryStatus(InventoryStatus.NEW);
        }
        resource.setItime(System.currentTimeMillis());
        resource.setModifiedBy(this.subjectManager.getOverlord().getName());
        for (Resource childResource : resource.getChildResources()) {
            this.initAutoDiscoveredResource(childResource, resource);
        }
    }

    @Override
    public void importResources(Subject subject, int[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.COMMITTED, EnumSet.of(InventoryStatus.NEW));
    }

    @Override
    public void ignoreResources(Subject subject, int[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.IGNORED, EnumSet.of(InventoryStatus.NEW));
    }

    @Override
    public void unignoreResources(Subject subject, int[] resourceIds) {
        if (resourceIds == null || resourceIds.length == 0) {
            return;
        }
        this.checkStatus(subject, resourceIds, InventoryStatus.NEW, EnumSet.of(InventoryStatus.IGNORED));
    }

    private void checkStatus(Subject subject, int[] resourceIds, InventoryStatus target, EnumSet<InventoryStatus> validStatuses) {
        Query query = this.entityManager.createQuery("  SELECT res.inventoryStatus     FROM Resource res    WHERE res.id IN ( :resourceIds ) GROUP BY res.inventoryStatus ");
        List resourceIdList = ArrayUtils.wrapInList((int[])resourceIds);
        EnumSet<InventoryStatus> statuses = EnumSet.noneOf(InventoryStatus.class);
        int fromIndex = 0;
        while (fromIndex < resourceIds.length) {
            int toIndex = resourceIds.length < fromIndex + 1000 ? resourceIds.length : fromIndex + 1000;
            List resourceIdSubList = resourceIdList.subList(fromIndex, toIndex);
            query.setParameter("resourceIds", resourceIdSubList);
            List batchStatuses = query.getResultList();
            statuses.addAll(batchStatuses);
            fromIndex = toIndex;
        }
        if (!validStatuses.containsAll(statuses)) {
            throw new IllegalArgumentException("Can only set inventory status to [" + target + "] for Resources with current inventory status of one of [" + validStatuses + "].");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>(resourceIds.length);
        fromIndex = 0;
        while (fromIndex < resourceIds.length) {
            int toIndex = resourceIds.length < fromIndex + 1000 ? resourceIds.length : fromIndex + 1000;
            int[] resourceIdSubArray = Arrays.copyOfRange(resourceIds, fromIndex, toIndex);
            PageList<Resource> batchResources = this.resourceManager.findResourceByIds(subject, resourceIdSubArray, false, PageControl.getUnlimitedInstance());
            resources.addAll((Collection<Resource>)batchResources);
            fromIndex = toIndex;
        }
        ArrayList<Resource> platforms = new ArrayList<Resource>();
        ArrayList<Resource> servers = new ArrayList<Resource>();
        for (Resource resource : resources) {
            ResourceCategory category = resource.getResourceType().getCategory();
            if (category == ResourceCategory.PLATFORM) {
                platforms.add(resource);
                continue;
            }
            if (category == ResourceCategory.SERVER) {
                servers.add(resource);
                continue;
            }
            throw new IllegalArgumentException("Can not directly change the inventory status of a service");
        }
        this.updateInventoryStatus(subject, platforms, servers, target);
    }

    private <T> boolean needsUpgrade(T oldValue, T newValue) {
        return newValue != null && (oldValue == null || !newValue.equals(oldValue));
    }
}

