/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.drift;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rhq.core.clientapi.server.drift.DriftServerService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.criteria.DriftDefinitionCriteria;
import org.rhq.core.domain.drift.DriftDefinition;
import org.rhq.core.domain.drift.DriftSnapshot;
import org.rhq.core.domain.drift.DriftSnapshotRequest;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.drift.DriftManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

public class DriftServerServiceImpl
implements DriftServerService {
    public void sendChangesetZip(int resourceId, long zipSize, InputStream zipStream) {
        try {
            DriftManagerLocal driftManager = LookupUtil.getDriftManager();
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            driftManager.addChangeSet(overlord, resourceId, zipSize, zipStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void sendFilesZip(int resourceId, String driftDefinitionName, String token, long zipSize, InputStream zipStream) {
        try {
            DriftManagerLocal driftManager = LookupUtil.getDriftManager();
            Subject overlord = LookupUtil.getSubjectManager().getOverlord();
            driftManager.addFiles(overlord, resourceId, driftDefinitionName, token, zipSize, zipStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void repeatChangeSet(int resourceId, String driftDefName, int version) {
        DriftManagerLocal driftManager = LookupUtil.getDriftManager();
        driftManager.processRepeatChangeSet(resourceId, driftDefName, version);
    }

    public Map<Integer, List<DriftDefinition>> getDriftDefinitions(Set<Integer> resourceIds) {
        DriftDefinitionCriteria criteria = new DriftDefinitionCriteria();
        criteria.addFilterResourceIds(resourceIds.toArray(new Integer[resourceIds.size()]));
        criteria.fetchConfiguration(Boolean.valueOf(true));
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        PageList<DriftDefinition> definitions = LookupUtil.getDriftManager().findDriftDefinitionsByCriteria(overlord, criteria);
        HashMap<Integer, List<DriftDefinition>> map = new HashMap<Integer, List<DriftDefinition>>();
        for (Integer resourceId : resourceIds) {
            map.put(resourceId, new ArrayList());
        }
        for (DriftDefinition c : definitions) {
            List list = (List)map.get(c.getResource().getId());
            list.add(c);
            map.put(c.getResource().getId(), list);
        }
        return map;
    }

    public DriftSnapshot getCurrentSnapshot(int driftDefinitionId) {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        return LookupUtil.getDriftManager().getSnapshot(overlord, new DriftSnapshotRequest(driftDefinitionId));
    }

    public DriftSnapshot getSnapshot(int driftDefinitionId, int startVersion, int endVersion) {
        Subject overlord = LookupUtil.getSubjectManager().getOverlord();
        return LookupUtil.getDriftManager().getSnapshot(overlord, new DriftSnapshotRequest(driftDefinitionId, Integer.valueOf(endVersion), Integer.valueOf(startVersion), null, false, true));
    }
}

