/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.Postgresql83DatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.common.EntityContext;
import org.rhq.core.domain.criteria.CallTimeDataCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.domain.measurement.calltime.CallTimeDataComposite;
import org.rhq.core.domain.measurement.calltime.CallTimeDataValue;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheManagerLocal;
import org.rhq.enterprise.server.alert.engine.AlertConditionCacheStats;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerLocal;
import org.rhq.enterprise.server.measurement.CallTimeDataManagerRemote;
import org.rhq.enterprise.server.measurement.MeasurementStorageException;
import org.rhq.enterprise.server.measurement.instrumentation.MeasurementMonitor;
import org.rhq.enterprise.server.util.CriteriaQueryGenerator;
import org.rhq.enterprise.server.util.CriteriaQueryRunner;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class CallTimeDataManagerBean
implements CallTimeDataManagerLocal,
CallTimeDataManagerRemote {
    private static final String DATA_VALUE_TABLE_NAME = "RHQ_CALLTIME_DATA_VALUE";
    private static final String DATA_KEY_TABLE_NAME = "RHQ_CALLTIME_DATA_KEY";
    private static final String CALLTIME_KEY_INSERT_STATEMENT = "INSERT INTO RHQ_CALLTIME_DATA_KEY(id, schedule_id, call_destination) SELECT %s, ?, ? FROM RHQ_numbers WHERE i = 42 AND NOT EXISTS (SELECT * FROM RHQ_CALLTIME_DATA_KEY WHERE schedule_id = ? AND call_destination = ?)";
    private static final String CALLTIME_KEY_INSERT_STATEMENT_AUTOINC = "INSERT INTO RHQ_CALLTIME_DATA_KEY(schedule_id, call_destination) SELECT ?, ? FROM RHQ_numbers WHERE i = 42 AND NOT EXISTS (SELECT * FROM RHQ_CALLTIME_DATA_KEY WHERE schedule_id = ? AND call_destination = ?)";
    private static final String CALLTIME_VALUE_INSERT_STATEMENT = "INSERT /*+ APPEND */ INTO RHQ_CALLTIME_DATA_VALUE(id, key_id, begin_time, end_time, minimum, maximum, total, count) SELECT %s, key.id, ?, ?, ?, ?, ?, ? FROM RHQ_CALLTIME_DATA_KEY key WHERE key.schedule_id = ? AND key.call_destination = ?";
    private static final String CALLTIME_VALUE_INSERT_STATEMENT_AUTOINC = "INSERT INTO RHQ_CALLTIME_DATA_VALUE(key_id, begin_time, end_time, minimum, maximum, total, count) SELECT key.id, ?, ?, ?, ?, ?, ? FROM RHQ_CALLTIME_DATA_KEY key WHERE key.schedule_id = ? AND key.call_destination = ?";
    private static final String CALLTIME_VALUE_PURGE_STATEMENT = "DELETE FROM RHQ_CALLTIME_DATA_VALUE WHERE end_time < ?";
    private final Log log = LogFactory.getLog(CallTimeDataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private CallTimeDataManagerLocal callTimeDataManager;
    @EJB
    private AlertConditionCacheManagerLocal alertConditionCacheManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
    public void addCallTimeData(@NotNull Set<CallTimeData> callTimeDataSet) {
        if (callTimeDataSet.isEmpty()) {
            return;
        }
        this.log.debug((Object)("Persisting call-time data for " + callTimeDataSet.size() + " schedules..."));
        long startTime = System.currentTimeMillis();
        this.callTimeDataManager.insertCallTimeDataKeys(callTimeDataSet);
        this.callTimeDataManager.insertCallTimeDataValues(callTimeDataSet);
        MeasurementMonitor.getMBean().incrementCallTimeInsertTime(System.currentTimeMillis() - startTime);
    }

    @Override
    public PageList<CallTimeDataComposite> findCallTimeDataForResource(Subject subject, int scheduleId, long beginTime, long endTime, PageControl pageControl) {
        pageControl.initDefaultOrderingField("SUM(value.total)/SUM(value.count)", PageOrdering.DESC);
        pageControl.addDefaultOrderingField("key.callDestination", PageOrdering.ASC);
        MeasurementSchedule schedule = (MeasurementSchedule)this.entityManager.find(MeasurementSchedule.class, (Object)scheduleId);
        int resourceId = schedule.getResource().getId();
        if (!this.authorizationManager.canViewResource(subject, resourceId)) {
            throw new PermissionException("User [" + subject + "] does not have permission to view call time data for measurementSchedule[id=" + scheduleId + "] and resource[id=" + resourceId + "]");
        }
        String query = "CallTimeDataValue.findCompositesForResource";
        Query queryWithOrderBy = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)query, (PageControl)pageControl);
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)query);
        queryWithOrderBy.setParameter("scheduleId", (Object)scheduleId);
        queryWithOrderBy.setParameter("beginTime", (Object)beginTime);
        queryWithOrderBy.setParameter("endTime", (Object)endTime);
        List results = queryWithOrderBy.getResultList();
        queryCount.setParameter("scheduleId", (Object)scheduleId);
        queryCount.setParameter("beginTime", (Object)beginTime);
        queryCount.setParameter("endTime", (Object)endTime);
        long count = queryCount.getResultList().size();
        return new PageList((Collection)results, (int)count, pageControl);
    }

    @Override
    public PageList<CallTimeDataComposite> findCallTimeDataForCompatibleGroup(Subject subject, int groupId, long beginTime, long endTime, PageControl pageControl) {
        return this.findCallTimeDataForContext(subject, EntityContext.forGroup((int)groupId), beginTime, endTime, null, pageControl);
    }

    @Override
    public PageList<CallTimeDataComposite> findCallTimeDataForAutoGroup(Subject subject, int parentResourceId, int childResourceTypeId, long beginTime, long endTime, PageControl pageControl) {
        return this.findCallTimeDataForContext(subject, EntityContext.forAutoGroup((int)parentResourceId, (int)childResourceTypeId), beginTime, endTime, null, pageControl);
    }

    @Override
    public PageList<CallTimeDataComposite> findCallTimeDataForContext(Subject subject, EntityContext context, long beginTime, long endTime, String destination, PageControl pageControl) {
        CallTimeDataCriteria criteria = new CallTimeDataCriteria();
        criteria.addFilterBeginTime(Long.valueOf(beginTime));
        criteria.addFilterEndTime(Long.valueOf(endTime));
        if (destination != null && !destination.trim().equals("")) {
            criteria.addFilterDestination(destination);
        }
        pageControl.initDefaultOrderingField("SUM(calltimedatavalue.total)/SUM(calltimedatavalue.count)", PageOrdering.DESC);
        pageControl.addDefaultOrderingField("calltimedatavalue.key.callDestination", PageOrdering.ASC);
        criteria.setPageControl(pageControl);
        if (context.type == EntityContext.Type.Resource) {
            criteria.addFilterResourceId(Integer.valueOf(context.resourceId));
        } else if (context.type == EntityContext.Type.ResourceGroup) {
            criteria.addFilterResourceGroupId(Integer.valueOf(context.groupId));
        } else if (context.type == EntityContext.Type.AutoGroup) {
            criteria.addFilterAutoGroupParentResourceId(Integer.valueOf(context.parentResourceId));
            criteria.addFilterAutoGroupResourceTypeId(Integer.valueOf(context.resourceTypeId));
        }
        CriteriaQueryGenerator generator = new CriteriaQueryGenerator(subject, (Criteria)criteria);
        String replacementSelectList = " new org.rhq.core.domain.measurement.calltime.CallTimeDataComposite(    calltimedatavalue.key.callDestination,    MIN(calltimedatavalue.minimum),    MAX(calltimedatavalue.maximum),    SUM(calltimedatavalue.total),    SUM(calltimedatavalue.count),    SUM(calltimedatavalue.total) / SUM(calltimedatavalue.count) ) ";
        generator.alterProjection(replacementSelectList);
        generator.setGroupByClause("calltimedatavalue.key.callDestination");
        if (!this.authorizationManager.isInventoryManager(subject)) {
            generator.setAuthorizationResourceFragment(CriteriaQueryGenerator.AuthorizationTokenType.RESOURCE, "key.schedule.resource", subject.getId());
        }
        CriteriaQueryRunner queryRunner = new CriteriaQueryRunner((Criteria)criteria, generator, this.entityManager);
        PageList results = queryRunner.execute();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    @TransactionTimeout(value=21600)
    public int purgeCallTimeData(Date deleteUpToTime) throws SQLException {
        int n;
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.rhqDs.getConnection();
            stmt = conn.prepareStatement(CALLTIME_VALUE_PURGE_STATEMENT);
            stmt.setLong(1, deleteUpToTime.getTime());
            long startTime = System.currentTimeMillis();
            int deletedRowCount = stmt.executeUpdate();
            MeasurementMonitor.getMBean().incrementPurgeTime(System.currentTimeMillis() - startTime);
            MeasurementMonitor.getMBean().setPurgedCallTimeData(deletedRowCount);
            n = deletedRowCount;
        }
        catch (Throwable throwable) {
            JDBCUtil.safeClose((Connection)conn, stmt, null);
            throw throwable;
        }
        JDBCUtil.safeClose((Connection)conn, (Statement)stmt, null);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void insertCallTimeDataKeys(Set<CallTimeData> callTimeDataSet) {
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            String insertKeySql;
            conn = this.rhqDs.getConnection();
            DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (dbType instanceof Postgresql83DatabaseType) {
                Statement st = null;
                try {
                    st = conn.createStatement();
                    st.execute("SET synchronous_commit = off");
                }
                finally {
                    JDBCUtil.safeClose((Statement)st);
                }
            }
            if (dbType instanceof PostgresqlDatabaseType || dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                String keyNextvalSql = JDBCUtil.getNextValSql((Connection)conn, (String)"RHQ_calltime_data_key");
                insertKeySql = String.format(CALLTIME_KEY_INSERT_STATEMENT, keyNextvalSql);
            } else if (dbType instanceof SQLServerDatabaseType) {
                insertKeySql = CALLTIME_KEY_INSERT_STATEMENT_AUTOINC;
            } else {
                throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
            }
            ps = conn.prepareStatement(insertKeySql);
            for (CallTimeData callTimeData : callTimeDataSet) {
                ps.setInt(1, callTimeData.getScheduleId());
                ps.setInt(3, callTimeData.getScheduleId());
                Set callDestinations = callTimeData.getValues().keySet();
                for (String callDestination : callDestinations) {
                    ps.setString(2, callDestination);
                    ps.setString(4, callDestination);
                    ps.addBatch();
                }
            }
            int[] results = ps.executeBatch();
            int insertedRowCount = 0;
            for (int i = 0; i < results.length; ++i) {
                if ((results[i] < 0 || results[i] > 1) && results[i] != -2) {
                    throw new MeasurementStorageException("Failed to insert call-time data key rows - result [" + results[i] + "] for batch command [" + i + "] is less than 0 or greater than 1.");
                }
                insertedRowCount += results[i] == -2 ? 1 : results[i];
            }
            this.log.debug((Object)("Inserted new call-time data key rows for " + (insertedRowCount >= 0 ? Integer.valueOf(insertedRowCount) : "?") + " out of " + results.length + " reported key-value pairs."));
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, null);
        }
        catch (SQLException e) {
            this.logSQLException("Failed to persist call-time data keys", e);
        }
        catch (Throwable t) {
            this.log.error((Object)"Failed to persist call-time data keys", t);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            JDBCUtil.safeClose((Connection)conn, ps, null);
        }
        finally {
            JDBCUtil.safeClose((Connection)conn, ps, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void insertCallTimeDataValues(Set<CallTimeData> callTimeDataSet) {
        PreparedStatement ps = null;
        Connection conn = null;
        try {
            String insertValueSql;
            conn = this.rhqDs.getConnection();
            DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
            if (dbType instanceof Postgresql83DatabaseType) {
                Statement st = null;
                try {
                    st = conn.createStatement();
                    st.execute("SET synchronous_commit = off");
                }
                finally {
                    JDBCUtil.safeClose((Statement)st);
                }
            }
            if (dbType instanceof PostgresqlDatabaseType || dbType instanceof OracleDatabaseType || dbType instanceof H2DatabaseType) {
                String valueNextvalSql = JDBCUtil.getNextValSql((Connection)conn, (String)"RHQ_calltime_data_value");
                insertValueSql = String.format(CALLTIME_VALUE_INSERT_STATEMENT, valueNextvalSql);
            } else if (dbType instanceof SQLServerDatabaseType) {
                insertValueSql = CALLTIME_VALUE_INSERT_STATEMENT_AUTOINC;
            } else {
                throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
            }
            ps = conn.prepareStatement(insertValueSql);
            for (CallTimeData callTimeData : callTimeDataSet) {
                ps.setInt(7, callTimeData.getScheduleId());
                Set callDestinations = callTimeData.getValues().keySet();
                for (String callDestination : callDestinations) {
                    CallTimeDataValue callTimeDataValue = (CallTimeDataValue)callTimeData.getValues().get(callDestination);
                    ps.setLong(1, callTimeDataValue.getBeginTime());
                    ps.setLong(2, callTimeDataValue.getEndTime());
                    ps.setDouble(3, callTimeDataValue.getMinimum());
                    ps.setDouble(4, callTimeDataValue.getMaximum());
                    ps.setDouble(5, callTimeDataValue.getTotal());
                    ps.setLong(6, callTimeDataValue.getCount());
                    ps.setString(8, callDestination);
                    ps.addBatch();
                }
            }
            int[] results = ps.executeBatch();
            int insertedRowCount = 0;
            for (int i = 0; i < results.length; ++i) {
                if (results[i] != 1 && results[i] != -2) {
                    throw new MeasurementStorageException("Failed to insert call-time data value rows - result [" + results[i] + "] for batch command [" + i + "] does not equal 1.");
                }
                insertedRowCount += results[i] == -2 ? 1 : results[i];
            }
            this.notifyAlertConditionCacheManager("insertCallTimeDataValues", callTimeDataSet.toArray(new CallTimeData[callTimeDataSet.size()]));
            if (insertedRowCount > 0) {
                MeasurementMonitor.getMBean().incrementCalltimeValuesInserted(insertedRowCount);
                this.log.debug((Object)("Inserted " + insertedRowCount + " call-time data value rows."));
            }
            JDBCUtil.safeClose((Connection)conn, (Statement)ps, null);
        }
        catch (SQLException e) {
            this.logSQLException("Failed to persist call-time data values", e);
        }
        catch (Throwable t) {
            this.log.error((Object)"Failed to persist call-time data values", t);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            JDBCUtil.safeClose((Connection)conn, ps, null);
        }
        finally {
            JDBCUtil.safeClose((Connection)conn, ps, null);
        }
    }

    private void notifyAlertConditionCacheManager(String callingMethod, CallTimeData ... data) {
        AlertConditionCacheStats stats = this.alertConditionCacheManager.checkConditions(data);
        this.log.debug((Object)(callingMethod + ": " + stats.toString()));
    }

    private void logSQLException(String message, SQLException e) {
        SQLException mainException = e;
        StringBuilder causes = new StringBuilder();
        int i = 1;
        while ((e = e.getNextException()) != null) {
            causes.append(i++).append("\n\t").append(e);
        }
        this.log.error((Object)(message + " - causes: " + causes), (Throwable)mainException);
    }
}

