/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.measurement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.db.DatabaseType;
import org.rhq.core.db.DatabaseTypeFactory;
import org.rhq.core.db.H2DatabaseType;
import org.rhq.core.db.OracleDatabaseType;
import org.rhq.core.db.PostgresqlDatabaseType;
import org.rhq.core.db.SQLServerDatabaseType;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDataNumeric1H;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.composite.MeasurementOOBComposite;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementOOBManagerLocal;
import org.rhq.enterprise.server.util.QueryUtility;

@Stateless
@Resource(name="RHQ_DS", mappedName="java:/RHQDS")
public class MeasurementOOBManagerBean
implements MeasurementOOBManagerLocal {
    private final Log log = LogFactory.getLog(MeasurementOOBManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @Resource(name="RHQ_DS")
    private DataSource rhqDs;
    @EJB
    AuthorizationManagerLocal authMangager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void computeOOBsFromHourBeginingAt(Subject subject, long begin) {
        block17: {
            Connection conn = null;
            PreparedStatement stmt = null;
            ArrayList<Long> timings = new ArrayList<Long>();
            try {
                String theQuery;
                long t0;
                this.log.info((Object)("Calculating OOBs for hour starting at " + new Date(begin)));
                conn = this.rhqDs.getConnection();
                DatabaseType dbType = DatabaseTypeFactory.getDatabaseType((Connection)conn);
                long tstart = t0 = System.currentTimeMillis();
                this.log.debug((Object)"Truncating tmp table");
                stmt = conn.prepareStatement("DELETE FROM RHQ_MEASUREMENT_OOB_TMP");
                stmt.executeUpdate();
                long t1 = System.currentTimeMillis();
                timings.add(t1 - t0);
                this.log.debug((Object)"Truncating the tmp table done");
                if (dbType instanceof PostgresqlDatabaseType || dbType instanceof H2DatabaseType) {
                    theQuery = "INSERT INTO rhq_measurement_oob_tmp (oob_factor, schedule_id, time_stamp ) \n     ( SELECT max(mx*100) as mxdiff, id, ? \n         FROM ( SELECT max(((d.maxvalue - b.bl_max) / (b.bl_max - b.bl_min))) AS mx, d.schedule_id as id \n                  FROM rhq_measurement_bline b, rhq_measurement_data_num_1h d, rhq_measurement_sched sc, rhq_measurement_def def \n                 WHERE b.schedule_id = d.schedule_id \n                   AND sc.id = b.schedule_id \n                   AND d.value > b.bl_max \n                   AND d.time_stamp = ? \n                   AND (b.bl_max - b.bl_min) > 0.1 \n                   AND (d.maxvalue - b.bl_max) >0 \n                    AND sc.enabled = %TRUE% \n                   AND sc.definition = def.id \n                   AND def.numeric_type = 0 \n              GROUP BY d.schedule_id \nUNION ALL \n      SELECT max(((b.bl_min - d.minvalue) / (b.bl_max - b.bl_min))) AS mx, d.schedule_id as id \n        FROM rhq_measurement_bline b, rhq_measurement_data_num_1h d, rhq_measurement_sched sc, rhq_measurement_def def \n       WHERE b.schedule_id = d.schedule_id \n         AND sc.id = b.schedule_id \n         AND d.value < b.bl_max  \n         AND d.time_stamp = ? \n         AND (b.bl_max - b.bl_min) > 0.1 \n         AND (b.bl_min - d.minvalue) >0 \n         AND sc.enabled = %TRUE% \n         AND sc.definition = def.id \n         AND def.numeric_type = 0 \n    GROUP BY d.schedule_id \n   ) data \nGROUP BY id, mx \n  HAVING mx > 0.05 )".replace("%TRUE%", "true");
                } else if (dbType instanceof OracleDatabaseType || dbType instanceof SQLServerDatabaseType) {
                    theQuery = "INSERT INTO rhq_measurement_oob_tmp (oob_factor, schedule_id, time_stamp ) \n     ( SELECT max(mx*100) as mxdiff, id, ? \n         FROM ( SELECT max(((d.maxvalue - b.bl_max) / (b.bl_max - b.bl_min))) AS mx, d.schedule_id as id \n                  FROM rhq_measurement_bline b, rhq_measurement_data_num_1h d, rhq_measurement_sched sc, rhq_measurement_def def \n                 WHERE b.schedule_id = d.schedule_id \n                   AND sc.id = b.schedule_id \n                   AND d.value > b.bl_max \n                   AND d.time_stamp = ? \n                   AND (b.bl_max - b.bl_min) > 0.1 \n                   AND (d.maxvalue - b.bl_max) >0 \n                    AND sc.enabled = %TRUE% \n                   AND sc.definition = def.id \n                   AND def.numeric_type = 0 \n              GROUP BY d.schedule_id \nUNION ALL \n      SELECT max(((b.bl_min - d.minvalue) / (b.bl_max - b.bl_min))) AS mx, d.schedule_id as id \n        FROM rhq_measurement_bline b, rhq_measurement_data_num_1h d, rhq_measurement_sched sc, rhq_measurement_def def \n       WHERE b.schedule_id = d.schedule_id \n         AND sc.id = b.schedule_id \n         AND d.value < b.bl_max  \n         AND d.time_stamp = ? \n         AND (b.bl_max - b.bl_min) > 0.1 \n         AND (b.bl_min - d.minvalue) >0 \n         AND sc.enabled = %TRUE% \n         AND sc.definition = def.id \n         AND def.numeric_type = 0 \n    GROUP BY d.schedule_id \n   ) data \nGROUP BY id, mx \n  HAVING mx > 0.05 )".replace("%TRUE%", "1");
                } else {
                    throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
                }
                stmt = conn.prepareStatement(theQuery);
                stmt.setLong(1, begin);
                stmt.setLong(2, begin);
                stmt.setLong(3, begin);
                int count = stmt.executeUpdate();
                t1 = System.currentTimeMillis();
                this.log.debug((Object)"Calculation of OOBs done");
                timings.add(t1 - t0);
                t0 = t1;
                if (dbType instanceof PostgresqlDatabaseType) {
                    stmt = conn.prepareStatement("UPDATE rhq_measurement_oob \n   SET oob_factor = rhq_measurement_oob_tmp.oob_factor,time_stamp=rhq_measurement_oob_tmp.time_stamp \n  FROM rhq_measurement_oob_tmp \n WHERE rhq_measurement_oob_tmp.oob_factor > rhq_measurement_oob.oob_factor \n   AND rhq_measurement_oob_tmp.schedule_id = rhq_measurement_oob.schedule_id ");
                    stmt.executeUpdate();
                    t1 = System.currentTimeMillis();
                    timings.add(t1 - t0);
                    this.log.debug((Object)"Update of master table done");
                    t0 = t1;
                    stmt = conn.prepareStatement("INSERT INTO rhq_measurement_oob (oob_factor, schedule_id, time_stamp) \n     ( SELECT oob_factor, schedule_id,  time_stamp \n         FROM rhq_measurement_oob_tmp \n        WHERE NOT EXISTS ( SELECT rhq_measurement_oob.schedule_id \n                              FROM rhq_measurement_oob \n                             WHERE rhq_measurement_oob.schedule_id = rhq_measurement_oob_tmp.schedule_id ) )");
                    stmt.executeUpdate();
                    t1 = System.currentTimeMillis();
                    timings.add(t1 - t0);
                    this.log.debug((Object)"Insert of new oobs done");
                } else if (dbType instanceof OracleDatabaseType) {
                    stmt = conn.prepareStatement("MERGE INTO rhq_measurement_oob oob_ \n     USING rhq_measurement_oob_tmp tmp_ \n        ON ( tmp_.schedule_id = oob_.schedule_id ) \n      WHEN MATCHED THEN UPDATE SET oob_factor = tmp_.oob_factor, time_stamp = tmp_.time_stamp \n      WHEN NOT MATCHED THEN INSERT ( oob_.schedule_id, oob_.time_stamp, oob_.oob_factor ) \n                            VALUES ( tmp_.schedule_id, tmp_.time_stamp, tmp_.oob_factor )");
                    stmt.executeUpdate();
                    t1 = System.currentTimeMillis();
                    timings.add(t1 - t0);
                    this.log.debug((Object)"Merge of master table done");
                } else if (dbType instanceof H2DatabaseType || dbType instanceof SQLServerDatabaseType) {
                    stmt = conn.prepareStatement("DELETE FROM rhq_measurement_oob \n      WHERE EXISTS ( SELECT oob_tmp.schedule_id \n                       FROM rhq_measurement_oob_tmp oob_tmp \n                      WHERE oob_tmp.oob_factor > rhq_measurement_oob.oob_factor \n                        AND oob_tmp.schedule_id = rhq_measurement_oob.schedule_id ) ");
                    stmt.executeUpdate();
                    t1 = System.currentTimeMillis();
                    timings.add(t1 - t0);
                    this.log.debug((Object)"Update of master table done");
                    t0 = t1;
                    stmt = conn.prepareStatement("INSERT INTO rhq_measurement_oob (oob_factor, schedule_id, time_stamp) \n     ( SELECT oob_factor, schedule_id,  time_stamp \n         FROM rhq_measurement_oob_tmp \n        WHERE NOT EXISTS ( SELECT rhq_measurement_oob.schedule_id \n                              FROM rhq_measurement_oob \n                             WHERE rhq_measurement_oob.schedule_id = rhq_measurement_oob_tmp.schedule_id ) )");
                    stmt.executeUpdate();
                    t1 = System.currentTimeMillis();
                    timings.add(t1 - t0);
                    this.log.debug((Object)"Insert of new oobs done");
                } else {
                    throw new IllegalArgumentException("Unknown database type, can't continue: " + dbType);
                }
                this.log.info((Object)("Done calculating OOBs. [" + count + "] entries in [" + (t1 - tstart) + "] ms (" + timings + ")"));
                JDBCUtil.safeClose((Connection)conn, (Statement)stmt, null);
            }
            catch (SQLException e) {
                this.log.error((Object)e);
            }
            catch (Exception e2) {
                this.log.error((Object)e2);
                break block17;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                JDBCUtil.safeClose(conn, stmt, null);
            }
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void computeOOBsFromLastHour(Subject subject) {
        Query q = this.entityManager.createNamedQuery("MeasurementDataNumeric1H.getMaxTimestamp");
        Object res = q.getSingleResult();
        if (res == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No data yet in 1h table, nothing to do");
            }
            return;
        }
        long timeStamp = (Long)res;
        q = this.entityManager.createNamedQuery("CountOOBForDate");
        q.setParameter("timestamp", (Object)timeStamp);
        Long count = (Long)q.getSingleResult();
        if (count == 0L) {
            this.computeOOBsFromHourBeginingAt(subject, timeStamp);
        } else {
            this.log.info((Object)("Calculation of OOBs already done for hour " + new Date(timeStamp)));
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void removeOutdatedOOBs(Subject subject, long cutoffTime) {
        Query q = this.entityManager.createNamedQuery("DeleteOutdatedOOBs");
        q.setParameter("cutOff", (Object)cutoffTime);
        int count = q.executeUpdate();
        this.log.info((Object)("Removed [" + count + "] outdated OOBs"));
    }

    @Override
    public void removeOOBsForSchedule(Subject subject, MeasurementSchedule sched) {
        Query q = this.entityManager.createNamedQuery("DeleteOOBForSchedule");
        q.setParameter("id", (Object)sched.getId());
        q.executeUpdate();
    }

    @Override
    public void removeOOBsForGroupAndDefinition(Subject subject, int resourceGroupId, int measurementDefinitionId) {
        Query query = this.entityManager.createNamedQuery("DeleteOOBForGroupAndDefinition");
        query.setParameter("groupId", (Object)resourceGroupId);
        query.setParameter("definitionId", (Object)measurementDefinitionId);
        query.executeUpdate();
    }

    @Override
    public PageList<MeasurementOOBComposite> getSchedulesWithOOBs(Subject subject, String metricNameFilter, String resourceNameFilter, String parentNameFilter, PageControl pc) {
        pc.initDefaultOrderingField("o.oobFactor", PageOrdering.DESC);
        boolean isAdmin = this.authMangager.isOverlord(subject) || this.authMangager.isSystemSuperuser(subject);
        String queryName = isAdmin ? "GetSchedulesWithOObAggregate_admin" : "GetSchedulesWithOObAggregate";
        Query queryCount = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName, (String)"sched.id");
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        metricNameFilter = QueryUtility.formatSearchParameter(metricNameFilter);
        resourceNameFilter = QueryUtility.formatSearchParameter(resourceNameFilter);
        parentNameFilter = QueryUtility.formatSearchParameter(parentNameFilter);
        query.setParameter("metricName", (Object)metricNameFilter);
        queryCount.setParameter("metricName", (Object)metricNameFilter);
        query.setParameter("resourceName", (Object)resourceNameFilter);
        queryCount.setParameter("resourceName", (Object)resourceNameFilter);
        query.setParameter("parentName", (Object)parentNameFilter);
        queryCount.setParameter("parentName", (Object)parentNameFilter);
        query.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        queryCount.setParameter("escapeChar", (Object)QueryUtility.getEscapeCharacter());
        if (!isAdmin) {
            query.setParameter("subjectId", (Object)subject.getId());
            queryCount.setParameter("subjectId", (Object)subject.getId());
        }
        List results = query.getResultList();
        long totalCount = (Long)queryCount.getSingleResult();
        if (!results.isEmpty()) {
            ArrayList<MeasurementDataPK> pks = new ArrayList<MeasurementDataPK>(results.size());
            HashMap<MeasurementDataPK, MeasurementOOBComposite> map = new HashMap<MeasurementDataPK, MeasurementOOBComposite>();
            for (MeasurementOOBComposite comp : results) {
                MeasurementDataPK key = new MeasurementDataPK(comp.getTimestamp(), comp.getScheduleId());
                map.put(key, comp);
                pks.add(key);
            }
            List<MeasurementDataNumeric1H> datas = this.getOneHourDataForPKs(pks);
            for (MeasurementDataNumeric1H data : datas) {
                MeasurementDataPK pk = new MeasurementDataPK(data.getTimestamp(), data.getScheduleId());
                MeasurementOOBComposite comp = (MeasurementOOBComposite)map.get(pk);
                comp.setData(data);
                comp.calculateOutlier();
            }
        }
        return new PageList((Collection)results, (int)totalCount, pc);
    }

    @Override
    public PageList<MeasurementOOBComposite> getHighestNOOBsForResource(Subject subject, int resourceId, int n) {
        if (!this.authMangager.canViewResource(subject, resourceId)) {
            return new PageList();
        }
        PageControl pc = new PageControl(0, n);
        pc.addDefaultOrderingField("sched.id");
        pc.addDefaultOrderingField("o.oobFactor", PageOrdering.DESC);
        String queryName = "GetHighestOOBFactorForResource";
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        query.setParameter("resourceId", (Object)resourceId);
        countQuery.setParameter("resourceId", (Object)resourceId);
        List results = query.getResultList();
        if (!results.isEmpty()) {
            ArrayList<MeasurementDataPK> pks = new ArrayList<MeasurementDataPK>(results.size());
            HashMap<MeasurementDataPK, MeasurementOOBComposite> map = new HashMap<MeasurementDataPK, MeasurementOOBComposite>();
            for (MeasurementOOBComposite comp : results) {
                int schedule = comp.getScheduleId();
                MeasurementDataPK key = new MeasurementDataPK(comp.getTimestamp(), schedule);
                pks.add(key);
                map.put(key, comp);
            }
            List<MeasurementDataNumeric1H> datas = this.getOneHourDataForPKs(pks);
            for (MeasurementDataNumeric1H data : datas) {
                MeasurementDataPK pk = new MeasurementDataPK(data.getTimestamp(), data.getScheduleId());
                MeasurementOOBComposite comp = (MeasurementOOBComposite)map.get(pk);
                comp.setData(data);
                comp.calculateOutlier();
            }
        }
        long totalCount = (Long)countQuery.getSingleResult();
        PageList result = new PageList((Collection)results, (int)totalCount, pc);
        return result;
    }

    @Override
    public PageList<MeasurementOOBComposite> getHighestNOOBsForGroup(Subject subject, int groupId, int n) {
        if (!this.authMangager.canViewResource(subject, groupId)) {
            return new PageList();
        }
        PageControl pc = new PageControl(0, n);
        pc.addDefaultOrderingField("sched.id");
        pc.addDefaultOrderingField("o.oobFactor", PageOrdering.DESC);
        String queryName = "GetHighestOOBFactorForGroup";
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)queryName, (PageControl)pc);
        Query countQuery = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)queryName);
        query.setParameter("groupId", (Object)groupId);
        countQuery.setParameter("groupId", (Object)groupId);
        List results = query.getResultList();
        if (!results.isEmpty()) {
            ArrayList<MeasurementDataPK> pks = new ArrayList<MeasurementDataPK>(results.size());
            HashMap<MeasurementDataPK, MeasurementOOBComposite> map = new HashMap<MeasurementDataPK, MeasurementOOBComposite>();
            for (MeasurementOOBComposite comp : results) {
                int schedule = comp.getScheduleId();
                MeasurementDataPK key = new MeasurementDataPK(comp.getTimestamp(), schedule);
                pks.add(key);
                map.put(key, comp);
            }
            List<MeasurementDataNumeric1H> datas = this.getOneHourDataForPKs(pks);
            for (MeasurementDataNumeric1H data : datas) {
                MeasurementDataPK pk = new MeasurementDataPK(data.getTimestamp(), data.getScheduleId());
                MeasurementOOBComposite comp = (MeasurementOOBComposite)map.get(pk);
                comp.setData(data);
                comp.calculateOutlier();
            }
        }
        long totalCount = (Long)countQuery.getSingleResult();
        PageList result = new PageList((Collection)results, (int)totalCount, pc);
        return result;
    }

    private List<MeasurementDataNumeric1H> getOneHourDataForPKs(List<MeasurementDataPK> pks) {
        Query q = this.entityManager.createQuery("SELECT data FROM MeasurementDataNumeric1H data WHERE data.id IN (:pks)");
        q.setParameter("pks", pks);
        List res = q.getResultList();
        return res;
    }
}

