/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.rhq.core.domain.plugin.PluginKey;
import org.rhq.enterprise.server.plugin.pc.ClassLoaderManager;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginType;
import org.rhq.enterprise.server.plugin.pc.ServerPluginValidator;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorMetadataParser;
import org.rhq.enterprise.server.xmlschema.ServerPluginDescriptorUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.ServerPluginDescriptorType;

public class ServerPluginValidatorUtil {
    private static final String SYSPROP_VALIDATE_SERVERPLUGINS = "rhq.test.serverplugins";
    private static final Log LOG = LogFactory.getLog(ServerPluginValidatorUtil.class);
    private static final String PLUGIN_DESCRIPTOR_PATH = "META-INF/rhq-serverplugin.xml";

    public static void main(String[] args) {
        try {
            if (new ServerPluginValidatorUtil().validatePlugins(args)) {
                System.out.println("!OK!");
                System.exit(0);
            } else {
                System.out.println("!FAILED!");
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.out.println("!FAILED!");
            System.out.println("Could not complete server plugin validation due to the following exception:");
            e.printStackTrace(System.out);
            System.exit(1);
        }
    }

    public boolean validatePlugins(String[] pluginFileNames) throws Exception {
        List<URL> jars;
        try {
            if (pluginFileNames != null && pluginFileNames.length > 0) {
                jars = new ArrayList<URL>(pluginFileNames.length);
                for (String arg : pluginFileNames) {
                    URL jarUrl = new File(arg).toURI().toURL();
                    jars.add(jarUrl);
                    LOG.info((Object)("Plugin jar: " + jarUrl));
                }
            } else {
                String sysprop = System.getProperty(SYSPROP_VALIDATE_SERVERPLUGINS);
                if (sysprop != null && !sysprop.startsWith("$")) {
                    String[] serverplugins = sysprop.split(",");
                    jars = new ArrayList<URL>(serverplugins.length);
                    for (String serverplugin : serverplugins) {
                        URL jarUrl = new File(serverplugin).toURI().toURL();
                        jars.add(jarUrl);
                        LOG.info((Object)("Plugin jar: " + jarUrl));
                    }
                } else {
                    jars = this.findPluginJars();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean status = this.validatePlugins(jars);
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validatePlugins(List<URL> jars) throws Exception {
        boolean success = true;
        ClassLoaderManager classloaderManager = null;
        try {
            boolean sizesMatch;
            HashMap<URL, ServerPluginDescriptorType> descriptors = new HashMap<URL, ServerPluginDescriptorType>();
            for (URL jar : jars) {
                try {
                    LOG.info((Object)("Parsing server plugin [" + jar + "]"));
                    ServerPluginDescriptorType descriptor = ServerPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)jar);
                    descriptors.put(jar, descriptor);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to parse descriptor from plugin [" + jar + "]"), (Throwable)e);
                }
            }
            boolean bl = sizesMatch = descriptors.size() == jars.size();
            if (!sizesMatch) {
                success = false;
                LOG.error((Object)("Only [" + descriptors.size() + "] out of [" + jars.size() + "] plugin descriptors are valid."));
            } else {
                LOG.info((Object)("All [" + jars.size() + "] plugin descriptors are valid."));
            }
            classloaderManager = new ClassLoaderManager(descriptors, this.getClass().getClassLoader(), null);
            for (Map.Entry entry : descriptors.entrySet()) {
                URL pluginUrl = (URL)entry.getKey();
                ServerPluginDescriptorType descriptor = (ServerPluginDescriptorType)entry.getValue();
                String pluginName = descriptor.getName();
                if (pluginName == null) {
                    LOG.error((Object)("No plugin name in [" + pluginUrl + "]"));
                    success = false;
                    continue;
                }
                LOG.info((Object)("Validating plugin [" + pluginName + "] from [" + pluginUrl + "]"));
                ServerPluginType pluginType = new ServerPluginType(descriptor);
                PluginKey pluginKey = PluginKey.createServerPluginKey((String)pluginType.stringify(), (String)pluginName);
                ClassLoader classloader = classloaderManager.obtainServerPluginClassLoader(pluginKey);
                ServerPluginEnvironment env = new ServerPluginEnvironment(pluginUrl, classloader, descriptor);
                success = success && this.validatePluginComponentClass(env);
                success = success && this.validatePluginVersion(env);
                success = success && this.validatePluginConfiguration(env);
                boolean bl2 = success = success && this.validateScheduledJobs(env);
                ServerPluginValidator validator = this.getValidator(pluginType);
                if (validator == null) continue;
                boolean validatorStatus = validator.validate(env);
                if (!validatorStatus) {
                    LOG.error((Object)(pluginType.toString() + " validator detected a problem in plugin [" + env.getPluginUrl() + "]"));
                }
                success = success && validatorStatus;
            }
        }
        finally {
            if (classloaderManager != null) {
                classloaderManager.shutdown();
            }
        }
        return success;
    }

    private boolean validateScheduledJobs(ServerPluginEnvironment env) {
        boolean success = true;
        try {
            ServerPluginDescriptorMetadataParser.getScheduledJobs((ServerPluginDescriptorType)env.getPluginDescriptor());
        }
        catch (Exception e) {
            LOG.error((Object)("Invalid scheduled jobs for plugin [" + env.getPluginUrl() + "]"), (Throwable)e);
            success = false;
        }
        return success;
    }

    private boolean validatePluginConfiguration(ServerPluginEnvironment env) {
        boolean success = true;
        try {
            ServerPluginDescriptorMetadataParser.getPluginConfigurationDefinition((ServerPluginDescriptorType)env.getPluginDescriptor());
        }
        catch (Exception e) {
            LOG.error((Object)("Invalid plugin configuration for plugin [" + env.getPluginUrl() + "]"), (Throwable)e);
            success = false;
        }
        return success;
    }

    private boolean validatePluginVersion(ServerPluginEnvironment env) {
        boolean success = true;
        try {
            File pluginFile = new File(env.getPluginUrl().toURI());
            ComparableVersion version = ServerPluginDescriptorUtil.getPluginVersion((File)pluginFile, (ServerPluginDescriptorType)env.getPluginDescriptor());
            if (version == null) {
                throw new NullPointerException("version is null");
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Invalid version for plugin [" + env.getPluginUrl() + "]"), (Throwable)e);
            success = false;
        }
        return success;
    }

    private boolean validatePluginComponentClass(ServerPluginEnvironment env) {
        boolean success = true;
        String clazz = ServerPluginDescriptorMetadataParser.getPluginComponentClassName((ServerPluginDescriptorType)env.getPluginDescriptor());
        if (clazz != null) {
            try {
                Class<?> componentClazz = Class.forName(clazz, false, env.getPluginClassLoader());
                if (!ServerPluginComponent.class.isAssignableFrom(componentClazz)) {
                    success = false;
                    LOG.error((Object)("Component class [" + clazz + "] from plugin [" + env.getPluginUrl() + "] does not implement " + ServerPluginComponent.class));
                }
            }
            catch (Exception e) {
                success = false;
                LOG.error((Object)("Component class [" + clazz + "] from plugin [" + env.getPluginUrl() + "] could not be loaded"), (Throwable)e);
            }
        }
        return success;
    }

    private List<URL> findPluginJars() throws Exception {
        ArrayList<URL> retUrls = new ArrayList<URL>();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> descriptorUrls = classloader.getResources(PLUGIN_DESCRIPTOR_PATH);
        while (descriptorUrls.hasMoreElements()) {
            URL descriptorUrl = descriptorUrls.nextElement();
            URLConnection connection = descriptorUrl.openConnection();
            if (connection instanceof JarURLConnection) {
                URL jarUrl = ((JarURLConnection)connection).getJarFileURL();
                retUrls.add(jarUrl);
                LOG.info((Object)("Found plugin jar: " + jarUrl));
                continue;
            }
            LOG.warn((Object)("Found a plugin descriptor outside of a jar, skipping: " + descriptorUrl));
        }
        return retUrls;
    }

    private ServerPluginValidator getValidator(ServerPluginType pluginType) throws Exception {
        String pkg = ServerPluginValidator.class.getPackage().getName();
        String simpleName = pluginType.getDescriptorType().getSimpleName().replaceAll("DescriptorType$", "");
        String subpkg = simpleName.replaceAll("Plugin$", "").toLowerCase();
        String className = pkg + '.' + subpkg + '.' + simpleName + "Validator";
        ServerPluginValidator validator = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (clazz != null && ServerPluginValidator.class.isAssignableFrom(clazz)) {
            validator = (ServerPluginValidator)clazz.newInstance();
        }
        return validator;
    }
}

