/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.criteria.MeasurementDefinitionCriteria;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementDefinitionManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.metadata.MeasurementMetadataManagerLocal;

@Stateless
public class MeasurementMetadataManagerBean
implements MeasurementMetadataManagerLocal {
    private final Log log = LogFactory.getLog(MeasurementMetadataManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityMgr;
    @EJB
    private MeasurementScheduleManagerLocal scheduleMgr;
    @EJB
    private MeasurementDefinitionManagerLocal measurementDefinitionMgr;
    @EJB
    private SubjectManagerLocal subjectMgr;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void updateMetadata(ResourceType existingType, ResourceType newType) {
        this.log.debug((Object)("Updating metric definitions for " + existingType));
        existingType = (ResourceType)this.entityMgr.find(ResourceType.class, (Object)existingType.getId());
        Set existingDefinitions = existingType.getMetricDefinitions();
        if (existingDefinitions.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(existingType + " currently does not define any metric definitions."));
                this.log.debug((Object)("New metric definitions to be added: " + newType.getMetricDefinitions()));
            }
            for (MeasurementDefinition newDefinition : newType.getMetricDefinitions()) {
                if (newDefinition.getDefaultInterval() < 30000L) {
                    newDefinition.setDefaultInterval(30000L);
                    this.log.info((Object)("Definition [" + newDefinition + "] has too short of a default interval, setting to minimum"));
                }
                existingType.addMetricDefinition(newDefinition);
                this.entityMgr.persist((Object)newDefinition);
                this.scheduleMgr.createSchedulesForExistingResources(existingType, newDefinition);
            }
        } else {
            for (MeasurementDefinition newDefinition : newType.getMetricDefinitions()) {
                boolean found = false;
                for (MeasurementDefinition existingDefinition : existingDefinitions) {
                    if (!existingDefinition.getName().equals(newDefinition.getName()) || existingDefinition.isPerMinute() != newDefinition.isPerMinute()) continue;
                    found = true;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Updating existing metric definition: " + existingDefinition));
                    }
                    existingDefinition.update(newDefinition, false);
                    if (existingDefinition.getDefaultInterval() < 30000L) {
                        existingDefinition.setDefaultInterval(30000L);
                        this.log.info((Object)("Definition [" + existingDefinition + "] has too short of a default interval, setting to minimum"));
                    }
                    this.entityMgr.merge((Object)existingDefinition);
                    break;
                }
                if (found) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Adding metric definition: " + newDefinition));
                }
                existingType.addMetricDefinition(newDefinition);
                this.entityMgr.persist((Object)newDefinition);
                this.scheduleMgr.createSchedulesForExistingResources(existingType, newDefinition);
            }
            ArrayList<MeasurementDefinition> definitionsToDelete = new ArrayList<MeasurementDefinition>();
            for (MeasurementDefinition existingDefinition : existingDefinitions) {
                if (newType.getMetricDefinitions().contains(existingDefinition)) continue;
                definitionsToDelete.add(existingDefinition);
            }
            existingDefinitions.removeAll(definitionsToDelete);
            for (MeasurementDefinition definitionToDelete : definitionsToDelete) {
                this.measurementDefinitionMgr.removeMeasurementDefinition(definitionToDelete);
            }
            if (!definitionsToDelete.isEmpty() && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Metadata update: Measurement definitions deleted from resource type [" + existingType.getName() + "]:" + definitionsToDelete));
            }
            this.entityMgr.flush();
        }
    }

    @Override
    public void deleteMetadata(ResourceType existingType) {
        this.log.debug((Object)("Deleting metric definitions for " + existingType));
        MeasurementDefinitionCriteria criteria = new MeasurementDefinitionCriteria();
        criteria.addFilterResourceTypeId(Integer.valueOf(existingType.getId()));
        PageList<MeasurementDefinition> definitions = this.measurementDefinitionMgr.findMeasurementDefinitionsByCriteria(this.subjectMgr.getOverlord(), criteria);
        if (definitions != null) {
            Iterator defIter = definitions.iterator();
            while (defIter.hasNext()) {
                MeasurementDefinition def = (MeasurementDefinition)defIter.next();
                this.measurementDefinitionMgr.removeMeasurementDefinition(def);
                defIter.remove();
            }
        }
    }
}

