/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.links.AddLinks;
import org.jboss.resteasy.links.LinkResource;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.AlertHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.AlertDefinitionRest;
import org.rhq.enterprise.server.rest.domain.AlertRest;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class AlertHandlerBean
extends AbstractRestBean
implements AlertHandlerLocal {
    @EJB
    AlertManagerLocal alertManager;
    @EJB
    AlertDefinitionManagerLocal alertDefinitionManager;

    @Override
    @GET
    @AddLinks
    @LinkResource(value=AlertRest.class)
    public List<AlertRest> listAlerts(@QueryParam(value="page") int page, @QueryParam(value="status") String status) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.setPaging(page, 20);
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        ArrayList<AlertRest> ret = new ArrayList<AlertRest>(alerts.size());
        for (Alert al : alerts) {
            AlertRest ar = this.alertToDomain(al);
            ret.add(ar);
        }
        return ret;
    }

    @Override
    public AlertRest getAlert(@PathParam(value="id") int id) {
        Alert al = this.findAlertWithId(id);
        AlertRest ar = this.alertToDomain(al);
        return ar;
    }

    @Override
    public AlertRest ackAlert(@PathParam(value="id") int id) {
        this.findAlertWithId(id);
        this.alertManager.acknowledgeAlerts(this.caller, new int[]{id});
        Alert al = this.findAlertWithId(id);
        AlertRest ar = this.alertToDomain(al);
        return ar;
    }

    @Override
    public void purgeAlert(@PathParam(value="id") int id) {
        this.alertManager.deleteAlerts(this.caller, new int[]{id});
    }

    @Override
    @GET
    @LinkResource(rel="definition")
    @Path(value="/{id}/definition")
    public AlertDefinitionRest getDefinitionForAlert(@PathParam(value="id") int alertId) {
        Alert al = this.findAlertWithId(alertId);
        AlertDefinition def = al.getAlertDefinition();
        AlertDefinitionRest ret = this.definitionToDomain(def);
        return ret;
    }

    @Override
    public List<AlertDefinitionRest> listAlertDefinitions(@QueryParam(value="page") int page, @QueryParam(value="status") String status) {
        AlertDefinitionCriteria criteria = new AlertDefinitionCriteria();
        criteria.setPaging(page, 20);
        PageList<AlertDefinition> defs = this.alertDefinitionManager.findAlertDefinitionsByCriteria(this.caller, criteria);
        ArrayList<AlertDefinitionRest> ret = new ArrayList<AlertDefinitionRest>(defs.size());
        for (AlertDefinition def : defs) {
            AlertDefinitionRest adr = this.definitionToDomain(def);
            ret.add(adr);
        }
        return ret;
    }

    @Override
    @GET
    @Path(value="/definition/{id}")
    public AlertDefinitionRest getAlertDefinition(@PathParam(value="id") int definitionId) {
        AlertDefinition def = this.alertDefinitionManager.getAlertDefinition(this.caller, definitionId);
        if (def == null) {
            throw new StuffNotFoundException("AlertDefinition with id " + definitionId);
        }
        AlertDefinitionRest adr = this.definitionToDomain(def);
        return adr;
    }

    private AlertDefinitionRest definitionToDomain(AlertDefinition def) {
        AlertDefinitionRest adr = new AlertDefinitionRest(def.getId());
        adr.setName(def.getName());
        adr.setEnabled(def.getEnabled());
        return adr;
    }

    private Alert findAlertWithId(int id) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterId(Integer.valueOf(id));
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        if (alerts.isEmpty()) {
            throw new StuffNotFoundException("Alert with id " + id);
        }
        return (Alert)alerts.get(0);
    }

    public AlertRest alertToDomain(Alert al) {
        AlertRest ret = new AlertRest();
        ret.setId(al.getId());
        AlertDefinition alertDefinition = al.getAlertDefinition();
        ret.setName(alertDefinition.getName());
        ret.setAlertDefinition(this.definitionToDomain(alertDefinition));
        ret.setDefinitionEnabled(alertDefinition.getEnabled());
        if (al.getAcknowledgingSubject() != null) {
            ret.setAckBy(al.getAcknowledgingSubject());
            ret.setAckTime(al.getAcknowledgeTime());
        }
        ret.setAlertTime(al.getCtime());
        ret.setDescription(this.alertManager.prettyPrintAlertConditions(al, false));
        ret.setResource(new ResourceWithType(alertDefinition.getResource().getId()));
        return ret;
    }
}

