/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.composite.MeasurementDataNumericHighLowComposite;
import org.rhq.enterprise.server.measurement.MeasurementAggregate;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.MetricHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StuffNotFoundException;
import org.rhq.enterprise.server.rest.domain.MetricAggregate;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;

@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class MetricHandlerBean
extends AbstractRestBean
implements MetricHandlerLocal {
    @EJB
    MeasurementDataManagerLocal dataManager;
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    ResourceManagerLocal resMgr;
    private static final long EIGHT_HOURS = 28800000L;

    @Override
    public MetricAggregate getMetricData(int scheduleId, long startTime, long endTime, int dataPoints, boolean hideEmpty) {
        MeasurementSchedule schedule;
        if (dataPoints < 0) {
            throw new IllegalArgumentException("dataPoints must be >0 ");
        }
        if (startTime == 0L) {
            endTime = System.currentTimeMillis();
            startTime = endTime - 28800000L;
        }
        if ((schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId)).getDefinition().getDataType() != DataType.MEASUREMENT) {
            throw new IllegalArgumentException("Schedule [" + scheduleId + "] is not a (numerical) metric");
        }
        MeasurementAggregate aggr = this.dataManager.getAggregate(this.caller, scheduleId, startTime, endTime);
        MetricAggregate res = new MetricAggregate(scheduleId, aggr.getMin(), aggr.getAvg(), aggr.getMax());
        int definitionId = schedule.getDefinition().getId();
        List<List<MeasurementDataNumericHighLowComposite>> listList = this.dataManager.findDataForResource(this.caller, schedule.getResource().getId(), new int[]{definitionId}, startTime, endTime, dataPoints);
        long minTime = Long.MAX_VALUE;
        long maxTime = 0L;
        if (!listList.isEmpty()) {
            List<MeasurementDataNumericHighLowComposite> list = listList.get(0);
            for (MeasurementDataNumericHighLowComposite c : list) {
                long timestamp = c.getTimestamp();
                if (!Double.isNaN(c.getValue()) || !hideEmpty) {
                    MetricAggregate.DataPoint dp = new MetricAggregate.DataPoint(timestamp, c.getValue(), c.getHighValue(), c.getLowValue());
                    res.addDataPoint(dp);
                }
                if (timestamp < minTime) {
                    minTime = timestamp;
                }
                if (timestamp <= maxTime) continue;
                maxTime = timestamp;
            }
            res.setNumDataPoints(list.size());
        }
        res.setMaxTimeStamp(maxTime);
        res.setMinTimeStamp(minTime);
        return res;
    }

    @Override
    public String getMetricDataHtml(int scheduleId, long startTime, long endTime, int dataPoints, boolean hideEmpty) {
        MetricAggregate agg = this.getMetricData(scheduleId, startTime, endTime, dataPoints, hideEmpty);
        return this.renderTemplate("metricData", agg);
    }

    @Override
    public MetricSchedule getSchedule(int scheduleId) {
        MeasurementSchedule schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
        if (schedule == null) {
            throw new StuffNotFoundException("Schedule with id " + scheduleId);
        }
        MeasurementDefinition definition = schedule.getDefinition();
        MetricSchedule ms = new MetricSchedule(schedule.getId(), definition.getName(), definition.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), definition.getUnits().toString(), definition.getDataType().toString());
        return ms;
    }

    @Override
    public String getScheduleHtml(int scheduleId) {
        MetricSchedule ms = this.getSchedule(scheduleId);
        return this.renderTemplate("metricSchedule", ms);
    }

    @Override
    public List<MetricAggregate> getAggregatesForResource(int resourceId) {
        List<MeasurementSchedule> schedules = this.scheduleManager.findSchedulesForResourceAndType(this.caller, resourceId, DataType.MEASUREMENT, null, false);
        ArrayList<MetricAggregate> ret = new ArrayList<MetricAggregate>(schedules.size());
        long now = System.currentTimeMillis();
        long then = now - 28800000L;
        for (MeasurementSchedule schedule : schedules) {
            MeasurementAggregate aggr = this.dataManager.getAggregate(this.caller, schedule.getId(), then, now);
            MetricAggregate res = new MetricAggregate(schedule.getId(), aggr.getMin(), aggr.getAvg(), aggr.getMax());
            ret.add(res);
        }
        return ret;
    }

    @Override
    public MetricSchedule updateSchedule(int scheduleId, MetricSchedule in) {
        if (in == null) {
            throw new StuffNotFoundException("Input is null");
        }
        if (in.getScheduleId() == null) {
            throw new StuffNotFoundException("Invalid input data");
        }
        MeasurementSchedule schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
        if (schedule == null) {
            throw new StuffNotFoundException("Schedule with id " + scheduleId);
        }
        schedule.setEnabled(in.getEnabled().booleanValue());
        schedule.setInterval(in.getCollectionInterval());
        this.scheduleManager.updateSchedule(this.caller, schedule);
        schedule = this.scheduleManager.getScheduleById(this.caller, scheduleId);
        MetricSchedule ret = new MetricSchedule(scheduleId, in.getScheduleName(), in.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), in.getUnit(), in.getType());
        return ret;
    }
}

