/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import org.jboss.resteasy.spi.Link;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.measurement.Availability;
import org.rhq.core.domain.measurement.MeasurementDefinition;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.measurement.AvailabilityManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ResourceHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.domain.AvailabilityRest;
import org.rhq.enterprise.server.rest.domain.MetricSchedule;
import org.rhq.enterprise.server.rest.domain.ResourceWithChildren;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class ResourceHandlerBean
extends AbstractRestBean
implements ResourceHandlerLocal {
    @EJB
    ResourceManagerLocal resMgr;
    @EJB
    AvailabilityManagerLocal availMgr;
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    AlertManagerLocal alertManager;

    @Override
    public ResourceWithType getResource(int id) {
        Resource res = this.resMgr.getResource(this.caller, id);
        ResourceWithType rwt = this.fillRWT(res);
        return rwt;
    }

    @Override
    public String getResourceHtml(int id) {
        ResourceWithType rwt = this.getResource(id);
        return this.renderTemplate("resourceWithType.ftl", rwt);
    }

    @Override
    public List<ResourceWithType> getPlatforms() {
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourcesByCategory(this.caller, ResourceCategory.PLATFORM, InventoryStatus.COMMITTED, pc);
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(ret.size());
        for (Resource r : ret) {
            ResourceWithType rwt = this.fillRWT(r);
            rwtList.add(rwt);
        }
        return rwtList;
    }

    @Override
    public String getPlatformsHtml() {
        List<ResourceWithType> list = this.getPlatforms();
        return this.renderTemplate("listResourceWithType", list);
    }

    @Override
    public ResourceWithChildren getHierarchy(int baseResourceId) {
        Resource start = this.resMgr.getResource(this.caller, baseResourceId);
        ResourceWithChildren rwc = this.getHierarchy(start);
        return rwc;
    }

    ResourceWithChildren getHierarchy(Resource baseResource) {
        ResourceWithChildren rwc = new ResourceWithChildren("" + baseResource.getId(), baseResource.getName());
        PageControl pc = new PageControl();
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, baseResource, InventoryStatus.COMMITTED, pc);
        if (!ret.isEmpty()) {
            ArrayList<ResourceWithChildren> resList = new ArrayList<ResourceWithChildren>(ret.size());
            for (Resource res : ret) {
                ResourceWithChildren child = this.getHierarchy(res);
                resList.add(child);
            }
            if (!resList.isEmpty()) {
                rwc.setChildren(resList);
            }
        }
        return rwc;
    }

    @Override
    public AvailabilityRest getAvailability(int resourceId) {
        Availability avail = this.availMgr.getCurrentAvailabilityForResource(this.caller, resourceId);
        AvailabilityRest availabilityRest = new AvailabilityRest(avail.getAvailabilityType(), avail.getStartTime().getTime(), avail.getResource().getId());
        return availabilityRest;
    }

    private ResourceWithType fillRWT(Resource res) {
        ResourceType resourceType = res.getResourceType();
        ResourceWithType rwt = new ResourceWithType(res.getName(), res.getId());
        rwt.setTypeName(resourceType.getName());
        rwt.setTypeId(resourceType.getId());
        rwt.setPluginName(resourceType.getPlugin());
        Resource parent = res.getParentResource();
        if (parent != null) {
            rwt.setParentId(parent.getId());
        }
        return rwt;
    }

    @Override
    public List<MetricSchedule> getSchedules(int resourceId) {
        Resource res = this.resMgr.getResource(this.caller, resourceId);
        Set schedules = res.getSchedules();
        ArrayList<MetricSchedule> ret = new ArrayList<MetricSchedule>(schedules.size());
        for (MeasurementSchedule schedule : schedules) {
            MeasurementDefinition definition = schedule.getDefinition();
            MetricSchedule ms = new MetricSchedule(schedule.getId(), definition.getName(), definition.getDisplayName(), schedule.isEnabled(), schedule.getInterval(), definition.getUnits().toString(), definition.getDataType().toString());
            ret.add(ms);
        }
        return ret;
    }

    @Override
    public String getSchedulesHtml(int resourceId) {
        List<MetricSchedule> list = this.getSchedules(resourceId);
        return this.renderTemplate("listMetricSchedule", list);
    }

    @Override
    public List<ResourceWithType> getChildren(int id) {
        PageControl pc = new PageControl();
        Resource parent = this.resMgr.getResource(this.caller, id);
        PageList<Resource> ret = this.resMgr.findResourceByParentAndInventoryStatus(this.caller, parent, InventoryStatus.COMMITTED, pc);
        ArrayList<ResourceWithType> rwtList = new ArrayList<ResourceWithType>(ret.size());
        for (Resource r : ret) {
            ResourceWithType rwt = this.fillRWT(r);
            rwtList.add(rwt);
        }
        return rwtList;
    }

    @Override
    public String getChildrenHtml(int id) {
        List<ResourceWithType> list = this.getChildren(id);
        return this.renderTemplate("listResourceWithType", list);
    }

    @Override
    public List<Link> getAlertsForResource(int resourceId) {
        AlertCriteria criteria = new AlertCriteria();
        criteria.addFilterResourceIds(new Integer[]{resourceId});
        PageList<Alert> alerts = this.alertManager.findAlertsByCriteria(this.caller, criteria);
        ArrayList<Link> links = new ArrayList<Link>(alerts.size());
        for (Alert al : alerts) {
            Link link = new Link();
            link.setRelationship("alert");
            link.setHref("/alert/" + al.getId());
        }
        return links;
    }
}

