/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.criteria.AlertCriteria;
import org.rhq.core.domain.criteria.AlertDefinitionCriteria;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceCategory;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.server.alert.AlertDefinitionManagerLocal;
import org.rhq.enterprise.server.alert.AlertManagerLocal;
import org.rhq.enterprise.server.measurement.MeasurementScheduleManagerLocal;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.StatusHandlerLocal;
import org.rhq.enterprise.server.rest.domain.Status;

@Stateless
@Interceptors(value={SetCallerInterceptor.class})
public class StatusHandlerBean
extends AbstractRestBean
implements StatusHandlerLocal {
    @EJB
    MeasurementScheduleManagerLocal scheduleManager;
    @EJB
    ResourceManagerLocal resourceManager;
    @EJB
    AlertManagerLocal alertManager;
    @EJB
    AlertDefinitionManagerLocal alertDefinitionManager;

    @Override
    public Status getStatus() {
        Status status = new Status();
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.PLATFORM});
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        PageList<Resource> resList = this.resourceManager.findResourcesByCriteria(this.caller, criteria);
        status.setPlatforms(resList.getTotalSize());
        criteria = new ResourceCriteria();
        criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.SERVER});
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        resList = this.resourceManager.findResourcesByCriteria(this.caller, criteria);
        status.setServers(resList.getTotalSize());
        criteria = new ResourceCriteria();
        criteria.addFilterResourceCategories(new ResourceCategory[]{ResourceCategory.SERVICE});
        criteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        resList = this.resourceManager.findResourcesByCriteria(this.caller, criteria);
        status.setServices(resList.getTotalSize());
        AlertCriteria alertCriteria = new AlertCriteria();
        alertCriteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        PageList<Alert> alertList = this.alertManager.findAlertsByCriteria(this.caller, alertCriteria);
        status.setAlerts(alertList.getTotalSize());
        AlertDefinitionCriteria alertDefinitionCriteria = new AlertDefinitionCriteria();
        alertDefinitionCriteria.setRestriction(Criteria.Restriction.COUNT_ONLY);
        PageList<AlertDefinition> defList = this.alertDefinitionManager.findAlertDefinitionsByCriteria(this.caller, alertDefinitionCriteria);
        status.setAlertDefinitions(defList.getTotalSize());
        status.setSchedules(-1);
        status.setMetricsMin(this.scheduleManager.getScheduledMeasurementsPerMinute());
        return status;
    }

    @Override
    public String getStatusHtml() {
        Status status = this.getStatus();
        return this.renderTemplate("status", status);
    }
}

