/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.rest.AbstractRestBean;
import org.rhq.enterprise.server.rest.ResourceHandlerLocal;
import org.rhq.enterprise.server.rest.SetCallerInterceptor;
import org.rhq.enterprise.server.rest.UserHandlerLocal;
import org.rhq.enterprise.server.rest.domain.ResourceWithType;

@Interceptors(value={SetCallerInterceptor.class})
@Stateless
public class UserHandlerBean
extends AbstractRestBean
implements UserHandlerLocal {
    public static final String RESOURCE_HEALTH_RESOURCES = ".dashContent.resourcehealth.resources";
    public static final String GROUP_HEALTH_GROUPS = ".dashContent.grouphealth.groups";
    @EJB
    SubjectManagerLocal subjectManager;
    @EJB
    ResourceHandlerLocal resourceHandler;

    @Override
    @GET
    @Path(value="favorites/r")
    public List<ResourceWithType> getFavorites() {
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        ArrayList<ResourceWithType> ret = new ArrayList<ResourceWithType>();
        for (Integer id : favIds) {
            ResourceWithType rwt = this.resourceHandler.getResource(id);
            ret.add(rwt);
        }
        return ret;
    }

    @Override
    @PUT
    @Path(value="favorites/r/{id}")
    public void addFavoriteResource(@PathParam(value="id") int id) {
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        if (!favIds.contains(id)) {
            favIds.add(id);
            this.updateFavorites(favIds);
        }
    }

    @Override
    @DELETE
    @Path(value="favorites/r/{id}")
    public void removeResourceFromFavorites(@PathParam(value="id") int id) {
        Set<Integer> favIds = this.getResourceIdsForFavorites();
        if (favIds.contains(id)) {
            favIds.remove(id);
            this.updateFavorites(favIds);
        }
    }

    private void updateFavorites(Set<Integer> favIds) {
        Configuration conf = this.caller.getUserConfiguration();
        StringBuilder builder = new StringBuilder();
        Iterator<Integer> iter = favIds.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append('|');
        }
        PropertySimple prop = conf.getSimple(RESOURCE_HEALTH_RESOURCES);
        if (prop == null) {
            conf.put((Property)new PropertySimple(RESOURCE_HEALTH_RESOURCES, (Object)builder.toString()));
        } else {
            prop.setStringValue(builder.toString());
        }
        this.caller.setUserConfiguration(conf);
        this.subjectManager.updateSubject(this.caller, this.caller);
    }

    private Set<Integer> getResourceIdsForFavorites() {
        Configuration conf = this.caller.getUserConfiguration();
        String favsString = conf.getSimpleValue(RESOURCE_HEALTH_RESOURCES, "");
        TreeSet<Integer> favIds = new TreeSet<Integer>();
        if (!favsString.isEmpty()) {
            String[] favStringArray;
            for (String tmp : favStringArray = favsString.split("\\|")) {
                favIds.add(Integer.valueOf(tmp));
            }
        }
        return favIds;
    }
}

